/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 		Thomas Schuetz (changed for C code generator)
 * 
 *******************************************************************************/

package org.eclipse.etrice.generator.c.gen

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.etrice.core.room.DataClass
import org.eclipse.etrice.generator.base.ILogger
import org.eclipse.etrice.generator.etricegen.Root
import org.eclipse.xtext.generator.JavaIoFileSystemAccess
import org.eclipse.etrice.generator.generic.RoomExtensions
import org.eclipse.etrice.generator.generic.ProcedureHelpers


@Singleton
class DataClassGen {

	@Inject extension JavaIoFileSystemAccess fileAccess
	@Inject extension CExtensions stdExt
	@Inject extension RoomExtensions roomExt
	@Inject extension ProcedureHelpers helpers
	@Inject ILogger logger
	
	def doGenerate(Root root) {
		for (dc: root.usedDataClasses) {
			var path = dc.generationTargetPath+dc.getPath

			// header file
			logger.logInfo("generating DataClass header '"+dc.getCHeaderFileName+"' in '"+path+"'")
			fileAccess.setOutputPath(path)
			fileAccess.generateFile(dc.getCHeaderFileName, root.generateHeaderFile(dc))
			
			// source file
			logger.logInfo("generating DataClass source '"+dc.getCSourceFileName+"' in '"+path+"'")
			fileAccess.setOutputPath(path)
			fileAccess.generateFile(dc.getCSourceFileName, root.generateSourceFile(dc))
			
		}
	}
	
	def generateHeaderFile(Root root, DataClass dc) {'''
		/**
		 * @author generated by eTrice
		 *
		 * Header File of DataClass dc.name
		 * 
		 */

		generateIncludeGuardBegin(dc.name)
		
		#include "etDatatypes.h"

		TODO: includes only for used DataClasses, also for other models
		FOR dataClass : root.getReferencedDataClasses(dc)
			#include "dataClass.name.h"
		ENDFOR
		
		helpers.userCode(dc.userCode1)
				
		typedef struct {
			helpers.attributes(dc.allAttributes)
		} dc.name;
		
		FOR a:dc.allAttributes
			IF a.defaultValueLiteral!=null
				logger.logInfo(dc.name+" "+a.name+": Attribute initialization not supported in C")
			ENDIF
		ENDFOR
		
		TODO: do we need setters and getters for C and C++ ?
		
		helpers.operationsDeclaration(dc.operations, dc.name)
		
		/* deep copy */
		void dc.name_deepCopy(dc.name* source, dc.name* target);
		
		helpers.userCode(dc.userCode2)
		
		generateIncludeGuardEnd(dc.name)
		
		'''
	}
	
	def generateSourceFile(Root root, DataClass dc) {'''
		/**
		 * @author generated by eTrice
		 *
		 * Source File of DataClass dc.name
		 * 
		 */

		#include "dc.getCHeaderFileName"
		
		#include <string.h>
		
		helpers.userCode(dc.userCode3)
		
		TODO: do we need setters and getters for C and C++ ?
		
		helpers.operationsImplementation(dc.operations, dc.name)
		
		// deep copy
		void dc.name_deepCopy(dc.name* source, dc.name* target) {
			memcpy(target, source, sizeof(dc.name));
		}
		
		
	'''}
	
	
}