package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

@Singleton
@SuppressWarnings("all")
public class SubSystemRunnerGen {
  @Inject
  private JavaIoFileSystemAccess fileAccess;
  
  @Inject
  private RoomExtensions roomExt;
  
  public void doGenerate(final Root root) {
    EList<SubSystemInstance> _subSystemInstances = root.getSubSystemInstances();
    for (final SubSystemInstance sc : _subSystemInstances) {
      {
        SubSystemClass _subSystemClass = sc.getSubSystemClass();
        String _generationTargetPath = this.roomExt.getGenerationTargetPath(_subSystemClass);
        SubSystemClass _subSystemClass_1 = sc.getSubSystemClass();
        String _path = this.roomExt.getPath(_subSystemClass_1);
        String _plus = (_generationTargetPath + _path);
        this.fileAccess.setOutputPath(_plus);
        SubSystemClass _subSystemClass_2 = sc.getSubSystemClass();
        String _name = _subSystemClass_2.getName();
        String _plus_1 = (_name + "Runner.java");
        CharSequence _generate = this.generate(root, sc);
        this.fileAccess.generateFile(_plus_1, _generate);
      }
    }
  }
  
  public CharSequence generate(final Root root, final SubSystemInstance ssc) {
    CharSequence _xblockexpression = null;
    {
      final SubSystemClass cc = ssc.getSubSystemClass();
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* @author generated by eTrice");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* this class contains the main function running component ");
      String _name = ssc.getName();
      _builder.append(_name, " ");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* it instantiates ");
      String _name_1 = ssc.getName();
      _builder.append(_name_1, " ");
      _builder.append(" and starts and ends the lifecycle");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.newLine();
      _builder.append("package ");
      String _package = this.roomExt.getPackage(cc);
      _builder.append(_package, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.etrice.runtime.java.modelbase.SubSystemRunnerBase;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("class ");
      String _name_2 = cc.getName();
      String _plus = (_name_2 + "Runner");
      _builder.append(_plus, "");
      _builder.append(" extends SubSystemRunnerBase {");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("     ");
      _builder.append("* main function");
      _builder.newLine();
      _builder.append("     ");
      _builder.append("* creates the main component and starts and stops the lifecycle");
      _builder.newLine();
      _builder.append("     ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static void main(String[] args) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("// instantiate the main component");
      _builder.newLine();
      _builder.append("\t\t");
      String _name_3 = cc.getName();
      _builder.append(_name_3, "		");
      _builder.append(" main_component = new ");
      String _name_4 = cc.getName();
      _builder.append(_name_4, "		");
      _builder.append("(\"");
      String _runtimeName = this.getRuntimeName(ssc);
      _builder.append(_runtimeName, "		");
      _builder.append("\");");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("run(main_component, args);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("};");
      _builder.newLine();
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  private String getRuntimeName(final SubSystemInstance ssc) {
    String _xblockexpression = null;
    {
      EObject parent = ssc.eContainer();
      String _switchResult = null;
      boolean _matched = false;
      if (!_matched) {
        if (parent instanceof SystemInstance) {
          final SystemInstance _systemInstance = (SystemInstance)parent;
          _matched=true;
          String _name = _systemInstance.getName();
          String _plus = (_name + "/");
          String _name_1 = ssc.getName();
          String _plus_1 = (_plus + _name_1);
          _switchResult = _plus_1;
        }
      }
      if (!_matched) {
        String _name = ssc.getName();
        _switchResult = _name;
      }
      _xblockexpression = (_switchResult);
    }
    return _xblockexpression;
  }
}
