/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 		Thomas Schuetz (changed for C code generator)
 * 
 *******************************************************************************/

package org.eclipse.etrice.generator.c.gen

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.etrice.core.room.ActorClass
import org.eclipse.etrice.core.room.ProtocolClass
import org.eclipse.etrice.core.room.ActorCommunicationType
import org.eclipse.etrice.core.room.CommunicationType
import static extension org.eclipse.etrice.core.room.util.RoomHelpers.*
import org.eclipse.etrice.core.genmodel.base.ILogger
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass
import org.eclipse.etrice.core.genmodel.etricegen.Root
import org.eclipse.xtext.generator.JavaIoFileSystemAccess

import org.eclipse.etrice.generator.generic.RoomExtensions
import org.eclipse.etrice.generator.generic.ProcedureHelpers
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator
import org.eclipse.etrice.generator.generic.ILanguageExtension

@Singleton
class ActorClassGen extends GenericActorClassGenerator {
	
	@Inject JavaIoFileSystemAccess fileAccess
	@Inject extension ILanguageExtension langExt
	@Inject extension CExtensions
	@Inject extension RoomExtensions
	
	@Inject extension ProcedureHelpers
	@Inject extension StateMachineGen
	@Inject ILogger logger
	
	def doGenerate(Root root) {
		for (xpac: root.xpActorClasses) {
			var path = xpac.actorClass.generationTargetPath+xpac.actorClass.getPath
			
			// header file
			logger.logInfo("generating ActorClass header '"+xpac.actorClass.getCHeaderFileName+"' in '"+path+"'")
			fileAccess.setOutputPath(path)
			fileAccess.generateFile(xpac.actorClass.getCHeaderFileName, root.generateHeaderFile(xpac, xpac.actorClass))

			// source file
			if (hasBehaviorAnnotation(xpac, "BehaviorManual")) {
				logger.logInfo("omitting ActorClass source for '"+xpac.actorClass.name+"' since @BehaviorManual is specified")
			}
			else {
				logger.logInfo("generating ActorClass source '"+xpac.actorClass.getCSourceFileName +"' in '"+path+"'")
				fileAccess.setOutputPath(path)
				fileAccess.generateFile(xpac.actorClass.getCSourceFileName , root.generateSourceFile(xpac, xpac.actorClass))
			}
		}
	}
	
	def private hasBehaviorAnnotation(ExpandedActorClass xpac, String annotation) {
		if (xpac.actorClass.behaviorAnnotations != null){
			if(xpac.actorClass.behaviorAnnotations.findFirst(e|e.name == annotation) != null){
				return true;
			}
		}
		return false;		
	}
	
	def private generateHeaderFile(Root root, ExpandedActorClass xpac, ActorClass ac) {
		var eventPorts = ac.allEndPorts.filter(p|(p.protocol as ProtocolClass).commType==CommunicationType::EVENT_DRIVEN)
		var sendPorts = ac.allEndPorts.filter(p|(p.protocol as ProtocolClass).commType==CommunicationType::DATA_DRIVEN && p.conjugated)
		var recvPorts = ac.allEndPorts.filter(p|(p.protocol as ProtocolClass).commType==CommunicationType::DATA_DRIVEN && !p.conjugated)
		var dataDriven = ac.commType==ActorCommunicationType::DATA_DRIVEN
		var async = ac.commType==ActorCommunicationType::ASYNCHRONOUS
		
	'''
		/**
		 * @author generated by eTrice
		 *
		 * Header File of ActorClass ac.name
		 * 
		 */

		generateIncludeGuardBegin(ac.name)
		
		#include "etDatatypes.h"
		#include "messaging/etMessage.h"
		
		FOR dataClass : root.getReferencedDataClasses(ac)
			#include "dataClass.name.h"
		ENDFOR
		FOR pc : root.getReferencedProtocolClasses(ac)
			#include "pc.name.h"
		ENDFOR
		
		ac.userCode(1)
		
		typedef struct ac.name ac.name;
		
		/* const part of ActorClass (ROM) */
		IF eventPorts.empty && recvPorts.empty && ac.allSAPs.empty && ac.allServiceImplementations.empty
			/* this actor class has no ports and thus no constant data */
		ELSE
			typedef struct ac.name_const {
				/* simple ports */
				FOR ep : eventPorts
					IF ep.multiplicity==1
						const ep.getPortClassName() ep.name;
					ENDIF
				ENDFOR
				
				/* data receive ports */
				FOR ep : recvPorts
					IF ep.multiplicity==1
						const ep.getPortClassName() ep.name;
					ENDIF
				ENDFOR

				/* saps */
				FOR sap: ac.allSAPs
					const sap.getPortClassName() sap.name;
				ENDFOR
				
				/* replicated ports */
				FOR ep : ac.allEndPorts
					IF ep.multiplicity!=1
						const etReplPort ep.name;
					ENDIF
				ENDFOR
				
				/* services */
				FOR svc : ac.allServiceImplementations
					const etReplPort svc.spp.name;
				ENDFOR
			} ac.name_const;
		ENDIF
		
		IF !xpac.stateMachine.empty
			
			xpac.genHeaderConstants
		ENDIF
		
		/* variable part of ActorClass (RAM) */
		struct ac.name {
			IF !(eventPorts.empty && recvPorts.empty && ac.allSAPs.empty && ac.allServiceImplementations.empty)
				const ac.name_const* const constData;
				
			ENDIF
			/* data send ports */
			FOR ep : sendPorts
				IF ep.multiplicity==1
					ep.getPortClassName() ep.name;
				ENDIF
			ENDFOR

			ac.allAttributes.attributes
			
			IF !xpac.stateMachine.empty
			
				xpac.genDataMembers
			ENDIF
		};

		void ac.name_init(ac.name* self);

		void ac.name_receiveMessage(void* self, void* ifitem, const etMessage* msg);
		
		IF dataDriven || async
			void ac.name_execute(ac.name* self);
		ENDIF
		
		ac.operations.operationsDeclaration(ac.name)
		
		ac.userCode(2)
		
		generateIncludeGuardEnd(ac.name)
		
	'''
	}
	
	def private generateSourceFile(Root root, ExpandedActorClass xpac, ActorClass ac) {
		var async = ac.commType==ActorCommunicationType::ASYNCHRONOUS
		var eventDriven = ac.commType==ActorCommunicationType::EVENT_DRIVEN
		var dataDriven = ac.commType==ActorCommunicationType::DATA_DRIVEN
		var handleEvents = async || eventDriven
		
	'''
		/**
		 * @author generated by eTrice
		 *
		 * Source File of ActorClass ac.name
		 * 
		 */

		#include "ac.getCHeaderFileName"
		
		#include "modelbase/etActor.h"
		#include "debugging/etLogger.h"
		#include "debugging/etMSCLogger.h"
		#include "etUnit/etUnit.h"
		#include "platform/etMemory.h"

		FOR pc : root.getReferencedProtocolClasses(ac)
			#include "pc.getCHeaderFileName"
		ENDFOR
		
		ac.userCode(3)

		/* interface item IDs */
		genInterfaceItemConstants(xpac, ac)

		IF !xpac.stateMachine.empty
			xpac.genStateMachine()
		ENDIF
		
		void ac.name_init(ac.name* self){
			ET_MSC_LOGGER_SYNC_ENTRY("ac.name", "init")
			IF !xpac.stateMachine.empty
				xpac.genInitialization
			ENDIF
			ET_MSC_LOGGER_SYNC_EXIT
		}
		
		
		void ac.name_receiveMessage(void* self, void* ifitem, const etMessage* msg){
			ET_MSC_LOGGER_SYNC_ENTRY("ac.name", "_receiveMessage")
			IF !xpac.stateMachine.empty
				
				langExt.operationScope(ac.name, false)receiveEvent(selfIF handleEvents, (etPort*)ifitem, msg->evtID, (void*)(((char*)msg)+MEM_CEIL(sizeof(etMessage)))ENDIF);
			ENDIF
			
			ET_MSC_LOGGER_SYNC_EXIT
		}
		
		IF dataDriven || async
			void ac.name_execute(ac.name* self) {
				ET_MSC_LOGGER_SYNC_ENTRY("ac.name", "_execute")
				IF !xpac.stateMachine.empty
					
					langExt.operationScope(ac.name, false)receiveEvent(selfIF handleEvents, NULL, 0, NULLENDIF);
				ENDIF
				
				ET_MSC_LOGGER_SYNC_EXIT
			}
		ENDIF
		
		ac.operationsImplementation
		
		'''
	}
}
