package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class ProtocolClassGen extends GenericProtocolClassGenerator {
  @Inject
  private JavaIoFileSystemAccess fileAccess;
  
  @Inject
  private CExtensions _cExtensions;
  
  @Inject
  private RoomExtensions _roomExtensions;
  
  @Inject
  private ProcedureHelpers _procedureHelpers;
  
  @Inject
  private TypeHelpers _typeHelpers;
  
  @Inject
  private ILogger logger;
  
  public void doGenerate(final Root root) {
    EList<ProtocolClass> _usedProtocolClasses = root.getUsedProtocolClasses();
    for (final ProtocolClass pc : _usedProtocolClasses) {
      {
        String _generationTargetPath = this._roomExtensions.getGenerationTargetPath(pc);
        String _path = this._roomExtensions.getPath(pc);
        String path = (_generationTargetPath + _path);
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName(pc);
        String _plus = ("generating ProtocolClass header \'" + _cHeaderFileName);
        String _plus_1 = (_plus + "\' in \'");
        String _plus_2 = (_plus_1 + path);
        String _plus_3 = (_plus_2 + "\'");
        this.logger.logInfo(_plus_3);
        this.fileAccess.setOutputPath(path);
        String _cHeaderFileName_1 = this._cExtensions.getCHeaderFileName(pc);
        CharSequence _generateHeaderFile = this.generateHeaderFile(root, pc);
        this.fileAccess.generateFile(_cHeaderFileName_1, _generateHeaderFile);
        String _cSourceFileName = this._cExtensions.getCSourceFileName(pc);
        String _plus_4 = ("generating ProtocolClass source \'" + _cSourceFileName);
        String _plus_5 = (_plus_4 + "\' in \'");
        String _plus_6 = (_plus_5 + path);
        String _plus_7 = (_plus_6 + "\'");
        this.logger.logInfo(_plus_7);
        this.fileAccess.setOutputPath(path);
        String _cSourceFileName_1 = this._cExtensions.getCSourceFileName(pc);
        CharSequence _generateSourceFile = this.generateSourceFile(root, pc);
        this.fileAccess.generateFile(_cSourceFileName_1, _generateSourceFile);
      }
    }
  }
  
  private CharSequence generateHeaderFile(final Root root, final ProtocolClass pc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Header File of ProtocolClass ");
    String _name = pc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    String _name_1 = pc.getName();
    CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(_name_1);
    _builder.append(_generateIncludeGuardBegin, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"etDatatypes.h\"");
    _builder.newLine();
    _builder.append("#include \"modelbase/etPort.h\"");
    _builder.newLine();
    _builder.newLine();
    CharSequence _userCode = this._procedureHelpers.userCode(pc, 1);
    _builder.append(_userCode, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      HashSet<DataClass> _referencedDataClasses = root.getReferencedDataClasses(pc);
      for(final DataClass dataClass : _referencedDataClasses) {
        _builder.append("#include \"");
        String _name_2 = dataClass.getName();
        _builder.append(_name_2, "");
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      CommunicationType _commType = pc.getCommType();
      boolean _equals = Objects.equal(_commType, CommunicationType.EVENT_DRIVEN);
      if (_equals) {
        _builder.newLine();
        _builder.append("/* message IDs */");
        _builder.newLine();
        String _genMessageIDs = this.genMessageIDs(pc);
        _builder.append(_genMessageIDs, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*--------------------- port structs and methods */");
        _builder.newLine();
        CharSequence _portClassHeader = this.portClassHeader(pc, Boolean.valueOf(false));
        _builder.append(_portClassHeader, "");
        _builder.newLineIfNotEmpty();
        CharSequence _portClassHeader_1 = this.portClassHeader(pc, Boolean.valueOf(true));
        _builder.append(_portClassHeader_1, "");
        _builder.newLineIfNotEmpty();
      } else {
        CommunicationType _commType_1 = pc.getCommType();
        boolean _equals_1 = Objects.equal(_commType_1, CommunicationType.DATA_DRIVEN);
        if (_equals_1) {
          _builder.append("/*--------------------- port structs and methods */");
          _builder.newLine();
          CharSequence _genDataDrivenPortHeaders = this.genDataDrivenPortHeaders(pc);
          _builder.append(_genDataDrivenPortHeaders, "");
          _builder.newLineIfNotEmpty();
        } else {
          CommunicationType _commType_2 = pc.getCommType();
          boolean _equals_2 = Objects.equal(_commType_2, CommunicationType.SYNCHRONOUS);
          if (_equals_2) {
            _builder.append("#error \"synchronoue protocols not implemented yet\"");
            _builder.newLine();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("/*--------------------- debug helpers */");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/* get message string for message id */");
    _builder.newLine();
    _builder.append("const char* ");
    String _name_3 = pc.getName();
    _builder.append(_name_3, "");
    _builder.append("_getMessageString(int msg_id);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _userCode_1 = this._procedureHelpers.userCode(pc, 2);
    _builder.append(_userCode_1, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _name_4 = pc.getName();
    CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(_name_4);
    _builder.append(_generateIncludeGuardEnd, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
  
  private CharSequence generateSourceFile(final Root root, final ProtocolClass pc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Source File of ProtocolClass ");
    String _name = pc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _cHeaderFileName = this._cExtensions.getCHeaderFileName(pc);
    _builder.append(_cHeaderFileName, "");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"debugging/etMSCLogger.h\"");
    _builder.newLine();
    _builder.newLine();
    CharSequence _userCode = this._procedureHelpers.userCode(pc, 3);
    _builder.append(_userCode, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/*--------------------- port methods */");
    _builder.newLine();
    {
      CommunicationType _commType = pc.getCommType();
      boolean _equals = Objects.equal(_commType, CommunicationType.EVENT_DRIVEN);
      if (_equals) {
        CharSequence _portClassSource = this.portClassSource(pc, Boolean.valueOf(false));
        _builder.append(_portClassSource, "");
        _builder.newLineIfNotEmpty();
        CharSequence _portClassSource_1 = this.portClassSource(pc, Boolean.valueOf(true));
        _builder.append(_portClassSource_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*--------------------- debug helpers */");
        _builder.newLine();
        CharSequence _generateDebugHelpersImplementation = this.generateDebugHelpersImplementation(root, pc);
        _builder.append(_generateDebugHelpersImplementation, "");
        _builder.newLineIfNotEmpty();
      } else {
        CommunicationType _commType_1 = pc.getCommType();
        boolean _equals_1 = Objects.equal(_commType_1, CommunicationType.DATA_DRIVEN);
        if (_equals_1) {
          CharSequence _genDataDrivenPortSources = this.genDataDrivenPortSources(pc);
          _builder.append(_genDataDrivenPortSources, "");
          _builder.newLineIfNotEmpty();
        } else {
          CommunicationType _commType_2 = pc.getCommType();
          boolean _equals_2 = Objects.equal(_commType_2, CommunicationType.SYNCHRONOUS);
          if (_equals_2) {
            _builder.append("#error \"synchronous protocols not implemented yet\"");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }
  
  private CharSequence portClassHeader(final ProtocolClass pc, final Boolean conj) {
    CharSequence _xblockexpression = null;
    {
      String portClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue());
      String replPortClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue(), true);
      List<Message> _xifexpression = null;
      if ((conj).booleanValue()) {
        List<Message> _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
        _xifexpression = _allIncomingMessages;
      } else {
        List<Message> _allOutgoingMessages = this._roomExtensions.getAllOutgoingMessages(pc);
        _xifexpression = _allOutgoingMessages;
      }
      List<Message> messages = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("typedef etPort ");
      _builder.append(portClassName, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("typedef etReplPort ");
      _builder.append(replPortClassName, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        PortClass _portClass = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
        boolean _notEquals = (!Objects.equal(_portClass, null));
        if (_notEquals) {
          {
            PortClass _portClass_1 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
            EList<Attribute> _attributes = _portClass_1.getAttributes();
            boolean _isEmpty = _attributes.isEmpty();
            boolean _not = (!_isEmpty);
            if (_not) {
              _builder.append("/* variable part of PortClass (RAM) */");
              _builder.newLine();
              _builder.append("typedef struct ");
              _builder.append(portClassName, "");
              _builder.append("_var ");
              _builder.append(portClassName, "");
              _builder.append("_var; ");
              _builder.newLineIfNotEmpty();
              _builder.append("struct ");
              _builder.append(portClassName, "");
              _builder.append("_var {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              PortClass _portClass_2 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
              EList<Attribute> _attributes_1 = _portClass_2.getAttributes();
              CharSequence _attributes_2 = this._procedureHelpers.attributes(_attributes_1);
              _builder.append(_attributes_2, "	");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("};");
              _builder.newLine();
              {
                PortClass _portClass_3 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
                EList<Attribute> _attributes_3 = _portClass_3.getAttributes();
                for(final Attribute a : _attributes_3) {
                  {
                    String _defaultValueLiteral = a.getDefaultValueLiteral();
                    boolean _notEquals_1 = (!Objects.equal(_defaultValueLiteral, null));
                    if (_notEquals_1) {
                      String _plus = (portClassName + " ");
                      String _name = a.getName();
                      String _plus_1 = (_plus + _name);
                      String _plus_2 = (_plus_1 + ": Attribute initialization not supported in C");
                      this.logger.logInfo(_plus_2);
                      _builder.newLineIfNotEmpty();
                    }
                  }
                }
              }
            }
          }
        }
      }
      _builder.newLine();
      {
        for(final Message message : messages) {
          VarDecl _data = message.getData();
          boolean hasData = (!Objects.equal(_data, null));
          _builder.newLineIfNotEmpty();
          String _xifexpression_1 = null;
          if (hasData) {
            VarDecl _data_1 = message.getData();
            RefableType _refType = _data_1.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _xifexpression_1 = _typeName;
          } else {
            _xifexpression_1 = "";
          }
          String typeName = _xifexpression_1;
          _builder.newLineIfNotEmpty();
          String _xifexpression_2 = null;
          boolean _and = false;
          if (!hasData) {
            _and = false;
          } else {
            boolean _or = false;
            VarDecl _data_2 = message.getData();
            RefableType _refType_1 = _data_2.getRefType();
            DataType _type_1 = _refType_1.getType();
            boolean _not_1 = (!(_type_1 instanceof PrimitiveType));
            if (_not_1) {
              _or = true;
            } else {
              VarDecl _data_3 = message.getData();
              RefableType _refType_2 = _data_3.getRefType();
              boolean _isRef = _refType_2.isRef();
              _or = (_not_1 || _isRef);
            }
            _and = (hasData && _or);
          }
          if (_and) {
            _xifexpression_2 = "*";
          } else {
            _xifexpression_2 = "";
          }
          String refp = _xifexpression_2;
          _builder.newLineIfNotEmpty();
          String _xifexpression_3 = null;
          if (hasData) {
            String _plus_3 = (", " + typeName);
            String _plus_4 = (_plus_3 + refp);
            String _plus_5 = (_plus_4 + " data");
            _xifexpression_3 = _plus_5;
          } else {
            _xifexpression_3 = "";
          }
          String data = _xifexpression_3;
          _builder.newLineIfNotEmpty();
          String _name_1 = message.getName();
          String _messageSignature = this.messageSignature(portClassName, _name_1, "", data);
          _builder.append(_messageSignature, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          String _name_2 = message.getName();
          String _messageSignature_1 = this.messageSignature(replPortClassName, _name_2, "_broadcast", data);
          _builder.append(_messageSignature_1, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          String _name_3 = message.getName();
          String _plus_6 = (", int idx" + data);
          String _messageSignature_2 = this.messageSignature(replPortClassName, _name_3, "", _plus_6);
          _builder.append(_messageSignature_2, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      {
        PortClass _portClass_4 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
        boolean _notEquals_2 = (!Objects.equal(_portClass_4, null));
        if (_notEquals_2) {
          PortClass _portClass_5 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
          EList<PortOperation> _operations = _portClass_5.getOperations();
          CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration(_operations, portClassName);
          _builder.append(_operationsDeclaration, "");
          _builder.newLineIfNotEmpty();
          PortClass _portClass_6 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
          EList<PortOperation> _operations_1 = _portClass_6.getOperations();
          CharSequence _operationsDeclaration_1 = this._procedureHelpers.operationsDeclaration(_operations_1, replPortClassName);
          _builder.append(_operationsDeclaration_1, "");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      {
        boolean _handlesReceive = this._roomExtensions.handlesReceive(pc, (conj).booleanValue());
        if (_handlesReceive) {
          {
            List<MessageHandler> _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, (conj).booleanValue());
            for(final MessageHandler h : _receiveHandlers) {
              _builder.append("void ");
              _builder.append(portClassName, "");
              _builder.append("_");
              Message _msg = h.getMsg();
              String _name_4 = _msg.getName();
              _builder.append(_name_4, "");
              _builder.append("_receiveHandler(");
              _builder.append(portClassName, "");
              _builder.append("* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc);");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.append("etInt32 ");
      _builder.append(replPortClassName, "");
      _builder.append("_getReplication(const ");
      _builder.append(replPortClassName, "");
      _builder.append("* self);");
      _builder.newLineIfNotEmpty();
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  private CharSequence genDataDrivenPortHeaders(final ProtocolClass pc) {
    CharSequence _xblockexpression = null;
    {
      List<Message> _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
      final Function1<Message,Boolean> _function = new Function1<Message,Boolean>() {
          public Boolean apply(final Message m) {
            VarDecl _data = m.getData();
            boolean _notEquals = (!Objects.equal(_data, null));
            return Boolean.valueOf(_notEquals);
          }
        };
      Iterable<Message> sentMsgs = IterableExtensions.<Message>filter(_allIncomingMessages, _function);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/* data driven send port (conjugated) */");
      _builder.newLine();
      _builder.append("typedef struct {");
      _builder.newLine();
      {
        for(final Message msg : sentMsgs) {
          _builder.append("\t");
          VarDecl _data = msg.getData();
          RefableType _refType = _data.getRefType();
          DataType _type = _refType.getType();
          String typeName = this._typeHelpers.typeName(_type);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String _xifexpression = null;
          VarDecl _data_1 = msg.getData();
          RefableType _refType_1 = _data_1.getRefType();
          boolean _isRef = _refType_1.isRef();
          if (_isRef) {
            _xifexpression = "*";
          } else {
            _xifexpression = "";
          }
          String refp = _xifexpression;
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(typeName, "	");
          _builder.append(refp, "	");
          _builder.append(" ");
          String _name = msg.getName();
          _builder.append(_name, "	");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("}");
      _builder.newLine();
      String _portClassName = this._roomExtensions.getPortClassName(pc, true);
      _builder.append(_portClassName, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("/* data driven receive port (regular) */");
      _builder.newLine();
      _builder.append("typedef struct {");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("const ");
      String _portClassName_1 = this._roomExtensions.getPortClassName(pc, true);
      _builder.append(_portClassName_1, "	");
      _builder.append("* peer;");
      _builder.newLineIfNotEmpty();
      _builder.append("}");
      _builder.newLine();
      String _portClassName_2 = this._roomExtensions.getPortClassName(pc, false);
      _builder.append(_portClassName_2, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        for(final Message message : sentMsgs) {
          VarDecl _data_2 = message.getData();
          boolean hasData = (!Objects.equal(_data_2, null));
          _builder.newLineIfNotEmpty();
          String _xifexpression_1 = null;
          if (hasData) {
            VarDecl _data_3 = message.getData();
            RefableType _refType_2 = _data_3.getRefType();
            DataType _type_1 = _refType_2.getType();
            String _typeName = this._typeHelpers.typeName(_type_1);
            _xifexpression_1 = _typeName;
          } else {
            _xifexpression_1 = "";
          }
          String typeName_1 = _xifexpression_1;
          _builder.newLineIfNotEmpty();
          String _xifexpression_2 = null;
          boolean _and = false;
          if (!hasData) {
            _and = false;
          } else {
            VarDecl _data_4 = message.getData();
            RefableType _refType_3 = _data_4.getRefType();
            DataType _type_2 = _refType_3.getType();
            boolean _not = (!(_type_2 instanceof PrimitiveType));
            _and = (hasData && _not);
          }
          if (_and) {
            _xifexpression_2 = "*";
          } else {
            _xifexpression_2 = "";
          }
          String refp_1 = _xifexpression_2;
          _builder.newLineIfNotEmpty();
          String _xifexpression_3 = null;
          if (hasData) {
            String _plus = (", " + typeName_1);
            String _plus_1 = (_plus + refp_1);
            String _plus_2 = (_plus_1 + " data");
            _xifexpression_3 = _plus_2;
          } else {
            _xifexpression_3 = "";
          }
          String data = _xifexpression_3;
          _builder.newLineIfNotEmpty();
          String _portClassName_3 = this._roomExtensions.getPortClassName(pc, true);
          String _name_1 = message.getName();
          String _messageSetterSignature = this.messageSetterSignature(_portClassName_3, _name_1, data);
          _builder.append(_messageSetterSignature, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          String _portClassName_4 = this._roomExtensions.getPortClassName(pc, false);
          String _name_2 = message.getName();
          String _messageGetterSignature = this.messageGetterSignature(_portClassName_4, _name_2, typeName_1);
          _builder.append(_messageGetterSignature, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
        }
      }
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  private CharSequence genDataDrivenPortSources(final ProtocolClass pc) {
    CharSequence _xblockexpression = null;
    {
      List<Message> _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
      final Function1<Message,Boolean> _function = new Function1<Message,Boolean>() {
          public Boolean apply(final Message m) {
            VarDecl _data = m.getData();
            boolean _notEquals = (!Objects.equal(_data, null));
            return Boolean.valueOf(_notEquals);
          }
        };
      Iterable<Message> messages = IterableExtensions.<Message>filter(_allIncomingMessages, _function);
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final Message message : messages) {
          VarDecl _data = message.getData();
          RefableType _refType = _data.getRefType();
          DataType _type = _refType.getType();
          String typeName = this._typeHelpers.typeName(_type);
          _builder.newLineIfNotEmpty();
          String _xifexpression = null;
          VarDecl _data_1 = message.getData();
          RefableType _refType_1 = _data_1.getRefType();
          DataType _type_1 = _refType_1.getType();
          boolean _not = (!(_type_1 instanceof PrimitiveType));
          if (_not) {
            _xifexpression = "*";
          } else {
            _xifexpression = "";
          }
          String refp = _xifexpression;
          _builder.newLineIfNotEmpty();
          String _plus = (", " + typeName);
          String _plus_1 = (_plus + refp);
          String data = (_plus_1 + " data");
          _builder.newLineIfNotEmpty();
          String _portClassName = this._roomExtensions.getPortClassName(pc, true);
          String _name = message.getName();
          String _messageSetterSignature = this.messageSetterSignature(_portClassName, _name, data);
          _builder.append(_messageSetterSignature, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("self->");
          String _name_1 = message.getName();
          _builder.append(_name_1, "	");
          _builder.append(" = data;");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
          String _portClassName_1 = this._roomExtensions.getPortClassName(pc, false);
          String _name_2 = message.getName();
          String _messageGetterSignature = this.messageGetterSignature(_portClassName_1, _name_2, typeName);
          _builder.append(_messageGetterSignature, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("return self->peer->");
          String _name_3 = message.getName();
          _builder.append(_name_3, "	");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
        }
      }
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  private CharSequence portClassSource(final ProtocolClass pc, final Boolean conj) {
    CharSequence _xblockexpression = null;
    {
      String portClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue());
      String replPortClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue(), true);
      List<Message> _xifexpression = null;
      if ((conj).booleanValue()) {
        List<Message> _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
        _xifexpression = _allIncomingMessages;
      } else {
        List<Message> _allOutgoingMessages = this._roomExtensions.getAllOutgoingMessages(pc);
        _xifexpression = _allOutgoingMessages;
      }
      List<Message> messages = _xifexpression;
      String _xifexpression_1 = null;
      if ((conj).booleanValue()) {
        _xifexpression_1 = "IN_";
      } else {
        _xifexpression_1 = "OUT_";
      }
      String dir = _xifexpression_1;
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final Message message : messages) {
          VarDecl _data = message.getData();
          boolean hasData = (!Objects.equal(_data, null));
          _builder.newLineIfNotEmpty();
          String _xifexpression_2 = null;
          if (hasData) {
            VarDecl _data_1 = message.getData();
            RefableType _refType = _data_1.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _xifexpression_2 = _typeName;
          } else {
            _xifexpression_2 = "";
          }
          String typeName = _xifexpression_2;
          _builder.newLineIfNotEmpty();
          String _xifexpression_3 = null;
          boolean _and = false;
          if (!hasData) {
            _and = false;
          } else {
            VarDecl _data_2 = message.getData();
            RefableType _refType_1 = _data_2.getRefType();
            boolean _isRef = _refType_1.isRef();
            _and = (hasData && _isRef);
          }
          if (_and) {
            _xifexpression_3 = "*";
          } else {
            _xifexpression_3 = "";
          }
          String refp = _xifexpression_3;
          _builder.newLineIfNotEmpty();
          String _xifexpression_4 = null;
          boolean _and_1 = false;
          if (!hasData) {
            _and_1 = false;
          } else {
            boolean _or = false;
            VarDecl _data_3 = message.getData();
            RefableType _refType_2 = _data_3.getRefType();
            DataType _type_1 = _refType_2.getType();
            boolean _not = (!(_type_1 instanceof PrimitiveType));
            if (_not) {
              _or = true;
            } else {
              VarDecl _data_4 = message.getData();
              RefableType _refType_3 = _data_4.getRefType();
              boolean _isRef_1 = _refType_3.isRef();
              _or = (_not || _isRef_1);
            }
            _and_1 = (hasData && _or);
          }
          if (_and_1) {
            _xifexpression_4 = "*";
          } else {
            _xifexpression_4 = "";
          }
          String refpd = _xifexpression_4;
          _builder.newLineIfNotEmpty();
          String _xifexpression_5 = null;
          boolean _and_2 = false;
          boolean _and_3 = false;
          if (!hasData) {
            _and_3 = false;
          } else {
            VarDecl _data_5 = message.getData();
            RefableType _refType_4 = _data_5.getRefType();
            DataType _type_2 = _refType_4.getType();
            boolean _not_1 = (!(_type_2 instanceof PrimitiveType));
            _and_3 = (hasData && _not_1);
          }
          if (!_and_3) {
            _and_2 = false;
          } else {
            VarDecl _data_6 = message.getData();
            RefableType _refType_5 = _data_6.getRefType();
            boolean _isRef_2 = _refType_5.isRef();
            boolean _not_2 = (!_isRef_2);
            _and_2 = (_and_3 && _not_2);
          }
          if (_and_2) {
            _xifexpression_5 = "";
          } else {
            _xifexpression_5 = "&";
          }
          String refa = _xifexpression_5;
          _builder.newLineIfNotEmpty();
          String _xifexpression_6 = null;
          if (hasData) {
            String _plus = (", " + typeName);
            String _plus_1 = (_plus + refpd);
            String _plus_2 = (_plus_1 + " data");
            _xifexpression_6 = _plus_2;
          } else {
            _xifexpression_6 = "";
          }
          String data = _xifexpression_6;
          _builder.newLineIfNotEmpty();
          String _xifexpression_7 = null;
          if (hasData) {
            _xifexpression_7 = ", data";
          } else {
            _xifexpression_7 = "";
          }
          String dataCall = _xifexpression_7;
          _builder.newLineIfNotEmpty();
          MessageHandler hdlr = this._roomExtensions.getSendHandler(message, (conj).booleanValue());
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          String _name = message.getName();
          String _messageSignature = this.messageSignature(portClassName, _name, "", data);
          _builder.append(_messageSignature, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            boolean _notEquals = (!Objects.equal(hdlr, null));
            if (_notEquals) {
              _builder.append("\t");
              {
                DetailCode _detailCode = hdlr.getDetailCode();
                EList<String> _commands = _detailCode.getCommands();
                for(final String command : _commands) {
                  _builder.append("\t");
                  _builder.append(command, "	");
                  _builder.newLineIfNotEmpty();
                }
              }
            } else {
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
              _builder.append(portClassName, "	");
              _builder.append("\", \"");
              String _name_1 = message.getName();
              _builder.append(_name_1, "	");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              String _name_2 = pc.getName();
              String _name_3 = message.getName();
              String _plus_3 = (dir + _name_3);
              String _memberInUse = this._cExtensions.memberInUse(_name_2, _plus_3);
              String _plus_4 = (typeName + refp);
              String _plus_5 = (refa + "data");
              String _sendMessageCall = this.sendMessageCall(hasData, "self", _memberInUse, _plus_4, _plus_5);
              _builder.append(_sendMessageCall, "		");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
              _builder.newLine();
            }
          }
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          String _name_4 = message.getName();
          String _messageSignature_1 = this.messageSignature(replPortClassName, _name_4, "_broadcast", data);
          _builder.append(_messageSignature_1, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            boolean _notEquals_1 = (!Objects.equal(hdlr, null));
            if (_notEquals_1) {
              _builder.append("\t");
              _builder.append("int i;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("for (i=0; i<((etReplPort*)self)->size; ++i) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append(portClassName, "		");
              _builder.append("_");
              String _name_5 = message.getName();
              _builder.append(_name_5, "		");
              _builder.append("((etPort*)&((etReplPort*)self)->ports[i]");
              _builder.append(dataCall, "		");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}\t\t\t\t\t");
              _builder.newLine();
            } else {
              _builder.append("\t");
              _builder.append("int i;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
              _builder.append(replPortClassName, "	");
              _builder.append("\", \"");
              String _name_6 = message.getName();
              _builder.append(_name_6, "	");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("for (i=0; i<((etReplPort*)self)->size; ++i) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              String _name_7 = pc.getName();
              String _name_8 = message.getName();
              String _plus_6 = (dir + _name_8);
              String _memberInUse_1 = this._cExtensions.memberInUse(_name_7, _plus_6);
              String _plus_7 = (typeName + refp);
              String _plus_8 = (refa + "data");
              String _sendMessageCall_1 = this.sendMessageCall(hasData, "((etPort*)&((etReplPort*)self)->ports[i])", _memberInUse_1, _plus_7, _plus_8);
              _builder.append(_sendMessageCall_1, "		");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
              _builder.newLine();
            }
          }
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          String _name_9 = message.getName();
          String _plus_9 = (", int idx" + data);
          String _messageSignature_2 = this.messageSignature(replPortClassName, _name_9, "", _plus_9);
          _builder.append(_messageSignature_2, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            boolean _notEquals_2 = (!Objects.equal(hdlr, null));
            if (_notEquals_2) {
              _builder.append("\t");
              _builder.append(portClassName, "	");
              _builder.append("_");
              String _name_10 = message.getName();
              _builder.append(_name_10, "	");
              _builder.append("((etPort*)&((etReplPort*)self)->ports[idx]");
              _builder.append(dataCall, "	");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            } else {
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
              _builder.append(replPortClassName, "	");
              _builder.append("\", \"");
              String _name_11 = message.getName();
              _builder.append(_name_11, "	");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("if (0<=idx && idx<((etReplPort*)self)->size) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              String _name_12 = pc.getName();
              String _name_13 = message.getName();
              String _plus_10 = (dir + _name_13);
              String _memberInUse_2 = this._cExtensions.memberInUse(_name_12, _plus_10);
              String _plus_11 = (typeName + refp);
              String _plus_12 = (refa + "data");
              String _sendMessageCall_2 = this.sendMessageCall(hasData, "((etPort*)&((etReplPort*)self)->ports[idx])", _memberInUse_2, _plus_11, _plus_12);
              _builder.append(_sendMessageCall_2, "		");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
              _builder.newLine();
            }
          }
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        PortClass _portClass = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
        boolean _notEquals_3 = (!Objects.equal(_portClass, null));
        if (_notEquals_3) {
          PortClass _portClass_1 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
          EList<PortOperation> _operations = _portClass_1.getOperations();
          CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation(_operations, portClassName);
          _builder.append(_operationsImplementation, "");
          _builder.newLineIfNotEmpty();
          PortClass _portClass_2 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
          EList<PortOperation> _operations_1 = _portClass_2.getOperations();
          CharSequence _operationsImplementation_1 = this._procedureHelpers.operationsImplementation(_operations_1, replPortClassName);
          _builder.append(_operationsImplementation_1, "");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("// getReplication");
      _builder.newLine();
      _builder.append("etInt32 ");
      _builder.append(replPortClassName, "");
      _builder.append("_getReplication(const ");
      _builder.append(replPortClassName, "");
      _builder.append("* self) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("return ((etReplPort*)self)->size;");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      {
        boolean _handlesReceive = this._roomExtensions.handlesReceive(pc, (conj).booleanValue());
        if (_handlesReceive) {
          CharSequence _genReceiveHandlers = this.genReceiveHandlers(pc, conj);
          _builder.append(_genReceiveHandlers, "");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  private String sendMessageCall(final boolean hasData, final String self, final String msg, final String typeName, final String data) {
    String _xifexpression = null;
    if (hasData) {
      String _plus = ("etPort_sendMessage(" + self);
      String _plus_1 = (_plus + ", ");
      String _plus_2 = (_plus_1 + msg);
      String _plus_3 = (_plus_2 + ", sizeof(");
      String _plus_4 = (_plus_3 + typeName);
      String _plus_5 = (_plus_4 + "), ");
      String _plus_6 = (_plus_5 + data);
      String _plus_7 = (_plus_6 + ");");
      _xifexpression = _plus_7;
    } else {
      String _plus_8 = ("etPort_sendMessage(" + self);
      String _plus_9 = (_plus_8 + ", ");
      String _plus_10 = (_plus_9 + msg);
      String _plus_11 = (_plus_10 + ", 0, NULL);");
      _xifexpression = _plus_11;
    }
    return _xifexpression;
  }
  
  private String messageSignature(final String className, final String messageName, final String methodSuffix, final String data) {
    String _plus = ("void " + className);
    String _plus_1 = (_plus + "_");
    String _plus_2 = (_plus_1 + messageName);
    String _plus_3 = (_plus_2 + methodSuffix);
    String _plus_4 = (_plus_3 + "(const ");
    String _plus_5 = (_plus_4 + className);
    String _plus_6 = (_plus_5 + "* self");
    String _plus_7 = (_plus_6 + data);
    String _plus_8 = (_plus_7 + ")");
    return _plus_8;
  }
  
  private String messageSetterSignature(final String className, final String messageName, final String data) {
    String _plus = ("void " + className);
    String _plus_1 = (_plus + "_");
    String _plus_2 = (_plus_1 + messageName);
    String _plus_3 = (_plus_2 + "_set(");
    String _plus_4 = (_plus_3 + className);
    String _plus_5 = (_plus_4 + "* self");
    String _plus_6 = (_plus_5 + data);
    String _plus_7 = (_plus_6 + ")");
    return _plus_7;
  }
  
  private String messageGetterSignature(final String className, final String messageName, final String type) {
    String _plus = (type + " ");
    String _plus_1 = (_plus + className);
    String _plus_2 = (_plus_1 + "_");
    String _plus_3 = (_plus_2 + messageName);
    String _plus_4 = (_plus_3 + "_get(const ");
    String _plus_5 = (_plus_4 + className);
    String _plus_6 = (_plus_5 + "* const self)");
    return _plus_6;
  }
  
  private CharSequence genReceiveHandlers(final ProtocolClass pc, final Boolean conj) {
    CharSequence _xblockexpression = null;
    {
      String portClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue());
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/* receiver handlers */");
      _builder.newLine();
      {
        List<MessageHandler> _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, (conj).booleanValue());
        for(final MessageHandler h : _receiveHandlers) {
          _builder.append("void ");
          _builder.append(portClassName, "");
          _builder.append("_");
          Message _msg = h.getMsg();
          String _name = _msg.getName();
          _builder.append(_name, "");
          _builder.append("_receiveHandler(");
          _builder.append(portClassName, "");
          _builder.append("* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc){");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          DetailCode _detailCode = h.getDetailCode();
          CharSequence _userCode = this._procedureHelpers.userCode(_detailCode);
          _builder.append(_userCode, "	");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("/* hand over the message to the actor:      */");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/* (*receiveMessageFunc)(actor, self, msg); */");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      }
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  private CharSequence generateDebugHelpersImplementation(final Root root, final ProtocolClass pc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("/* message names as strings for debugging (generate MSC) */");
    _builder.newLine();
    _builder.append("static const char* const ");
    String _name = pc.getName();
    _builder.append(_name, "");
    _builder.append("_messageStrings[] = {\"MIN\", ");
    {
      List<Message> _allOutgoingMessages = this._roomExtensions.getAllOutgoingMessages(pc);
      for(final Message m : _allOutgoingMessages) {
        _builder.append("\"");
        String _name_1 = m.getName();
        _builder.append(_name_1, "");
        _builder.append("\",");
      }
    }
    {
      List<Message> _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
      for(final Message m_1 : _allIncomingMessages) {
        _builder.append("\"");
        String _name_2 = m_1.getName();
        _builder.append(_name_2, "");
        _builder.append("\", ");
      }
    }
    _builder.append("\"MAX\"};");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("const char* ");
    String _name_3 = pc.getName();
    _builder.append(_name_3, "");
    _builder.append("_getMessageString(int msg_id) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (msg_id<");
    String _name_4 = pc.getName();
    _builder.append(_name_4, "	");
    _builder.append("_MSG_MIN || msg_id>");
    String _name_5 = pc.getName();
    _builder.append(_name_5, "	");
    _builder.append("_MSG_MAX+1){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("/* id out of range */");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return \"Message ID out of range\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("else{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    String _name_6 = pc.getName();
    _builder.append(_name_6, "		");
    _builder.append("_messageStrings[msg_id];");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
