/**
 * Copyright (c) 2012 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Juergen Haug (initial contribution)
 */
package org.eclipse.etrice.core.etphys.postprocessing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.common.postprocessing.PostprocessingHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.GeneratedMetamodel;

@SuppressWarnings("all")
public class DocuPostprocessor {
  public void process(final GeneratedMetamodel metamodel) {
    final EPackage pckg = metamodel.getEPackage();
    EClass cls = PostprocessingHelpers.getClass(pckg, "PhysicalModel");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("The root object for the physical model. It gives access to the systems, node classes");
    _builder.newLine();
    _builder.append("and runtimes defined.");
    _builder.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder.toString());
    EAttribute _attribute = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("The model name is a dot separated fully qualified name and is");
    _builder_1.newLine();
    _builder_1.append("used to provide a name space.");
    _builder_1.newLine();
    PostprocessingHelpers.setDocumentation(_attribute, _builder_1.toString());
    EReference _reference = PostprocessingHelpers.getReference(cls, "imports");
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append("A list of all imported models.");
    _builder_2.newLine();
    PostprocessingHelpers.setDocumentation(_reference, _builder_2.toString());
    EReference _reference_1 = PostprocessingHelpers.getReference(cls, "systems");
    StringConcatenation _builder_3 = new StringConcatenation();
    _builder_3.append("A list of all defined physical systems.");
    _builder_3.newLine();
    PostprocessingHelpers.setDocumentation(_reference_1, _builder_3.toString());
    EReference _reference_2 = PostprocessingHelpers.getReference(cls, "nodeClasses");
    StringConcatenation _builder_4 = new StringConcatenation();
    _builder_4.append("A list of all defined node classes.");
    _builder_4.newLine();
    PostprocessingHelpers.setDocumentation(_reference_2, _builder_4.toString());
    EReference _reference_3 = PostprocessingHelpers.getReference(cls, "runtimeClasses");
    StringConcatenation _builder_5 = new StringConcatenation();
    _builder_5.append("A list of all defined runtime classes.");
    _builder_5.newLine();
    PostprocessingHelpers.setDocumentation(_reference_3, _builder_5.toString());
    EClass _class = PostprocessingHelpers.getClass(pckg, "PhysicalSystem");
    cls = _class;
    StringConcatenation _builder_6 = new StringConcatenation();
    _builder_6.append("This model object represents a complete physical system.");
    _builder_6.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_6.toString());
    EAttribute _attribute_1 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_7 = new StringConcatenation();
    _builder_7.append("The name of the physical system by which it is referred to in the model.");
    _builder_7.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_1, _builder_7.toString());
    EReference _reference_4 = PostprocessingHelpers.getReference(cls, "nodeRefs");
    StringConcatenation _builder_8 = new StringConcatenation();
    _builder_8.append("A list of referenced nodes.");
    _builder_8.newLine();
    PostprocessingHelpers.setDocumentation(_reference_4, _builder_8.toString());
    EReference _reference_5 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_9 = new StringConcatenation();
    _builder_9.append("This is an optional documentation.");
    _builder_9.newLine();
    PostprocessingHelpers.setDocumentation(_reference_5, _builder_9.toString());
    EClass _class_1 = PostprocessingHelpers.getClass(pckg, "NodeRef");
    cls = _class_1;
    StringConcatenation _builder_10 = new StringConcatenation();
    _builder_10.append("This stands for a node instance in a specific role.");
    _builder_10.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_10.toString());
    EAttribute _attribute_2 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_11 = new StringConcatenation();
    _builder_11.append("The name of the reference by which it is referred to in the model.");
    _builder_11.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_2, _builder_11.toString());
    EReference _reference_6 = PostprocessingHelpers.getReference(cls, "type");
    StringConcatenation _builder_12 = new StringConcatenation();
    _builder_12.append("The node class of this reference.");
    _builder_12.newLine();
    PostprocessingHelpers.setDocumentation(_reference_6, _builder_12.toString());
    EReference _reference_7 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_13 = new StringConcatenation();
    _builder_13.append("This is an optional documentation.");
    _builder_13.newLine();
    PostprocessingHelpers.setDocumentation(_reference_7, _builder_13.toString());
    EClass _class_2 = PostprocessingHelpers.getClass(pckg, "NodeClass");
    cls = _class_2;
    StringConcatenation _builder_14 = new StringConcatenation();
    _builder_14.append("This defines a node class.");
    _builder_14.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_14.toString());
    EAttribute _attribute_3 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_15 = new StringConcatenation();
    _builder_15.append("The name of the node class by which it is referred to in the model.");
    _builder_15.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_3, _builder_15.toString());
    EReference _reference_8 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_16 = new StringConcatenation();
    _builder_16.append("This is an optional documentation.");
    _builder_16.newLine();
    PostprocessingHelpers.setDocumentation(_reference_8, _builder_16.toString());
    EReference _reference_9 = PostprocessingHelpers.getReference(cls, "runtime");
    StringConcatenation _builder_17 = new StringConcatenation();
    _builder_17.append("This is the associated runtime class.");
    _builder_17.newLine();
    PostprocessingHelpers.setDocumentation(_reference_9, _builder_17.toString());
    EAttribute _attribute_4 = PostprocessingHelpers.getAttribute(cls, "priomin");
    StringConcatenation _builder_18 = new StringConcatenation();
    _builder_18.append("This is the minimal thread priority for this node type.");
    _builder_18.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_4, _builder_18.toString());
    EAttribute _attribute_5 = PostprocessingHelpers.getAttribute(cls, "priomax");
    StringConcatenation _builder_19 = new StringConcatenation();
    _builder_19.append("This is the maximum thread priority for this node type.");
    _builder_19.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_5, _builder_19.toString());
    EReference _reference_10 = PostprocessingHelpers.getReference(cls, "threads");
    StringConcatenation _builder_20 = new StringConcatenation();
    _builder_20.append("This is a list of all threads defined for this node.");
    _builder_20.newLine();
    PostprocessingHelpers.setDocumentation(_reference_10, _builder_20.toString());
    EClass _class_3 = PostprocessingHelpers.getClass(pckg, "PhysicalThread");
    cls = _class_3;
    StringConcatenation _builder_21 = new StringConcatenation();
    _builder_21.append("This defines a physical thread running in a node.");
    _builder_21.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_21.toString());
    EAttribute _attribute_6 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_22 = new StringConcatenation();
    _builder_22.append("The name of the thread by which it is referred to in the model.");
    _builder_22.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_6, _builder_22.toString());
    EAttribute _attribute_7 = PostprocessingHelpers.getAttribute(cls, "default");
    StringConcatenation _builder_23 = new StringConcatenation();
    _builder_23.append("If this is {@code true} then this is the default thread.");
    _builder_23.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_7, _builder_23.toString());
    EAttribute _attribute_8 = PostprocessingHelpers.getAttribute(cls, "execmode");
    StringConcatenation _builder_24 = new StringConcatenation();
    _builder_24.append("This is the execution mode of the thread.");
    _builder_24.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_8, _builder_24.toString());
    EAttribute _attribute_9 = PostprocessingHelpers.getAttribute(cls, "prio");
    StringConcatenation _builder_25 = new StringConcatenation();
    _builder_25.append("This is the priority of the thread.");
    _builder_25.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_9, _builder_25.toString());
    EAttribute _attribute_10 = PostprocessingHelpers.getAttribute(cls, "stacksize");
    StringConcatenation _builder_26 = new StringConcatenation();
    _builder_26.append("This is the stacksize of the thread.");
    _builder_26.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_10, _builder_26.toString());
    EAttribute _attribute_11 = PostprocessingHelpers.getAttribute(cls, "msgblocksize");
    StringConcatenation _builder_27 = new StringConcatenation();
    _builder_27.append("This is the msgblocksize of the thread.");
    _builder_27.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_11, _builder_27.toString());
    EAttribute _attribute_12 = PostprocessingHelpers.getAttribute(cls, "msgpoolsize");
    StringConcatenation _builder_28 = new StringConcatenation();
    _builder_28.append("This is the msgpoolsize of the thread.");
    _builder_28.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_12, _builder_28.toString());
    EClass _class_4 = PostprocessingHelpers.getClass(pckg, "RuntimeClass");
    cls = _class_4;
    StringConcatenation _builder_29 = new StringConcatenation();
    _builder_29.append("This defines a runtime class.");
    _builder_29.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_29.toString());
    EAttribute _attribute_13 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_30 = new StringConcatenation();
    _builder_30.append("The name of the runtime class by which it is referred to in the model.");
    _builder_30.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_13, _builder_30.toString());
    EReference _reference_11 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_31 = new StringConcatenation();
    _builder_31.append("This is an optional documentation.");
    _builder_31.newLine();
    PostprocessingHelpers.setDocumentation(_reference_11, _builder_31.toString());
    EAttribute _attribute_14 = PostprocessingHelpers.getAttribute(cls, "threadModel");
    StringConcatenation _builder_32 = new StringConcatenation();
    _builder_32.append("This distinguishes single and multi threaded.");
    _builder_32.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_14, _builder_32.toString());
    EClass _class_5 = PostprocessingHelpers.getClass(pckg, "Documentation");
    cls = _class_5;
    StringConcatenation _builder_33 = new StringConcatenation();
    _builder_33.append("A piece of documentation that can be optionally attached at");
    _builder_33.newLine();
    _builder_33.append("certain places in the model.");
    _builder_33.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_33.toString());
    EAttribute _attribute_15 = PostprocessingHelpers.getAttribute(cls, "text");
    StringConcatenation _builder_34 = new StringConcatenation();
    _builder_34.append("This is the documentation\'s contents.");
    _builder_34.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_15, _builder_34.toString());
    EClass _class_6 = PostprocessingHelpers.getClass(pckg, "Import");
    cls = _class_6;
    StringConcatenation _builder_35 = new StringConcatenation();
    _builder_35.append("The import declares an imported model (given as a URI) and");
    _builder_35.newLine();
    _builder_35.append("an optional imported namespace.");
    _builder_35.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_35.toString());
    EAttribute _attribute_16 = PostprocessingHelpers.getAttribute(cls, "importedNamespace");
    StringConcatenation _builder_36 = new StringConcatenation();
    _builder_36.append("The imported name space has to be a dot separated qualified name followed by .*.");
    _builder_36.newLine();
    _builder_36.append("Example: my.namespace.*");
    _builder_36.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_16, _builder_36.toString());
    EAttribute _attribute_17 = PostprocessingHelpers.getAttribute(cls, "importURI");
    StringConcatenation _builder_37 = new StringConcatenation();
    _builder_37.append("The import URI can be a relative or absolute file system path.");
    _builder_37.newLine();
    _builder_37.append("It may contain environment variables in ${} which will be expanded.");
    _builder_37.newLine();
    _builder_37.append("<p>");
    _builder_37.newLine();
    _builder_37.append("Examples:");
    _builder_37.newLine();
    _builder_37.append("<ul>");
    _builder_37.newLine();
    _builder_37.append("  ");
    _builder_37.append("<li>import model \"AnotherModel.room\"</li>");
    _builder_37.newLine();
    _builder_37.append("  ");
    _builder_37.append("<li>import my.namespace.* from \"AnotherModel.room\"</li>");
    _builder_37.newLine();
    _builder_37.append("  ");
    _builder_37.append("<li>import my.namespace.* from \"../../AnotherProject/models/AnotherModel.room\"</li>");
    _builder_37.newLine();
    _builder_37.append("  ");
    _builder_37.append("<li>import my.namespace.* from \"/${ROOM_MODELS}/SomeModel.room\"</li>");
    _builder_37.newLine();
    _builder_37.append("</ul>");
    _builder_37.newLine();
    _builder_37.append("</p>");
    _builder_37.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_17, _builder_37.toString());
  }
}
