/**
 * Copyright (c) 2012 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Juergen Haug (initial contribution)
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class Initialization {
  @Inject
  private CExtensions languageExt;
  
  @Inject
  @Extension
  private RoomExtensions _roomExtensions;
  
  @Inject
  @Extension
  private TypeHelpers _typeHelpers;
  
  public CharSequence generateAttributeInit(final InstanceBase instance, final List<Attribute> attributes) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasElements = false;
      for(final Attribute a : attributes) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "");
        }
        ArrayList<Attribute> _arrayList = new ArrayList<Attribute>();
        List<Attribute> _union = this._roomExtensions.<Attribute>union(_arrayList, a);
        String _initAttributeArray = this.initAttributeArray(instance, _union);
        _builder.append(_initAttributeArray, "");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  private String initAttributeArray(final InstanceBase instance, final List<Attribute> path) {
    String _xblockexpression = null;
    {
      Attribute a = IterableExtensions.<Attribute>last(path);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("\t\t");
      _builder.append("/* ");
      String _name = a.getName();
      _builder.append(_name, "		");
      {
        int _size = a.getSize();
        boolean _greaterThan = (_size > 1);
        if (_greaterThan) {
          _builder.append("[");
          int _size_1 = a.getSize();
          _builder.append(_size_1, "		");
          _builder.append("]");
        }
      }
      _builder.append(" */");
      String COMMENT = _builder.toString();
      String _xifexpression = null;
      boolean _or = false;
      int _size_2 = a.getSize();
      boolean _equals = (_size_2 == 0);
      if (_equals) {
        _or = true;
      } else {
        boolean _and = false;
        RefableType _type = a.getType();
        boolean _isRef = _type.isRef();
        boolean _not = (!_isRef);
        if (!_not) {
          _and = false;
        } else {
          RefableType _type_1 = a.getType();
          DataType _type_2 = _type_1.getType();
          boolean _isEnumerationOrPrimitive = this._typeHelpers.isEnumerationOrPrimitive(_type_2);
          _and = (_not && _isEnumerationOrPrimitive);
        }
        _or = (_equals || _and);
      }
      if (_or) {
        CharSequence _initAttribute = this.initAttribute(instance, path);
        String _plus = (_initAttribute + COMMENT);
        _xifexpression = _plus;
      } else {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("{ ");
        {
          int _size_3 = a.getSize();
          IntegerRange _upTo = new IntegerRange(1, _size_3);
          boolean _hasElements = false;
          for(final Integer i : _upTo) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder_1.appendImmediate(", ", "");
            }
            CharSequence _initAttribute_1 = this.initAttribute(instance, path);
            _builder_1.append(_initAttribute_1, "");
          }
        }
        _builder_1.append(" } ");
        _builder_1.append(COMMENT, "");
        _builder_1.newLineIfNotEmpty();
        _xifexpression = _builder_1.toString();
      }
      _xblockexpression = (_xifexpression);
    }
    return _xblockexpression;
  }
  
  private CharSequence initAttribute(final InstanceBase instance, final List<Attribute> path) {
    CharSequence _xblockexpression = null;
    {
      Attribute a = IterableExtensions.<Attribute>last(path);
      RefableType _type = a.getType();
      DataType aType = _type.getType();
      RefableType _type_1 = a.getType();
      boolean _isRef = _type_1.isRef();
      if (_isRef) {
        String _xifexpression = null;
        String _defaultValueLiteral = a.getDefaultValueLiteral();
        boolean _notEquals = (!Objects.equal(_defaultValueLiteral, null));
        if (_notEquals) {
          String _defaultValueLiteral_1 = a.getDefaultValueLiteral();
          _xifexpression = _defaultValueLiteral_1;
        } else {
          String _nullPointer = this.languageExt.nullPointer();
          _xifexpression = _nullPointer;
        }
        return _xifexpression;
      }
      CharSequence _switchResult = null;
      boolean _matched = false;
      if (!_matched) {
        if (aType instanceof DataClass) {
          final DataClass _dataClass = (DataClass)aType;
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("{");
          _builder.newLine();
          {
            List<Attribute> _allAttributes = RoomHelpers.getAllAttributes(((DataClass) _dataClass));
            boolean _hasElements = false;
            for(final Attribute subA : _allAttributes) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(",", "	");
              }
              _builder.append("\t");
              List<Attribute> _union = this._roomExtensions.<Attribute>union(path, subA);
              String _initAttributeArray = this.initAttributeArray(instance, _union);
              _builder.append(_initAttributeArray, "	");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("}");
          _switchResult = _builder;
        }
      }
      if (!_matched) {
        if (aType instanceof ExternalType) {
          final ExternalType _externalType = (ExternalType)aType;
          _matched=true;
          String _xifexpression_1 = null;
          String _defaultValueLiteral_2 = a.getDefaultValueLiteral();
          boolean _notEquals_1 = (!Objects.equal(_defaultValueLiteral_2, null));
          if (_notEquals_1) {
            String _defaultValueLiteral_3 = a.getDefaultValueLiteral();
            _xifexpression_1 = _defaultValueLiteral_3;
          } else {
            String _defaultValue = this.languageExt.defaultValue(_externalType);
            _xifexpression_1 = _defaultValue;
          }
          _switchResult = _xifexpression_1;
        }
      }
      if (!_matched) {
        if (aType instanceof PrimitiveType) {
          final PrimitiveType _primitiveType = (PrimitiveType)aType;
          _matched=true;
          CharSequence _xblockexpression_1 = null;
          {
            String value = this.getPrimitiveValue(instance, path);
            CharSequence _xifexpression_1 = null;
            boolean _and = false;
            boolean _and_1 = false;
            int _size = a.getSize();
            boolean _greaterThan = (_size > 0);
            if (!_greaterThan) {
              _and_1 = false;
            } else {
              boolean _isCharacterType = this._typeHelpers.isCharacterType(_primitiveType);
              boolean _not = (!_isCharacterType);
              _and_1 = (_greaterThan && _not);
            }
            if (!_and_1) {
              _and = false;
            } else {
              String _trim = value.trim();
              boolean _startsWith = _trim.startsWith("{");
              boolean _not_1 = (!_startsWith);
              _and = (_and_1 && _not_1);
            }
            if (_and) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("{");
              {
                int _size_1 = a.getSize();
                IntegerRange _upTo = new IntegerRange(1, _size_1);
                boolean _hasElements = false;
                for(final Integer i : _upTo) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  _builder.append(value, "");
                }
              }
              _builder.append("}");
              _xifexpression_1 = _builder;
            } else {
              _xifexpression_1 = value;
            }
            _xblockexpression_1 = (_xifexpression_1);
          }
          _switchResult = _xblockexpression_1;
        }
      }
      if (!_matched) {
        if (aType instanceof EnumerationType) {
          final EnumerationType _enumerationType = (EnumerationType)aType;
          _matched=true;
          CharSequence _xblockexpression_1 = null;
          {
            String value = this.getPrimitiveValue(instance, path);
            CharSequence _xifexpression_1 = null;
            boolean _and = false;
            int _size = a.getSize();
            boolean _greaterThan = (_size > 0);
            if (!_greaterThan) {
              _and = false;
            } else {
              String _trim = value.trim();
              boolean _startsWith = _trim.startsWith("{");
              boolean _not = (!_startsWith);
              _and = (_greaterThan && _not);
            }
            if (_and) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("{");
              {
                int _size_1 = a.getSize();
                IntegerRange _upTo = new IntegerRange(1, _size_1);
                boolean _hasElements = false;
                for(final Integer i : _upTo) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  _builder.append(value, "");
                }
              }
              _builder.append("}");
              _xifexpression_1 = _builder;
            } else {
              _xifexpression_1 = value;
            }
            _xblockexpression_1 = (_xifexpression_1);
          }
          _switchResult = _xblockexpression_1;
        }
      }
      _xblockexpression = (_switchResult);
    }
    return _xblockexpression;
  }
  
  private String getPrimitiveValue(final InstanceBase instance, final List<Attribute> path) {
    String value = this._typeHelpers.getAttrInstanceConfigValue(path, instance);
    boolean _equals = Objects.equal(value, null);
    if (_equals) {
      String _switchResult = null;
      boolean _matched = false;
      if (!_matched) {
        if (instance instanceof ActorInstance) {
          final ActorInstance _actorInstance = (ActorInstance)instance;
          _matched=true;
          ActorClass _actorClass = _actorInstance.getActorClass();
          String _attrClassConfigValue = this._typeHelpers.getAttrClassConfigValue(path, _actorClass, true);
          _switchResult = _attrClassConfigValue;
        }
      }
      if (!_matched) {
        if (instance instanceof InterfaceItemInstance) {
          final InterfaceItemInstance _interfaceItemInstance = (InterfaceItemInstance)instance;
          _matched=true;
          InterfaceItem _interfaceItem = _interfaceItemInstance.getInterfaceItem();
          PortClass _portClass = RoomHelpers.getPortClass(_interfaceItem);
          String _attrClassConfigValue = this._typeHelpers.getAttrClassConfigValue(path, _portClass);
          _switchResult = _attrClassConfigValue;
        }
      }
      value = _switchResult;
    }
    boolean _equals_1 = Objects.equal(value, null);
    if (_equals_1) {
      Attribute _last = IterableExtensions.<Attribute>last(path);
      String _defaultValueLiteral = _last.getDefaultValueLiteral();
      value = _defaultValueLiteral;
    }
    Attribute _last_1 = IterableExtensions.<Attribute>last(path);
    RefableType _type = _last_1.getType();
    DataType type = _type.getType();
    String _xifexpression = null;
    boolean _and = false;
    boolean _notEquals = (!Objects.equal(value, null));
    if (!_notEquals) {
      _and = false;
    } else {
      boolean _isPrimitive = this._typeHelpers.isPrimitive(type);
      _and = (_notEquals && _isPrimitive);
    }
    if (_and) {
      String _valueLiteral = this.languageExt.toValueLiteral(((PrimitiveType) type), value);
      _xifexpression = _valueLiteral;
    } else {
      String _xifexpression_1 = null;
      boolean _and_1 = false;
      boolean _notEquals_1 = (!Objects.equal(value, null));
      if (!_notEquals_1) {
        _and_1 = false;
      } else {
        boolean _isEnumeration = this._typeHelpers.isEnumeration(type);
        _and_1 = (_notEquals_1 && _isEnumeration);
      }
      if (_and_1) {
        String _enumLiteral = this.languageExt.toEnumLiteral(((EnumerationType) type), value);
        _xifexpression_1 = _enumLiteral;
      } else {
        String _defaultValue = this.languageExt.defaultValue(type);
        _xifexpression_1 = _defaultValue;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
}
