/**
 * Copyright (c) 2011 Draeger Medical GmbH (http://www.draeger.com).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Peter Karlitschek (initial contribution)
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * @author Peter Karlitschek
 */
@Singleton
@SuppressWarnings("all")
public class SubSystemRunnerGen {
  @Inject
  @Extension
  private JavaIoFileSystemAccess fileAccess;
  
  @Inject
  @Extension
  private CppExtensions _cppExtensions;
  
  @Inject
  @Extension
  private RoomExtensions roomExt;
  
  public void doGenerate(final Root root) {
    EList<SubSystemInstance> _subSystemInstances = root.getSubSystemInstances();
    for (final SubSystemInstance sc : _subSystemInstances) {
      {
        SubSystemClass _subSystemClass = sc.getSubSystemClass();
        String _generationTargetPath = this.roomExt.getGenerationTargetPath(_subSystemClass);
        SubSystemClass _subSystemClass_1 = sc.getSubSystemClass();
        String _path = this.roomExt.getPath(_subSystemClass_1);
        String _plus = (_generationTargetPath + _path);
        this.fileAccess.setOutputPath(_plus);
        SubSystemClass _subSystemClass_2 = sc.getSubSystemClass();
        String _name = _subSystemClass_2.getName();
        String _plus_1 = (_name + "_Runner.h");
        SubSystemClass _subSystemClass_3 = sc.getSubSystemClass();
        CharSequence _generateHeaderFile = this.generateHeaderFile(root, sc, _subSystemClass_3);
        this.fileAccess.generateFile(_plus_1, _generateHeaderFile);
        SubSystemClass _subSystemClass_4 = sc.getSubSystemClass();
        String _generationTargetPath_1 = this.roomExt.getGenerationTargetPath(_subSystemClass_4);
        SubSystemClass _subSystemClass_5 = sc.getSubSystemClass();
        String _path_1 = this.roomExt.getPath(_subSystemClass_5);
        String _plus_2 = (_generationTargetPath_1 + _path_1);
        this.fileAccess.setOutputPath(_plus_2);
        SubSystemClass _subSystemClass_6 = sc.getSubSystemClass();
        String _name_1 = _subSystemClass_6.getName();
        String _plus_3 = (_name_1 + "_Runner.cpp");
        SubSystemClass _subSystemClass_7 = sc.getSubSystemClass();
        CharSequence _generateSourceFile = this.generateSourceFile(root, sc, _subSystemClass_7);
        this.fileAccess.generateFile(_plus_3, _generateSourceFile);
      }
    }
  }
  
  public CharSequence generateHeaderFile(final Root root, final SubSystemInstance ssc, final SubSystemClass cc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* this class contains the main function running component ");
    String _name = cc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* it instantiates ");
    String _name_1 = cc.getName();
    _builder.append(_name_1, " ");
    _builder.append(" and starts and ends the lifecycle");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    String _name_2 = cc.getName();
    String _plus = (_name_2 + "_Runner");
    CharSequence _generateIncludeGuardBegin = this._cppExtensions.generateIncludeGuardBegin(_plus);
    _builder.append(_generateIncludeGuardBegin, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"common/modelbase/SubSystemRunnerBase.h\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ");
    String _name_3 = cc.getName();
    String _plus_1 = (_name_3 + "Runner");
    _builder.append(_plus_1, "");
    _builder.append(" :public etRuntime::SubSystemRunnerBase {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    String _name_4 = cc.getName();
    String _plus_2 = (_name_4 + "_Runner");
    CharSequence _generateIncludeGuardEnd = this._cppExtensions.generateIncludeGuardEnd(_plus_2);
    _builder.append(_generateIncludeGuardEnd, "");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateSourceFile(final Root root, final SubSystemInstance ssi, final SubSystemClass ssc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* this class contains the main function running component ");
    String _name = ssc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* it instantiates ");
    String _name_1 = ssc.getName();
    _builder.append(_name_1, " ");
    _builder.append(" and starts and ends the lifecycle");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _name_2 = ssc.getName();
    _builder.append(_name_2, "");
    _builder.append(".h\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _name_3 = ssc.getName();
    _builder.append(_name_3, "");
    _builder.append("_Runner.h\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* main function");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* creates component and starts and stops the lifecycle");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("int main(int argc, char* argv[]) {");
    _builder.newLine();
    _builder.append("\t");
    String _name_4 = ssc.getName();
    _builder.append(_name_4, "	");
    _builder.append(" mainComponent(0, \"");
    String _name_5 = ssc.getName();
    _builder.append(_name_5, "	");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _name_6 = ssc.getName();
    String _plus = (_name_6 + "Runner");
    _builder.append(_plus, "	");
    _builder.append("::run(mainComponent, argc, argv);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    return _builder;
  }
}
