/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.graphviz.dot.dot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AttributeType implements Enumerator
{
    GRAPH(0, "graph", "graph"),
    NODE(1, "node", "node"),
    EDGE(2, "edge", "edge");

    public static final int GRAPH_VALUE = 0;
    public static final int NODE_VALUE = 1;
    public static final int EDGE_VALUE = 2;
    private static final AttributeType[] VALUES_ARRAY;
    public static final List<AttributeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttributeType[]{GRAPH, NODE, EDGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttributeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeType get(int value) {
        switch (value) {
            case 0: {
                return GRAPH;
            }
            case 1: {
                return NODE;
            }
            case 2: {
                return EDGE;
            }
        }
        return null;
    }

    private AttributeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

