/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.WrappedException;
import de.cau.cs.kieler.core.alg.IFactory;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.service.grana.AnalysisCategory;
import de.cau.cs.kieler.kiml.service.grana.AnalysisData;
import de.cau.cs.kieler.kiml.service.grana.AnalysisFailed;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import de.cau.cs.kieler.kiml.service.grana.dependency.Dependency;
import de.cau.cs.kieler.kiml.service.grana.dependency.DependencyGraph;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalysisService {
    public static final String EXTP_ID_ANALYSIS_PROVIDERS = "de.cau.cs.kieler.kiml.service.analysisProviders";
    protected static final String ELEMENT_ANALYSIS = "analysis";
    protected static final String ELEMENT_CATEGORY = "category";
    protected static final String ELEMENT_DEPENDENCY = "dependency";
    protected static final String ELEMENT_COMPONENT = "component";
    protected static final String ATTRIBUTE_ANALYSIS = "analysis";
    protected static final String ATTRIBUTE_CATEGORY = "category";
    protected static final String ATTRIBUTE_CLASS = "class";
    protected static final String ATTRIBUTE_DESCRIPTION = "description";
    protected static final String ATTRIBUTE_ID = "id";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_ABBREVIATION = "abbreviation";
    protected static final String ATTRIBUTE_WEAK = "weak";
    protected static final String ATTRIBUTE_PROGRAMMATIC = "programmatic";
    public static final String DEFAULT_CATEGORY_ID = "de.cau.cs.kieler.kiml.grana.defaultCategory";
    private static AnalysisService instance;
    private final DependencyGraph<String, AnalysisData> dependencyGraph = new DependencyGraph();
    private final List<AnalysisCategory> categories = new LinkedList<AnalysisCategory>();
    private final Map<String, AnalysisCategory> categoryIdMapping = new HashMap<String, AnalysisCategory>();
    private final Map<String, AnalysisData> analysisIdMapping = new HashMap<String, AnalysisData>();
    private AnalysisCategory defaultCategory = null;

    public static AnalysisService getInstance() {
        return instance;
    }

    protected AnalysisService() {
        instance = this;
    }

    protected abstract void reportError(String var1, IConfigurationElement var2, String var3, Throwable var4);

    protected abstract void reportError(CoreException var1);

    protected abstract void reportWarning(String var1);

    protected void loadAnalysisProviderExtension() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_ANALYSIS_PROVIDERS);
        LinkedList<AnalysisData> analyses = new LinkedList<AnalysisData>();
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            Object category;
            String description;
            String name;
            String id;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("category".equals(element.getName())) {
                id = element.getAttribute(ATTRIBUTE_ID);
                name = element.getAttribute(ATTRIBUTE_NAME);
                description = element.getAttribute(ATTRIBUTE_DESCRIPTION);
                if (id == null || id.length() == 0) {
                    this.reportError(EXTP_ID_ANALYSIS_PROVIDERS, element, ATTRIBUTE_ID, null);
                } else if (name == null) {
                    this.reportError(EXTP_ID_ANALYSIS_PROVIDERS, element, ATTRIBUTE_NAME, null);
                } else if (description == null) {
                    this.reportError(EXTP_ID_ANALYSIS_PROVIDERS, element, ATTRIBUTE_DESCRIPTION, null);
                } else {
                    category = new AnalysisCategory();
                    ((AnalysisCategory)category).setId(id);
                    ((AnalysisCategory)category).setName(name);
                    ((AnalysisCategory)category).setDescription(description);
                    this.categories.add((AnalysisCategory)category);
                    this.categoryIdMapping.put(id, (AnalysisCategory)category);
                }
            } else if ("analysis".equals(element.getName())) {
                id = element.getAttribute(ATTRIBUTE_ID);
                name = element.getAttribute(ATTRIBUTE_NAME);
                description = element.getAttribute(ATTRIBUTE_DESCRIPTION);
                category = element.getAttribute("category");
                String isProgrString = element.getAttribute(ATTRIBUTE_PROGRAMMATIC);
                boolean isProgr = Boolean.parseBoolean(isProgrString);
                if (id == null || id.length() == 0) {
                    this.reportError(EXTP_ID_ANALYSIS_PROVIDERS, element, ATTRIBUTE_ID, null);
                } else if (name == null) {
                    this.reportError(EXTP_ID_ANALYSIS_PROVIDERS, element, ATTRIBUTE_NAME, null);
                } else if (description == null) {
                    this.reportError(EXTP_ID_ANALYSIS_PROVIDERS, element, ATTRIBUTE_DESCRIPTION, null);
                } else {
                    if (category == null || ((String)category).length() == 0) {
                        category = DEFAULT_CATEGORY_ID;
                    }
                    AnalysisData analysisData = new AnalysisData();
                    final IConfigurationElement factoryElement = element;
                    IFactory<IAnalysis> analysisFactory = new IFactory<IAnalysis>(){

                        public IAnalysis create() {
                            try {
                                return (IAnalysis)factoryElement.createExecutableExtension(AnalysisService.ATTRIBUTE_CLASS);
                            }
                            catch (CoreException e) {
                                throw new WrappedException((Throwable)e);
                            }
                        }

                        public void destroy(IAnalysis provider) {
                        }
                    };
                    analysisData.createPool(analysisFactory);
                    analysisData.setId(id);
                    analysisData.setName(name);
                    analysisData.setDescription(description);
                    analysisData.setCategory((String)category);
                    analysisData.setProgrammatic(isProgr);
                    analyses.add(analysisData);
                    this.analysisIdMapping.put(id, analysisData);
                    IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement child = iConfigurationElementArray2[n4];
                        if (ELEMENT_DEPENDENCY.equals(child.getName())) {
                            String analysisId = child.getAttribute("analysis");
                            String weakString = child.getAttribute(ATTRIBUTE_WEAK);
                            if (analysisId == null || analysisId.length() == 0) {
                                this.reportError(EXTP_ID_ANALYSIS_PROVIDERS, child, "analysis", null);
                            } else {
                                boolean weak = Boolean.parseBoolean(weakString);
                                analysisData.getDependencies().add(new Dependency<String>(analysisId, weak));
                            }
                        } else if (ELEMENT_COMPONENT.equals(child.getName())) {
                            String componentName = child.getAttribute(ATTRIBUTE_NAME);
                            String componentAbbreviation = child.getAttribute(ATTRIBUTE_ABBREVIATION);
                            if (componentName == null || componentName.length() == 0) {
                                this.reportError(EXTP_ID_ANALYSIS_PROVIDERS, child, ATTRIBUTE_NAME, null);
                            } else {
                                if (componentAbbreviation == null || componentAbbreviation.length() == 0) {
                                    componentAbbreviation = componentName;
                                }
                                analysisData.getComponents().add((Pair<String, String>)new Pair((Object)componentName, (Object)componentAbbreviation));
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        List<AnalysisData> unresolvedAnalyses = this.dependencyGraph.addAll(analyses);
        analyses.removeAll(unresolvedAnalyses);
        for (AnalysisData analysis : unresolvedAnalyses) {
            this.analysisIdMapping.remove(analysis.getId());
            String message = "Analysis " + analysis.getId() + " is missing a dependency or is part of a dependency cycle.";
            this.reportWarning(message);
        }
        this.defaultCategory = this.categoryIdMapping.get(DEFAULT_CATEGORY_ID);
        for (AnalysisData analysis : analyses) {
            if (analysis.isProgrammatic()) continue;
            AnalysisCategory category = this.categoryIdMapping.get(analysis.getCategory());
            if (category == null) {
                category = this.defaultCategory;
            }
            if (category == null) continue;
            category.getAnalyses().add(analysis);
        }
        Collections.sort(this.categories, new Comparator<AnalysisCategory>(){

            @Override
            public int compare(AnalysisCategory category1, AnalysisCategory category2) {
                if (category1 == AnalysisService.this.defaultCategory) {
                    return category2 == AnalysisService.this.defaultCategory ? 0 : 1;
                }
                return category2 == AnalysisService.this.defaultCategory ? -1 : category1.getName().compareTo(category2.getName());
            }
        });
        for (AnalysisCategory category : this.categories) {
            Collections.sort(category.getAnalyses(), new Comparator<AnalysisData>(){

                @Override
                public int compare(AnalysisData analysis1, AnalysisData analysis2) {
                    return analysis1.getName().compareTo(analysis2.getName());
                }
            });
        }
    }

    public List<AnalysisCategory> getCategories() {
        return this.categories;
    }

    public Collection<AnalysisData> getAnalyses() {
        return this.analysisIdMapping.values();
    }

    public AnalysisCategory getCategory(String id) {
        return this.categoryIdMapping.get(id);
    }

    public AnalysisData getAnalysis(String id) {
        return this.analysisIdMapping.get(id);
    }

    public Object analyze(KNode graph, String analysisId, IKielerProgressMonitor monitor, Map<String, Object> resultCache) {
        AnalysisData analysis = this.analysisIdMapping.get(analysisId);
        if (analysis != null) {
            Object result = resultCache.get(analysisId);
            if (result == null) {
                result = this.analyze(graph, analysis, monitor, resultCache);
            }
            return result;
        }
        return null;
    }

    public Object analyze(KNode graph, AnalysisData analysis, IKielerProgressMonitor monitor, Map<String, Object> resultCache) {
        List<AnalysisData> analysesSequence = this.getExecutionOrder(analysis);
        monitor.begin("Graph analyses", (float)analysesSequence.size());
        for (AnalysisData ad : analysesSequence) {
            if (monitor.isCanceled()) {
                resultCache.put(ad.getId(), new AnalysisFailed(AnalysisFailed.Type.Canceled));
                continue;
            }
            if (resultCache.containsKey(ad.getId())) {
                monitor.worked(1.0f);
                continue;
            }
            try {
                IAnalysis a = (IAnalysis)ad.getInstancePool().fetch();
                Object o = a.doAnalysis(graph, resultCache, monitor.subTask(1.0f));
                resultCache.put(ad.getId(), o);
                ad.getInstancePool().release((Object)a);
            }
            catch (Exception e) {
                resultCache.put(ad.getId(), new AnalysisFailed(AnalysisFailed.Type.Failed, e));
            }
        }
        monitor.done();
        return resultCache.get(analysis.getId());
    }

    public Map<String, Object> analyze(KNode graph, List<AnalysisData> analyses, IKielerProgressMonitor monitor) {
        List<AnalysisData> analysesSequence = this.getExecutionOrder(analyses);
        monitor.begin("Graph analyses", (float)analysesSequence.size());
        HashMap resultCache = Maps.newHashMapWithExpectedSize((int)analysesSequence.size());
        for (AnalysisData ad : analysesSequence) {
            if (monitor.isCanceled()) {
                resultCache.put(ad.getId(), new AnalysisFailed(AnalysisFailed.Type.Canceled));
                continue;
            }
            try {
                IAnalysis a = (IAnalysis)ad.getInstancePool().fetch();
                Object o = a.doAnalysis(graph, resultCache, monitor.subTask(1.0f));
                resultCache.put(ad.getId(), o);
                ad.getInstancePool().release((Object)a);
            }
            catch (Exception e) {
                resultCache.put(ad.getId(), new AnalysisFailed(AnalysisFailed.Type.Failed, e));
            }
        }
        monitor.done();
        return resultCache;
    }

    public List<AnalysisData> getExecutionOrder(AnalysisData ... analyses) {
        return this.dependencyGraph.dependencySort(Arrays.asList(analyses));
    }

    public List<AnalysisData> getExecutionOrder(List<AnalysisData> analyses) {
        return this.dependencyGraph.dependencySort(analyses);
    }
}

