/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.service;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.config.CompoundLayoutConfig;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.LayoutInfoService;
import de.cau.cs.kieler.kiml.ui.diagram.LayoutMapping;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutConfig;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutOptionManager {
    private final Map<EClass, List<ILayoutConfig>> semanticConfigMap = Maps.newHashMap();
    private final DefaultLayoutConfig defaultLayoutConfig = new DefaultLayoutConfig();

    public void configure(LayoutMapping<?> layoutMapping, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Layout configuration", 1.0f);
        CompoundLayoutConfig clc = new CompoundLayoutConfig();
        clc.add((ILayoutConfig)this.defaultLayoutConfig);
        clc.addAll((Collection)LayoutInfoService.getInstance().getActiveConfigs());
        clc.addAll(layoutMapping.getLayoutConfigs());
        KNode layoutGraph = layoutMapping.getLayoutGraph();
        this.recursiveConf(layoutGraph, layoutMapping, clc);
        progressMonitor.done();
    }

    public IMutableLayoutConfig createConfig(EObject domainElement, ILayoutConfig ... extraConfigs) {
        CompoundLayoutConfig clc = new CompoundLayoutConfig();
        clc.add((ILayoutConfig)this.defaultLayoutConfig);
        clc.addAll((Collection)LayoutInfoService.getInstance().getActiveConfigs());
        clc.addAll(this.getSemanticConfigs(domainElement));
        ILayoutConfig[] iLayoutConfigArray = extraConfigs;
        int n = extraConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ILayoutConfig conf = iLayoutConfigArray[n2];
            clc.add(conf);
            ++n2;
        }
        return clc;
    }

    private void recursiveConf(KNode node, LayoutMapping<?> layoutMapping, CompoundLayoutConfig config) {
        this.configure((KGraphElement)node, layoutMapping, config);
        for (KLabel label : node.getLabels()) {
            this.configure((KGraphElement)label, layoutMapping, config);
        }
        for (KPort port : node.getPorts()) {
            this.configure((KGraphElement)port, layoutMapping, config);
            for (KLabel label : port.getLabels()) {
                this.configure((KGraphElement)label, layoutMapping, config);
            }
        }
        for (KEdge edge : node.getOutgoingEdges()) {
            this.configure((KGraphElement)edge, layoutMapping, config);
            for (KLabel label : edge.getLabels()) {
                this.configure((KGraphElement)label, layoutMapping, config);
            }
        }
        for (KNode child : node.getChildren()) {
            this.recursiveConf(child, layoutMapping, config);
        }
    }

    private void configure(KGraphElement graphElement, LayoutMapping<?> layoutMapping, CompoundLayoutConfig config) {
        LayoutContext context = new LayoutContext();
        context.setProperty(LayoutContext.GRAPH_ELEM, (Object)graphElement);
        Object diagramPart = layoutMapping.getGraphMap().get((Object)graphElement);
        context.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
        EObject modelElement = (EObject)layoutMapping.getAdapterFactory().getAdapter(diagramPart, EObject.class);
        context.setProperty(LayoutContext.DOMAIN_MODEL, (Object)modelElement);
        IWorkbenchPart workbenchPart = (IWorkbenchPart)layoutMapping.getProperty(IWorkbenchPart.class);
        context.setProperty(EclipseLayoutConfig.WORKBENCH_PART, (Object)workbenchPart);
        List<ILayoutConfig> semanticConfigs = this.getSemanticConfigs(modelElement);
        config.addAll(semanticConfigs);
        config.enrich(context);
        KGraphData graphData = graphElement.getData(graphElement instanceof KEdge ? KEdgeLayout.class : KShapeLayout.class);
        graphData.getProperties().clear();
        config.transferValues(graphData, context);
        config.removeAll(semanticConfigs);
    }

    private List<ILayoutConfig> getSemanticConfigs(EObject modelElement) {
        if (modelElement == null) {
            return Collections.emptyList();
        }
        EClass modelClass = modelElement.eClass();
        List configs = this.semanticConfigMap.get(modelClass);
        if (configs == null) {
            configs = EclipseLayoutInfoService.getInstance().getSemanticConfigs(modelClass);
            this.semanticConfigMap.put(modelClass, configs);
        }
        return configs;
    }
}

