/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.LayoutTypeData;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutDataService {
    public static final String DIAGRAM_TYPE_GENERAL = "de.cau.cs.kieler.layout.diagrams.general";
    public static final String ECLIPSEDATASERVICE = "de.cau.cs.kieler.kiml.ui.service.EclipseLayoutDataService";
    public static final String REMOTEDATASERVICE = "de.cau.cs.kieler.kwebs.client.layout.RemoteLayoutDataService";
    public static final String SERVICEDATASERVICE = "de.cau.cs.kieler.kwebs.server.layout.ServerLayoutDataService";
    private Registry registry = null;
    private final Map<String, LayoutAlgorithmData> layoutAlgorithmMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutOptionData<?>> layoutOptionMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutTypeData> layoutTypeMap = Maps.newLinkedHashMap();
    private final Map<String, String> categoryMap = Maps.newHashMap();
    private final Map<String, LayoutAlgorithmData> algorithmSuffixMap = Maps.newHashMap();
    private final Map<String, LayoutOptionData<?>> optionSuffixMap = Maps.newHashMap();
    private final Map<String, LayoutTypeData> typeSuffixMap = Maps.newHashMap();
    private static List<String> validDataServices = Lists.newArrayList((Object[])new String[]{"de.cau.cs.kieler.kiml.ui.service.EclipseLayoutDataService", "de.cau.cs.kieler.kwebs.client.layout.RemoteLayoutDataService", "de.cau.cs.kieler.kwebs.server.layout.ServerLayoutDataService"});
    private static Map<String, LayoutDataService> instances = Maps.newHashMap();
    private static LayoutDataService current;

    protected LayoutDataService() {
    }

    private static String getType(LayoutDataService object) {
        String type = null;
        if (object != null) {
            type = object.getClass().getCanonicalName();
        }
        return type;
    }

    protected static synchronized void addService(LayoutDataService subInstance) {
        String type = LayoutDataService.getType(subInstance);
        if (validDataServices.contains(type) && !instances.containsKey(type)) {
            if (current == null) {
                current = subInstance;
            }
            LayoutDataService layoutDataService = subInstance;
            layoutDataService.getClass();
            subInstance.registry = layoutDataService.new Registry();
            instances.put(type, subInstance);
        }
    }

    public static synchronized void removeService(LayoutDataService subInstance) {
        String type = LayoutDataService.getType(subInstance);
        if (!validDataServices.contains(type)) {
            throw new IllegalArgumentException("Layout data service instance of class " + type + " not supported");
        }
        if (subInstance == current) {
            throw new IllegalArgumentException("Currently active layout data service cant be removed");
        }
        instances.remove(type);
    }

    public static synchronized String getMode() {
        return current != null ? LayoutDataService.getType(current) : null;
    }

    public static synchronized void setMode(String mode) {
        if (!validDataServices.contains(mode) || !instances.containsKey(mode)) {
            throw new IllegalArgumentException("Mode " + mode + " not supported or layout data service was not" + " registered before");
        }
        current = instances.get(mode);
    }

    public static LayoutDataService getInstance() {
        return current;
    }

    public static <T extends LayoutDataService> T getInstanceOf(String type) {
        if (validDataServices.contains(type) && instances.containsKey(type)) {
            return (T)instances.get(type);
        }
        return null;
    }

    public static final Registry getRegistry() {
        if (current != null) {
            return LayoutDataService.current.registry;
        }
        return null;
    }

    public final LayoutAlgorithmData getAlgorithmData(String id) {
        return this.layoutAlgorithmMap.get(id);
    }

    public final Collection<LayoutAlgorithmData> getAlgorithmData() {
        return Collections.unmodifiableCollection(this.layoutAlgorithmMap.values());
    }

    public final LayoutAlgorithmData getAlgorithmDataBySuffix(String suffix) {
        LayoutAlgorithmData data = this.layoutAlgorithmMap.get(suffix);
        if (data == null && (data = this.algorithmSuffixMap.get(suffix)) == null) {
            for (LayoutAlgorithmData d : this.layoutAlgorithmMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                this.algorithmSuffixMap.put(suffix, d);
                return d;
            }
        }
        return data;
    }

    public final LayoutOptionData<?> getOptionData(String id) {
        return this.layoutOptionMap.get(id);
    }

    public final Collection<LayoutOptionData<?>> getOptionData() {
        return Collections.unmodifiableCollection(this.layoutOptionMap.values());
    }

    public final LayoutOptionData<?> getOptionDataBySuffix(String suffix) {
        LayoutOptionData<?> data = this.layoutOptionMap.get(suffix);
        if (data == null && (data = this.optionSuffixMap.get(suffix)) == null) {
            for (LayoutOptionData<?> d : this.layoutOptionMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                this.optionSuffixMap.put(suffix, d);
                return d;
            }
        }
        return data;
    }

    public final List<LayoutOptionData<?>> getOptionData(LayoutAlgorithmData algorithmData, LayoutOptionData.Target targetType) {
        LinkedList optionDataList = new LinkedList();
        for (LayoutOptionData<?> optionData : this.layoutOptionMap.values()) {
            if (!algorithmData.knowsOption(optionData) && !LayoutOptions.ALGORITHM.equals(optionData) || !optionData.getTargets().contains((Object)targetType)) continue;
            optionDataList.add(optionData);
        }
        return optionDataList;
    }

    public final LayoutTypeData getTypeData(String id) {
        return this.layoutTypeMap.get(id);
    }

    public final Collection<LayoutTypeData> getTypeData() {
        return Collections.unmodifiableCollection(this.layoutTypeMap.values());
    }

    public final LayoutTypeData getTypeDataBySuffix(String suffix) {
        LayoutTypeData data = this.layoutTypeMap.get(suffix);
        if (data == null && (data = this.typeSuffixMap.get(suffix)) == null) {
            for (LayoutTypeData d : this.layoutTypeMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                this.typeSuffixMap.put(suffix, d);
                return d;
            }
        }
        return data;
    }

    public final String getCategoryName(String id) {
        return this.categoryMap.get(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Registry {
        private Registry() {
        }

        public void addLayoutProvider(LayoutAlgorithmData providerData) {
            if (LayoutDataService.this.layoutAlgorithmMap.containsKey(providerData.getId())) {
                LayoutDataService.this.layoutAlgorithmMap.remove(providerData.getId());
            }
            LayoutDataService.this.layoutAlgorithmMap.put(providerData.getId(), providerData);
        }

        public void addLayoutOption(LayoutOptionData<?> optionData) {
            if (LayoutDataService.this.layoutOptionMap.containsKey(optionData.getId())) {
                LayoutDataService.this.layoutOptionMap.remove(optionData.getId());
            }
            LayoutDataService.this.layoutOptionMap.put(optionData.getId(), optionData);
        }

        public void addLayoutType(LayoutTypeData typeData) {
            LayoutTypeData oldData = (LayoutTypeData)LayoutDataService.this.layoutTypeMap.get(typeData.getId());
            if (oldData != null) {
                typeData.getLayouters().addAll(oldData.getLayouters());
                LayoutDataService.this.layoutTypeMap.remove(typeData.getId());
            }
            LayoutDataService.this.layoutTypeMap.put(typeData.getId(), typeData);
        }

        public void addCategory(String id, String name) {
            LayoutDataService.this.categoryMap.put(id, name);
        }
    }
}

