/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.etrice.abstractexec.behavior.Activator;
import org.eclipse.etrice.abstractexec.behavior.ActiveRules;
import org.eclipse.etrice.abstractexec.behavior.SemanticsCheck;
import org.eclipse.etrice.core.genmodel.etricegen.ActiveTrigger;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.SemanticsRule;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class ProposalGenerator {
    private ExpandedActorClass xpac;
    private SemanticsCheck checker;
    private List<MessageFromIf> outgoingProposal = new LinkedList<MessageFromIf>();
    private List<MessageFromIf> incomingProposal = new LinkedList<MessageFromIf>();
    private static boolean traceProposals;

    static {
        String value;
        traceProposals = false;
        if (Activator.getDefault().isDebugging() && (value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/proposals")) != null && value.equalsIgnoreCase(Boolean.toString(true))) {
            traceProposals = true;
        }
    }

    public ProposalGenerator(ExpandedActorClass xp, SemanticsCheck chk) {
        this.xpac = xp;
        this.checker = chk;
    }

    public List<MessageFromIf> getIncomingProposals() {
        return this.incomingProposal;
    }

    public List<MessageFromIf> getOutgoingProposals() {
        return this.outgoingProposal;
    }

    public void createProposals(State st) {
        ActiveRules rules = this.checker.getActiveRules((StateGraphItem)st);
        if (rules == null) {
            return;
        }
        if (RoomHelpers.hasDirectSubStructure((State)st)) {
            return;
        }
        this.outgoingProposal.clear();
        this.incomingProposal.clear();
        for (InterfaceItem port : rules.getPortList()) {
            HashSet<Message> messages = new HashSet<Message>();
            for (ActiveTrigger t : this.xpac.getActiveTriggers(st)) {
                if (!t.getIfitem().equals(port)) continue;
                messages.add(t.getMsg());
            }
            if (!rules.getPortList().contains(port)) continue;
            for (SemanticsRule curRule : rules.getRulesForPort(port)) {
                if (messages.contains(curRule.getMsg())) continue;
                MessageFromIf mif = RoomFactory.eINSTANCE.createMessageFromIf();
                mif.setFrom(port);
                mif.setMessage(curRule.getMsg());
                boolean isOutgoing = RoomHelpers.getMessageListDeep((InterfaceItem)port, (boolean)true).contains(curRule.getMsg());
                if (isOutgoing) {
                    this.outgoingProposal.add(mif);
                    continue;
                }
                this.incomingProposal.add(mif);
            }
        }
        if (traceProposals) {
            System.out.println("  Proposals for : " + st.getName());
            for (MessageFromIf msg : this.outgoingProposal) {
                System.out.println("    Outgoing msg proposal : " + msg.getFrom().getName() + "." + msg.getMessage().getName() + "()");
            }
            for (MessageFromIf msg : this.incomingProposal) {
                System.out.println("    Incoming msg proposal : " + msg.getMessage().getName() + " from " + msg.getFrom().getName());
            }
        }
    }
}

