/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.abstractexec.behavior.ReachabilityCheck;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.base.NullDiagnostician;
import org.eclipse.etrice.core.genmodel.base.NullLogger;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilder;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.validation.IRoomValidator;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class ReachabilityValidator
implements IRoomValidator {
    public static String DIAG_CODE_UNREACHABLE = "etrice.unreachable";

    public void validate(EObject object, ValidationMessageAcceptor messageAcceptor) {
        if (!(object instanceof ActorClass)) {
            return;
        }
        ActorClass ac = (ActorClass)object;
        if (ac.isAbstract()) {
            return;
        }
        if (ValidationUtil.isCircularClassHierarchy((ActorClass)ac)) {
            return;
        }
        NullDiagnostician diagnostician = new NullDiagnostician();
        GeneratorModelBuilder builder = new GeneratorModelBuilder((ILogger)new NullLogger(), (IDiagnostician)diagnostician);
        ExpandedActorClass xpac = builder.createExpandedActorClass(ac);
        if (xpac != null && !diagnostician.isFailed()) {
            ReachabilityCheck checker = new ReachabilityCheck(xpac);
            checker.computeReachability();
            TreeIterator it = xpac.getStateMachine().eAllContents();
            while (it.hasNext()) {
                StateGraphItem toCheck;
                EObject item = (EObject)it.next();
                if (!(item instanceof StateGraphItem) || checker.isReachable(toCheck = (StateGraphItem)item)) continue;
                EObject orig = xpac.getOrig((EObject)toCheck);
                EObject container = orig.eContainer();
                int idx = ((List)container.eGet(orig.eContainingFeature())).indexOf(orig);
                messageAcceptor.acceptWarning("Unreachable state/point of graph", xpac.getOrig((EObject)toCheck).eContainer(), xpac.getOrig((EObject)toCheck).eContainingFeature(), idx, DIAG_CODE_UNREACHABLE, new String[]{toCheck.getName()});
            }
        }
    }

    public String getName() {
        return "State Reachability Validator";
    }

    public String getDescription() {
        return "This validator checks the reachability of state graph items.";
    }
}

