/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.config.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.PortInstanceConfig;
import org.eclipse.etrice.core.config.RefPath;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LiteralType;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class ConfigUtil {
    public static LiteralType getLiteralType(Attribute attr) {
        DataType type;
        if (attr == null) {
            return null;
        }
        if (attr.getRefType() != null && (type = attr.getRefType().getType()) instanceof PrimitiveType) {
            return ((PrimitiveType)type).getType();
        }
        return null;
    }

    public static ActorClass resolve(ActorContainerClass root, RefPath path) {
        if (path.getRefs().isEmpty()) {
            return null;
        }
        ActorContainerClass result = root;
        for (String ref : path.getRefs()) {
            ActorRef match = null;
            for (ActorContainerRef actor : RoomHelpers.getRefs((StructureClass)result, (boolean)true)) {
                if (!(actor instanceof ActorRef) || !actor.getName().equals(ref)) continue;
                match = (ActorRef)actor;
                break;
            }
            if (match == null) {
                return null;
            }
            result = match.getType();
        }
        return (ActorClass)result;
    }

    public static ActorRef getLastActorRef(ActorContainerClass root, RefPath path) {
        if (path.getRefs().isEmpty()) {
            return null;
        }
        ActorRef lastMatch = null;
        ActorContainerClass result = root;
        for (String ref : path.getRefs()) {
            ActorRef match = null;
            for (ActorContainerRef actor : RoomHelpers.getRefs((StructureClass)result, (boolean)true)) {
                if (!(actor instanceof ActorRef) || !actor.getName().equals(ref)) continue;
                match = (ActorRef)actor;
                break;
            }
            if (match == null) {
                return null;
            }
            result = match.getType();
            lastMatch = match;
        }
        return lastMatch;
    }

    public static String checkPath(ActorContainerClass root, RefPath path) {
        if (path == null) {
            return null;
        }
        ActorContainerClass last = root;
        Iterator it = path.getRefs().iterator();
        while (it.hasNext()) {
            String ref = (String)it.next();
            ActorRef match = null;
            for (ActorRef actor : last.getActorRefs()) {
                if (!actor.getName().equals(ref)) continue;
                match = actor;
                break;
            }
            ArrayList ifs = new ArrayList();
            ifs.addAll(last.getIfSPPs());
            if (last instanceof ActorClass) {
                ActorClass actor = (ActorClass)last;
                ifs.addAll(actor.getIfPorts());
                ifs.addAll(actor.getIntPorts());
            }
            if (last instanceof SubSystemClass) {
                ifs.addAll(((SubSystemClass)last).getRelayPorts());
            }
            for (InterfaceItem item : ifs) {
                if (!item.getName().equals(ref) || it.hasNext()) continue;
                return null;
            }
            if (match == null) {
                return ref;
            }
            last = match.getType();
        }
        return null;
    }

    public static PortClass getPortClass(PortInstanceConfig config) {
        ProtocolClass protocol;
        InterfaceItem item = config.getItem();
        PortClass portClass = null;
        if (item instanceof Port) {
            Port port = (Port)item;
            if (port.getProtocol() instanceof ProtocolClass) {
                ProtocolClass protocol2 = (ProtocolClass)port.getProtocol();
                portClass = port.isConjugated() ? protocol2.getConjugate() : protocol2.getRegular();
            }
        } else if (item instanceof SAPRef && (protocol = ((SAPRef)item).getProtocol()).getConjugate() != null) {
            portClass = protocol.getConjugate();
        }
        return portClass;
    }

    public static List<InterfaceItem> getConfigurableInterfaceItems(ActorContainerClass acc, boolean includeInherited) {
        ArrayList<InterfaceItem> result = new ArrayList<InterfaceItem>();
        if (acc instanceof ActorClass) {
            ActorClass ac = (ActorClass)acc;
            do {
                result.addAll((Collection<InterfaceItem>)ac.getIntPorts());
                result.addAll((Collection<InterfaceItem>)ac.getStrSAPs());
                for (ExternalPort ext : ac.getExtPorts()) {
                    result.add((InterfaceItem)ext.getIfport());
                }
                ac = ac.getBase();
            } while (includeInherited && ac != null);
        } else {
            boolean cfr_ignored_0 = acc instanceof SubSystemClass;
        }
        return result;
    }

    public static String getPath(ActorInstanceConfig config) {
        String path = "/" + config.getRoot().getName() + "/" + config.getSubSystem().getName();
        for (String s : config.getPath().getRefs()) {
            path = String.valueOf(path) + "/" + s;
        }
        return path;
    }

    public static String getPath(SubSystemConfig config) {
        return "/" + config.getRoot().getName() + "/" + config.getSubSystem().getName();
    }

    public static List<Attribute> filterConfigurableAttributes(List<Attribute> attributes) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (Attribute a : attributes) {
            if (a.getRefType().isRef() || !(a.getRefType().getType() instanceof PrimitiveType) && (!(a.getRefType().getType() instanceof DataClass) || a.getSize() != 0)) continue;
            result.add(a);
        }
        return result;
    }
}

