/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.etmap.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.etrice.core.etmap.eTMap.Import;
import org.eclipse.etrice.core.etmap.eTMap.Mapping;
import org.eclipse.etrice.core.etmap.eTMap.SubSystemMapping;
import org.eclipse.etrice.core.etmap.eTMap.ThreadMapping;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.ui.label.StylerFactory;

public class ETMapLabelProvider
extends DefaultEObjectLabelProvider {
    private static final String KEYWORD_COLOR = "KEYWORD_COLOR";
    @Inject
    private StylerFactory stylerFactory;
    private StyledString.Styler keywordStyler = null;

    @Inject
    public ETMapLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String text(Mapping m) {
        return "Mapping " + m.getLogicalSys().getName() + " -> " + m.getPhysicalSys().getName();
    }

    String text(SubSystemMapping ssm) {
        return "SubSystemMapping " + ssm.getLogicalSubSys().getName() + " -> Node " + ssm.getNode().getName();
    }

    String text(ThreadMapping tm) {
        return "ThreadMapping " + tm.getLogicalThread().getName() + " -> " + tm.getPhysicalThread().getName();
    }

    StyledString text(Import im) {
        if (im.getImportedNamespace() == null) {
            StyledString txt = new StyledString("import model " + im.getImportURI());
            txt.setStyle(0, 12, this.getKeywordStyler());
            return txt;
        }
        StyledString txt = new StyledString("import ns " + im.getImportedNamespace());
        txt.setStyle(0, 9, this.getKeywordStyler());
        return txt;
    }

    private StyledString.Styler getKeywordStyler() {
        if (this.keywordStyler == null) {
            FontDescriptor font = JFaceResources.getFontDescriptor((String)"org.eclipse.jface.textfont");
            FontDescriptor boldFont = font.setStyle(1);
            this.keywordStyler = this.stylerFactory.createStyler(boldFont, KEYWORD_COLOR, null);
        }
        return this.keywordStyler;
    }
}

