/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.BindingInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ETriceGenFactory;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortKind;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomPackage;

public class BindingUtil {
    private static final String SEP = "#";
    private StructureInstance si;
    private IDiagnostician diagnostician;
    private ArrayList<Binding> bindings = new ArrayList();
    private HashMap<String, ArrayList<PortInstance>> ep2portInstances = new HashMap();
    private HashMap<String, ArrayList<BindingInfo>> ep2bindings = new HashMap();
    private HashMap<Binding, BindingInfo> binding2info = new HashMap();

    public BindingUtil(StructureInstance si, IDiagnostician diagnostician) {
        this.si = si;
        this.diagnostician = diagnostician;
        if (si instanceof ActorInstance) {
            ActorClass ac = ((ActorInstance)si).getActorClass();
            while (ac != null) {
                this.bindings.addAll((Collection<Binding>)ac.getBindings());
                ac = ac.getBase();
            }
        } else if (si instanceof SubSystemInstance) {
            this.bindings.addAll((Collection<Binding>)((SubSystemInstance)si).getSubSystemClass().getBindings());
        }
    }

    public void createBindingInstances() {
        this.initPortInstanceMap();
        for (Binding bind : this.bindings) {
            if (bind.getEndpoint1().getActorRef() == null && bind.getEndpoint2().getActorRef() == null) {
                int idx = this.bindings.indexOf(bind);
                this.diagnostician.error("binding connects two ports of the same actor", bind.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStructureClass_Bindings(), idx);
                continue;
            }
            ArrayList<PortInstance> ep1Ports = this.ep2portInstances.get(BindingUtil.getEndPointKey(bind.getEndpoint1()));
            ArrayList<PortInstance> ep2Ports = this.ep2portInstances.get(BindingUtil.getEndPointKey(bind.getEndpoint2()));
            BindingInfo bi = this.binding2info.get(bind);
            int nBind = Math.min(bi.getMultiplicity(), ep1Ports.size());
            nBind = Math.min(nBind, ep2Ports.size());
            int i = 0;
            while (i < nBind) {
                this.createBindingInstance(ep1Ports.get(0), ep2Ports.get(0), bind);
                ep1Ports.remove(0);
                ep2Ports.remove(0);
                ++i;
            }
        }
    }

    private void createBindingInstance(PortInstance pi1, PortInstance pi2, Binding bind) {
        BindingInstance bi = ETriceGenFactory.eINSTANCE.createBindingInstance();
        bi.getPorts().add((Object)pi1);
        bi.getPorts().add((Object)pi2);
        bi.setBinding(bind);
        this.si.getBindings().add((Object)bi);
    }

    private void initPortInstanceMap() {
        for (PortInstance pi : this.si.getPorts()) {
            if (pi.getKind() == PortKind.EXTERNAL) continue;
            this.addPortInstance(pi, BindingUtil.getEndPointKey(null, pi));
        }
        for (ActorInstance sub : this.si.getInstances()) {
            boolean forceMultFixed = sub.getReplIdx() > 1;
            for (PortInstance pi : sub.getPorts()) {
                if (pi.getKind() == PortKind.INTERNAL) continue;
                if (forceMultFixed && pi.getPort().getMultiplicity() < 0) {
                    this.diagnostician.error("port multiplicity of replicated actor has to be fixed", (EObject)pi.getPort(), (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
                }
                this.addPortInstance(pi, BindingUtil.getEndPointKey(sub, pi));
            }
        }
        for (Binding bind : this.bindings) {
            BindingInfo bi = new BindingInfo(bind);
            this.binding2info.put(bind, bi);
            this.addBindingInfoToEndPoint(bi, bind.getEndpoint1());
            this.addBindingInfoToEndPoint(bi, bind.getEndpoint2());
        }
        block4: for (Map.Entry entry : this.ep2bindings.entrySet()) {
            boolean implicitMany;
            PortInstance pi;
            ArrayList<PortInstance> ports = this.ep2portInstances.get(entry.getKey());
            pi = ports.get(0);
            Port p = pi.getPort();
            boolean bl = implicitMany = pi.getProtocol() == null || pi.getProtocol().getCommType() == CommunicationType.DATA_DRIVEN;
            if (!implicitMany && p.getMultiplicity() >= 0) continue;
            int m = 0;
            for (BindingInfo bi : (ArrayList)entry.getValue()) {
                Port peer = bi.getPeer(p);
                if (peer.getMultiplicity() > 0) {
                    m += bi.getMultiplicity();
                    continue;
                }
                this.diagnostician.error("could not compute multiplicity", (EObject)p, (EStructuralFeature)RoomPackage.Literals.PORT__MULTIPLICITY);
                break block4;
            }
            m -= ports.size();
            while (m > 0) {
                ports.add(pi);
                --m;
            }
        }
    }

    private void addBindingInfoToEndPoint(BindingInfo bi, BindingEndPoint ep) {
        String key = BindingUtil.getEndPointKey(ep.getActorRef(), ep.getPort());
        ArrayList<BindingInfo> list = this.ep2bindings.get(key);
        if (list == null) {
            list = new ArrayList();
            this.ep2bindings.put(key, list);
        }
        list.add(bi);
    }

    private static String getEndPointKey(ActorInstance ai, PortInstance pi) {
        return String.valueOf(ai != null ? ai.getUnindexedName() : "") + SEP + pi.getPort().getName();
    }

    private static String getEndPointKey(BindingEndPoint ep) {
        return BindingUtil.getEndPointKey(ep.getActorRef(), ep.getPort());
    }

    private static String getEndPointKey(ActorContainerRef ref, Port port) {
        return ref == null ? SEP + port.getName() : String.valueOf(ref.getName()) + SEP + port.getName();
    }

    private void addPortInstance(PortInstance pi, String key) {
        int repl;
        ArrayList<PortInstance> ports = this.ep2portInstances.get(key);
        if (ports == null) {
            ports = new ArrayList();
            this.ep2portInstances.put(key, ports);
        }
        if ((repl = pi.getPort().getMultiplicity()) <= 0) {
            repl = 1;
        }
        int i = 0;
        while (i < repl) {
            ports.add(pi);
            ++i;
        }
    }

    private static class BindingInfo {
        private Binding binding;
        private int multiplicity;

        public BindingInfo(Binding binding) {
            this.binding = binding;
            int m1 = this.getMultiplicity(binding.getEndpoint1());
            int m2 = this.getMultiplicity(binding.getEndpoint2());
            this.multiplicity = Math.max(m1, m2);
        }

        public int getMultiplicity() {
            return this.multiplicity;
        }

        public Port getPeer(Port p) {
            if (this.binding.getEndpoint1().getPort() == p) {
                return this.binding.getEndpoint2().getPort();
            }
            return this.binding.getEndpoint1().getPort();
        }

        private int getMultiplicity(BindingEndPoint ep) {
            if (ep.getActorRef() instanceof ActorRef) {
                return ((ActorRef)ep.getActorRef()).getSize();
            }
            return 1;
        }
    }
}

