/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilder;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.validation.RoomJavaValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckMode;

public class RoomModelValidator
extends RoomJavaValidator
implements ILogger {
    @Check
    public void checkModel(RoomModel model) {
        if (this.getCheckMode() == CheckMode.ALL) {
            ResourceSet rs;
            System.out.println("checking model " + model.getName());
            ArrayList<RoomModel> models = new ArrayList<RoomModel>();
            Resource resource = model.eResource();
            if (resource != null && (rs = resource.getResourceSet()) != null) {
                EcoreUtil.resolveAll((ResourceSet)rs);
                for (Resource res : rs.getResources()) {
                    for (EObject obj : res.getContents()) {
                        if (!(obj instanceof RoomModel)) continue;
                        models.add((RoomModel)obj);
                    }
                }
            }
            if (models.isEmpty()) {
                models.add(model);
            }
            Diag diagnostician = new Diag();
            GeneratorModelBuilder builder = new GeneratorModelBuilder((ILogger)this, (IDiagnostician)diagnostician);
            builder.createGeneratorModel(models, false);
            System.out.println("done checking model " + model.getName() + " with result: " + (diagnostician.isFailed() ? "failed" : "ok"));
        }
    }

    public void issueError(String msg, EObject source, EStructuralFeature feature, int index) {
        if (index == -1) {
            index = -1;
        }
        this.error(msg, source, feature, index);
    }

    public void issueWarning(String msg, EObject source, EStructuralFeature feature, int index) {
        if (index == -1) {
            index = -1;
        }
        this.warning(msg, source, feature, index);
    }

    public void logInfo(String text) {
    }

    public void logError(String text, EObject obj) {
    }

    private class Diag
    implements IDiagnostician {
        private boolean failed = false;

        private Diag() {
        }

        public void warning(String msg, EObject source, EStructuralFeature feature) {
            this.warning(msg, source, feature, -1);
        }

        public void warning(String msg, EObject source, EStructuralFeature feature, int index) {
            RoomModelValidator.this.issueWarning(msg, source, feature, index);
        }

        public void error(String msg, EObject source, EStructuralFeature feature) {
            this.error(msg, source, feature, -1);
        }

        public void error(String msg, EObject source, EStructuralFeature feature, int index) {
            this.failed = true;
            RoomModelValidator.this.issueError(msg, source, feature, index);
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

