/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ActorCommunicationType implements Enumerator
{
    EVENT_DRIVEN(0, "EVENT_DRIVEN", "eventdriven"),
    DATA_DRIVEN(1, "DATA_DRIVEN", "datadriven"),
    ASYNCHRONOUS(2, "ASYNCHRONOUS", "async"),
    SYNCHRONOUS(3, "SYNCHRONOUS", "sync");

    public static final int EVENT_DRIVEN_VALUE = 0;
    public static final int DATA_DRIVEN_VALUE = 1;
    public static final int ASYNCHRONOUS_VALUE = 2;
    public static final int SYNCHRONOUS_VALUE = 3;
    private static final ActorCommunicationType[] VALUES_ARRAY;
    public static final List<ActorCommunicationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActorCommunicationType[]{EVENT_DRIVEN, DATA_DRIVEN, ASYNCHRONOUS, SYNCHRONOUS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActorCommunicationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActorCommunicationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActorCommunicationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActorCommunicationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActorCommunicationType get(int value) {
        switch (value) {
            case 0: {
                return EVENT_DRIVEN;
            }
            case 1: {
                return DATA_DRIVEN;
            }
            case 2: {
                return ASYNCHRONOUS;
            }
            case 3: {
                return SYNCHRONOUS;
            }
        }
        return null;
    }

    private ActorCommunicationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

