/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.ChoicepointTerminal;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.ContinuationTransition;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EntryPoint;
import org.eclipse.etrice.core.room.ExitPoint;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.GuardedTransition;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateTerminal;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionPoint;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.util.CompoundProtocolHelpers;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class ValidationUtil {
    public static boolean isCircularClassHierarchy(DataClass dc) {
        HashSet<DataClass> classes = new HashSet<DataClass>();
        classes.add(dc);
        while (dc.getBase() != null) {
            if (classes.contains(dc = dc.getBase())) {
                return true;
            }
            classes.add(dc);
        }
        return false;
    }

    public static boolean isCircularClassHierarchy(ProtocolClass pc) {
        HashSet<ProtocolClass> classes = new HashSet<ProtocolClass>();
        classes.add(pc);
        while (pc.getBase() != null) {
            if (classes.contains(pc = pc.getBase())) {
                return true;
            }
            classes.add(pc);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isKindOf(ActorClass ac1, ActorClass ac2) {
        if (ac2 == null) {
            return false;
        }
        if (ac1 != null && !ValidationUtil.isCircularClassHierarchy(ac1)) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (ac2 == ac1) {
                return true;
            }
            ac1 = ac1.getBase();
lbl8:
            // 2 sources

            ** while (ac1 != null)
        }
lbl9:
        // 1 sources

        return false;
    }

    public static boolean isCircularClassHierarchy(ActorClass ac) {
        HashSet<ActorClass> classes = new HashSet<ActorClass>();
        classes.add(ac);
        while (ac.getBase() != null) {
            if (classes.contains(ac = ac.getBase())) {
                return true;
            }
            classes.add(ac);
        }
        return false;
    }

    public static boolean isReferencing(ActorClass ref, ActorClass ac) {
        if (ValidationUtil.isKindOf(ref, ac)) {
            return true;
        }
        for (ActorRef ar : ref.getActorRefs()) {
            if (ValidationUtil.isKindOf(ar.getType(), ac)) {
                return true;
            }
            if (!ValidationUtil.isReferencing(ar.getType(), ac)) continue;
            return true;
        }
        return false;
    }

    public static Result isConnectable(Port port, ActorContainerRef ref, StructureClass acc) {
        return ValidationUtil.isConnectable(port, ref, acc, null);
    }

    public static Result isConnectable(Port port, ActorContainerRef ref, StructureClass acc, Binding exclude) {
        if (!ValidationUtil.isMultipleConnectable(port, ref) && ValidationUtil.isConnected(port, ref, acc, exclude)) {
            return Result.error("port with multiplicity 1 is already connected");
        }
        if (acc instanceof ActorClass) {
            for (ExternalPort xp : ((ActorClass)acc).getExtPorts()) {
                if (xp.getIfport() != port) continue;
                return Result.error("external end ports must not be connected");
            }
        }
        return Result.ok();
    }

    public static boolean isMultipleConnectable(Port port, ActorContainerRef ref) {
        if (port.isReplicated()) {
            return true;
        }
        if (ref != null && ref instanceof ActorRef && ((ActorRef)ref).getSize() > 1) {
            return true;
        }
        if (RoomHelpers.isRelay(port) && port.getProtocol() instanceof CompoundProtocolClass) {
            return true;
        }
        if (port.getProtocol() instanceof ProtocolClass && ((ProtocolClass)port.getProtocol()).getCommType() == CommunicationType.DATA_DRIVEN) {
            if (ref == null) {
                if (RoomHelpers.isRelay(port)) {
                    return !port.isConjugated();
                }
                return port.isConjugated();
            }
            return port.isConjugated();
        }
        return false;
    }

    public static Result isValid(Binding bind) {
        return ValidationUtil.isConnectable(bind.getEndpoint1().getPort(), bind.getEndpoint1().getActorRef(), bind.getEndpoint1().getSub(), bind.getEndpoint2().getPort(), bind.getEndpoint2().getActorRef(), bind.getEndpoint2().getSub(), (StructureClass)bind.eContainer(), bind, true);
    }

    public static Result isConnectable(BindingEndPoint ep1, BindingEndPoint ep2, StructureClass sc) {
        return ValidationUtil.isConnectable(ep1.getPort(), ep1.getActorRef(), ep1.getSub(), ep2.getPort(), ep2.getActorRef(), ep2.getSub(), sc);
    }

    public static Result isConnectable(Port p1, ActorContainerRef ref1, SubProtocol sub1, Port p2, ActorContainerRef ref2, SubProtocol sub2, StructureClass sc) {
        return ValidationUtil.isConnectable(p1, ref1, sub1, p2, ref2, sub2, sc, null, true);
    }

    public static Result isConnectable(Port p1, ActorContainerRef ref1, SubProtocol sub1, Port p2, ActorContainerRef ref2, SubProtocol sub2, StructureClass sc, Binding exclude, boolean checkCompound) {
        boolean compoundInvolved;
        if (p1 == p2) {
            return Result.error("no self connection allowed, ports are indentical");
        }
        if (ValidationUtil.alreadyConnected(p1, ref1, p2, ref2, sc, exclude)) {
            return Result.error("ports are already bound");
        }
        boolean pc1extendsIncoming = false;
        boolean pc1extendsOutgoing = false;
        boolean pc2extendsIncoming = false;
        boolean pc2extendsOutgoing = false;
        GeneralProtocolClass pc1 = p1.getProtocol();
        GeneralProtocolClass pc2 = p2.getProtocol();
        boolean bl = compoundInvolved = pc1 instanceof CompoundProtocolClass || pc2 instanceof CompoundProtocolClass;
        if (pc1 instanceof CompoundProtocolClass && pc2 instanceof CompoundProtocolClass) {
            if (sub1 != null) {
                pc1 = sub1.getProtocol();
            }
            if (sub2 != null) {
                pc2 = sub2.getProtocol();
            }
            if (checkCompound && pc1 != pc2) {
                return Result.error("(sub) protocols don't match");
            }
        } else if (pc1 instanceof ProtocolClass && pc2 instanceof CompoundProtocolClass) {
            if (checkCompound) {
                if (sub2 == null) {
                    return Result.error("specify a sub protocol at " + p2.getName());
                }
                if (pc1 != sub2.getProtocol()) {
                    return Result.error("sub protocol doesn't match");
                }
            }
        } else if (pc1 instanceof CompoundProtocolClass && pc2 instanceof ProtocolClass) {
            if (checkCompound) {
                if (sub1 == null) {
                    return Result.error("specify a sub protocol at " + p1.getName());
                }
                if (pc2 != sub1.getProtocol()) {
                    return Result.error("sub protocol doesn't match");
                }
            }
        } else if (pc1 != pc2) {
            if (compoundInvolved) {
                return Result.error("protocols don't match");
            }
            if (!(pc1 instanceof ProtocolClass) || !(pc2 instanceof ProtocolClass)) {
                return Result.error("protocols don't match");
            }
            if (RoomHelpers.isDerivedFrom((ProtocolClass)pc1, (ProtocolClass)pc2)) {
                if (RoomHelpers.getAllMessages((ProtocolClass)pc1, true).size() > RoomHelpers.getAllMessages((ProtocolClass)pc2, true).size()) {
                    pc1extendsIncoming = true;
                }
                if (RoomHelpers.getAllMessages((ProtocolClass)pc1, false).size() > RoomHelpers.getAllMessages((ProtocolClass)pc2, false).size()) {
                    pc1extendsOutgoing = true;
                }
                if (pc1extendsIncoming && pc1extendsOutgoing) {
                    return Result.error("derived protocols not connectable (both directions extended)");
                }
            } else if (RoomHelpers.isDerivedFrom((ProtocolClass)pc2, (ProtocolClass)pc1)) {
                if (RoomHelpers.getAllMessages((ProtocolClass)pc2, true).size() > RoomHelpers.getAllMessages((ProtocolClass)pc1, true).size()) {
                    pc2extendsIncoming = true;
                }
                if (RoomHelpers.getAllMessages((ProtocolClass)pc2, false).size() > RoomHelpers.getAllMessages((ProtocolClass)pc1, false).size()) {
                    pc2extendsOutgoing = true;
                }
                if (pc2extendsIncoming && pc2extendsOutgoing) {
                    return Result.error("derived protocols not connectable (both directions extended)");
                }
            } else {
                if (pc1.getName().equals(pc2.getName())) {
                    String ns2;
                    String ns1 = ((RoomModel)pc1.eContainer()).getName();
                    if (!ns1.equals(ns2 = ((RoomModel)pc2.eContainer()).getName())) {
                        return Result.error("protocols don't match (same name, different name spaces)");
                    }
                    return Result.error("protocols don't match (but have same name)");
                }
                return Result.error("protocols don't match");
            }
        }
        if (checkCompound || !compoundInvolved) {
            ProtocolClass spc1 = null;
            if (pc1 instanceof ProtocolClass) {
                spc1 = (ProtocolClass)pc1;
            } else if (sub1.getProtocol() instanceof ProtocolClass) {
                spc1 = (ProtocolClass)sub1.getProtocol();
            }
            ProtocolClass spc2 = null;
            if (pc2 instanceof ProtocolClass) {
                spc2 = (ProtocolClass)pc2;
            } else if (sub2.getProtocol() instanceof ProtocolClass) {
                spc2 = (ProtocolClass)sub2.getProtocol();
            }
            if (spc1 != null && spc2 != null && spc1.getCommType() != spc2.getCommType()) {
                return Result.error("protocol communication types don't match");
            }
        }
        if (compoundInvolved) {
            List<CompoundProtocolHelpers.Match> matches = CompoundProtocolHelpers.getMatches(p1, ref1, p2, ref2, sc, exclude);
            if (matches.isEmpty()) {
                return Result.error("no matching sub protocol(s) found");
            }
            if (matches.size() == 1 && exclude != null) {
                if (matches.get(0).getLeft() != exclude.getEndpoint1().getSub()) {
                    return Result.error("sub protocol already connected");
                }
                if (matches.get(0).getRight() != exclude.getEndpoint2().getSub()) {
                    return Result.error("sub protocol already connected");
                }
            }
        }
        if (ref1 == null && ref2 == null) {
            return Result.error("cannot connect two local ports");
        }
        if (ref1 != null && ref2 != null) {
            if (ref1 == ref2) {
                return Result.error("ports of one ref must not be connected");
            }
            if (p1.isConjugated() == p2.isConjugated()) {
                return Result.error("connected sub component ports must be conjugated to each other");
            }
            if (p1.isConjugated() && pc1extendsIncoming) {
                return Result.error("protocol extends incoming");
            }
            if (p2.isConjugated() && pc2extendsIncoming) {
                return Result.error("protocol extends incoming");
            }
            if (!p1.isConjugated() && pc1extendsOutgoing) {
                return Result.error("protocol extends outgoing");
            }
            if (!p2.isConjugated() && pc2extendsOutgoing) {
                return Result.error("protocol extends outgoing");
            }
            Result result = ValidationUtil.isConnectable(p1, ref1, sc, exclude);
            if (!result.isOk()) {
                return result;
            }
            result = ValidationUtil.isConnectable(p2, ref2, sc, exclude);
            if (!result.isOk()) {
                return result;
            }
        } else {
            ActorContainerRef ref;
            Port local = ref1 == null ? p1 : p2;
            Port sub = ref1 != null ? p1 : p2;
            ActorContainerRef actorContainerRef = ref = ref1 != null ? ref1 : ref2;
            if (RoomHelpers.isRelay(local)) {
                ActorContainerClass acc;
                Result result;
                if (local.isConjugated() != sub.isConjugated()) {
                    return Result.error("relay port must have same direction as local port");
                }
                if (local == p1) {
                    if (!p1.isConjugated() && pc1extendsIncoming) {
                        return Result.error("protocol extends incoming");
                    }
                    if (p2.isConjugated() && pc2extendsIncoming) {
                        return Result.error("protocol extends incoming");
                    }
                    if (p1.isConjugated() && pc1extendsOutgoing) {
                        return Result.error("protocol extends outgoing");
                    }
                    if (!p2.isConjugated() && pc2extendsOutgoing) {
                        return Result.error("protocol extends outgoing");
                    }
                } else {
                    if (p1.isConjugated() && pc1extendsIncoming) {
                        return Result.error("protocol extends incoming");
                    }
                    if (!p2.isConjugated() && pc2extendsIncoming) {
                        return Result.error("protocol extends incoming");
                    }
                    if (!p1.isConjugated() && pc1extendsOutgoing) {
                        return Result.error("protocol extends outgoing");
                    }
                    if (p2.isConjugated() && pc2extendsOutgoing) {
                        return Result.error("protocol extends outgoing");
                    }
                }
                if (!(result = ValidationUtil.isConnectable(local, null, acc = (ActorContainerClass)ref.eContainer(), exclude)).isOk()) {
                    return result;
                }
                result = ValidationUtil.isConnectable(sub, ref, acc, exclude);
                if (!result.isOk()) {
                    return result;
                }
            } else {
                if (local.isConjugated() == sub.isConjugated()) {
                    return Result.error("internal end port must have opposite direction");
                }
                if (p1.isConjugated() && pc1extendsIncoming) {
                    return Result.error("protocol extends incoming");
                }
                if (p2.isConjugated() && pc2extendsIncoming) {
                    return Result.error("protocol extends incoming");
                }
                if (!p1.isConjugated() && pc1extendsOutgoing) {
                    return Result.error("protocol extends outgoing");
                }
                if (!p2.isConjugated() && pc2extendsOutgoing) {
                    return Result.error("protocol extends outgoing");
                }
                Result result = ValidationUtil.isConnectable(sub, ref, sc, exclude);
                if (!result.isOk()) {
                    return result;
                }
                result = ValidationUtil.isConnectable(local, null, sc, exclude);
                if (!result.isOk()) {
                    return result;
                }
            }
        }
        return Result.ok();
    }

    private static boolean alreadyConnected(Port p1, ActorContainerRef ref1, Port p2, ActorContainerRef ref2, StructureClass sc, Binding exclude) {
        HashSet<String> bindings = new HashSet<String>();
        String key = ValidationUtil.getKey(p1, ref1, p2, ref2);
        bindings.add(key);
        for (Binding bind : sc.getBindings()) {
            if (bind == exclude || bind.getEndpoint1().getPort() != p1 || bind.getEndpoint1().getActorRef() != ref1 || bind.getEndpoint2().getPort() != p2 || bind.getEndpoint2().getActorRef() != ref2 || bind.getEndpoint2().getPort() != p1 || bind.getEndpoint2().getActorRef() != ref1 || bind.getEndpoint1().getPort() != p2 || bind.getEndpoint1().getActorRef() != ref2 || bindings.add(key = ValidationUtil.getKey(bind.getEndpoint1().getPort(), bind.getEndpoint1().getActorRef(), bind.getEndpoint2().getPort(), bind.getEndpoint2().getActorRef()))) continue;
            return true;
        }
        return false;
    }

    private static String getKey(Port p1, ActorContainerRef ref1, Port p2, ActorContainerRef ref2) {
        String ep2;
        String ep1 = ValidationUtil.getEndpointName(p1, ref1);
        return ep1.compareTo(ep2 = ValidationUtil.getEndpointName(p2, ref2)) > 0 ? String.valueOf(ep1) + ep2 : String.valueOf(ep2) + ep1;
    }

    private static String getEndpointName(Port p1, ActorContainerRef ref1) {
        if (ref1 == null) {
            return String.valueOf(p1.getName()) + "#.";
        }
        return String.valueOf(p1.getName()) + "#" + ref1.getName();
    }

    public static Result isFreeOfReferences(Port port) {
        Collection refs = EcoreUtil.UsageCrossReferencer.find((EObject)port, (ResourceSet)port.eResource().getResourceSet());
        boolean bound = false;
        boolean usedByFSM = false;
        for (EStructuralFeature.Setting ref : refs) {
            if (ref.getEObject() instanceof BindingEndPoint) {
                bound = true;
                continue;
            }
            if (!(ref.getEObject() instanceof MessageFromIf)) continue;
            usedByFSM = true;
        }
        if (bound && usedByFSM) {
            return Result.error("port is bound and also used by state machine (triggers)");
        }
        if (bound) {
            return Result.error("port is bound (may be externally)");
        }
        if (usedByFSM) {
            return Result.error("port is used by state machine (triggers)");
        }
        return Result.ok();
    }

    public static boolean isReferencedAsReplicatedInModel(ActorClass ac) {
        Collection refs = EcoreUtil.UsageCrossReferencer.find((EObject)ac, (ResourceSet)ac.eResource().getResourceSet());
        for (EStructuralFeature.Setting ref : refs) {
            if (!(ref.getEObject() instanceof ActorRef)) continue;
            return ((ActorRef)ref.getEObject()).getSize() > 1;
        }
        return false;
    }

    public static boolean isConnected(Port port, ActorContainerRef ref, StructureClass sc) {
        return ValidationUtil.isConnected(port, ref, sc, null);
    }

    public static boolean isConnected(Port port, ActorContainerRef ref, StructureClass sc, Binding exclude) {
        for (Binding bind : sc.getBindings()) {
            if (bind == exclude) continue;
            if (ValidationUtil.isEndpoint(bind.getEndpoint1(), port, ref)) {
                return true;
            }
            if (!ValidationUtil.isEndpoint(bind.getEndpoint2(), port, ref)) continue;
            return true;
        }
        if (sc instanceof ActorClass && ((ActorClass)sc).getBase() != null) {
            return ValidationUtil.isConnected(port, ref, ((ActorClass)sc).getBase(), exclude);
        }
        return false;
    }

    private static boolean isEndpoint(BindingEndPoint ep, Port port, ActorContainerRef ref) {
        return ep.getActorRef() == ref && ep.getPort() == port;
    }

    public static boolean isRelay(SPPRef spp) {
        ActorContainerClass acc = (ActorContainerClass)spp.eContainer();
        if (acc instanceof ActorClass) {
            ActorClass ac = (ActorClass)acc;
            for (ServiceImplementation svc : ac.getServiceImplementations()) {
                if (svc.getSpp() != spp) continue;
                return false;
            }
        }
        return true;
    }

    public static Result isValid(LayerConnection lc) {
        if (lc.getFrom() instanceof RelaySAPoint) {
            return ValidationUtil.isConnectable(((RelaySAPoint)lc.getFrom()).getRelay(), null, lc.getTo().getService(), lc.getTo().getRef(), (StructureClass)lc.eContainer(), lc);
        }
        if (lc.getFrom() instanceof RefSAPoint) {
            return ValidationUtil.isConnectable(null, ((RefSAPoint)lc.getFrom()).getRef(), lc.getTo().getService(), lc.getTo().getRef(), (StructureClass)lc.eContainer(), lc);
        }
        assert (false) : "unexpected sub type";
        return Result.error("internal error");
    }

    public static Result isConnectable(SPPRef src, ActorContainerRef srcRef, SPPRef tgt, ActorContainerRef tgtRef, StructureClass ac) {
        return ValidationUtil.isConnectable(src, srcRef, tgt, tgtRef, ac, null);
    }

    public static Result isConnectable(SPPRef src, ActorContainerRef srcRef, SPPRef dst, ActorContainerRef dstRef, StructureClass sc, LayerConnection exclude) {
        if (sc == null) {
            return Result.error("internal error");
        }
        if (src == null && srcRef == null || src != null && srcRef != null) {
            return Result.error("source can be an own SPP _or_ a ref");
        }
        if (dst == null || dstRef == null) {
            return Result.error("destination must be an SPP on a ref");
        }
        if (src != null && ValidationUtil.isConnectedSrc(src, sc, exclude)) {
            return Result.error("source SPP is already connected");
        }
        return Result.ok();
    }

    public static boolean isConnectableSrc(SPPRef src, ActorContainerRef ref, StructureClass sc) {
        return ValidationUtil.isConnectableSrc(src, ref, sc, null);
    }

    public static boolean isConnectableSrc(SPPRef src, ActorContainerRef ref, StructureClass sc, LayerConnection exclude) {
        if (sc == null) {
            return false;
        }
        if (src == null && ref == null || src != null && ref != null) {
            return false;
        }
        if (ref instanceof ActorRef && ((ActorRef)ref).getSize() > 1) {
            return false;
        }
        return src == null || !ValidationUtil.isConnectedSrc(src, sc, exclude);
    }

    public static boolean isReferencedInModel(SPPRef spp) {
        Collection refs = EcoreUtil.UsageCrossReferencer.find((EObject)spp, (ResourceSet)spp.eResource().getResourceSet());
        for (EStructuralFeature.Setting ref : refs) {
            if (ref.getEObject() instanceof ServiceImplementation) {
                return true;
            }
            if (ref.getEObject() instanceof RelaySAPoint) {
                return true;
            }
            if (!(ref.getEObject() instanceof SPPoint)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConnectedSrc(SPPRef src, StructureClass sc) {
        return ValidationUtil.isConnectedSrc(src, sc, null);
    }

    public static boolean isConnectedSrc(SPPRef src, StructureClass sc, LayerConnection exclude) {
        for (LayerConnection lc : sc.getConnections()) {
            if (lc == exclude || !(lc.getFrom() instanceof RelaySAPoint) || ((RelaySAPoint)lc.getFrom()).getRelay() != src) continue;
            return true;
        }
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            for (ServiceImplementation svc : ac.getServiceImplementations()) {
                if (svc.getSpp() != src) continue;
                return true;
            }
            if (ac.getBase() != null) {
                return ValidationUtil.isConnectedSrc(src, ac.getBase(), exclude);
            }
        }
        return false;
    }

    public static boolean isConnectableDst(SPPRef src, ActorContainerRef ref, StructureClass sc) {
        return ValidationUtil.isConnectableDst(src, ref, sc, null);
    }

    public static boolean isConnectableDst(SPPRef dst, ActorContainerRef ref, StructureClass sc, LayerConnection exclude) {
        if (sc == null) {
            return false;
        }
        if (dst == null || ref == null) {
            return false;
        }
        return dst == null || !ValidationUtil.isConnectedDst(dst, ref, sc, exclude);
    }

    public static boolean isConnectedDst(SPPRef src, ActorContainerRef acr, StructureClass sc) {
        return ValidationUtil.isConnectedDst(src, acr, sc, null);
    }

    public static boolean isConnectedDst(SPPRef src, ActorContainerRef acr, StructureClass sc, LayerConnection exclude) {
        for (LayerConnection lc : sc.getConnections()) {
            if (lc == exclude || lc.getTo().getService() != src || lc.getTo().getRef() != acr) continue;
            return true;
        }
        if (sc instanceof ActorClass && ((ActorClass)sc).getBase() != null) {
            return ValidationUtil.isConnectedDst(src, acr, ((ActorClass)sc).getBase(), exclude);
        }
        return false;
    }

    public static Result isConnectable(TransitionTerminal src, TransitionTerminal tgt, StateGraph sg) {
        return ValidationUtil.isConnectable(src, tgt, null, sg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Result isConnectable(TransitionTerminal src, TransitionTerminal tgt, Transition trans, StateGraph sg) {
        Result result = ValidationUtil.isConnectableSrc(src, trans, sg);
        if (!result.isOk()) {
            return result;
        }
        if (tgt instanceof TrPointTerminal) {
            if (((TrPointTerminal)tgt).getTrPoint() instanceof EntryPoint) {
                return Result.error("entry point can not be transition target", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            }
            TrPoint tgtTP = ((TrPointTerminal)tgt).getTrPoint();
            if (!(((TrPointTerminal)tgt).getTrPoint() instanceof TransitionPoint)) return Result.ok();
            if (src instanceof TrPointTerminal) {
                TrPoint srcTP = ((TrPointTerminal)src).getTrPoint();
                if (srcTP == tgtTP) return Result.ok();
                return Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            }
            if (!(src instanceof ChoicepointTerminal)) return Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            ChoicePoint cp = ((ChoicepointTerminal)src).getCp();
            block0: while (cp != null) {
                for (Transition tr : sg.getTransitions()) {
                    if (!(tr.getTo() instanceof ChoicepointTerminal) || ((ChoicepointTerminal)tr.getTo()).getCp() != cp || !(tr instanceof NonInitialTransition)) continue;
                    if (((NonInitialTransition)tr).getFrom() instanceof TrPointTerminal) {
                        TrPoint srcTP = ((TrPointTerminal)((NonInitialTransition)tr).getFrom()).getTrPoint();
                        if (srcTP == tgtTP) return Result.ok();
                        return Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
                    }
                    if (!(((NonInitialTransition)tr).getFrom() instanceof ChoicepointTerminal)) continue;
                    cp = ((ChoicepointTerminal)((NonInitialTransition)tr).getFrom()).getCp();
                    continue block0;
                }
            }
            return Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
        }
        if (!(tgt instanceof SubStateTrPointTerminal) || !(((SubStateTrPointTerminal)tgt).getTrPoint() instanceof ExitPoint)) return Result.ok();
        return Result.error("sub state exit point can not be transition target", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
    }

    public static Result isConnectable(TransitionTerminal src, StateGraph sg) {
        return ValidationUtil.isConnectableSrc(src, null, sg);
    }

    public static Result isConnectableSrc(TransitionTerminal src, Transition trans, StateGraph sg) {
        block7: {
            block8: {
                block6: {
                    if (src != null) break block6;
                    for (Transition t : sg.getTransitions()) {
                        if (t == trans || !(t instanceof InitialTransition)) continue;
                        return Result.error("there already is an InitialTransition", sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), sg.getTransitions().indexOf((Object)trans));
                    }
                    break block7;
                }
                if (!(src instanceof TrPointTerminal)) break block8;
                TrPoint srcTP = ((TrPointTerminal)src).getTrPoint();
                if (srcTP instanceof ExitPoint) {
                    return Result.error("exit point can not be transition source", trans, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
                }
                if (!(srcTP instanceof EntryPoint)) break block7;
                for (Transition t : sg.getTransitions()) {
                    TrPointTerminal tpt;
                    if (t == trans || !(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof TrPointTerminal) || (tpt = (TrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != srcTP) continue;
                    return Result.error("source transition point already is connected", src, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
                }
                break block7;
            }
            if (src instanceof SubStateTrPointTerminal) {
                if (((SubStateTrPointTerminal)src).getTrPoint() instanceof EntryPoint) {
                    return Result.error("sub state entry point can not be transition source", src, (EStructuralFeature)RoomPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
                }
                for (Transition t : sg.getTransitions()) {
                    SubStateTrPointTerminal tpt;
                    if (t == trans || !(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof SubStateTrPointTerminal) || (tpt = (SubStateTrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != ((SubStateTrPointTerminal)src).getTrPoint()) continue;
                    return Result.error("source transition point already is connected", src, (EStructuralFeature)RoomPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
                }
            }
        }
        return Result.ok();
    }

    public static Result isValid(TrPoint tp) {
        if (!ValidationUtil.isUniqueName(tp, tp.getName()).isOk()) {
            return Result.error("name is not unique", tp, (EStructuralFeature)RoomPackage.Literals.TR_POINT__NAME);
        }
        if (tp instanceof TransitionPoint) {
            return Result.ok();
        }
        if (!(tp.eContainer().eContainer() instanceof State)) {
            StateGraph sg = (StateGraph)tp.eContainer();
            int idx = sg.getTrPoints().indexOf((Object)tp);
            return Result.error("entry and exit points forbidden on top level state graph", tp.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
        }
        return Result.ok();
    }

    public static Result isUniqueName(InterfaceItem item) {
        return ValidationUtil.isUniqueName(item, item.getName());
    }

    public static boolean isConnectedOutside(TrPoint tp) {
        if (tp instanceof TransitionPoint) {
            return false;
        }
        StateGraph parentSG = (StateGraph)tp.eContainer().eContainer().eContainer();
        for (Transition t : parentSG.getTransitions()) {
            SubStateTrPointTerminal term;
            if (t.getTo() instanceof SubStateTrPointTerminal && (term = (SubStateTrPointTerminal)t.getTo()).getTrPoint() == tp) {
                return true;
            }
            if (!(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof SubStateTrPointTerminal) || (term = (SubStateTrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != tp) continue;
            return true;
        }
        return false;
    }

    public static Result isUniqueName(InterfaceItem item, String name) {
        block8: {
            block7: {
                if (name.isEmpty()) {
                    return Result.error("name must not be empty");
                }
                if (!ValidationUtil.isValidID(name)) {
                    return Result.error("name is no valid ID");
                }
                if (!(item.eContainer() instanceof ActorClass)) break block7;
                ArrayList<InterfaceItem> all = new ArrayList<InterfaceItem>();
                ActorClass ac = (ActorClass)item.eContainer();
                if (ValidationUtil.isCircularClassHierarchy(ac)) {
                    return Result.ok();
                }
                do {
                    all.addAll((Collection<InterfaceItem>)ac.getIfPorts());
                    all.addAll((Collection<InterfaceItem>)ac.getIntPorts());
                    all.addAll((Collection<InterfaceItem>)ac.getIfSPPs());
                    all.addAll((Collection<InterfaceItem>)ac.getStrSAPs());
                } while ((ac = ac.getBase()) != null);
                for (InterfaceItem ii : all) {
                    if (ii == item || !ii.getName().equals(name)) continue;
                    if (ii.eContainer() != item.eContainer()) {
                        return Result.error("name already used in base class " + ((ActorClass)ii.eContainer()).getName());
                    }
                    return Result.error("name already used");
                }
                break block8;
            }
            if (!(item.eContainer() instanceof SubSystemClass)) break block8;
            SubSystemClass ssc = (SubSystemClass)item.eContainer();
            ArrayList<InterfaceItem> all = new ArrayList<InterfaceItem>();
            all.addAll((Collection<InterfaceItem>)ssc.getIfSPPs());
            all.addAll((Collection<InterfaceItem>)ssc.getRelayPorts());
            for (InterfaceItem ii : all) {
                if (ii == item || !ii.getName().equals(name)) continue;
                return Result.error("name already used");
            }
        }
        return Result.ok();
    }

    public static Result isUniqueName(StateGraphItem s, String name) {
        if (name.trim().isEmpty()) {
            return Result.error("name must not be empty");
        }
        if (!ValidationUtil.isValidID(name)) {
            return Result.error("name is no valid ID");
        }
        StateGraph sg = (StateGraph)s.eContainer();
        Set<String> names = RoomHelpers.getAllNames(sg, s);
        if (names.contains(name)) {
            return Result.error("name already used");
        }
        return Result.ok();
    }

    public static Result checkTransition(Transition tr) {
        TransitionTerminal term;
        ActorClass ac = RoomHelpers.getActorClass(tr);
        if (ac.getCommType() == ActorCommunicationType.DATA_DRIVEN) {
            if (tr instanceof TriggeredTransition) {
                return Result.error("data driven state machine must not contain triggered transition", tr.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
            if (tr instanceof ContinuationTransition) {
                TransitionTerminal term2 = ((ContinuationTransition)tr).getFrom();
                if (term2 instanceof StateTerminal || term2 instanceof TrPointTerminal && ((TrPointTerminal)term2).getTrPoint() instanceof TransitionPoint) {
                    return Result.error("guard must not be empty", tr.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
                }
            } else if (tr instanceof GuardedTransition && !RoomHelpers.hasDetailCode(((GuardedTransition)tr).getGuard())) {
                return Result.error("guard must not be empty", tr, (EStructuralFeature)RoomPackage.eINSTANCE.getGuardedTransition_Guard());
            }
        } else if (ac.getCommType() == ActorCommunicationType.EVENT_DRIVEN) {
            TransitionTerminal term3;
            if (tr instanceof GuardedTransition) {
                return Result.error("event driven state machine must not contain guarded transition", tr.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
            if (tr instanceof ContinuationTransition && ((term3 = ((ContinuationTransition)tr).getFrom()) instanceof StateTerminal || term3 instanceof TrPointTerminal && ((TrPointTerminal)term3).getTrPoint() instanceof TransitionPoint)) {
                return Result.error("trigger must not be empty", tr.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
        } else if (ac.getCommType() == ActorCommunicationType.ASYNCHRONOUS && tr instanceof ContinuationTransition && ((term = ((ContinuationTransition)tr).getFrom()) instanceof StateTerminal || term instanceof TrPointTerminal && ((TrPointTerminal)term).getTrPoint() instanceof TransitionPoint)) {
            return Result.error("trigger/guard must not be empty", tr.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
        }
        return Result.ok();
    }

    public static Result checkState(State state) {
        ActorClass ac;
        if (state.getDoCode() != null && (ac = RoomHelpers.getActorClass(state)).getCommType() == ActorCommunicationType.EVENT_DRIVEN) {
            return Result.error("event driven state machines must not have 'do' action code", state, (EStructuralFeature)RoomPackage.eINSTANCE.getState_DoCode());
        }
        return Result.ok();
    }

    public static List<Result> checkTopLevelRefinedStates(ActorClass ac) {
        ArrayList<Result> errors = new ArrayList<Result>();
        if (ac.getStateMachine() == null) {
            return errors;
        }
        Map<RefinedState, RefinedState> rs2parent = RoomHelpers.getRefinedStatesToRelocate(ac);
        for (RefinedState rs : rs2parent.keySet()) {
            RefinedState parent = rs2parent.get(rs);
            String path = RoomNameProvider.getFullPath(parent);
            int idx = ((StateGraph)rs.eContainer()).getStates().indexOf((Object)rs);
            errors.add(Result.error("RefinedState has to be in the context of " + path, rs.eContainer(), (EStructuralFeature)RoomPackage.Literals.STATE_GRAPH__STATES, idx));
        }
        return errors;
    }

    public static boolean isValidID(String name) {
        return name.matches("\\^?[a-zA-Z_][a-zA-Z_0-9]*");
    }

    public static class Result {
        private boolean ok;
        private String msg;
        private EObject source;
        private EStructuralFeature feature;
        private int index;

        public static Result ok() {
            return new Result(true, "", null, null, 0);
        }

        public static Result error(String msg) {
            return new Result(false, msg, null, null, -1);
        }

        public static Result error(String msg, EObject source, EStructuralFeature feature) {
            return new Result(false, msg, source, feature, -1);
        }

        public static Result error(String msg, EObject source, EStructuralFeature feature, int index) {
            return new Result(false, msg, source, feature, index);
        }

        private Result(boolean ok, String msg, EObject source, EStructuralFeature feature, int index) {
            this.ok = ok;
            this.msg = msg;
            this.source = source;
            this.feature = feature;
            this.index = index;
        }

        public boolean isOk() {
            return this.ok;
        }

        public String getMsg() {
            return this.msg;
        }

        public EObject getSource() {
            return this.source;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

