/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.gen.StateMachineGen;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ActorClassGen
extends GenericActorClassGenerator {
    @Inject
    @Extension
    protected RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private StateMachineGen _stateMachineGen;
    @Inject
    protected ILanguageExtension langExt;
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _xpActorClasses = root.getXpActorClasses();
        for (ExpandedActorClass xpac : _xpActorClasses) {
            String _cSourceFileName;
            ActorClass _actorClass = xpac.getActorClass();
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_actorClass);
            ActorClass _actorClass_1 = xpac.getActorClass();
            String _path = this._roomExtensions.getPath((RoomClass)_actorClass_1);
            String path = String.valueOf(_generationTargetPath) + _path;
            ActorClass _actorClass_2 = xpac.getActorClass();
            String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)_actorClass_2);
            ActorClass _actorClass_3 = xpac.getActorClass();
            String _path_1 = this._roomExtensions.getPath((RoomClass)_actorClass_3);
            String infopath = String.valueOf(_generationInfoPath) + _path_1;
            ActorClass _actorClass_4 = xpac.getActorClass();
            String file = this._cExtensions.getCHeaderFileName((RoomClass)_actorClass_4);
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, xpac);
            this.fileIO.generateFile("generating ActorClass header", path, infopath, file, _generateHeaderFile);
            CharSequence _generateHeaderFile_1 = this.generateHeaderFile(root, xpac);
            this.fileIO.generateFile("generating ActorClass header", path, infopath, file, _generateHeaderFile_1);
            ActorClass _actorClass_5 = xpac.getActorClass();
            boolean _isBehaviorAnnotationPresent = RoomHelpers.isBehaviorAnnotationPresent((ActorClass)_actorClass_5, (String)"BehaviorManual");
            if (_isBehaviorAnnotationPresent) {
                ActorClass _actorClass_6 = xpac.getActorClass();
                String _name = _actorClass_6.getName();
                String _plus = "omitting ActorClass source for '" + _name;
                String _plus_1 = String.valueOf(_plus) + "' since @BehaviorManual is specified";
                this.logger.logInfo(_plus_1);
                continue;
            }
            ActorClass _actorClass_7 = xpac.getActorClass();
            file = _cSourceFileName = this._cExtensions.getCSourceFileName((RoomClass)_actorClass_7);
            CharSequence _generateSourceFile = this.generateSourceFile(root, xpac);
            this.fileIO.generateFile("generating ActorClass source", path, infopath, file, _generateSourceFile);
        }
    }

    private CharSequence generateHeaderFile(Root root, ExpandedActorClass xpac) {
        boolean _not_1;
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        List _allEndPorts = RoomHelpers.getAllEndPorts((ActorClass)ac);
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                GeneralProtocolClass _protocol = p.getProtocol();
                CommunicationType _commType = ((ProtocolClass)_protocol).getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
                return _equals;
            }
        };
        Iterable eventPorts = IterableExtensions.filter((Iterable)_allEndPorts, (Functions.Function1)_function);
        List _allEndPorts_1 = RoomHelpers.getAllEndPorts((ActorClass)ac);
        Functions.Function1<Port, Boolean> _function_1 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                boolean _and = false;
                GeneralProtocolClass _protocol = p.getProtocol();
                CommunicationType _commType = ((ProtocolClass)_protocol).getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                if (!_equals) {
                    _and = false;
                } else {
                    boolean _isConjugated = p.isConjugated();
                    _and = _equals && _isConjugated;
                }
                return _and;
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)_allEndPorts_1, (Functions.Function1)_function_1);
        List _allEndPorts_2 = RoomHelpers.getAllEndPorts((ActorClass)ac);
        Functions.Function1<Port, Boolean> _function_2 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                boolean _and = false;
                GeneralProtocolClass _protocol = p.getProtocol();
                CommunicationType _commType = ((ProtocolClass)_protocol).getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                if (!_equals) {
                    _and = false;
                } else {
                    boolean _isConjugated = p.isConjugated();
                    boolean _not = !_isConjugated;
                    _and = _equals && _not;
                }
                return _and;
            }
        };
        Iterable recvPorts = IterableExtensions.filter((Iterable)_allEndPorts_2, (Functions.Function1)_function_2);
        ActorCommunicationType _commType = ac.getCommType();
        boolean dataDriven = Objects.equal((Object)_commType, (Object)ActorCommunicationType.DATA_DRIVEN);
        ActorCommunicationType _commType_1 = ac.getCommType();
        boolean async = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.ASYNCHRONOUS);
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)eventPorts);
        if (!_isEmpty) {
            _and_2 = false;
        } else {
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)recvPorts);
            boolean bl = _and_2 = _isEmpty && _isEmpty_1;
        }
        if (!_and_2) {
            _and_1 = false;
        } else {
            List _allSAPs = RoomHelpers.getAllSAPs((ActorClass)ac);
            boolean _isEmpty_2 = _allSAPs.isEmpty();
            boolean bl = _and_1 = _and_2 && _isEmpty_2;
        }
        if (!_and_1) {
            _and = false;
        } else {
            List _allServiceImplementations = RoomHelpers.getAllServiceImplementations((ActorClass)ac);
            boolean _isEmpty_3 = _allServiceImplementations.isEmpty();
            _and = _and_1 && _isEmpty_3;
        }
        boolean hasConstData = !_and;
        boolean _and_3 = false;
        boolean _and_4 = false;
        boolean _and_5 = false;
        boolean _isEmpty_4 = IterableExtensions.isEmpty((Iterable)sendPorts);
        if (!_isEmpty_4) {
            _and_5 = false;
        } else {
            List _allAttributes = RoomHelpers.getAllAttributes((ActorClass)ac);
            boolean _isEmpty_5 = _allAttributes.isEmpty();
            boolean bl = _and_5 = _isEmpty_4 && _isEmpty_5;
        }
        if (!_and_5) {
            _and_4 = false;
        } else {
            StateGraph _stateMachine = xpac.getStateMachine();
            boolean _isEmpty_6 = RoomHelpers.isEmpty((StateGraph)_stateMachine);
            boolean bl = _and_4 = _and_5 && _isEmpty_6;
        }
        if (!_and_4) {
            _and_3 = false;
        } else {
            boolean _not = !hasConstData;
            _and_3 = _and_4 && _not;
        }
        boolean hasVarData = !_and_3;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of ActorClass ");
        String _name = ac.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin((RoomClass)ac);
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"messaging/etMessage.h\"");
        _builder.newLine();
        _builder.newLine();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)ac);
        for (DataClass dataClass : _referencedDataClasses) {
            _builder.append((Object)"#include ");
            String _includePath = this._cExtensions.getIncludePath((RoomClass)dataClass);
            _builder.append((Object)_includePath, "");
            _builder.newLineIfNotEmpty();
        }
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)ac);
        for (ProtocolClass pc : _referencedProtocolClasses) {
            _builder.append((Object)"#include ");
            String _includePath_1 = this._cExtensions.getIncludePath((RoomClass)pc);
            _builder.append((Object)_includePath_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)ac, 1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"typedef struct ");
        String _name_1 = ac.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" ");
        String _name_2 = ac.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* const part of ActorClass (ROM) */");
        _builder.newLine();
        if (hasConstData) {
            _builder.append((Object)"typedef struct ");
            String _name_3 = ac.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)"_const {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* simple ports */");
            _builder.newLine();
            for (Port ep : eventPorts) {
                boolean _equals;
                int _multiplicity = ep.getMultiplicity();
                boolean bl = _equals = _multiplicity == 1;
                if (!_equals) continue;
                _builder.append((Object)"\t");
                _builder.append((Object)"const ");
                String _portClassName = this._roomExtensions.getPortClassName((EObject)ep);
                _builder.append((Object)_portClassName, "\t");
                _builder.append((Object)" ");
                String _name_4 = ep.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* data receive ports */");
            _builder.newLine();
            for (Port ep_1 : recvPorts) {
                boolean _equals_1;
                int _multiplicity_1 = ep_1.getMultiplicity();
                boolean bl = _equals_1 = _multiplicity_1 == 1;
                if (!_equals_1) continue;
                _builder.append((Object)"\t");
                _builder.append((Object)"const ");
                String _portClassName_1 = this._roomExtensions.getPortClassName((EObject)ep_1);
                _builder.append((Object)_portClassName_1, "\t");
                _builder.append((Object)" ");
                String _name_5 = ep_1.getName();
                _builder.append((Object)_name_5, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* saps */");
            _builder.newLine();
            List _allSAPs_1 = RoomHelpers.getAllSAPs((ActorClass)ac);
            for (SAPRef sap : _allSAPs_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"const ");
                String _portClassName_2 = this._roomExtensions.getPortClassName((EObject)sap);
                _builder.append((Object)_portClassName_2, "\t");
                _builder.append((Object)" ");
                String _name_6 = sap.getName();
                _builder.append((Object)_name_6, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* replicated ports */");
            _builder.newLine();
            List _allEndPorts_3 = RoomHelpers.getAllEndPorts((ActorClass)ac);
            for (Port ep_2 : _allEndPorts_3) {
                boolean _notEquals;
                int _multiplicity_2 = ep_2.getMultiplicity();
                boolean bl = _notEquals = _multiplicity_2 != 1;
                if (!_notEquals) continue;
                _builder.append((Object)"\t");
                _builder.append((Object)"const etReplPort ");
                String _name_7 = ep_2.getName();
                _builder.append((Object)_name_7, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* services */");
            _builder.newLine();
            List _allServiceImplementations_1 = RoomHelpers.getAllServiceImplementations((ActorClass)ac);
            for (ServiceImplementation svc : _allServiceImplementations_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"const etReplPort ");
                SPPRef _spp = svc.getSpp();
                String _name_8 = _spp.getName();
                _builder.append((Object)_name_8, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"} ");
            String _name_9 = ac.getName();
            _builder.append((Object)_name_9, "");
            _builder.append((Object)"_const;");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"/* this actor class has no ports and thus no constant data */");
            _builder.newLine();
        }
        _builder.newLine();
        StateGraph _stateMachine_1 = xpac.getStateMachine();
        boolean _isEmpty_7 = RoomHelpers.isEmpty((StateGraph)_stateMachine_1);
        boolean bl = _not_1 = !_isEmpty_7;
        if (_not_1) {
            _builder.newLine();
            CharSequence _genHeaderConstants = this._stateMachineGen.genHeaderConstants(xpac);
            _builder.append((Object)_genHeaderConstants, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* variable part of ActorClass (RAM) */");
        _builder.newLine();
        if (hasVarData) {
            boolean _not_2;
            _builder.append((Object)"struct ");
            String _name_10 = ac.getName();
            _builder.append((Object)_name_10, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            if (hasConstData) {
                _builder.append((Object)"\t");
                _builder.append((Object)"const ");
                String _name_11 = ac.getName();
                _builder.append((Object)_name_11, "\t");
                _builder.append((Object)"_const* const constData;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"/* data send ports */");
            _builder.newLine();
            for (Port ep_3 : sendPorts) {
                boolean _equals_2;
                int _multiplicity_3 = ep_3.getMultiplicity();
                boolean bl2 = _equals_2 = _multiplicity_3 == 1;
                if (!_equals_2) continue;
                _builder.append((Object)"\t");
                String _portClassName_3 = this._roomExtensions.getPortClassName((EObject)ep_3);
                _builder.append((Object)_portClassName_3, "\t");
                _builder.append((Object)" ");
                String _name_12 = ep_3.getName();
                _builder.append((Object)_name_12, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            List _allAttributes_1 = RoomHelpers.getAllAttributes((ActorClass)ac);
            CharSequence _attributes = this._procedureHelpers.attributes(_allAttributes_1);
            _builder.append((Object)_attributes, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            StateGraph _stateMachine_2 = xpac.getStateMachine();
            boolean _isEmpty_8 = RoomHelpers.isEmpty((StateGraph)_stateMachine_2);
            boolean bl3 = _not_2 = !_isEmpty_8;
            if (_not_2) {
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                CharSequence _genDataMembers = this._stateMachineGen.genDataMembers(xpac);
                _builder.append((Object)_genDataMembers, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"};");
            _builder.newLine();
        } else {
            _builder.append((Object)"struct ");
            String _name_13 = ac.getName();
            _builder.append((Object)_name_13, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* This actor class has no data at all.");
            _builder.newLine();
            _builder.append((Object)"\t   ");
            _builder.append((Object)"But the private actor instance data is passed to all life cycle functions.");
            _builder.newLine();
            _builder.append((Object)"\t   ");
            _builder.append((Object)"By introducing the dummy data we keep this case simple");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"int dummy;");
            _builder.newLine();
            _builder.append((Object)"};");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_14 = ac.getName();
        _builder.append((Object)_name_14, "");
        _builder.append((Object)"_init(");
        String _name_15 = ac.getName();
        _builder.append((Object)_name_15, "");
        _builder.append((Object)"* self);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_16 = ac.getName();
        _builder.append((Object)_name_16, "");
        _builder.append((Object)"_receiveMessage(void* self, void* ifitem, const etMessage* msg);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _or = false;
        if (dataDriven) {
            _or = true;
        } else {
            boolean bl4 = _or = dataDriven || async;
        }
        if (_or) {
            _builder.append((Object)"void ");
            String _name_17 = ac.getName();
            _builder.append((Object)_name_17, "");
            _builder.append((Object)"_execute(");
            String _name_18 = ac.getName();
            _builder.append((Object)_name_18, "");
            _builder.append((Object)"* self);");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList _operations = ac.getOperations();
        String _name_19 = ac.getName();
        CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration((List)_operations, _name_19);
        _builder.append((Object)_operationsDeclaration, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode_1 = this._procedureHelpers.userCode((ActorContainerClass)ac, 2);
        _builder.append((Object)_userCode_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd((RoomClass)ac);
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateSourceFile(Root root, ExpandedActorClass xpac) {
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        ActorCommunicationType _commType = ac.getCommType();
        boolean async = Objects.equal((Object)_commType, (Object)ActorCommunicationType.ASYNCHRONOUS);
        ActorCommunicationType _commType_1 = ac.getCommType();
        boolean eventDriven = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.EVENT_DRIVEN);
        ActorCommunicationType _commType_2 = ac.getCommType();
        boolean dataDriven = Objects.equal((Object)_commType_2, (Object)ActorCommunicationType.DATA_DRIVEN);
        boolean _or = false;
        _or = async ? true : async || eventDriven;
        boolean handleEvents = _or;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of ActorClass ");
        String _name = ac.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)ac);
        _builder.append((Object)_cHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"modelbase/etActor.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"etUnit/etUnit.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"osal/etMemory.h\"");
        _builder.newLine();
        _builder.newLine();
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)ac);
        for (ProtocolClass pc : _referencedProtocolClasses) {
            _builder.append((Object)"#include ");
            String _includePath = this._cExtensions.getIncludePath((RoomClass)pc);
            _builder.append((Object)_includePath, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)ac, 3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* interface item IDs */");
        _builder.newLine();
        String _genInterfaceItemConstants = this.genInterfaceItemConstants(xpac);
        _builder.append((Object)_genInterfaceItemConstants, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        StateGraph _stateMachine = xpac.getStateMachine();
        boolean _isEmpty = RoomHelpers.isEmpty((StateGraph)_stateMachine);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _genStateMachine = this._stateMachineGen.genStateMachine(xpac);
            _builder.append((Object)_genStateMachine, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_1 = ac.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_init(");
        String _name_2 = ac.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"* self){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String _name_3 = ac.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"\", \"init\")");
        _builder.newLineIfNotEmpty();
        StateGraph _stateMachine_1 = xpac.getStateMachine();
        boolean _isEmpty_1 = RoomHelpers.isEmpty((StateGraph)_stateMachine_1);
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append((Object)"\t");
            CharSequence _genInitialization = this._stateMachineGen.genInitialization(xpac);
            _builder.append((Object)_genInitialization, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_4 = ac.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)"_receiveMessage(void* self, void* ifitem, const etMessage* msg){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String _name_5 = ac.getName();
        _builder.append((Object)_name_5, "\t");
        _builder.append((Object)"\", \"_receiveMessage\")");
        _builder.newLineIfNotEmpty();
        StateGraph _stateMachine_2 = xpac.getStateMachine();
        boolean _isEmpty_2 = RoomHelpers.isEmpty((StateGraph)_stateMachine_2);
        boolean bl3 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _name_6 = ac.getName();
            String _operationScope = this.langExt.operationScope(_name_6, false);
            _builder.append((Object)_operationScope, "\t");
            _builder.append((Object)"receiveEvent(self");
            if (handleEvents) {
                _builder.append((Object)", (etPort*)ifitem, msg->evtID, (void*)(((char*)msg)+MEM_CEIL(sizeof(etMessage)))");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean _or_1 = false;
        if (dataDriven) {
            _or_1 = true;
        } else {
            boolean bl4 = _or_1 = dataDriven || async;
        }
        if (_or_1) {
            boolean _not_3;
            _builder.append((Object)"void ");
            String _name_7 = ac.getName();
            _builder.append((Object)_name_7, "");
            _builder.append((Object)"_execute(");
            String _name_8 = ac.getName();
            _builder.append((Object)_name_8, "");
            _builder.append((Object)"* self) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
            String _name_9 = ac.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)"\", \"_execute\")");
            _builder.newLineIfNotEmpty();
            StateGraph _stateMachine_3 = xpac.getStateMachine();
            boolean _isEmpty_3 = RoomHelpers.isEmpty((StateGraph)_stateMachine_3);
            boolean bl5 = _not_3 = !_isEmpty_3;
            if (_not_3) {
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                String _name_10 = ac.getName();
                String _operationScope_1 = this.langExt.operationScope(_name_10, false);
                _builder.append((Object)_operationScope_1, "\t");
                _builder.append((Object)"receiveEvent(self");
                if (handleEvents) {
                    _builder.append((Object)", NULL, 0, NULL");
                }
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation(ac);
        _builder.append((Object)_operationsImplementation, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

