/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeClass;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.IntelligentSeparator;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.gen.Initialization;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    private Initialization attrInitGenAddon;
    @Inject
    private ILanguageExtension languageExt;
    @Inject
    private ILogger logger;
    @Inject
    private IDiagnostician diagnostician;

    public void doGenerate(Root root) {
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                String _dispSourceFileName;
                String _instSourceFileName;
                String _cSourceFileName;
                HashSet<PhysicalThread> _hashSet;
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                SubSystemClass _subSystemClass = ssi.getSubSystemClass();
                String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_subSystemClass);
                SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
                String _path = this._roomExtensions.getPath((RoomClass)_subSystemClass_1);
                String filepath = String.valueOf(_generationTargetPath) + _path;
                String file = this._cExtensions.getCHeaderFileName(nr, ssi);
                this.checkDataPorts(ssi);
                HashSet<PhysicalThread> usedThreads = _hashSet = new HashSet<PhysicalThread>();
                NodeClass _type = nr.getType();
                EList _threads = _type.getThreads();
                for (final PhysicalThread thread : _threads) {
                    boolean _not;
                    Functions.Function1<ActorInstance, Boolean> _function;
                    EList _allContainedInstances = ssi.getAllContainedInstances();
                    Iterable instancesOnThread = IterableExtensions.filter((Iterable)_allContainedInstances, (Functions.Function1)(_function = new Functions.Function1<ActorInstance, Boolean>(){

                        public Boolean apply(ActorInstance ai) {
                            PhysicalThread _physicalThread = ETMapUtil.getPhysicalThread((ActorInstance)ai);
                            boolean _equals = Objects.equal((Object)_physicalThread, (Object)thread);
                            return _equals;
                        }
                    }));
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)instancesOnThread);
                    boolean bl = _not = !_isEmpty;
                    if (!_not) continue;
                    usedThreads.add(thread);
                }
                String _plus = "generating Node declaration: '" + file;
                String _plus_1 = String.valueOf(_plus) + "' in '";
                String _plus_2 = String.valueOf(_plus_1) + filepath;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                this.logger.logInfo(_plus_3);
                this.fileAccess.setOutputPath(filepath);
                CharSequence _generateHeaderFile = this.generateHeaderFile(root, ssi);
                this.fileAccess.generateFile(file, _generateHeaderFile);
                file = _cSourceFileName = this._cExtensions.getCSourceFileName(nr, ssi);
                String _plus_4 = "generating Node implementation: '" + file;
                String _plus_5 = String.valueOf(_plus_4) + "' in '";
                String _plus_6 = String.valueOf(_plus_5) + filepath;
                String _plus_7 = String.valueOf(_plus_6) + "'";
                this.logger.logInfo(_plus_7);
                this.fileAccess.setOutputPath(filepath);
                CharSequence _generateSourceFile = this.generateSourceFile(root, ssi, usedThreads);
                this.fileAccess.generateFile(file, _generateSourceFile);
                file = _instSourceFileName = this._cExtensions.getInstSourceFileName(nr, ssi);
                String _plus_8 = "generating Node instance file: '" + file;
                String _plus_9 = String.valueOf(_plus_8) + "' in '";
                String _plus_10 = String.valueOf(_plus_9) + filepath;
                String _plus_11 = String.valueOf(_plus_10) + "'";
                this.logger.logInfo(_plus_11);
                this.fileAccess.setOutputPath(filepath);
                CharSequence _generateInstanceFile = this.generateInstanceFile(root, ssi, usedThreads);
                this.fileAccess.generateFile(file, _generateInstanceFile);
                file = _dispSourceFileName = this._cExtensions.getDispSourceFileName(nr, ssi);
                String _plus_12 = "generating Node dispatcher file: '" + file;
                String _plus_13 = String.valueOf(_plus_12) + "' in '";
                String _plus_14 = String.valueOf(_plus_13) + filepath;
                String _plus_15 = String.valueOf(_plus_14) + "'";
                this.logger.logInfo(_plus_15);
                this.fileAccess.setOutputPath(filepath);
                CharSequence _generateDispatcherFile = this.generateDispatcherFile(root, ssi, usedThreads);
                this.fileAccess.generateFile(file, _generateDispatcherFile);
            }
        }
    }

    private CharSequence generateHeaderFile(Root root, SubSystemInstance ssi) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((StructureInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String _name = nr.getName();
        String _plus = String.valueOf(_name) + "_";
        String _name_1 = ssi.getName();
        String clsname = String.valueOf(_plus) + _name_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of Node ");
        String _name_2 = nr.getName();
        _builder.append((Object)_name_2, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_3 = ssi.getName();
        _builder.append((Object)_name_3, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(clsname);
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.newLine();
        DetailCode _userCode1 = ssc.getUserCode1();
        CharSequence _userCode = this.helpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* lifecycle functions");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* init -> start -> run (loop) -> stop -> destroy");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_init(void);\t\t/* lifecycle init  \t */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_start(void);\t/* lifecycle start \t */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_run(etBool runAsTest);\t\t/* lifecycle run \t */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_stop(void); \t/* lifecycle stop\t */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_destroy(void); \t/* lifecycle destroy */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_shutdown(void);  /* shutdown the dispatcher loop */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        DetailCode _userCode2 = ssc.getUserCode2();
        CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
        _builder.append((Object)_userCode_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(clsname);
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateSourceFile(Root root, SubSystemInstance ssi, final HashSet<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((StructureInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String _name = nr.getName();
        String _plus = String.valueOf(_name) + "_";
        String _name_1 = ssi.getName();
        String clsname = String.valueOf(_plus) + _name_1;
        NodeClass _type = nr.getType();
        EList _threads = _type.getThreads();
        Functions.Function1<PhysicalThread, Boolean> _function = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                boolean _contains = usedThreads.contains(t);
                return _contains;
            }
        };
        Iterable threads = IterableExtensions.filter((Iterable)_threads, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of Node ");
        String _name_2 = nr.getName();
        _builder.append((Object)_name_2, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_3 = ssi.getName();
        _builder.append((Object)_name_3, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include <stdio.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName(nr, ssi);
        _builder.append((Object)_cHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"messaging/etSystemProtocol.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"osal/etTimer.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"osal/etSema.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"runtime/etRuntime.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"etRuntimeConfig.h\"");
        _builder.newLine();
        _builder.newLine();
        DetailCode _userCode3 = ssc.getUserCode3();
        CharSequence _userCode = this.helpers.userCode(_userCode3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* data for Node ");
        String _name_4 = nr.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)" with SubSystem ");
        String _name_5 = ssi.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)" */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef struct ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"char *name;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"volatile int shutdownRequest;");
        _builder.newLine();
        _builder.append((Object)"} ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"static ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)" ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"Inst = {\"");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"\", 0};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_initActorInstances(void);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_constructActorInstances(void);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* include instances for all classes */");
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _instSourceFileName = this._cExtensions.getInstSourceFileName(nr, ssi);
        _builder.append((Object)_instSourceFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#include \"");
        String _dispSourceFileName = this._cExtensions.getDispSourceFileName(nr, ssi);
        _builder.append((Object)_dispSourceFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_initMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"initMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"etTime interval;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/* initialization of all message services */");
        _builder.newLine();
        for (PhysicalThread thread : threads) {
            boolean _or = false;
            ExecMode _execmode = thread.getExecmode();
            boolean _equals = Objects.equal((Object)_execmode, (Object)ExecMode.POLLED);
            if (_equals) {
                _or = true;
            } else {
                ExecMode _execmode_1 = thread.getExecmode();
                boolean _equals_1 = Objects.equal((Object)_execmode_1, (Object)ExecMode.MIXED);
                boolean bl = _or = _equals || _equals_1;
            }
            if (_or) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"interval.sec = 0;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"interval.nSec = ");
                int _time = thread.getTime();
                _builder.append((Object)_time, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"etMessageService_init(");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"&msgService_");
            String _name_6 = thread.getName();
            _builder.append((Object)_name_6, "\t\t\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"msgBuffer_");
            String _name_7 = thread.getName();
            _builder.append((Object)_name_7, "\t\t\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _name_8 = thread.getName();
            String _upperCase = _name_8.toUpperCase();
            _builder.append((Object)_upperCase, "\t\t\t");
            _builder.append((Object)"_POOL_SIZE,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _name_9 = thread.getName();
            String _upperCase_1 = _name_9.toUpperCase();
            _builder.append((Object)_upperCase_1, "\t\t\t");
            _builder.append((Object)"_BLOCK_SIZE,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            int _stacksize = thread.getStacksize();
            _builder.append((Object)_stacksize, "\t\t\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            int _prio = thread.getPrio();
            _builder.append((Object)_prio, "\t\t\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"interval,");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"MsgDispatcher_");
            String _name_10 = thread.getName();
            _builder.append((Object)_name_10, "\t\t\t");
            _builder.append((Object)"_receiveMessage,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"EXECMODE_");
            ExecMode _execmode_2 = thread.getExecmode();
            String _string = _execmode_2.toString();
            String _upperCase_2 = _string.toUpperCase();
            _builder.append((Object)_upperCase_2, "\t\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_startMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"startMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        for (PhysicalThread thread_1 : threads) {
            _builder.append((Object)"\t");
            _builder.append((Object)"etMessageService_start(&msgService_");
            String _name_11 = thread_1.getName();
            _builder.append((Object)_name_11, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_stopMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"stopMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        for (PhysicalThread thread_2 : threads) {
            _builder.append((Object)"\t");
            _builder.append((Object)"etMessageService_stop(&msgService_");
            String _name_12 = thread_2.getName();
            _builder.append((Object)_name_12, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_destroyMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"destroyMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        for (PhysicalThread thread_3 : threads) {
            _builder.append((Object)"\t");
            _builder.append((Object)"etMessageService_destroy(&msgService_");
            String _name_13 = thread_3.getName();
            _builder.append((Object)_name_13, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_init(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"init\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_init\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* construct all actors */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_constructActorInstances();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* initialization of all message services */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_initMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* init all actors */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_initActorInstances();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_start(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"start\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_start\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_startMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_run(etBool runAsTest) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"run\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (runAsTest) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"etSema_waitForWakeup(etRuntime_getTerminateSemaphore());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"printf(\"type quit to exit\\n\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"while (TRUE) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"char line[64];");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (fgets(line, 64, stdin) == NULL) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"printf(\"got NULL\\n\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"else if (strncmp(line, \"quit\", 4)==0){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_stop(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"stop\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_stop\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_stopMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_destroy(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"destroy\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_destroy\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        List _reverseView = ListExtensions.reverseView((List)_allContainedInstances);
        for (ActorInstance ai : _reverseView) {
            boolean _not;
            Functions.Function1<StandardOperation, Boolean> _function_1;
            ActorClass _actorClass = ai.getActorClass();
            EList _operations = _actorClass.getOperations();
            Iterable _filter = IterableExtensions.filter((Iterable)_operations, (Functions.Function1)(_function_1 = new Functions.Function1<StandardOperation, Boolean>(){

                public Boolean apply(StandardOperation op) {
                    boolean _isDestructor = op.isDestructor();
                    return _isDestructor;
                }
            }));
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            _builder.append((Object)"\t");
            ActorClass _actorClass_1 = ai.getActorClass();
            String _name_14 = _actorClass_1.getName();
            ActorClass _actorClass_2 = ai.getActorClass();
            String _name_15 = _actorClass_2.getName();
            String _destructorName = this.languageExt.destructorName(_name_15);
            String _memberInUse = this.languageExt.memberInUse(_name_14, _destructorName);
            _builder.append((Object)_memberInUse, "\t");
            _builder.append((Object)"(&");
            String _path = ai.getPath();
            String _pathName = this._roomExtensions.getPathName(_path);
            _builder.append((Object)_pathName, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_destroyMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_shutdown(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"shutdown\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_shutdown\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.shutdownRequest = 1;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_constructActorInstances(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"constructActorInstances\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _allContainedInstances_1 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            boolean _not_1;
            Functions.Function1<StandardOperation, Boolean> _function_2;
            ActorClass _actorClass_3 = ai_1.getActorClass();
            EList _operations_1 = _actorClass_3.getOperations();
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_operations_1, (Functions.Function1)(_function_2 = new Functions.Function1<StandardOperation, Boolean>(){

                public Boolean apply(StandardOperation op) {
                    boolean _isConstructor = RoomHelpers.isConstructor((Operation)op);
                    return _isConstructor;
                }
            }));
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)_filter_1);
            boolean bl = _not_1 = !_isEmpty_1;
            if (!_not_1) continue;
            _builder.append((Object)"\t");
            ActorClass _actorClass_4 = ai_1.getActorClass();
            String _name_16 = _actorClass_4.getName();
            ActorClass _actorClass_5 = ai_1.getActorClass();
            String _name_17 = _actorClass_5.getName();
            String _constructorName = this.languageExt.constructorName(_name_17);
            String _memberInUse_1 = this.languageExt.memberInUse(_name_16, _constructorName);
            _builder.append((Object)_memberInUse_1, "\t");
            _builder.append((Object)"(&");
            String _path_1 = ai_1.getPath();
            String _pathName_1 = this._roomExtensions.getPathName(_path_1);
            _builder.append((Object)_pathName_1, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_initActorInstances(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"initActorInstances\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _allContainedInstances_2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_2) {
            _builder.append((Object)"\t");
            ActorClass _actorClass_6 = ai_2.getActorClass();
            String _name_18 = _actorClass_6.getName();
            _builder.append((Object)_name_18, "\t");
            _builder.append((Object)"_init(&");
            String _path_2 = ai_2.getPath();
            String _pathName_2 = this._roomExtensions.getPathName(_path_2);
            _builder.append((Object)_pathName_2, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateInstanceFile(Root root, SubSystemInstance ssi, final HashSet<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((StructureInstance)ssi);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Instance File of Node ");
        String _name = nr.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_1 = ssi.getName();
        _builder.append((Object)_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* - instantiation of all actor instances and port instances");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* - configuration of data and connection of ports");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"messaging/etMessageService.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* include all referenced ActorClasses */");
        _builder.newLine();
        SubSystemClass _subSystemClass = ssi.getSubSystemClass();
        EList _referencedActorClasses = root.getReferencedActorClasses((RoomClass)_subSystemClass);
        for (ActorClass actorClass : _referencedActorClasses) {
            _builder.append((Object)"#include ");
            String _includePath = this._cExtensions.getIncludePath((RoomClass)actorClass);
            _builder.append((Object)_includePath, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* include all referenced ProtcolClasses */");
        _builder.newLine();
        SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)_subSystemClass_1);
        for (ProtocolClass protocolClass : _referencedProtocolClasses) {
            _builder.append((Object)"#include ");
            String _includePath_1 = this._cExtensions.getIncludePath((RoomClass)protocolClass);
            _builder.append((Object)_includePath_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* instantiation of message services and message buffers */");
        _builder.newLine();
        NodeClass _type = nr.getType();
        EList _threads = _type.getThreads();
        Functions.Function1<PhysicalThread, Boolean> _function = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                boolean _contains = usedThreads.contains(t);
                return _contains;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_threads, (Functions.Function1)_function);
        for (PhysicalThread thread : _filter) {
            _builder.append((Object)"/* ");
            String _name_2 = thread.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)" */");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"#define ");
            String _name_3 = thread.getName();
            String _upperCase = _name_3.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.append((Object)"_POOL_SIZE\t\t");
            int _msgpoolsize = thread.getMsgpoolsize();
            _builder.append((Object)_msgpoolsize, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"#define ");
            String _name_4 = thread.getName();
            String _upperCase_1 = _name_4.toUpperCase();
            _builder.append((Object)_upperCase_1, "");
            _builder.append((Object)"_BLOCK_SIZE\t");
            int _msgblocksize = thread.getMsgblocksize();
            _builder.append((Object)_msgblocksize, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"static uint8 msgBuffer_");
            String _name_5 = thread.getName();
            _builder.append((Object)_name_5, "");
            _builder.append((Object)"[");
            String _name_6 = thread.getName();
            String _upperCase_2 = _name_6.toUpperCase();
            _builder.append((Object)_upperCase_2, "");
            _builder.append((Object)"_POOL_SIZE * ");
            String _name_7 = thread.getName();
            String _upperCase_3 = _name_7.toUpperCase();
            _builder.append((Object)_upperCase_3, "");
            _builder.append((Object)"_BLOCK_SIZE]; ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"static etMessageService msgService_");
            String _name_8 = thread.getName();
            _builder.append((Object)_name_8, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* declarations of all ActorClass instances (const and variable structs) */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* forward declaration of variable actor structs */");
        _builder.newLine();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            _builder.append((Object)"static ");
            ActorClass _actorClass = ai.getActorClass();
            String _name_9 = _actorClass.getName();
            _builder.append((Object)_name_9, "");
            _builder.append((Object)" ");
            String _path = ai.getPath();
            String _pathName = this._roomExtensions.getPathName(_path);
            _builder.append((Object)_pathName, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* forward declaration of variable port structs */");
        _builder.newLine();
        EList _allContainedInstances_1 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            EList _orderedIfItemInstances = ai_1.getOrderedIfItemInstances();
            boolean _isEmpty = _orderedIfItemInstances.isEmpty();
            if (_isEmpty) {
                _builder.append((Object)"/* nothing to do */");
                _builder.newLine();
                continue;
            }
            EList _orderedIfItemInstances_1 = ai_1.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances_1) {
                boolean _equals;
                boolean _greaterThan;
                boolean _isConjugated;
                ProtocolClass _protocol = pi.getProtocol();
                PortClass _portClass = this._roomExtensions.getPortClass(_protocol, _isConjugated = this._roomExtensions.isConjugated(pi));
                EList _attributes = _portClass == null ? null : _portClass.getAttributes();
                int _size = _attributes == null ? 0 : _attributes.size();
                boolean bl = _greaterThan = _size > 0;
                if (!_greaterThan) continue;
                _builder.append((Object)"static ");
                ProtocolClass _protocol_1 = pi.getProtocol();
                boolean _isConjugated_1 = this._roomExtensions.isConjugated(pi);
                String _portClassName = this._roomExtensions.getPortClassName(_protocol_1, _isConjugated_1);
                _builder.append((Object)_portClassName, "");
                _builder.append((Object)"_var ");
                String _path_1 = pi.getPath();
                String _pathName_1 = this._roomExtensions.getPathName(_path_1);
                _builder.append((Object)_pathName_1, "");
                _builder.append((Object)"_var");
                boolean _isReplicated = pi.isReplicated();
                if (_isReplicated) {
                    _builder.append((Object)"[");
                    EList _peers = pi.getPeers();
                    int _size_1 = _peers.size();
                    _builder.append((Object)_size_1, "");
                    _builder.append((Object)"]");
                }
                _builder.append((Object)"={");
                _builder.newLineIfNotEmpty();
                int _xifexpression = 0;
                EList _peers_1 = pi.getPeers();
                int _size_2 = _peers_1.size();
                boolean bl2 = _equals = _size_2 == 0;
                if (_equals) {
                    _xifexpression = 1;
                } else {
                    int _size_3;
                    EList _peers_2 = pi.getPeers();
                    _xifexpression = _size_3 = _peers_2.size();
                }
                IntegerRange _upTo = new IntegerRange(1, _xifexpression);
                boolean _hasElements = false;
                for (Integer i : _upTo) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    _builder.append((Object)"\t");
                    InterfaceItem _interfaceItem = pi.getInterfaceItem();
                    PortClass _portClass_1 = RoomHelpers.getPortClass((InterfaceItem)_interfaceItem);
                    EList _attributes_1 = _portClass_1.getAttributes();
                    CharSequence _generateAttributeInit = this.attrInitGenAddon.generateAttributeInit((InstanceBase)pi, (List<Attribute>)_attributes_1);
                    _builder.append((Object)_generateAttributeInit, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t\t\t\t\t");
                }
                _builder.append((Object)"};");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        EList _allContainedInstances_2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_2) {
            _builder.newLine();
            _builder.append((Object)"/* instance ");
            String _path_2 = ai_2.getPath();
            String _pathName_2 = this._roomExtensions.getPathName(_path_2);
            _builder.append((Object)_pathName_2, "");
            _builder.append((Object)" */");
            _builder.newLineIfNotEmpty();
            EList _orderedIfItemInstances_2 = ai_2.getOrderedIfItemInstances();
            boolean _isEmpty_1 = _orderedIfItemInstances_2.isEmpty();
            if (_isEmpty_1) {
                _builder.append((Object)"/* no ports/saps/services - nothing to initialize statically */");
                _builder.newLine();
                continue;
            }
            CharSequence _genActorInstanceInitializer = this.genActorInstanceInitializer(root, ai_2);
            _builder.append((Object)_genActorInstanceInitializer, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence genActorInstanceInitializer(Root root, ActorInstance ai) {
        IntelligentSeparator _intelligentSeparator;
        boolean _not;
        String _plus;
        HashMap<InterfaceItemInstance, Integer> _hashMap;
        ArrayList _arrayList_1;
        ArrayList _arrayList;
        StringConcatenation _xblockexpression = null;
        String _path = ai.getPath();
        String instName = this._roomExtensions.getPathName(_path);
        ArrayList replEventItems = _arrayList = new ArrayList();
        EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
        Functions.Function1<InterfaceItemInstance, Boolean> _function = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                boolean _isReplicated = e.isReplicated();
                return _isReplicated;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_orderedIfItemInstances, (Functions.Function1)_function);
        Iterables.addAll(replEventItems, (Iterable)_filter);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_1 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                EList _peers = e.getPeers();
                boolean _isEmpty = _peers.isEmpty();
                boolean _not = !_isEmpty;
                return _not;
            }
        };
        InterfaceItemInstance _findFirst = (InterfaceItemInstance)IterableExtensions.findFirst(replEventItems, (Functions.Function1)_function_1);
        boolean haveReplSubItems = !Objects.equal((Object)_findFirst, null);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_2 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem _interfaceItem = i.getInterfaceItem();
                return _interfaceItem instanceof Port;
            }
        };
        Iterable replEventPorts = IterableExtensions.filter(replEventItems, (Functions.Function1)_function_2);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_3 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem _interfaceItem = i.getInterfaceItem();
                return _interfaceItem instanceof SPPRef;
            }
        };
        Iterable replEventSPPs = IterableExtensions.filter(replEventItems, (Functions.Function1)_function_3);
        EList _orderedIfItemInstances_1 = ai.getOrderedIfItemInstances();
        Functions.Function1<InterfaceItemInstance, Boolean> _function_4 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                boolean _isSimple = e.isSimple();
                return _isSimple;
            }
        };
        Iterable simplePorts = IterableExtensions.filter((Iterable)_orderedIfItemInstances_1, (Functions.Function1)_function_4);
        ArrayList simpleEventItems = _arrayList_1 = new ArrayList();
        Functions.Function1<InterfaceItemInstance, Boolean> _function_5 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                ProtocolClass _protocol = p.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
                return _equals;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_5);
        Iterables.addAll(simpleEventItems, (Iterable)_filter_1);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_6 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem _interfaceItem = i.getInterfaceItem();
                return _interfaceItem instanceof Port;
            }
        };
        Iterable simpleEventPorts = IterableExtensions.filter(simpleEventItems, (Functions.Function1)_function_6);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_7 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem _interfaceItem = i.getInterfaceItem();
                return _interfaceItem instanceof SAPRef;
            }
        };
        Iterable simpleEventSAPs = IterableExtensions.filter(simpleEventItems, (Functions.Function1)_function_7);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_8 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                ProtocolClass _protocol = p.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                return _equals;
            }
        };
        Iterable dataPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_8);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_9 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                boolean _and = false;
                if (!(p instanceof PortInstance)) {
                    _and = false;
                } else {
                    Port _port = ((PortInstance)p).getPort();
                    boolean _isConjugated = _port.isConjugated();
                    boolean _not = !_isConjugated;
                    _and = p instanceof PortInstance && _not;
                }
                return _and;
            }
        };
        Iterable recvPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)_function_9);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_10 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                boolean _and = false;
                if (!(p instanceof PortInstance)) {
                    _and = false;
                } else {
                    Port _port = ((PortInstance)p).getPort();
                    boolean _isConjugated = _port.isConjugated();
                    _and = p instanceof PortInstance && _isConjugated;
                }
                return _and;
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)_function_10);
        HashMap<InterfaceItemInstance, Integer> offsets = _hashMap = new HashMap<InterfaceItemInstance, Integer>();
        int offset = 0;
        for (InterfaceItemInstance p : replEventItems) {
            int _plus2;
            offsets.put(p, offset);
            EList _peers = p.getPeers();
            int _size = _peers.size();
            offset = _plus2 = offset + _size;
        }
        String _xifexpression = null;
        _xifexpression = haveReplSubItems ? (_plus = String.valueOf(instName) + "_repl_sub_ports") : "NULL";
        String replSubPortsArray = _xifexpression;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _isEmpty = simpleEventItems.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _or_1 = true;
        } else {
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)recvPorts);
            boolean _not_1 = !_isEmpty_1;
            boolean bl2 = _or_1 = _not || _not_1;
        }
        if (_or_1) {
            _or = true;
        } else {
            boolean _isEmpty_2 = replEventItems.isEmpty();
            boolean _not_2 = !_isEmpty_2;
            _or = _or_1 || _not_2;
        }
        boolean haveConstData = _or;
        IntelligentSeparator sep = _intelligentSeparator = new IntelligentSeparator(",");
        StringConcatenation _builder = new StringConcatenation();
        if (haveReplSubItems) {
            _builder.append((Object)"static const etReplSubPort ");
            _builder.append((Object)replSubPortsArray, "");
            _builder.append((Object)"[");
            _builder.append((Object)offset, "");
            _builder.append((Object)"] = {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* Replicated Sub Ports: {varData, msgService, peerAddress, localId, index} */");
            _builder.newLine();
            Functions.Function1<InterfaceItemInstance, Boolean> _function_11 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                public Boolean apply(InterfaceItemInstance e) {
                    EList _peers = e.getPeers();
                    boolean _isEmpty = _peers.isEmpty();
                    boolean _not = !_isEmpty;
                    return _not;
                }
            };
            Iterable _filter_2 = IterableExtensions.filter(replEventItems, (Functions.Function1)_function_11);
            boolean _hasElements = false;
            for (Object pi : _filter_2) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append((Object)"\t");
                String _genReplSubPortInitializers = this.genReplSubPortInitializers(root, ai, (InterfaceItemInstance)pi);
                _builder.append((Object)_genReplSubPortInitializers, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"};");
            _builder.newLine();
        }
        if (haveConstData) {
            _builder.append((Object)"static const ");
            ActorClass _actorClass = ai.getActorClass();
            String _name = _actorClass.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_const ");
            _builder.append((Object)instName, "");
            _builder.append((Object)"_const = {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* Ports: {varData, msgService, peerAddress, localId} */");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* simple ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_1 : simpleEventPorts) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                String _genPortInitializer = this.genPortInitializer(root, ai, pi_1);
                _builder.append((Object)_genPortInitializer, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* data receive ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_2 : recvPorts) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                String _genRecvPortInitializer = this.genRecvPortInitializer(root, ai, pi_2);
                _builder.append((Object)_genRecvPortInitializer, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* saps */");
            _builder.newLine();
            for (InterfaceItemInstance pi_3 : simpleEventSAPs) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                String _genPortInitializer_1 = this.genPortInitializer(root, ai, pi_3);
                _builder.append((Object)_genPortInitializer_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* replicated ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_4 : replEventPorts) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                _builder.append((Object)"{");
                EList _peers = pi_4.getPeers();
                int _size = _peers.size();
                _builder.append((Object)_size, "\t");
                _builder.append((Object)", ");
                _builder.append((Object)replSubPortsArray, "\t");
                _builder.append((Object)"+");
                Integer _get = (Integer)offsets.get(pi_4);
                _builder.append((Object)_get, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* services */");
            _builder.newLine();
            for (InterfaceItemInstance pi_5 : replEventSPPs) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                _builder.append((Object)"{");
                EList _peers_1 = pi_5.getPeers();
                int _size_1 = _peers_1.size();
                _builder.append((Object)_size_1, "\t");
                _builder.append((Object)", ");
                _builder.append((Object)replSubPortsArray, "\t");
                _builder.append((Object)"+");
                Integer _get_1 = (Integer)offsets.get(pi_5);
                _builder.append((Object)_get_1, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"};");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"static ");
        ActorClass _actorClass_1 = ai.getActorClass();
        String _name_1 = _actorClass_1.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        _builder.append((Object)instName, "\t");
        _builder.append((Object)" = {");
        _builder.newLineIfNotEmpty();
        if (haveConstData) {
            _builder.append((Object)"\t");
            _builder.append((Object)"&");
            _builder.append((Object)instName, "\t");
            _builder.append((Object)"_const,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/* data send ports */");
        _builder.newLine();
        for (InterfaceItemInstance pi_6 : sendPorts) {
            _builder.append((Object)"\t\t");
            CharSequence _genSendPortInitializer = this.genSendPortInitializer(pi_6);
            _builder.append((Object)_genSendPortInitializer, "\t\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/* attributes */");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        ActorClass _actorClass_2 = ai.getActorClass();
        List _allAttributes = RoomHelpers.getAllAttributes((ActorClass)_actorClass_2);
        CharSequence _generateAttributeInit = this.attrInitGenAddon.generateAttributeInit((InstanceBase)ai, _allAttributes);
        _builder.append((Object)_generateAttributeInit, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/* state and history are initialized in init fuction */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String genPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String _plus_12;
        String _xblockexpression = null;
        int _xifexpression = 0;
        EList _peers = pi.getPeers();
        boolean _isEmpty = _peers.isEmpty();
        if (_isEmpty) {
            _xifexpression = 0;
        } else {
            int _objId;
            EList _peers_1 = pi.getPeers();
            InterfaceItemInstance _get = (InterfaceItemInstance)_peers_1.get(0);
            _xifexpression = _objId = _get.getObjId();
        }
        int objId = _xifexpression;
        int _xifexpression_1 = 0;
        EList _peers_2 = pi.getPeers();
        boolean _isEmpty_1 = _peers_2.isEmpty();
        if (_isEmpty_1) {
            _xifexpression_1 = 0;
        } else {
            int _indexOf;
            EList _peers_3 = pi.getPeers();
            InterfaceItemInstance _get_1 = (InterfaceItemInstance)_peers_3.get(0);
            EList _peers_4 = _get_1.getPeers();
            _xifexpression_1 = _indexOf = _peers_4.indexOf((Object)pi);
        }
        int idx = _xifexpression_1;
        String _xifexpression_2 = null;
        EList _peers_5 = pi.getPeers();
        boolean _isEmpty_2 = _peers_5.isEmpty();
        if (_isEmpty_2) {
            _xifexpression_2 = "NULL";
        } else {
            String _plus;
            EList _peers_6 = pi.getPeers();
            InterfaceItemInstance _get_2 = (InterfaceItemInstance)_peers_6.get(0);
            EObject _eContainer = _get_2.eContainer();
            PhysicalThread _physicalThread = ETMapUtil.getPhysicalThread((ActorInstance)((ActorInstance)_eContainer));
            String _name = _physicalThread.getName();
            _xifexpression_2 = _plus = "&msgService_" + _name;
        }
        String msgSvc = _xifexpression_2;
        String _interfaceItemInstanceData = this.getInterfaceItemInstanceData(pi);
        String _plus_1 = "{" + _interfaceItemInstanceData;
        String _plus_2 = String.valueOf(_plus_1) + ", ";
        String _plus_3 = String.valueOf(_plus_2) + msgSvc;
        String _plus_4 = String.valueOf(_plus_3) + ", ";
        int _plus_5 = objId + idx;
        String _plus_6 = String.valueOf(_plus_4) + Integer.valueOf(_plus_5);
        String _plus_7 = String.valueOf(_plus_6) + "+BASE_ADDRESS, ";
        ExpandedActorClass _expandedActorClass = root.getExpandedActorClass(ai);
        InterfaceItem _interfaceItem = pi.getInterfaceItem();
        int _interfaceItemLocalId = _expandedActorClass.getInterfaceItemLocalId(_interfaceItem);
        int _plus_8 = _interfaceItemLocalId + 1;
        String _plus_9 = String.valueOf(_plus_7) + Integer.valueOf(_plus_8);
        String _plus_10 = String.valueOf(_plus_9) + "} /* Port ";
        String _name_1 = pi.getName();
        String _plus_11 = String.valueOf(_plus_10) + _name_1;
        _xblockexpression = _plus_12 = String.valueOf(_plus_11) + " */";
        return _xblockexpression;
    }

    private CharSequence genSendPortInitializer(InterfaceItemInstance pi) {
        StringConcatenation _xblockexpression = null;
        Port _port = ((PortInstance)pi).getPort();
        GeneralProtocolClass _protocol = _port.getProtocol();
        ProtocolClass pc = (ProtocolClass)_protocol;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        EList _incomingMessages = pc.getIncomingMessages();
        boolean _hasElements = false;
        for (Message m : _incomingMessages) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            VarDecl _data = m.getData();
            RefableType _refType = _data.getRefType();
            DataType _type = _refType.getType();
            String _defaultValue = this._cExtensions.defaultValue(_type);
            _builder.append((Object)_defaultValue, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"} /* send port ");
        String _name = pi.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" */");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getInterfaceItemInstanceData(InterfaceItemInstance pi) {
        boolean _isConjugated_1;
        boolean _isConjugated;
        ProtocolClass _protocol = pi.getProtocol();
        PortClass _portClass = this._roomExtensions.getPortClass(_protocol, _isConjugated = this._roomExtensions.isConjugated(pi));
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return "0";
        }
        ProtocolClass _protocol_1 = pi.getProtocol();
        PortClass _portClass_1 = this._roomExtensions.getPortClass(_protocol_1, _isConjugated_1 = this._roomExtensions.isConjugated(pi));
        EList _attributes = _portClass_1.getAttributes();
        boolean _isEmpty = _attributes.isEmpty();
        if (_isEmpty) {
            return "0";
        }
        String _path = pi.getPath();
        String _pathName = this._roomExtensions.getPathName(_path);
        String _plus = "&" + _pathName;
        return String.valueOf(_plus) + "_var";
    }

    private String genRecvPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String _plus_3;
        String _xblockexpression = null;
        EList _peers = pi.getPeers();
        boolean _isEmpty = _peers.isEmpty();
        if (_isEmpty) {
            return "{NULL}";
        }
        EList _peers_1 = pi.getPeers();
        InterfaceItemInstance peer = (InterfaceItemInstance)_peers_1.get(0);
        EList _peers_2 = pi.getPeers();
        InterfaceItemInstance _get = (InterfaceItemInstance)_peers_2.get(0);
        EObject _eContainer = _get.eContainer();
        ActorInstance peerInst = (ActorInstance)_eContainer;
        String _path = peerInst.getPath();
        String instName = this._roomExtensions.getPathName(_path);
        String _plus = "{&" + instName;
        String _plus_1 = String.valueOf(_plus) + ".";
        String _name = peer.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name;
        _xblockexpression = _plus_3 = String.valueOf(_plus_2) + "}";
        return _xblockexpression;
    }

    private String genReplSubPortInitializers(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String result = "";
        EList _peers = pi.getPeers();
        for (InterfaceItemInstance p : _peers) {
            String _plus_21;
            EList _peers_1 = pi.getPeers();
            int idx = _peers_1.indexOf((Object)p);
            String _xifexpression = null;
            EList _peers_2 = pi.getPeers();
            int _size = _peers_2.size();
            int _minus = _size - 1;
            boolean _lessThan = idx < _minus;
            _xifexpression = _lessThan ? "," : "";
            String comma = _xifexpression;
            EObject _eContainer = p.eContainer();
            PhysicalThread _physicalThread = ETMapUtil.getPhysicalThread((ActorInstance)((ActorInstance)_eContainer));
            String thread = _physicalThread.getName();
            String iiiD = this.getInterfaceItemInstanceData(pi);
            String _xifexpression_1 = null;
            boolean _equals = iiiD.equals("0");
            if (_equals) {
                String _plus;
                _xifexpression_1 = _plus = String.valueOf(iiiD) + ",";
            } else {
                String _plus_3;
                String _plus_1 = String.valueOf(iiiD) + "[";
                String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(idx);
                _xifexpression_1 = _plus_3 = String.valueOf(_plus_2) + "],";
            }
            iiiD = _xifexpression_1;
            String _plus_4 = String.valueOf(result) + "{";
            String _plus_5 = String.valueOf(_plus_4) + iiiD;
            String _plus_6 = String.valueOf(_plus_5) + "&msgService_";
            String _plus_7 = String.valueOf(_plus_6) + thread;
            String _plus_8 = String.valueOf(_plus_7) + ", ";
            int _objId = p.getObjId();
            String _plus_9 = String.valueOf(_plus_8) + Integer.valueOf(_objId);
            String _plus_10 = String.valueOf(_plus_9) + "+BASE_ADDRESS, ";
            ExpandedActorClass _expandedActorClass = root.getExpandedActorClass(ai);
            InterfaceItem _interfaceItem = pi.getInterfaceItem();
            int _interfaceItemLocalId = _expandedActorClass.getInterfaceItemLocalId(_interfaceItem);
            int _plus_11 = _interfaceItemLocalId + 1;
            String _plus_12 = String.valueOf(_plus_10) + Integer.valueOf(_plus_11);
            String _plus_13 = String.valueOf(_plus_12) + ", ";
            String _plus_14 = String.valueOf(_plus_13) + Integer.valueOf(idx);
            String _plus_15 = String.valueOf(_plus_14) + "}";
            String _plus_16 = String.valueOf(_plus_15) + comma;
            String _plus_17 = String.valueOf(_plus_16) + " /* Repl Sub Port ";
            String _name = pi.getName();
            String _plus_18 = String.valueOf(_plus_17) + _name;
            String _plus_19 = String.valueOf(_plus_18) + " idx +";
            String _plus_20 = String.valueOf(_plus_19) + Integer.valueOf(idx);
            result = _plus_21 = String.valueOf(_plus_20) + "*/\n";
        }
        return result;
    }

    private CharSequence generateDispatcherFile(Root root, SubSystemInstance ssi, final HashSet<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((StructureInstance)ssi);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Dispatcher File of Node ");
        String _name = nr.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_1 = ssi.getName();
        _builder.append((Object)_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* - one generated message dispatcher (receiveMessage) for each MessageService (Thread)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* - one generated execute dispatcher (execute) for each MessageService (Thread)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"messaging/etMessageReceiver.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.newLine();
        NodeClass _type = nr.getType();
        EList _threads = _type.getThreads();
        Functions.Function1<PhysicalThread, Boolean> _function = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                boolean _contains = usedThreads.contains(t);
                return _contains;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_threads, (Functions.Function1)_function);
        boolean _hasElements = false;
        for (final PhysicalThread thread : _filter) {
            boolean _not;
            boolean _greaterThan;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            EList _allContainedInstances = ssi.getAllContainedInstances();
            Functions.Function1<ActorInstance, Boolean> _function_1 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    PhysicalThread _physicalThread = ETMapUtil.getPhysicalThread((ActorInstance)ai);
                    boolean _equals = Objects.equal((Object)_physicalThread, (Object)thread);
                    return _equals;
                }
            };
            Iterable instancesOnThread = IterableExtensions.filter((Iterable)_allContainedInstances, (Functions.Function1)_function_1);
            _builder.newLineIfNotEmpty();
            Functions.Function1<ActorInstance, Boolean> _function_2 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    boolean _or = false;
                    ActorClass _actorClass = ai.getActorClass();
                    ActorCommunicationType _commType = _actorClass.getCommType();
                    boolean _equals = Objects.equal((Object)_commType, (Object)ActorCommunicationType.EVENT_DRIVEN);
                    if (_equals) {
                        _or = true;
                    } else {
                        ActorClass _actorClass_1 = ai.getActorClass();
                        ActorCommunicationType _commType_1 = _actorClass_1.getCommType();
                        boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.ASYNCHRONOUS);
                        _or = _equals || _equals_1;
                    }
                    return _or;
                }
            };
            Iterable dispatchedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)_function_2);
            _builder.newLineIfNotEmpty();
            Functions.Function1<ActorInstance, Boolean> _function_3 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    boolean _or = false;
                    ActorClass _actorClass = ai.getActorClass();
                    ActorCommunicationType _commType = _actorClass.getCommType();
                    boolean _equals = Objects.equal((Object)_commType, (Object)ActorCommunicationType.DATA_DRIVEN);
                    if (_equals) {
                        _or = true;
                    } else {
                        ActorClass _actorClass_1 = ai.getActorClass();
                        ActorCommunicationType _commType_1 = _actorClass_1.getCommType();
                        boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.ASYNCHRONOUS);
                        _or = _equals || _equals_1;
                    }
                    return _or;
                }
            };
            Iterable executedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)_function_3);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            int _size = IterableExtensions.size((Iterable)executedInstances);
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* generated execute function for all cyclic execute calls for the async or datadriven actor instances of thread \"");
                String _name_2 = thread.getName();
                _builder.append((Object)_name_2, " ");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"static void MsgDispatcher_");
                String _name_3 = thread.getName();
                _builder.append((Object)_name_3, "");
                _builder.append((Object)"_poll(void){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
                String _name_4 = thread.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append((Object)"\", \"execute\")");
                _builder.newLineIfNotEmpty();
                for (ActorInstance ai : executedInstances) {
                    _builder.append((Object)"\t");
                    ActorClass _actorClass = ai.getActorClass();
                    String _name_5 = _actorClass.getName();
                    _builder.append((Object)_name_5, "\t");
                    _builder.append((Object)"_execute((void*)&");
                    String _path = ai.getPath();
                    String _pathName = this._roomExtensions.getPathName(_path);
                    _builder.append((Object)_pathName, "\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* generated dispatch function for all messages for the thread \"");
            String _name_6 = thread.getName();
            _builder.append((Object)_name_6, " ");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"static etBool MsgDispatcher_");
            String _name_7 = thread.getName();
            _builder.append((Object)_name_7, "");
            _builder.append((Object)"_receiveMessage(const etMessage* msg){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
            String _name_8 = thread.getName();
            _builder.append((Object)_name_8, "\t");
            _builder.append((Object)"\", \"receiveMessage\")");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"switch(msg->address){");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"case MESSAGESERVICE_ADDRESS:");
            _builder.newLine();
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)executedInstances);
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"if (msg->evtID == etSystemProtocol_IN_poll)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"MsgDispatcher_");
                String _name_9 = thread.getName();
                _builder.append((Object)_name_9, "\t\t\t\t");
                _builder.append((Object)"_poll();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"else");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"if (msg->evtID == etSystemProtocol_IN_terminate)");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"return FALSE;");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            for (ActorInstance ai_1 : dispatchedInstances) {
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"/* interface items of ");
                String _path_1 = ai_1.getPath();
                _builder.append((Object)_path_1, "\t\t");
                _builder.append((Object)" */");
                _builder.newLineIfNotEmpty();
                EList _orderedIfItemInstances = ai_1.getOrderedIfItemInstances();
                Functions.Function1<InterfaceItemInstance, Boolean> _function_4 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                    public Boolean apply(InterfaceItemInstance p) {
                        ProtocolClass _protocol = p.getProtocol();
                        CommunicationType _commType = _protocol.getCommType();
                        boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
                        return _equals;
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)_orderedIfItemInstances, (Functions.Function1)_function_4);
                for (InterfaceItemInstance pi : _filter_1) {
                    boolean _isReplicated = pi.isReplicated();
                    if (_isReplicated) {
                        EList _peers = pi.getPeers();
                        for (InterfaceItemInstance peer : _peers) {
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"case ");
                            int _objId = pi.getObjId();
                            EList _peers_1 = pi.getPeers();
                            int _indexOf = _peers_1.indexOf((Object)peer);
                            int _plus = _objId + _indexOf;
                            _builder.append((Object)_plus, "\t\t");
                            _builder.append((Object)"+BASE_ADDRESS:");
                            _builder.newLineIfNotEmpty();
                            ProtocolClass _protocol = pi.getProtocol();
                            boolean _isConjugated = this._roomExtensions.isConjugated(pi);
                            boolean _handlesReceive = this._roomExtensions.handlesReceive(_protocol, _isConjugated);
                            if (_handlesReceive) {
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"switch (msg->evtID){");
                                _builder.newLine();
                                ProtocolClass _protocol_1 = pi.getProtocol();
                                boolean _isConjugated_1 = this._roomExtensions.isConjugated(pi);
                                List _receiveHandlers = this._roomExtensions.getReceiveHandlers(_protocol_1, _isConjugated_1);
                                for (MessageHandler h : _receiveHandlers) {
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"case ");
                                    ProtocolClass _protocol_2 = pi.getProtocol();
                                    String _name_10 = _protocol_2.getName();
                                    _builder.append((Object)_name_10, "\t\t\t\t");
                                    _builder.append((Object)"_");
                                    Message _msg = h.getMsg();
                                    String _codeName = this._roomExtensions.getCodeName(_msg);
                                    _builder.append((Object)_codeName, "\t\t\t\t");
                                    _builder.append((Object)":");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    ProtocolClass _protocol_3 = pi.getProtocol();
                                    boolean _isConjugated_2 = this._roomExtensions.isConjugated(pi);
                                    String _portClassName = this._roomExtensions.getPortClassName(_protocol_3, _isConjugated_2);
                                    _builder.append((Object)_portClassName, "\t\t\t\t\t");
                                    _builder.append((Object)"_");
                                    Message _msg_1 = h.getMsg();
                                    String _name_11 = _msg_1.getName();
                                    _builder.append((Object)_name_11, "\t\t\t\t\t");
                                    _builder.append((Object)"_receiveHandler((etPort *)&");
                                    String _path_2 = ai_1.getPath();
                                    String _pathName_1 = this._roomExtensions.getPathName(_path_2);
                                    _builder.append((Object)_pathName_1, "\t\t\t\t\t");
                                    _builder.append((Object)"_const.");
                                    String _name_12 = pi.getName();
                                    _builder.append((Object)_name_12, "\t\t\t\t\t");
                                    _builder.append((Object)".ports[");
                                    EList _peers_2 = pi.getPeers();
                                    int _indexOf_1 = _peers_2.indexOf((Object)peer);
                                    _builder.append((Object)_indexOf_1, "\t\t\t\t\t");
                                    _builder.append((Object)"],msg,(void*)&");
                                    String _path_3 = ai_1.getPath();
                                    String _pathName_2 = this._roomExtensions.getPathName(_path_3);
                                    _builder.append((Object)_pathName_2, "\t\t\t\t\t");
                                    _builder.append((Object)",");
                                    ActorClass _actorClass_1 = ai_1.getActorClass();
                                    String _name_13 = _actorClass_1.getName();
                                    _builder.append((Object)_name_13, "\t\t\t\t\t");
                                    _builder.append((Object)"_receiveMessage);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"break;");
                                    _builder.newLine();
                                }
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"default: ");
                                ActorClass _actorClass_2 = ai_1.getActorClass();
                                String _name_14 = _actorClass_2.getName();
                                _builder.append((Object)_name_14, "\t\t\t\t");
                                _builder.append((Object)"_receiveMessage((void*)&");
                                String _path_4 = ai_1.getPath();
                                String _pathName_3 = this._roomExtensions.getPathName(_path_4);
                                _builder.append((Object)_pathName_3, "\t\t\t\t");
                                _builder.append((Object)",(etPort*)&");
                                String _path_5 = ai_1.getPath();
                                String _pathName_4 = this._roomExtensions.getPathName(_path_5);
                                _builder.append((Object)_pathName_4, "\t\t\t\t");
                                _builder.append((Object)"_const.");
                                String _name_15 = pi.getName();
                                _builder.append((Object)_name_15, "\t\t\t\t");
                                _builder.append((Object)".ports[");
                                EList _peers_3 = pi.getPeers();
                                int _indexOf_2 = _peers_3.indexOf((Object)peer);
                                _builder.append((Object)_indexOf_2, "\t\t\t\t");
                                _builder.append((Object)"], msg);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"break;");
                                _builder.newLine();
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"}\t\t\t\t\t\t\t\t\t\t");
                                _builder.newLine();
                            } else {
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                ActorClass _actorClass_3 = ai_1.getActorClass();
                                String _name_16 = _actorClass_3.getName();
                                _builder.append((Object)_name_16, "\t\t\t");
                                _builder.append((Object)"_receiveMessage((void*)&");
                                String _path_6 = ai_1.getPath();
                                String _pathName_5 = this._roomExtensions.getPathName(_path_6);
                                _builder.append((Object)_pathName_5, "\t\t\t");
                                _builder.append((Object)",(etPort*)&");
                                String _path_7 = ai_1.getPath();
                                String _pathName_6 = this._roomExtensions.getPathName(_path_7);
                                _builder.append((Object)_pathName_6, "\t\t\t");
                                _builder.append((Object)"_const.");
                                String _name_17 = pi.getName();
                                _builder.append((Object)_name_17, "\t\t\t");
                                _builder.append((Object)".ports[");
                                EList _peers_4 = pi.getPeers();
                                int _indexOf_3 = _peers_4.indexOf((Object)peer);
                                _builder.append((Object)_indexOf_3, "\t\t\t");
                                _builder.append((Object)"], msg);");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"break;");
                            _builder.newLine();
                        }
                        continue;
                    }
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"case ");
                    int _objId_1 = pi.getObjId();
                    _builder.append((Object)_objId_1, "\t\t");
                    _builder.append((Object)"+BASE_ADDRESS:");
                    _builder.newLineIfNotEmpty();
                    ProtocolClass _protocol_4 = pi.getProtocol();
                    boolean _isConjugated_3 = this._roomExtensions.isConjugated(pi);
                    boolean _handlesReceive_1 = this._roomExtensions.handlesReceive(_protocol_4, _isConjugated_3);
                    if (_handlesReceive_1) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"switch (msg->evtID){");
                        _builder.newLine();
                        ProtocolClass _protocol_5 = pi.getProtocol();
                        boolean _isConjugated_4 = this._roomExtensions.isConjugated(pi);
                        List _receiveHandlers_1 = this._roomExtensions.getReceiveHandlers(_protocol_5, _isConjugated_4);
                        for (MessageHandler h_1 : _receiveHandlers_1) {
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"case ");
                            ProtocolClass _protocol_6 = pi.getProtocol();
                            String _name_18 = _protocol_6.getName();
                            _builder.append((Object)_name_18, "\t\t\t\t");
                            _builder.append((Object)"_");
                            Message _msg_2 = h_1.getMsg();
                            String _codeName_1 = this._roomExtensions.getCodeName(_msg_2);
                            _builder.append((Object)_codeName_1, "\t\t\t\t");
                            _builder.append((Object)":");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            ProtocolClass _protocol_7 = pi.getProtocol();
                            boolean _isConjugated_5 = this._roomExtensions.isConjugated(pi);
                            String _portClassName_1 = this._roomExtensions.getPortClassName(_protocol_7, _isConjugated_5);
                            _builder.append((Object)_portClassName_1, "\t\t\t\t\t");
                            _builder.append((Object)"_");
                            Message _msg_3 = h_1.getMsg();
                            String _name_19 = _msg_3.getName();
                            _builder.append((Object)_name_19, "\t\t\t\t\t");
                            _builder.append((Object)"_receiveHandler((etPort *)&");
                            String _path_8 = ai_1.getPath();
                            String _pathName_7 = this._roomExtensions.getPathName(_path_8);
                            _builder.append((Object)_pathName_7, "\t\t\t\t\t");
                            _builder.append((Object)"_const.");
                            String _name_20 = pi.getName();
                            _builder.append((Object)_name_20, "\t\t\t\t\t");
                            _builder.append((Object)",msg,(void*)&");
                            String _path_9 = ai_1.getPath();
                            String _pathName_8 = this._roomExtensions.getPathName(_path_9);
                            _builder.append((Object)_pathName_8, "\t\t\t\t\t");
                            _builder.append((Object)",");
                            ActorClass _actorClass_4 = ai_1.getActorClass();
                            String _name_21 = _actorClass_4.getName();
                            _builder.append((Object)_name_21, "\t\t\t\t\t");
                            _builder.append((Object)"_receiveMessage);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"break;");
                            _builder.newLine();
                        }
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"default: ");
                        ActorClass _actorClass_5 = ai_1.getActorClass();
                        String _name_22 = _actorClass_5.getName();
                        _builder.append((Object)_name_22, "\t\t\t\t");
                        _builder.append((Object)"_receiveMessage((void*)&");
                        String _path_10 = ai_1.getPath();
                        String _pathName_9 = this._roomExtensions.getPathName(_path_10);
                        _builder.append((Object)_pathName_9, "\t\t\t\t");
                        _builder.append((Object)",(etPort*)&");
                        String _path_11 = ai_1.getPath();
                        String _pathName_10 = this._roomExtensions.getPathName(_path_11);
                        _builder.append((Object)_pathName_10, "\t\t\t\t");
                        _builder.append((Object)"_const.");
                        String _name_23 = pi.getName();
                        _builder.append((Object)_name_23, "\t\t\t\t");
                        _builder.append((Object)", msg);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"break;");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                    } else {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        ActorClass _actorClass_6 = ai_1.getActorClass();
                        String _name_24 = _actorClass_6.getName();
                        _builder.append((Object)_name_24, "\t\t\t");
                        _builder.append((Object)"_receiveMessage((void*)&");
                        String _path_12 = ai_1.getPath();
                        String _pathName_11 = this._roomExtensions.getPathName(_path_12);
                        _builder.append((Object)_pathName_11, "\t\t\t");
                        _builder.append((Object)",(etPort*)&");
                        String _path_13 = ai_1.getPath();
                        String _pathName_12 = this._roomExtensions.getPathName(_path_13);
                        _builder.append((Object)_pathName_12, "\t\t\t");
                        _builder.append((Object)"_const.");
                        String _name_25 = pi.getName();
                        _builder.append((Object)_name_25, "\t\t\t");
                        _builder.append((Object)", msg);");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                }
            }
            _builder.append((Object)"\t\t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"default:");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"etLogger_logErrorF(\"MessageService_");
            String _name_26 = thread.getName();
            _builder.append((Object)_name_26, "\t\t\t");
            _builder.append((Object)"_receiveMessage: address %d does not exist \", msg->address);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"return TRUE;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private void checkDataPorts(SubSystemInstance comp) {
        HashSet<String> _hashSet;
        HashSet<String> found = _hashSet = new HashSet<String>();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            int thread = ai.getThreadId();
            EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                ProtocolClass _protocol = pi.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                if (!_equals) continue;
                EList _peers = pi.getPeers();
                for (InterfaceItemInstance peer : _peers) {
                    boolean _not;
                    boolean _lessThan;
                    boolean _notEquals;
                    EObject _eContainer = peer.eContainer();
                    ActorInstance peer_ai = (ActorInstance)_eContainer;
                    int peer_thread = peer_ai.getThreadId();
                    boolean bl = _notEquals = thread != peer_thread;
                    if (!_notEquals) continue;
                    String path = pi.getPath();
                    String ppath = peer.getPath();
                    String _xifexpression = null;
                    int _compareTo = path.compareTo(ppath);
                    boolean bl2 = _lessThan = _compareTo < 0;
                    if (_lessThan) {
                        String _plus_1;
                        String _plus = String.valueOf(path) + " and ";
                        _xifexpression = _plus_1 = String.valueOf(_plus) + ppath;
                    } else {
                        String _plus_3;
                        String _plus_2 = String.valueOf(ppath) + " and ";
                        _xifexpression = _plus_3 = String.valueOf(_plus_2) + path;
                    }
                    String pair = _xifexpression;
                    boolean _contains = found.contains(pair);
                    boolean bl3 = _not = !_contains;
                    if (!_not) continue;
                    found.add(pair);
                    String _plus_4 = String.valueOf(pair) + ": data ports placed on different threads (not supported yet)";
                    InterfaceItem _interfaceItem = pi.getInterfaceItem();
                    InterfaceItem _interfaceItem_1 = pi.getInterfaceItem();
                    EStructuralFeature _eContainingFeature = _interfaceItem_1.eContainingFeature();
                    this.diagnostician.error(_plus_4, (EObject)_interfaceItem, _eContainingFeature);
                }
            }
        }
    }
}

