/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.config;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.ConfigStandaloneSetup;
import org.eclipse.etrice.core.config.AttrClassConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.BooleanLiteral;
import org.eclipse.etrice.core.config.ConfigModel;
import org.eclipse.etrice.core.config.DynamicConfig;
import org.eclipse.etrice.core.config.Import;
import org.eclipse.etrice.core.config.IntLiteral;
import org.eclipse.etrice.core.config.Literal;
import org.eclipse.etrice.core.config.LiteralArray;
import org.eclipse.etrice.core.config.NumberLiteral;
import org.eclipse.etrice.core.config.RealLiteral;
import org.eclipse.etrice.core.config.StringLiteral;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.IResourceURIAcceptor;
import org.eclipse.etrice.generator.config.util.DataConfigurationHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class DataConfiguration
implements IDataConfiguration {
    @Inject
    protected ILogger logger;
    @Inject
    protected ImportUriResolver uriResolver;

    public void doSetup() {
        boolean _not;
        boolean bl = _not = !EMFPlugin.IS_ECLIPSE_RUNNING;
        if (_not) {
            ConfigStandaloneSetup.doSetup();
        }
    }

    public boolean setResources(ResourceSet resource, ILogger logger) {
        boolean _setConfigModels = DataConfigurationHelper.setConfigModels(resource, logger);
        return _setConfigModels;
    }

    public String getAttrClassConfigValue(ActorClass actor, List<Attribute> path) {
        AttrClassConfig _attrClassConfig = this.getAttrClassConfig(actor, path);
        LiteralArray _value = _attrClassConfig == null ? null : _attrClassConfig.getValue();
        String _stringExpr = _value == null ? null : this.toStringExpr(_value);
        return _stringExpr;
    }

    public String getAttrClassConfigMaxValue(ActorClass actor, List<Attribute> path) {
        AttrClassConfig _attrClassConfig = this.getAttrClassConfig(actor, path);
        NumberLiteral _max = _attrClassConfig == null ? null : _attrClassConfig.getMax();
        String _stringExpr = _max == null ? null : this.toStringExpr((Literal)_max);
        return _stringExpr;
    }

    public String getAttrClassConfigMinValue(ActorClass actor, List<Attribute> path) {
        AttrClassConfig _attrClassConfig = this.getAttrClassConfig(actor, path);
        NumberLiteral _min = _attrClassConfig == null ? null : _attrClassConfig.getMin();
        String _stringExpr = _min == null ? null : this.toStringExpr((Literal)_min);
        return _stringExpr;
    }

    private AttrClassConfig getAttrClassConfig(ActorClass actor, List<Attribute> path) {
        AttrClassConfig _get;
        AttrClassConfig _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/");
        String _name = actor.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"/");
        String _stringPath = this.toStringPath(path);
        _builder.append((Object)_stringPath, "");
        String id = _builder.toString();
        _xblockexpression = _get = DataConfigurationHelper.actorClassAttrMap.get(id);
        return _xblockexpression;
    }

    public String getAttrClassConfigValue(ProtocolClass pc, boolean regular, List<Attribute> path) {
        String _stringExpr;
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/");
        String _name = pc.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"/");
        if (regular) {
            _builder.append((Object)"regular");
        } else {
            _builder.append((Object)"conjugated");
        }
        _builder.append((Object)"/");
        String _stringPath = this.toStringPath(path);
        _builder.append((Object)_stringPath, "");
        String id = _builder.toString();
        AttrClassConfig _get = DataConfigurationHelper.protocolClassAttrMap.get(id);
        LiteralArray _value = _get == null ? null : _get.getValue();
        _xblockexpression = _stringExpr = _value == null ? null : this.toStringExpr(_value);
        return _xblockexpression;
    }

    private String toStringPath(List<Attribute> path) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : path) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"/", "");
            }
            String _name = a.getName();
            _builder.append((Object)_name, "");
        }
        String _string = _builder.toString();
        return _string;
    }

    public String getAttrInstanceConfigValue(ActorInstance ai, List<Attribute> path) {
        String _stringExpr;
        String _xblockexpression = null;
        String _path = ai.getPath();
        String _plus = String.valueOf(_path) + "/";
        String _stringPath = this.toStringPath(path);
        String id = String.valueOf(_plus) + _stringPath;
        AttrInstanceConfig _get = DataConfigurationHelper.actorInstanceAttrMap.get(id);
        LiteralArray _value = _get == null ? null : _get.getValue();
        _xblockexpression = _stringExpr = _value == null ? null : this.toStringExpr(_value);
        return _xblockexpression;
    }

    public String getAttrInstanceConfigValue(InterfaceItemInstance item, List<Attribute> path) {
        String _path = item.getPath();
        String _plus = String.valueOf(_path) + "/";
        String _stringPath = this.toStringPath(path);
        String _plus_1 = String.valueOf(_plus) + _stringPath;
        AttrInstanceConfig _get = DataConfigurationHelper.actorInstanceAttrMap.get(_plus_1);
        LiteralArray _value = _get == null ? null : _get.getValue();
        String _stringExpr = _value == null ? null : this.toStringExpr(_value);
        return _stringExpr;
    }

    public int getPollingTimerUser(SubSystemInstance subsystem) {
        int _polling;
        int _xblockexpression = 0;
        SubSystemConfig _config = this.getConfig(subsystem);
        DynamicConfig dynConf = _config == null ? null : _config.getDynConfig();
        int _xifexpression = 0;
        boolean _equals = Objects.equal((Object)dynConf, null);
        _xifexpression = _equals ? 0 : (_polling = dynConf.getPolling());
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getUserCode1(SubSystemInstance subsystem) {
        String _userCode1;
        boolean _notEquals;
        SubSystemConfig _config = this.getConfig(subsystem);
        DynamicConfig dynConfig = _config == null ? null : _config.getDynConfig();
        String _xifexpression = null;
        String _filePath = dynConfig == null ? null : dynConfig.getFilePath();
        boolean bl = _notEquals = !Objects.equal((Object)_filePath, null);
        _xifexpression = _notEquals ? "import org.eclipse.etrice.runtime.java.config.ConfigSourceFile;" : (_userCode1 = dynConfig == null ? null : dynConfig.getUserCode1());
        return _xifexpression;
    }

    public String getUserCode2(SubSystemInstance subsystem) {
        boolean _notEquals;
        SubSystemConfig _config = this.getConfig(subsystem);
        DynamicConfig dynConfig = _config == null ? null : _config.getDynConfig();
        String _xifexpression = null;
        String _filePath = dynConfig == null ? null : dynConfig.getFilePath();
        boolean bl = _notEquals = !Objects.equal((Object)_filePath, null);
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"new ConfigSourceFile(\"");
            String _filePath_1 = dynConfig.getFilePath();
            _builder.append((Object)_filePath_1, "");
            _builder.append((Object)"\")");
            _xifexpression = _builder.toString();
        } else {
            String _userCode2;
            _xifexpression = _userCode2 = dynConfig == null ? null : dynConfig.getUserCode2();
        }
        return _xifexpression;
    }

    public List<Attribute> getDynConfigReadAttributes(ActorInstance ai) {
        ArrayList<Attribute> _arrayList;
        final ArrayList<Attribute> result = _arrayList = new ArrayList<Attribute>();
        String _path = ai.getPath();
        List<AttrInstanceConfig> configs = DataConfigurationHelper.dynActorInstanceAttrMap.get(_path);
        Procedures.Procedure1<AttrInstanceConfig> _function = new Procedures.Procedure1<AttrInstanceConfig>(){

            public void apply(AttrInstanceConfig c) {
                boolean _isReadOnly = c.isReadOnly();
                if (_isReadOnly) {
                    Attribute _attribute = c.getAttribute();
                    result.add(_attribute);
                }
            }
        };
        if (configs != null) {
            IterableExtensions.forEach(configs, (Procedures.Procedure1)_function);
        }
        return result;
    }

    public List<Attribute> getDynConfigWriteAttributes(ActorInstance ai) {
        ArrayList<Attribute> _arrayList;
        final ArrayList<Attribute> result = _arrayList = new ArrayList<Attribute>();
        String _path = ai.getPath();
        List<AttrInstanceConfig> configs = DataConfigurationHelper.dynActorInstanceAttrMap.get(_path);
        Procedures.Procedure1<AttrInstanceConfig> _function = new Procedures.Procedure1<AttrInstanceConfig>(){

            public void apply(AttrInstanceConfig c) {
                boolean _not;
                boolean _isReadOnly = c.isReadOnly();
                boolean bl = _not = !_isReadOnly;
                if (_not) {
                    Attribute _attribute = c.getAttribute();
                    result.add(_attribute);
                }
            }
        };
        if (configs != null) {
            IterableExtensions.forEach(configs, (Procedures.Procedure1)_function);
        }
        return result;
    }

    public boolean hasVariableService(SubSystemInstance subsystem) {
        SubSystemConfig _config = this.getConfig(subsystem);
        DynamicConfig _dynConfig = _config == null ? null : _config.getDynConfig();
        boolean _notEquals = !Objects.equal((Object)_dynConfig, null);
        return _notEquals;
    }

    private String toStringExpr(LiteralArray literal) {
        StringConcatenation _builder = new StringConcatenation();
        EList _literals = literal.getLiterals();
        boolean _hasElements = false;
        for (Literal l : _literals) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _stringExpr = this.toStringExpr(l);
            _builder.append((Object)_stringExpr, "");
        }
        String _string = _builder.toString();
        return _string;
    }

    private String toStringExpr(Literal literal) {
        String _string;
        String _string2;
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && literal instanceof BooleanLiteral) {
            BooleanLiteral _booleanLiteral = (BooleanLiteral)literal;
            _matched = true;
            boolean _isIsTrue = _booleanLiteral.isIsTrue();
            _switchResult = _string2 = Boolean.valueOf(_isIsTrue).toString();
        }
        if (!_matched && literal instanceof IntLiteral) {
            IntLiteral _intLiteral = (IntLiteral)literal;
            _matched = true;
            long _value = _intLiteral.getValue();
            _switchResult = _string = Long.valueOf(_value).toString();
        }
        if (!_matched && literal instanceof RealLiteral) {
            RealLiteral _realLiteral = (RealLiteral)literal;
            _matched = true;
            double _value = _realLiteral.getValue();
            _switchResult = _string = Double.valueOf(_value).toString();
        }
        if (!_matched && literal instanceof StringLiteral) {
            StringLiteral _stringLiteral = (StringLiteral)literal;
            _matched = true;
            String _value = _stringLiteral.getValue();
            _switchResult = _string2 = _value.toString();
        }
        return _switchResult;
    }

    private SubSystemConfig getConfig(SubSystemInstance cc) {
        String _path = cc.getPath();
        SubSystemConfig _get = DataConfigurationHelper.subSystemConfigMap.get(_path);
        return _get;
    }

    public List<Attribute> getDynConfigReadAttributes(ActorClass actor) {
        ArrayList<Attribute> _arrayList;
        final ArrayList<Attribute> result = _arrayList = new ArrayList<Attribute>();
        List<AttrInstanceConfig> configs = DataConfigurationHelper.dynActorClassAttrMap.get(actor);
        Procedures.Procedure1<AttrInstanceConfig> _function = new Procedures.Procedure1<AttrInstanceConfig>(){

            public void apply(AttrInstanceConfig c) {
                boolean _isReadOnly = c.isReadOnly();
                if (_isReadOnly) {
                    Attribute _attribute = c.getAttribute();
                    result.add(_attribute);
                }
            }
        };
        if (configs != null) {
            IterableExtensions.forEach(configs, (Procedures.Procedure1)_function);
        }
        return result;
    }

    public List<Attribute> getDynConfigWriteAttributes(ActorClass actor) {
        ArrayList<Attribute> _arrayList;
        final ArrayList<Attribute> result = _arrayList = new ArrayList<Attribute>();
        List<AttrInstanceConfig> configs = DataConfigurationHelper.dynActorClassAttrMap.get(actor);
        Procedures.Procedure1<AttrInstanceConfig> _function = new Procedures.Procedure1<AttrInstanceConfig>(){

            public void apply(AttrInstanceConfig c) {
                boolean _not;
                boolean _isReadOnly = c.isReadOnly();
                boolean bl = _not = !_isReadOnly;
                if (_not) {
                    Attribute _attribute = c.getAttribute();
                    result.add(_attribute);
                }
            }
        };
        if (configs != null) {
            IterableExtensions.forEach(configs, (Procedures.Procedure1)_function);
        }
        return result;
    }

    public void addReferencedModels(IResourceURIAcceptor acceptor, EObject root) {
        if (root instanceof ConfigModel) {
            EList _imports = ((ConfigModel)root).getImports();
            for (Import imp : _imports) {
                String importURI = this.uriResolver.resolve((EObject)imp);
                acceptor.addResourceURI(importURI);
            }
        }
    }
}

