/**
 * Copyright (c) 2011 Draeger Medical GmbH (http://www.draeger.com).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Peter Karlitschek (initial contribution)
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.cpp.GeneratorOptions;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Peter Karlitschek
 */
@Singleton
@SuppressWarnings("all")
public class ProtocolClassGen extends GenericProtocolClassGenerator {
  @Inject
  @Extension
  private JavaIoFileSystemAccess fileAccess;
  
  @Inject
  @Extension
  private CppExtensions stdExt;
  
  @Inject
  @Extension
  private RoomExtensions roomExt;
  
  @Inject
  @Extension
  private ProcedureHelpers helpers;
  
  @Inject
  @Extension
  private TypeHelpers _typeHelpers;
  
  @Inject
  @Extension
  private Initialization _initialization;
  
  @Inject
  private ILogger logger;
  
  public void doGenerate(final Root root) {
    EList<ProtocolClass> _usedProtocolClasses = root.getUsedProtocolClasses();
    for (final ProtocolClass pc : _usedProtocolClasses) {
      {
        String _generationTargetPath = this.roomExt.getGenerationTargetPath(pc);
        String _path = this.roomExt.getPath(pc);
        String path = (_generationTargetPath + _path);
        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName(pc);
        String _plus = ("generating ProtocolClass header \'" + _cppHeaderFileName);
        String _plus_1 = (_plus + "\' in \'");
        String _plus_2 = (_plus_1 + path);
        String _plus_3 = (_plus_2 + "\'");
        this.logger.logInfo(_plus_3);
        this.fileAccess.setOutputPath(path);
        String _cppHeaderFileName_1 = this.stdExt.getCppHeaderFileName(pc);
        CharSequence _generateHeaderFile = this.generateHeaderFile(root, pc);
        this.fileAccess.generateFile(_cppHeaderFileName_1, _generateHeaderFile);
        String _cppSourceFileName = this.stdExt.getCppSourceFileName(pc);
        String _plus_4 = ("generating ProtocolClass source \'" + _cppSourceFileName);
        String _plus_5 = (_plus_4 + "\' in \'");
        String _plus_6 = (_plus_5 + path);
        String _plus_7 = (_plus_6 + "\'");
        this.logger.logInfo(_plus_7);
        this.fileAccess.setOutputPath(path);
        String _cppSourceFileName_1 = this.stdExt.getCppSourceFileName(pc);
        CharSequence _generateSourceFile = this.generateSourceFile(root, pc);
        this.fileAccess.generateFile(_cppSourceFileName_1, _generateSourceFile);
      }
    }
  }
  
  private CharSequence generateHeaderFile(final Root root, final ProtocolClass pc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Header File of ProtocolClass ");
    String _name = pc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    String _name_1 = pc.getName();
    CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin(_name_1);
    _builder.append(_generateIncludeGuardBegin, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"platforms/generic/etDatatypes.h\"");
    _builder.newLine();
    _builder.append("#include \"common/messaging/IRTObject.h\"");
    _builder.newLine();
    _builder.append("#include \"common/modelbase/PortBase.h\"");
    _builder.newLine();
    _builder.append("#include \"common/modelbase/InterfaceItemBase.h\"");
    _builder.newLine();
    _builder.append("#include \"common/messaging/Address.h\"");
    _builder.newLine();
    _builder.append("#include \"common/messaging/Message.h\"");
    _builder.newLine();
    _builder.append("#include <vector>");
    _builder.newLine();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("namespace etRuntime {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("class IEventReceiver;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    DetailCode _userCode1 = pc.getUserCode1();
    CharSequence _userCode = this.helpers.userCode(_userCode1);
    _builder.append(_userCode, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      EList<DataClass> _referencedDataClasses = root.getReferencedDataClasses(pc);
      for(final DataClass dataClass : _referencedDataClasses) {
        _builder.append("#include \"");
        String _path = this.roomExt.getPath(dataClass);
        _builder.append(_path, "");
        String _name_2 = dataClass.getName();
        _builder.append(_name_2, "");
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("class ");
    String _name_3 = pc.getName();
    _builder.append(_name_3, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("   ");
    _builder.append("public:");
    _builder.newLine();
    {
      CommunicationType _commType = pc.getCommType();
      boolean _equals = Objects.equal(_commType, CommunicationType.EVENT_DRIVEN);
      if (_equals) {
        _builder.append("\t   /* message IDs */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _genMessageIDs = this.genMessageIDs(pc);
        _builder.append(_genMessageIDs, "		");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("static bool isValidEvtID(int evtId) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ((MSG_MIN < evtId) && (evtId < MSG_MAX));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static bool isValidOutgoingEvtID(int evtId) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ((MSG_MIN < evtId) && (evtId < ");
        {
          EList<Message> _incomingMessages = pc.getIncomingMessages();
          int _size = _incomingMessages.size();
          boolean _equals_1 = (_size == 0);
          if (_equals_1) {
            _builder.append("MSG_MAX");
          } else {
            _builder.append("IN_");
            EList<Message> _incomingMessages_1 = pc.getIncomingMessages();
            Message _get = _incomingMessages_1.get(0);
            String _name_4 = _get.getName();
            _builder.append(_name_4, "			");
          }
        }
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static bool isValidIncomingEvtID(int evtId) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ((");
        {
          EList<Message> _incomingMessages_2 = pc.getIncomingMessages();
          int _size_1 = _incomingMessages_2.size();
          boolean _equals_2 = (_size_1 == 0);
          if (_equals_2) {
            _builder.append("MSG_MAX");
          } else {
            _builder.append("IN_");
            EList<Message> _incomingMessages_3 = pc.getIncomingMessages();
            Message _get_1 = _incomingMessages_3.get(0);
            String _name_5 = _get_1.getName();
            _builder.append(_name_5, "			");
          }
        }
        _builder.append(" <= evtId) && (evtId < MSG_MAX));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static std::string getMessageString(int msg_id);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static std::string s_messageStrings[];");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    DetailCode _userCode2 = pc.getUserCode2();
    CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
    _builder.append(_userCode_1, "		");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    CharSequence _portClassDeclaration = this.portClassDeclaration(pc, Boolean.valueOf(false));
    _builder.append(_portClassDeclaration, "");
    _builder.newLineIfNotEmpty();
    CharSequence _portClassDeclaration_1 = this.portClassDeclaration(pc, Boolean.valueOf(true));
    _builder.append(_portClassDeclaration_1, "");
    _builder.newLineIfNotEmpty();
    String _name_6 = pc.getName();
    CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd(_name_6);
    _builder.append(_generateIncludeGuardEnd, "");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  private CharSequence portClassDeclaration(final ProtocolClass pc, final Boolean conj) {
    CharSequence _xblockexpression = null;
    {
      PortClass pclass = this.roomExt.getPortClass(pc, (conj).booleanValue());
      String portClassName = this.roomExt.getPortClassName(pc, (conj).booleanValue());
      String replPortClassName = this.roomExt.getPortClassName(pc, (conj).booleanValue(), true);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("//------------------------------------------------------------------------------------------------------------");
      _builder.newLine();
      _builder.append("// ");
      {
        if ((conj).booleanValue()) {
          _builder.append("conjugated ");
        }
      }
      _builder.append("port class");
      _builder.newLineIfNotEmpty();
      _builder.append("//------------------------------------------------------------------------------------------------------------");
      _builder.newLine();
      _builder.append("class ");
      _builder.append(portClassName, "");
      _builder.append(" : public etRuntime::PortBase {");
      _builder.newLineIfNotEmpty();
      {
        boolean _notEquals = (!Objects.equal(pclass, null));
        if (_notEquals) {
          _builder.append("\t");
          DetailCode _userCode = pclass.getUserCode();
          CharSequence _userCode_1 = this.helpers.userCode(_userCode);
          _builder.append(_userCode_1, "	");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("   ");
      _builder.append("public:");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("// constructors");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append(portClassName, "	 ");
      _builder.append("(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, etRuntime::Address addr, etRuntime::Address peerAddress, bool doRegistration = true); ");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append(portClassName, "	 ");
      _builder.append("(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, int idx, etRuntime::Address addr, etRuntime::Address peerAddress, bool doRegistration = true);");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("virtual void receive(etRuntime::Message* m);");
      _builder.newLine();
      {
        boolean _notEquals_1 = (!Objects.equal(pclass, null));
        if (_notEquals_1) {
          _builder.append("\t");
          EList<Attribute> _attributes = pclass.getAttributes();
          CharSequence _attributes_1 = this.helpers.attributes(_attributes);
          _builder.append(_attributes_1, "	");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          EList<PortOperation> _operations = pclass.getOperations();
          CharSequence _operationsDeclaration = this.helpers.operationsDeclaration(_operations, portClassName);
          _builder.append(_operationsDeclaration, "	");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t");
      _builder.newLine();
      _builder.append("\t  ");
      _builder.append("// outgoing messages");
      _builder.newLine();
      {
        List<Message> _allMessages = RoomHelpers.getAllMessages(pc, (conj).booleanValue());
        for(final Message m : _allMessages) {
          _builder.append("\t");
          CharSequence _sendMessageDeclaration = this.sendMessageDeclaration(m, (conj).booleanValue());
          _builder.append(_sendMessageDeclaration, "	");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("};");
      _builder.newLine();
      _builder.newLine();
      _builder.append("//------------------------------------------------------------------------------------------------------------");
      _builder.newLine();
      _builder.append("// ");
      {
        if ((conj).booleanValue()) {
          _builder.append("conjugated ");
        }
      }
      _builder.append("replicated port class");
      _builder.newLineIfNotEmpty();
      _builder.append("//------------------------------------------------------------------------------------------------------------");
      _builder.newLine();
      _builder.append("class ");
      _builder.append(replPortClassName, "");
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("private:");
      _builder.newLine();
      _builder.append("\t    ");
      _builder.append("int m_replication;");
      _builder.newLine();
      _builder.append("\t    ");
      _builder.append(portClassName, "	    ");
      _builder.append("* m_ports;  //dynamic array used instead of vector to avoid copy construction");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public:");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append(replPortClassName, "		");
      _builder.append("(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, std::vector<etRuntime::Address> addr, std::vector<etRuntime::Address> peerAddress);");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("virtual ~");
      _builder.append(replPortClassName, "		");
      _builder.append("() {};");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("int getReplication() {\treturn m_replication; }");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("int getIndexOf(const etRuntime::InterfaceItemBase& ifitem){ return ifitem.getIdx();\t}");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append(portClassName, "		");
      _builder.append(" get(int i) {return m_ports[i];}");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.newLine();
      {
        CommunicationType _commType = pc.getCommType();
        boolean _equals = Objects.equal(_commType, CommunicationType.EVENT_DRIVEN);
        if (_equals) {
          _builder.append("\t\t");
          _builder.append(" ");
          _builder.append("// outgoing messages");
          _builder.newLine();
          {
            List<Message> _allMessages_1 = RoomHelpers.getAllMessages(pc, (conj).booleanValue());
            for(final Message m_1 : _allMessages_1) {
              _builder.append("\t\t");
              CharSequence _sendMessageDeclaration_1 = this.sendMessageDeclaration(m_1, (conj).booleanValue());
              _builder.append(_sendMessageDeclaration_1, "		");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.append("\t\t");
      _builder.newLine();
      _builder.append("};");
      _builder.newLine();
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  private CharSequence generateSourceFile(final Root root, final ProtocolClass pc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Source File of ProtocolClass ");
    String _name = pc.getName();
    _builder.append(_name, "	 ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("#include \"");
    String _cppHeaderFileName = this.stdExt.getCppHeaderFileName(pc);
    _builder.append(_cppHeaderFileName, "	");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("#include \"common/debugging/DebuggingService.h\"");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("#include <iostream>");
    _builder.newLine();
    {
      boolean _isUseEtUnit = GeneratorOptions.isUseEtUnit();
      if (_isUseEtUnit) {
        _builder.append("\t");
        _builder.append("extern \"C\" {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("#include \"etUnit.h\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("using namespace etRuntime;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    DetailCode _userCode3 = pc.getUserCode3();
    CharSequence _userCode = this.helpers.userCode(_userCode3);
    _builder.append(_userCode, "	");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      CommunicationType _commType = pc.getCommType();
      boolean _equals = Objects.equal(_commType, CommunicationType.EVENT_DRIVEN);
      if (_equals) {
        _builder.append("\t");
        DetailCode _userCode2 = pc.getUserCode2();
        CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
        _builder.append(_userCode_1, "	");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _portClassImplementation = this.portClassImplementation(pc, Boolean.valueOf(false));
        _builder.append(_portClassImplementation, "	");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _portClassImplementation_1 = this.portClassImplementation(pc, Boolean.valueOf(true));
        _builder.append(_portClassImplementation_1, "	");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*--------------------- debug helpers */");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateDebugHelpersImplementation = this.generateDebugHelpersImplementation(root, pc);
        _builder.append(_generateDebugHelpersImplementation, "	");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence portClassImplementation(final ProtocolClass pc, final Boolean conj) {
    CharSequence _xblockexpression = null;
    {
      PortClass pclass = this.roomExt.getPortClass(pc, (conj).booleanValue());
      String portClassName = this.roomExt.getPortClassName(pc, (conj).booleanValue());
      String replPortClassName = this.roomExt.getPortClassName(pc, (conj).booleanValue(), true);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("//------------------------------------------------------------------------------------------------------------");
      _builder.newLine();
      _builder.append("// ");
      {
        if ((conj).booleanValue()) {
          _builder.append("conjugated ");
        }
      }
      _builder.append("port class");
      _builder.newLineIfNotEmpty();
      _builder.append("//------------------------------------------------------------------------------------------------------------");
      _builder.newLine();
      _builder.newLine();
      _builder.append(portClassName, "");
      _builder.append("::");
      _builder.append(portClassName, "");
      _builder.append("(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, Address addr, Address peerAddress, bool doRegistration)");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append(": ");
      String _generateConstructorInitalizerList = this.generateConstructorInitalizerList(pclass, "0");
      _builder.append(_generateConstructorInitalizerList, "	");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      {
        boolean _notEquals = (!Objects.equal(pclass, null));
        if (_notEquals) {
          EList<Attribute> _attributes = pclass.getAttributes();
          CharSequence _attributeInitialization = this._initialization.attributeInitialization(_attributes, false);
          _builder.append(_attributeInitialization, "	");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("if (doRegistration) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("DebuggingService::getInstance().addPortInstance(*this);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append(portClassName, "");
      _builder.append("::");
      _builder.append(portClassName, "");
      _builder.append("(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, int idx, Address addr, Address peerAddress, bool doRegistration)");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append(": ");
      String _generateConstructorInitalizerList_1 = this.generateConstructorInitalizerList(pclass, "idx");
      _builder.append(_generateConstructorInitalizerList_1, "	");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      {
        boolean _notEquals_1 = (!Objects.equal(pclass, null));
        if (_notEquals_1) {
          EList<Attribute> _attributes_1 = pclass.getAttributes();
          CharSequence _attributeInitialization_1 = this._initialization.attributeInitialization(_attributes_1, false);
          _builder.append(_attributeInitialization_1, "	");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("if (doRegistration) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("DebuggingService::getInstance().addPortInstance(*this);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.newLine();
      _builder.append("void ");
      _builder.append(portClassName, "");
      _builder.append("::receive(Message* msg) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("if (! ");
      String _name = pc.getName();
      _builder.append(_name, "	");
      _builder.append("::");
      {
        if ((conj).booleanValue()) {
          _builder.append("isValidOutgoingEvtID");
        } else {
          _builder.append("isValidIncomingEvtID");
        }
      }
      _builder.append("(msg->getEvtId())) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("std::cout << \"unknown\" << std::endl;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("else {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("if (msg->hasDebugFlagSet()) {\t\t\t// TODO: model switch for activation of this flag");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("DebuggingService::getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), ");
      String _name_1 = pc.getName();
      _builder.append(_name_1, "			");
      _builder.append("::getMessageString(msg->getEvtId()));");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.newLine();
      {
        boolean _handlesReceive = this.roomExt.handlesReceive(pc, (conj).booleanValue());
        if (_handlesReceive) {
          _builder.append("\t\t");
          _builder.append("switch (msg->getEvtId()) {");
          _builder.newLine();
          {
            List<MessageHandler> _receiveHandlers = this.roomExt.getReceiveHandlers(pc, (conj).booleanValue());
            for(final MessageHandler hdlr : _receiveHandlers) {
              _builder.append("\t\t");
              _builder.append("\t");
              _builder.append("case ");
              String _name_2 = pc.getName();
              _builder.append(_name_2, "			");
              _builder.append("::");
              Message _msg = hdlr.getMsg();
              String _codeName = this.roomExt.getCodeName(_msg);
              _builder.append(_codeName, "			");
              _builder.append(":");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("{");
              _builder.newLine();
              {
                DetailCode _detailCode = hdlr.getDetailCode();
                EList<String> _commands = _detailCode.getCommands();
                for(final String command : _commands) {
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("\t\t");
                  _builder.append(command, "					");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t\t");
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("break;");
              _builder.newLine();
            }
          }
          _builder.append("\t\t");
          _builder.append("\t");
          _builder.append("default:");
          _builder.newLine();
        }
      }
      _builder.append("\t\t\t\t");
      _builder.append("getEventReceiver().receiveEvent(this, msg->getEvtId(),\tmsg->getData());");
      _builder.newLine();
      {
        boolean _handlesReceive_1 = this.roomExt.handlesReceive(pc, (conj).booleanValue());
        if (_handlesReceive_1) {
          _builder.append("\t\t");
          _builder.append("\t\t");
          _builder.append("break;");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("};");
      _builder.newLine();
      _builder.newLine();
      {
        boolean _notEquals_2 = (!Objects.equal(pclass, null));
        if (_notEquals_2) {
          EList<PortOperation> _operations = pclass.getOperations();
          CharSequence _operationsImplementation = this.helpers.operationsImplementation(_operations, portClassName);
          _builder.append(_operationsImplementation, "");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t\t");
      _builder.newLine();
      _builder.append("// sent messages");
      _builder.newLine();
      {
        List<Message> _allMessages = RoomHelpers.getAllMessages(pc, (conj).booleanValue());
        for(final Message m : _allMessages) {
          String _name_3 = pc.getName();
          CharSequence _sendMessage = this.sendMessage(m, _name_3, portClassName, (conj).booleanValue());
          _builder.append(_sendMessage, "");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t");
      _builder.newLine();
      _builder.append("//------------------------------------------------------------------------------------------------------------");
      _builder.newLine();
      _builder.append("// ");
      {
        if ((conj).booleanValue()) {
          _builder.append("conjugated ");
        }
      }
      _builder.append("replicated port class");
      _builder.newLineIfNotEmpty();
      _builder.append("//------------------------------------------------------------------------------------------------------------");
      _builder.newLine();
      _builder.append(replPortClassName, "");
      _builder.append("::");
      _builder.append(replPortClassName, "");
      _builder.append("(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, std::vector<Address> addr, std::vector<Address> peerAddress) ");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append(": m_replication(addr.size()),");
      _builder.newLine();
      _builder.append("  \t  ");
      _builder.append("m_ports()");
      _builder.newLine();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("char numstr[10]; // enough to hold all numbers up to 32-bits");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("m_ports = reinterpret_cast<");
      _builder.append(portClassName, "	");
      _builder.append("*> (new char[sizeof(");
      _builder.append(portClassName, "	");
      _builder.append(") * addr.size()]);");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("for (int i = 0; i < m_replication; ++i) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("snprintf(numstr, sizeof(numstr), \"%d\", i);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("//placement new to avoid copy construction, therefore no vector is used");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("new  (&m_ports[i]) ");
      _builder.append(portClassName, "		");
      _builder.append("(actor, parent, name + numstr, localId, i, addr[i], peerAddress[i]);");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("};");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.newLine();
      _builder.append("// outgoing messages");
      _builder.newLine();
      {
        List<Message> _allMessages_1 = RoomHelpers.getAllMessages(pc, (conj).booleanValue());
        for(final Message m_1 : _allMessages_1) {
          CharSequence _messageSignatureDefinition = this.messageSignatureDefinition(m_1, replPortClassName);
          _builder.append(_messageSignatureDefinition, "");
          _builder.append("{");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("for (int i=0; i<m_replication; ++i) {");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("m_ports[i].");
          CharSequence _messageCall = this.messageCall(m_1);
          _builder.append(_messageCall, "		");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      }
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  public String generateConstructorInitalizerList(final PortClass pc, final String index) {
    ArrayList<CharSequence> _arrayList = new ArrayList<CharSequence>();
    ArrayList<CharSequence> initializerList = _arrayList;
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("PortBase(actor, parent, name, localId, ");
    _builder.append(index, "");
    _builder.append(", addr, peerAddress)");
    initializerList.add(_builder);
    boolean _notEquals = (!Objects.equal(pc, null));
    if (_notEquals) {
      EList<Attribute> _attributes = pc.getAttributes();
      for (final Attribute attrib : _attributes) {
        CharSequence _attributeInitialization = this._initialization.attributeInitialization(attrib, false);
        initializerList.add(_attributeInitialization);
      }
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _join = IterableExtensions.join(initializerList, ",\n");
    _builder_1.append(_join, "");
    _builder_1.newLineIfNotEmpty();
    return _builder_1.toString();
  }
  
  private CharSequence messageCall(final Message m) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = m.getName();
    _builder.append(_name, "");
    _builder.append("(");
    {
      VarDecl _data = m.getData();
      boolean _notEquals = (!Objects.equal(_data, null));
      if (_notEquals) {
        _builder.append(" ");
        VarDecl _data_1 = m.getData();
        String _name_1 = _data_1.getName();
        _builder.append(_name_1, "");
      }
    }
    _builder.append(")");
    return _builder;
  }
  
  private CharSequence generateDebugHelpersImplementation(final Root root, final ProtocolClass pc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("/* message names as strings for debugging (generate MSC) */");
    _builder.newLine();
    _builder.append("std::string ");
    String _name = pc.getName();
    _builder.append(_name, "");
    _builder.append("::s_messageStrings[] ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("= {\"MIN\", ");
    _builder.newLine();
    {
      List<Message> _allOutgoingMessages = RoomHelpers.getAllOutgoingMessages(pc);
      for(final Message m : _allOutgoingMessages) {
        _builder.append("\t\t   ");
        _builder.append("\"");
        String _name_1 = m.getName();
        _builder.append(_name_1, "		   ");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      List<Message> _allIncomingMessages = RoomHelpers.getAllIncomingMessages(pc);
      for(final Message m_1 : _allIncomingMessages) {
        _builder.append("\t\t   ");
        _builder.append("\"");
        String _name_2 = m_1.getName();
        _builder.append(_name_2, "		   ");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t   ");
    _builder.append("\"MAX\"};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("std::string ");
    String _name_3 = pc.getName();
    _builder.append(_name_3, "");
    _builder.append("::getMessageString(int msg_id) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if ((MSG_MIN < msg_id ) && ( msg_id < MSG_MAX )) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return s_messageStrings[msg_id];");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// id out of range");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return \"Message ID out of range\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence messageSignature(final Message m) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isPriv = m.isPriv();
      if (_isPriv) {
        _builder.append("private:");
      } else {
        _builder.append("public:");
      }
    }
    _builder.append(" void ");
    String _name = m.getName();
    _builder.append(_name, "");
    _builder.append("(");
    {
      VarDecl _data = m.getData();
      boolean _notEquals = (!Objects.equal(_data, null));
      if (_notEquals) {
        VarDecl _data_1 = m.getData();
        RefableType _refType = _data_1.getRefType();
        DataType _type = _refType.getType();
        String _typeName = this._typeHelpers.typeName(_type);
        _builder.append(_typeName, "");
        _builder.append(" ");
        VarDecl _data_2 = m.getData();
        String _name_1 = _data_2.getName();
        _builder.append(_name_1, "");
      }
    }
    _builder.append(")");
    return _builder;
  }
  
  public CharSequence messageSignatureExplicit(final Message m) {
    CharSequence _xblockexpression = null;
    {
      VarDecl _data = m.getData();
      RefableType _refType = _data.getRefType();
      DataType _type = _refType.getType();
      DataClass dc = ((DataClass) _type);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("public: void ");
      String _name = m.getName();
      _builder.append(_name, "");
      _builder.append("(");
      {
        DataClass _base = dc.getBase();
        boolean _notEquals = (!Objects.equal(_base, null));
        if (_notEquals) {
          DataClass _base_1 = dc.getBase();
          String _typeName = this._typeHelpers.typeName(_base_1);
          _builder.append(_typeName, "");
          _builder.append(" _super, ");
        }
      }
      {
        EList<Attribute> _attributes = dc.getAttributes();
        boolean _hasElements = false;
        for(final Attribute a : _attributes) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(", ", "");
          }
          RefableType _refType_1 = a.getRefType();
          DataType _type_1 = _refType_1.getType();
          String _typeName_1 = this._typeHelpers.typeName(_type_1);
          _builder.append(_typeName_1, "");
          {
            int _size = a.getSize();
            boolean _greaterThan = (_size > 1);
            if (_greaterThan) {
              _builder.append("[]");
            }
          }
          _builder.append(" ");
          String _name_1 = a.getName();
          _builder.append(_name_1, "");
        }
      }
      _builder.append(")");
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  public CharSequence messageSignatureDefinition(final Message m, final String classPrefix) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("void ");
    _builder.append(classPrefix, "");
    _builder.append("::");
    String _name = m.getName();
    _builder.append(_name, "");
    _builder.append("(");
    {
      VarDecl _data = m.getData();
      boolean _notEquals = (!Objects.equal(_data, null));
      if (_notEquals) {
        VarDecl _data_1 = m.getData();
        RefableType _refType = _data_1.getRefType();
        DataType _type = _refType.getType();
        String _typeName = this._typeHelpers.typeName(_type);
        _builder.append(_typeName, "");
        _builder.append(" ");
        VarDecl _data_2 = m.getData();
        String _name_1 = _data_2.getName();
        _builder.append(_name_1, "");
      }
    }
    _builder.append(")");
    return _builder;
  }
  
  public CharSequence messageSignatureExplicitDefinition(final Message m, final String classPrefix) {
    CharSequence _xblockexpression = null;
    {
      VarDecl _data = m.getData();
      RefableType _refType = _data.getRefType();
      DataType _type = _refType.getType();
      DataClass dc = ((DataClass) _type);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("void ");
      _builder.append(classPrefix, "");
      _builder.append("::");
      String _name = m.getName();
      _builder.append(_name, "");
      _builder.append("(");
      {
        DataClass _base = dc.getBase();
        boolean _notEquals = (!Objects.equal(_base, null));
        if (_notEquals) {
          DataClass _base_1 = dc.getBase();
          String _typeName = this._typeHelpers.typeName(_base_1);
          _builder.append(_typeName, "");
          _builder.append(" _super, ");
        }
      }
      {
        EList<Attribute> _attributes = dc.getAttributes();
        boolean _hasElements = false;
        for(final Attribute a : _attributes) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(", ", "");
          }
          RefableType _refType_1 = a.getRefType();
          DataType _type_1 = _refType_1.getType();
          String _typeName_1 = this._typeHelpers.typeName(_type_1);
          _builder.append(_typeName_1, "");
          {
            int _size = a.getSize();
            boolean _greaterThan = (_size > 1);
            if (_greaterThan) {
              _builder.append("[]");
            }
          }
          _builder.append(" ");
          String _name_1 = a.getName();
          _builder.append(_name_1, "");
        }
      }
      _builder.append(")");
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  public CharSequence sendMessageDeclaration(final Message m, final boolean conj) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageSignature = this.messageSignature(m);
    _builder.append(_messageSignature, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    {
      boolean _and = false;
      VarDecl _data = m.getData();
      boolean _notEquals = (!Objects.equal(_data, null));
      if (!_notEquals) {
        _and = false;
      } else {
        VarDecl _data_1 = m.getData();
        RefableType _refType = _data_1.getRefType();
        DataType _type = _refType.getType();
        _and = (_notEquals && (_type instanceof DataClass));
      }
      if (_and) {
        CharSequence _messageSignatureExplicit = this.messageSignatureExplicit(m);
        _builder.append(_messageSignatureExplicit, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence sendMessage(final Message m, final String portClassName, final String classPrefix, final boolean conj) {
    CharSequence _xblockexpression = null;
    {
      String _xifexpression = null;
      if (conj) {
        _xifexpression = "IN";
      } else {
        _xifexpression = "OUT";
      }
      String dir = _xifexpression;
      MessageHandler hdlr = this.roomExt.getSendHandler(m, conj);
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _messageSignatureDefinition = this.messageSignatureDefinition(m, classPrefix);
      _builder.append(_messageSignatureDefinition, "");
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      {
        boolean _notEquals = (!Objects.equal(hdlr, null));
        if (_notEquals) {
          _builder.append("\t");
          {
            DetailCode _detailCode = hdlr.getDetailCode();
            EList<String> _commands = _detailCode.getCommands();
            for(final String command : _commands) {
              _builder.append("\t");
              _builder.append(command, "	");
              _builder.newLineIfNotEmpty();
            }
          }
        } else {
          _builder.append("\t");
          _builder.append("DebuggingService::getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(),");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t   ");
          _builder.append(portClassName, "													   ");
          _builder.append("::getMessageString(");
          _builder.append(portClassName, "													   ");
          _builder.append("::");
          _builder.append(dir, "													   ");
          _builder.append("_");
          String _name = m.getName();
          _builder.append(_name, "													   ");
          _builder.append("));");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("if (getPeerAddress().isValid()){");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          {
            VarDecl _data = m.getData();
            boolean _equals = Objects.equal(_data, null);
            if (_equals) {
              _builder.append("getPeerMsgReceiver()->receive(new Message(getPeerAddress(), ");
              _builder.append(portClassName, "		");
              _builder.append("::");
              _builder.append(dir, "		");
              _builder.append("_");
              String _name_1 = m.getName();
              _builder.append(_name_1, "		");
              _builder.append("));");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
            } else {
              _builder.append("getPeerMsgReceiver()->receive(new Message(getPeerAddress(),");
              _builder.append(portClassName, "		");
              _builder.append("::");
              _builder.append(dir, "		");
              _builder.append("_");
              String _name_2 = m.getName();
              _builder.append(_name_2, "		");
              _builder.append(", ");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("                                                ");
              _builder.append("reinterpret_cast<void*>(");
              {
                boolean _and = false;
                VarDecl _data_1 = m.getData();
                RefableType _refType = _data_1.getRefType();
                boolean _isRef = _refType.isRef();
                boolean _not = (!_isRef);
                if (!_not) {
                  _and = false;
                } else {
                  VarDecl _data_2 = m.getData();
                  RefableType _refType_1 = _data_2.getRefType();
                  DataType _type = _refType_1.getType();
                  boolean _not_1 = (!(_type instanceof PrimitiveType));
                  _and = (_not && _not_1);
                }
                if (_and) {
                  _builder.append("&");
                }
              }
              VarDecl _data_3 = m.getData();
              String _name_3 = _data_3.getName();
              _builder.append(_name_3, "		                                                ");
              _builder.append("),");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("                                                ");
              _builder.append("sizeof(");
              VarDecl _data_4 = m.getData();
              RefableType _refType_2 = _data_4.getRefType();
              DataType _type_1 = _refType_2.getType();
              String _typeName = this._typeHelpers.typeName(_type_1);
              _builder.append(_typeName, "		                                                ");
              _builder.append(")));");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      {
        boolean _and_1 = false;
        VarDecl _data_5 = m.getData();
        boolean _notEquals_1 = (!Objects.equal(_data_5, null));
        if (!_notEquals_1) {
          _and_1 = false;
        } else {
          VarDecl _data_6 = m.getData();
          RefableType _refType_3 = _data_6.getRefType();
          DataType _type_2 = _refType_3.getType();
          _and_1 = (_notEquals_1 && (_type_2 instanceof DataClass));
        }
        if (_and_1) {
          CharSequence _messageSignatureExplicitDefinition = this.messageSignatureExplicitDefinition(m, classPrefix);
          _builder.append(_messageSignatureExplicitDefinition, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String _name_4 = m.getName();
          _builder.append(_name_4, "	");
          _builder.append("(");
          VarDecl _data_7 = m.getData();
          RefableType _refType_4 = _data_7.getRefType();
          DataType _type_3 = _refType_4.getType();
          String _name_5 = _type_3.getName();
          _builder.append(_name_5, "	");
          _builder.append("(");
          {
            VarDecl _data_8 = m.getData();
            RefableType _refType_5 = _data_8.getRefType();
            DataType _type_4 = _refType_5.getType();
            DataClass _base = ((DataClass) _type_4).getBase();
            boolean _notEquals_2 = (!Objects.equal(_base, null));
            if (_notEquals_2) {
              _builder.append("_super, ");
            }
          }
          {
            VarDecl _data_9 = m.getData();
            RefableType _refType_6 = _data_9.getRefType();
            DataType _type_5 = _refType_6.getType();
            EList<Attribute> _attributes = ((DataClass) _type_5).getAttributes();
            boolean _hasElements = false;
            for(final Attribute a : _attributes) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(", ", "	");
              }
              String _name_6 = a.getName();
              _builder.append(_name_6, "	");
            }
          }
          _builder.append("));");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
        }
      }
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  public String getMessageID(final Message msg, final InterfaceItem item) {
    if ((item instanceof Port)) {
      Port p = ((Port) item);
      String _xifexpression = null;
      boolean _isConjugated = p.isConjugated();
      if (_isConjugated) {
        _xifexpression = "OUT_";
      } else {
        _xifexpression = "IN_";
      }
      String direction = _xifexpression;
      GeneralProtocolClass _protocol = p.getProtocol();
      String _name = _protocol.getName();
      String _name_1 = msg.getName();
      String _plus = (direction + _name_1);
      return this.enumInUse(_name, _plus);
    } else {
      if ((item instanceof SAPRef)) {
        SAPRef sap = ((SAPRef) item);
        ProtocolClass _protocol_1 = sap.getProtocol();
        String _name_2 = _protocol_1.getName();
        String _name_3 = msg.getName();
        String _plus_1 = ("OUT_" + _name_3);
        return this.enumInUse(_name_2, _plus_1);
      } else {
        if ((item instanceof SPPRef)) {
          SPPRef spp = ((SPPRef) item);
          ProtocolClass _protocol_2 = spp.getProtocol();
          String _name_4 = _protocol_2.getName();
          String _name_5 = msg.getName();
          String _plus_2 = ("IN_" + _name_5);
          return this.enumInUse(_name_4, _plus_2);
        }
      }
    }
    return "unknown interface item";
  }
  
  public String enumInUse(final String namespace, final String member) {
    String _plus = (namespace + "::");
    return (_plus + member);
  }
}
