/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.eTMap.Import;
import org.eclipse.etrice.core.etmap.eTMap.MappingModel;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalModel;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.IResourceURIAcceptor;
import org.eclipse.etrice.generator.cpp.GeneratorOptions;
import org.eclipse.etrice.generator.cpp.gen.Validator;
import org.eclipse.etrice.generator.cpp.setup.GeneratorModule;
import org.eclipse.etrice.generator.doc.gen.MainGen;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;

public class Main
extends AbstractGenerator {
    public static final String OPTION_LIB = "-lib";
    public static final String OPTION_NOEXIT = "-noexit";
    public static final String OPTION_DOCUMENTATION = "-genDocu";
    public static final String OPTION_SAVE_GEN_MODEL = "-saveGenModel";
    public static final String OPTION_DEBUG = "-debug";
    public static final String OPTION_ETUNIT = "-etunit";
    @Inject
    private IGenerator mainGenerator;
    @Inject
    protected MainGen mainDocGenerator;
    @Inject
    private Validator validator;
    @Inject
    protected IDataConfiguration dataConfig;
    @Inject
    protected ImportUriResolver uriResolver;

    private static void printUsage() {
        output.println(String.valueOf(Main.class.getName()) + " [-saveGenModel <genmodel path>] [-genInstDiag] [-lib] <list of model file paths>");
        output.println("      <list of model file paths>        # model file paths may be specified as");
        output.println("                                        # e.g. C:\\path\\to\\model\\mymodel.room");
        output.println("      -saveGenModel <genmodel path>     # if specified the generator model will be saved to this location");
        output.println("      -genDocu                          # if specified documentation is created");
        output.println("      -lib                              # if specified all classes are generated and no instances");
        output.println("      -noexit                           # if specified the JVM is not exited");
        output.println("      -debug                            # if specified create debug output");
    }

    public static void main(String[] args) {
        int ret = Main.createAndRunGenerator((Module)new GeneratorModule(), (String[])args);
        if (Main.isTerminateOnError() && ret != 0) {
            System.exit(ret);
        }
    }

    public int runGenerator(String[] args) {
        if (args.length == 0) {
            this.logger.logError(String.valueOf(Main.class.getName()) + " - aborting: no arguments!", null);
            Main.printUsage();
            return 1;
        }
        String genModelPath = null;
        ArrayList<String> uriList = new ArrayList<String>();
        boolean genDocumentation = false;
        boolean asLibrary = false;
        boolean debug = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(OPTION_SAVE_GEN_MODEL)) {
                if (++i < args.length) {
                    genModelPath = String.valueOf(args[i]) + "/genmodel.egm";
                }
            } else if (args[i].equals(OPTION_DOCUMENTATION)) {
                genDocumentation = true;
            } else if (args[i].equals(OPTION_LIB)) {
                asLibrary = true;
            } else if (args[i].equals(OPTION_NOEXIT)) {
                Main.setTerminateOnError((boolean)false);
            } else if (args[i].equals(OPTION_DEBUG)) {
                debug = true;
            } else if (args[i].equals(OPTION_ETUNIT)) {
                GeneratorOptions.setUseEtUnit(true);
            } else {
                uriList.add(args[i]);
            }
            ++i;
        }
        this.setupRoomModel();
        this.dataConfig.doSetup();
        if (!this.runGenerator(uriList, genModelPath, genDocumentation, asLibrary, debug)) {
            return 1;
        }
        return 0;
    }

    protected boolean runGenerator(List<String> uriList, String genModelPath, boolean genDocumentation, boolean asLibrary, boolean debug) {
        if (!this.loadModels(uriList)) {
            return false;
        }
        if (!this.validateModels()) {
            return false;
        }
        if (!this.dataConfig.setResources(this.getResourceSet(), (ILogger)this.logger)) {
            return false;
        }
        Root genModel = this.createGeneratorModel(asLibrary, genModelPath);
        if (genModel == null) {
            return false;
        }
        if (!this.validator.validate(genModel)) {
            return false;
        }
        ETMapUtil.processModels((Root)genModel, (ResourceSet)this.getResourceSet());
        if (debug) {
            this.logger.logInfo("-- begin dump of mappings");
            this.logger.logInfo(ETMapUtil.dumpMappings());
            this.logger.logInfo("-- end dump of mappings");
        }
        this.logger.logInfo("-- starting code generation");
        this.fileAccess.setOutputPath("src-gen/");
        this.mainGenerator.doGenerate(genModel.eResource(), (IFileSystemAccess)this.fileAccess);
        if (genDocumentation) {
            this.mainDocGenerator.doGenerate(genModel);
        }
        if (this.diagnostician.isFailed()) {
            this.logger.logInfo("validation failed during build of generator model");
            this.logger.logError("-- terminating", null);
            return false;
        }
        this.logger.logInfo("-- finished code generation");
        return true;
    }

    protected void addReferencedModels(EObject root, IResourceURIAcceptor acceptor) {
        super.addReferencedModels(root, acceptor);
        if (root instanceof PhysicalModel) {
            for (org.eclipse.etrice.core.etphys.eTPhys.Import imp : ((PhysicalModel)root).getImports()) {
                String importURI = this.uriResolver.resolve((EObject)imp);
                acceptor.addResourceURI(importURI);
            }
        } else if (root instanceof MappingModel) {
            for (Import imp : ((MappingModel)root).getImports()) {
                String importURI = this.uriResolver.resolve((EObject)imp);
                acceptor.addResourceURI(importURI);
            }
        } else {
            this.dataConfig.addReferencedModels(acceptor, root);
        }
    }
}

