/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ComplexType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.cpp.GeneratorOptions;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class DataClassGen {
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private CppExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    @Extension
    private TypeHelpers typeHelpers;
    @Inject
    @Extension
    private Initialization _initialization;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        this.logger.logInfo("generating code");
        EList _usedDataClasses = root.getUsedDataClasses();
        for (DataClass dc : _usedDataClasses) {
            String _generationTargetPath = this.roomExt.getGenerationTargetPath((EObject)dc);
            String _path = this.roomExt.getPath((RoomClass)dc);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)dc);
            String _plus = "generating DataClass header '" + _cppHeaderFileName;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            String _cppHeaderFileName_1 = this.stdExt.getCppHeaderFileName((RoomClass)dc);
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, dc);
            this.fileAccess.generateFile(_cppHeaderFileName_1, _generateHeaderFile);
            String _cppSourceFileName = this.stdExt.getCppSourceFileName((RoomClass)dc);
            String _plus_4 = "generating DataClass source '" + _cppSourceFileName;
            String _plus_5 = String.valueOf(_plus_4) + "' in '";
            String _plus_6 = String.valueOf(_plus_5) + path;
            String _plus_7 = String.valueOf(_plus_6) + "'";
            this.logger.logInfo(_plus_7);
            this.fileAccess.setOutputPath(path);
            String _cppSourceFileName_1 = this.stdExt.getCppSourceFileName((RoomClass)dc);
            CharSequence _generateSourceFile = this.generateSourceFile(root, dc);
            this.fileAccess.generateFile(_cppSourceFileName_1, _generateSourceFile);
        }
    }

    public CharSequence generateHeaderFile(Root root, DataClass dc) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        EList _operations = dc.getOperations();
        Functions.Function1<StandardOperation, Boolean> _function = new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation op) {
                boolean _isConstructor = RoomHelpers.isConstructor((Operation)op);
                return _isConstructor;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_operations, (Functions.Function1)_function);
        StandardOperation ctor = (StandardOperation)IterableExtensions.head((Iterable)_filter);
        EList _operations_1 = dc.getOperations();
        Functions.Function1<StandardOperation, Boolean> _function_1 = new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation op) {
                boolean _isDestructor = op.isDestructor();
                return _isDestructor;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_operations_1, (Functions.Function1)_function_1);
        StandardOperation dtor = (StandardOperation)IterableExtensions.head((Iterable)_filter_1);
        StringConcatenation _builder = new StringConcatenation();
        String _path = this.roomExt.getPath((RoomClass)dc);
        String _name = dc.getName();
        String _plus = String.valueOf(_path) + _name;
        CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin(_plus);
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        DataClass _base = dc.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            _builder.append((Object)"#include \"");
            DataClass _base_1 = dc.getBase();
            String _path_1 = this.roomExt.getPath((RoomClass)_base_1);
            _builder.append((Object)_path_1, "");
            DataClass _base_2 = dc.getBase();
            String _name_1 = _base_2.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)dc);
        for (DataClass classes : _referencedDataClasses) {
            _builder.append((Object)"#include \"");
            String _path_2 = this.roomExt.getPath((RoomClass)classes);
            _builder.append((Object)_path_2, "");
            String _name_2 = classes.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        EList models = root.getReferencedModels((RoomClass)dc);
        _builder.newLineIfNotEmpty();
        for (RoomModel model : models) {
            EList _dataClasses = model.getDataClasses();
            for (DataClass classes_1 : _dataClasses) {
                _builder.append((Object)"#include \"");
                String _path_3 = this.roomExt.getPath((RoomClass)classes_1);
                _builder.append((Object)_path_3, "");
                String _name_3 = classes_1.getName();
                _builder.append((Object)_name_3, "");
                _builder.append((Object)".h\"");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        DetailCode _userCode1 = dc.getUserCode1();
        CharSequence _userCode = this.helpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"class ");
        String _name_4 = dc.getName();
        _builder.append((Object)_name_4, "");
        DataClass _base_3 = dc.getBase();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_base_3, null);
        if (_notEquals_1) {
            _builder.append((Object)" : public ");
            DataClass _base_4 = dc.getBase();
            String _name_5 = _base_4.getName();
            _builder.append((Object)_name_5, "");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t");
        DetailCode _userCode2 = dc.getUserCode2();
        CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _attributes = dc.getAttributes();
        CharSequence _attributes_1 = this.helpers.attributes((List)_attributes);
        _builder.append((Object)_attributes_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _attributes_2 = dc.getAttributes();
        String _name_6 = dc.getName();
        CharSequence _attributeSettersGettersImplementation = this.helpers.attributeSettersGettersImplementation((List)_attributes_2, _name_6);
        _builder.append((Object)_attributeSettersGettersImplementation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _operations_2 = dc.getOperations();
        String _name_7 = dc.getName();
        CharSequence _operationsDeclaration = this.helpers.operationsDeclaration((List)_operations_2, _name_7);
        _builder.append((Object)_operationsDeclaration, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// default constructor, copy constructor and assignment operator");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_8 = dc.getName();
        _builder.append((Object)_name_8, "\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _name_9 = dc.getName();
        _builder.append((Object)_name_9, "\t");
        _builder.append((Object)"(const ");
        String _name_10 = dc.getName();
        _builder.append((Object)_name_10, "\t");
        _builder.append((Object)"& rhs);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _name_11 = dc.getName();
        _builder.append((Object)_name_11, "\t");
        _builder.append((Object)"& operator=(const ");
        String _name_12 = dc.getName();
        _builder.append((Object)_name_12, "\t");
        _builder.append((Object)"& rhs);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// constructor using fields");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_13 = dc.getName();
        _builder.append((Object)_name_13, "\t");
        _builder.append((Object)"(");
        String _argList = this.argList(dc);
        _builder.append((Object)_argList, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        DataClass _base_5 = dc.getBase();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_base_5, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// constructor using base class constructor");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _name_14 = dc.getName();
            _builder.append((Object)_name_14, "\t");
            _builder.append((Object)"(");
            DataClass _base_6 = dc.getBase();
            String _name_15 = _base_6.getName();
            _builder.append((Object)_name_15, "\t");
            _builder.append((Object)" _super, ");
            EList _attributes_3 = dc.getAttributes();
            CharSequence _argListConstructor = this.argListConstructor((List<Attribute>)_attributes_3);
            String _string = _argListConstructor.toString();
            _builder.append((Object)_string, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        String _name_16 = dc.getName();
        CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd(_name_16);
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateSourceFile(Root root, DataClass dc) {
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        EList _operations = dc.getOperations();
        Functions.Function1<StandardOperation, Boolean> _function = new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation op) {
                boolean _isConstructor = RoomHelpers.isConstructor((Operation)op);
                return _isConstructor;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_operations, (Functions.Function1)_function);
        StandardOperation ctor = (StandardOperation)IterableExtensions.head((Iterable)_filter);
        EList _operations_1 = dc.getOperations();
        Functions.Function1<StandardOperation, Boolean> _function_1 = new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation op) {
                boolean _isDestructor = op.isDestructor();
                return _isDestructor;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_operations_1, (Functions.Function1)_function_1);
        StandardOperation dtor = (StandardOperation)IterableExtensions.head((Iterable)_filter_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of DataClass ");
        String _name = dc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)dc);
        _builder.append((Object)_cppHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        boolean _isUseEtUnit = GeneratorOptions.isUseEtUnit();
        if (_isUseEtUnit) {
            _builder.append((Object)"extern \"C\" {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"#include \"etUnit.h\"");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        DetailCode _userCode3 = dc.getUserCode3();
        CharSequence _userCode = this.helpers.userCode(_userCode3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// default constructor");
        _builder.newLine();
        String _name_1 = dc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"::");
        String _name_2 = dc.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"() ");
        _builder.newLineIfNotEmpty();
        DataClass _base = dc.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            _builder.append((Object)":");
            DataClass _base_1 = dc.getBase();
            String _name_3 = _base_1.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)"()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _attributes = dc.getAttributes();
        CharSequence _attributeInitialization = this._initialization.attributeInitialization((List<Attribute>)_attributes, false);
        _builder.append((Object)_attributeInitialization, "\t");
        _builder.newLineIfNotEmpty();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)ctor, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"// user defined constructor body");
            _builder.newLine();
            DetailCode _detailCode = ctor.getDetailCode();
            EList _commands = _detailCode.getCommands();
            for (String l : _commands) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)l, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"// copy constructor");
        _builder.newLine();
        String _name_4 = dc.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)"::");
        String _name_5 = dc.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)"(const ");
        String _name_6 = dc.getName();
        _builder.append((Object)_name_6, "");
        _builder.append((Object)"& rhs)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)":");
        _builder.newLine();
        DataClass _base_2 = dc.getBase();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_base_2, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t");
            DataClass _base_3 = dc.getBase();
            String _name_7 = _base_3.getName();
            _builder.append((Object)_name_7, "\t");
            _builder.append((Object)"(rhs),");
            _builder.newLineIfNotEmpty();
        }
        EList _attributes_1 = dc.getAttributes();
        boolean _hasElements = false;
        for (Attribute a : _attributes_1) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            String _name_8 = a.getName();
            _builder.append((Object)_name_8, "\t");
            _builder.append((Object)"(rhs.");
            String _name_9 = a.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)")");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// constructor using fields");
        _builder.newLine();
        String _name_10 = dc.getName();
        _builder.append((Object)_name_10, "");
        _builder.append((Object)"::");
        String _name_11 = dc.getName();
        _builder.append((Object)_name_11, "");
        _builder.append((Object)"(");
        String _argList = this.argList(dc);
        _builder.append((Object)_argList, "");
        _builder.append((Object)") ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)":");
        _builder.newLine();
        DataClass _base_4 = dc.getBase();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_base_4, null);
        if (_notEquals_3) {
            _builder.append((Object)"\t");
            DataClass _base_5 = dc.getBase();
            String _name_12 = _base_5.getName();
            _builder.append((Object)_name_12, "\t");
            _builder.append((Object)"(");
            DataClass _base_6 = dc.getBase();
            String _paramList = this.paramList(_base_6);
            _builder.append((Object)_paramList, "\t");
            _builder.append((Object)"),");
            _builder.newLineIfNotEmpty();
        }
        EList _attributes_2 = dc.getAttributes();
        boolean _hasElements_1 = false;
        for (Attribute a_1 : _attributes_2) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            String _name_13 = a_1.getName();
            _builder.append((Object)_name_13, "\t");
            _builder.append((Object)"(");
            String _name_14 = a_1.getName();
            _builder.append((Object)_name_14, "\t");
            _builder.append((Object)"_)");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        DataClass _base_7 = dc.getBase();
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_base_7, null);
        if (_notEquals_4) {
            _builder.append((Object)"// constructor using base class constructor");
            _builder.newLine();
            String _name_15 = dc.getName();
            _builder.append((Object)_name_15, "");
            _builder.append((Object)"::");
            String _name_16 = dc.getName();
            _builder.append((Object)_name_16, "");
            _builder.append((Object)"(");
            DataClass _base_8 = dc.getBase();
            String _name_17 = _base_8.getName();
            _builder.append((Object)_name_17, "");
            _builder.append((Object)" _super, ");
            EList _attributes_3 = dc.getAttributes();
            CharSequence _argListConstructor = this.argListConstructor((List<Attribute>)_attributes_3);
            String _string = _argListConstructor.toString();
            _builder.append((Object)_string, "");
            _builder.append((Object)")");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)":");
            _builder.newLine();
            _builder.append((Object)"\t");
            DataClass _base_9 = dc.getBase();
            String _name_18 = _base_9.getName();
            _builder.append((Object)_name_18, "\t");
            _builder.append((Object)"(_super),");
            _builder.newLineIfNotEmpty();
            EList _attributes_4 = dc.getAttributes();
            boolean _hasElements_2 = false;
            for (Attribute a_2 : _attributes_4) {
                if (!_hasElements_2) {
                    _hasElements_2 = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append((Object)"\t");
                String _name_19 = a_2.getName();
                _builder.append((Object)_name_19, "\t");
                _builder.append((Object)"(");
                String _name_20 = a_2.getName();
                _builder.append((Object)_name_20, "\t");
                _builder.append((Object)"_)");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"// assignment operator");
        _builder.newLine();
        String _name_21 = dc.getName();
        _builder.append((Object)_name_21, "");
        _builder.append((Object)"& ");
        String _name_22 = dc.getName();
        _builder.append((Object)_name_22, "");
        _builder.append((Object)"::operator=(const ");
        String _name_23 = dc.getName();
        _builder.append((Object)_name_23, "");
        _builder.append((Object)"& rhs)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (this == &rhs) { return *this; };");
        _builder.newLine();
        DataClass _base_10 = dc.getBase();
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)_base_10, null);
        if (_notEquals_5) {
            _builder.append((Object)"\t");
            DataClass _base_11 = dc.getBase();
            String _name_24 = _base_11.getName();
            _builder.append((Object)_name_24, "\t");
            _builder.append((Object)"::operator=(rhs);");
            _builder.newLineIfNotEmpty();
        }
        EList _attributes_5 = dc.getAttributes();
        for (Attribute a_3 : _attributes_5) {
            _builder.append((Object)"\t");
            String _name_25 = a_3.getName();
            _builder.append((Object)_name_25, "\t");
            _builder.append((Object)"= rhs.");
            String _name_26 = a_3.getName();
            _builder.append((Object)_name_26, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return *this;");
        _builder.newLine();
        _builder.append((Object)"}\t\t\t");
        _builder.newLine();
        _builder.newLine();
        EList _operations_2 = dc.getOperations();
        String _name_27 = dc.getName();
        CharSequence _operationsImplementation = this.helpers.operationsImplementation((List)_operations_2, _name_27);
        _builder.append((Object)_operationsImplementation, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String paramList(DataClass _dc) {
        boolean _notEquals;
        String result = "";
        DataClass dc = _dc;
        boolean _while = _notEquals = !Objects.equal((Object)dc, null);
        while (_while) {
            boolean _notEquals_1;
            boolean _notEquals_12;
            String _plus;
            EList _attributes = dc.getAttributes();
            CharSequence _paramList = this.paramList((List<Attribute>)_attributes);
            String _string = _paramList.toString();
            result = _plus = String.valueOf(_string) + result;
            DataClass _base = dc.getBase();
            boolean bl = _notEquals_12 = !Objects.equal((Object)(dc = _base), null);
            if (_notEquals_12) {
                String _plus_1;
                result = _plus_1 = ", " + result;
            }
            _while = _notEquals_1 = !Objects.equal((Object)dc, null);
        }
        return result;
    }

    public CharSequence paramList(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : attributes) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name = a.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_");
        }
        return _builder;
    }

    public String argList(DataClass _dc) {
        boolean _notEquals;
        String result = "";
        DataClass dc = _dc;
        boolean _while = _notEquals = !Objects.equal((Object)dc, null);
        while (_while) {
            boolean _notEquals_1;
            boolean _notEquals_12;
            String _plus;
            EList _attributes = dc.getAttributes();
            CharSequence _argListConstructor = this.argListConstructor((List<Attribute>)_attributes);
            String _string = _argListConstructor.toString();
            result = _plus = String.valueOf(_string) + result;
            DataClass _base = dc.getBase();
            boolean bl = _notEquals_12 = !Objects.equal((Object)(dc = _base), null);
            if (_notEquals_12) {
                String _plus_1;
                result = _plus_1 = ", " + result;
            }
            _while = _notEquals_1 = !Objects.equal((Object)dc, null);
        }
        return result;
    }

    public CharSequence argListConstructor(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : attributes) {
            boolean _greaterThan;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            RefableType _refType = a.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this.typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            int _size = a.getSize();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                _builder.append((Object)"[]");
            }
            _builder.append((Object)" ");
            String _name = a.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_");
        }
        return _builder;
    }

    public String deepCopy(DataClass _dc) {
        boolean _notEquals;
        String result = "";
        DataClass dc = _dc;
        boolean _while = _notEquals = !Objects.equal((Object)dc, null);
        while (_while) {
            boolean _notEquals_1;
            String _plus;
            EList _attributes = dc.getAttributes();
            CharSequence _deepCopy = this.deepCopy((List<Attribute>)_attributes);
            String _string = _deepCopy.toString();
            result = _plus = String.valueOf(_string) + result;
            DataClass _base = dc.getBase();
            _while = _notEquals_1 = !Objects.equal((Object)(dc = _base), null);
        }
        return result;
    }

    public CharSequence deepCopy(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        for (Attribute a : attributes) {
            boolean _equals_1;
            RefableType _refType = a.getRefType();
            DataType _type = _refType.getType();
            if (_type instanceof ComplexType) {
                boolean _equals;
                _builder.append((Object)"if (");
                String _name = a.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"!=null) {");
                _builder.newLineIfNotEmpty();
                int _size = a.getSize();
                boolean bl = _equals = _size == 0;
                if (_equals) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"copy.");
                    String _name_1 = a.getName();
                    _builder.append((Object)_name_1, "\t");
                    _builder.append((Object)" = ");
                    String _name_2 = a.getName();
                    _builder.append((Object)_name_2, "\t");
                    _builder.append((Object)".deepCopy();");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"for (int i=0;i<");
                    String _name_3 = a.getName();
                    _builder.append((Object)_name_3, "\t");
                    _builder.append((Object)".length;i++){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"copy.");
                    String _name_4 = a.getName();
                    _builder.append((Object)_name_4, "\t\t");
                    _builder.append((Object)"[i] = ");
                    String _name_5 = a.getName();
                    _builder.append((Object)_name_5, "\t\t");
                    _builder.append((Object)"[i].deepCopy();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.append((Object)"}");
                _builder.newLine();
                continue;
            }
            int _size_1 = a.getSize();
            boolean bl = _equals_1 = _size_1 == 0;
            if (_equals_1) {
                _builder.append((Object)"copy.");
                String _name_6 = a.getName();
                _builder.append((Object)_name_6, "");
                _builder.append((Object)" = ");
                String _name_7 = a.getName();
                _builder.append((Object)_name_7, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"for (int i=0;i<");
            String _name_8 = a.getName();
            _builder.append((Object)_name_8, "");
            _builder.append((Object)".length;i++){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"copy.");
            String _name_9 = a.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)"[i] = ");
            String _name_10 = a.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)"[i];");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }
}

