/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.IRoomGenerator;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class InstanceDiagramGen
implements IRoomGenerator {
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _models = root.getModels();
        for (RoomModel model : _models) {
            String _docGenerationTargetPath = this.roomExt.getDocGenerationTargetPath((EObject)model);
            String path = String.valueOf(_docGenerationTargetPath) + "/images";
            this.fileAccess.setOutputPath(path);
            String batchFile = "dot2jpg.bat";
            EList _systemInstances = root.getSystemInstances();
            for (SystemInstance sys : _systemInstances) {
                String _name = sys.getName();
                String file = String.valueOf(_name) + "_instanceTree.dot";
                String _plus = "generating instance tree diagram: '" + file;
                String _plus_1 = String.valueOf(_plus) + "' in '";
                String _plus_2 = String.valueOf(_plus_1) + path;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                this.logger.logInfo(_plus_3);
                CharSequence _generate = this.generate(root, sys);
                this.fileAccess.generateFile(file, _generate);
            }
            CharSequence _generate2jpg = this.generate2jpg(root);
            this.fileAccess.generateFile(batchFile, _generate2jpg);
            this.runDot2Jpg(path, batchFile);
        }
    }

    public CharSequence generate2jpg(Root root) {
        StringConcatenation _builder = new StringConcatenation();
        EList _systemInstances = root.getSystemInstances();
        for (SystemInstance sys : _systemInstances) {
            _builder.append((Object)"dot -Tjpg -o ");
            String _name = sys.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_instanceTree.jpg ");
            String _name_1 = sys.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"_instanceTree.dot");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generate(Root root, SystemInstance sys) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"digraph ");
        String _name = sys.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"rankdir=TD;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"node [shape=box];");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _path = sys.getPath();
        String _pathName = this.roomExt.getPathName(_path);
        _builder.append((Object)_pathName, "\t");
        _builder.append((Object)" [label=\"");
        String _name_1 = sys.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)"\\n(");
        String _name_2 = sys.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)")\" style=filled color=red];");
        _builder.newLineIfNotEmpty();
        EList _instances = sys.getInstances();
        for (SubSystemInstance ssi : _instances) {
            _builder.append((Object)"\t");
            String _path_1 = ssi.getPath();
            String _pathName_1 = this.roomExt.getPathName(_path_1);
            _builder.append((Object)_pathName_1, "\t");
            _builder.append((Object)" [label=\"");
            String _name_3 = ssi.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)"\\n(");
            SubSystemClass _subSystemClass = ssi.getSubSystemClass();
            String _name_4 = _subSystemClass.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)")\" style=filled color=yellow];");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _path_2 = sys.getPath();
            String _pathName_2 = this.roomExt.getPathName(_path_2);
            _builder.append((Object)_pathName_2, "\t");
            _builder.append((Object)" -> ");
            String _path_3 = ssi.getPath();
            String _pathName_3 = this.roomExt.getPathName(_path_3);
            _builder.append((Object)_pathName_3, "\t");
            _builder.append((Object)";  ");
            _builder.newLineIfNotEmpty();
            EList _instances_1 = ssi.getInstances();
            for (ActorInstance ai : _instances_1) {
                _builder.append((Object)"\t");
                String _instance = this.instance(ai);
                _builder.append((Object)_instance, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public String instance(ActorInstance ai) {
        String _name_1;
        String _name;
        String _xblockexpression = null;
        EObject _eContainer = ai.eContainer();
        StructureInstance parent = (StructureInstance)_eContainer;
        PhysicalThread pthread = ETMapUtil.getPhysicalThread((ActorInstance)ai);
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)pthread, null);
        _xifexpression = _equals ? "?" : (_name = pthread.getName());
        String tname = _xifexpression;
        NodeRef node = ETMapUtil.getNodeRef((StructureInstance)ai);
        String _xifexpression_1 = null;
        boolean _equals_1 = Objects.equal((Object)node, null);
        _xifexpression_1 = _equals_1 ? "?" : (_name_1 = node.getName());
        String nname = _xifexpression_1;
        StringConcatenation _builder = new StringConcatenation();
        String _path = ai.getPath();
        String _pathName = this.roomExt.getPathName(_path);
        _builder.append((Object)_pathName, "");
        _builder.append((Object)" [label=\"");
        String _name_2 = ai.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"\\n(");
        ActorClass _actorClass = ai.getActorClass();
        String _name_3 = _actorClass.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)")\\n@");
        _builder.append((Object)nname, "");
        _builder.append((Object)":");
        _builder.append((Object)tname, "");
        _builder.append((Object)"\"];");
        _builder.newLineIfNotEmpty();
        String _path_1 = parent.getPath();
        String _pathName_1 = this.roomExt.getPathName(_path_1);
        _builder.append((Object)_pathName_1, "");
        _builder.append((Object)" -> ");
        String _path_2 = ai.getPath();
        String _pathName_2 = this.roomExt.getPathName(_path_2);
        _builder.append((Object)_pathName_2, "");
        _builder.append((Object)";  ");
        _builder.newLineIfNotEmpty();
        EList _instances = ai.getInstances();
        for (ActorInstance sub_ai : _instances) {
            String _instance = this.instance(sub_ai);
            _builder.append((Object)_instance, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public void runDot2Jpg(String path, String bat) {
        File _file;
        File wdir = _file = new File(path);
        try {
            Runtime _runtime = Runtime.getRuntime();
            String _plus = "cmd /C " + bat;
            Process p = _runtime.exec(_plus, null, wdir);
            String _plus_1 = String.valueOf(bat) + " finished with ";
            int _waitFor = p.waitFor();
            String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_waitFor);
            this.logger.logInfo(_plus_2);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

