/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.RoomStandaloneSetup;
import org.eclipse.etrice.core.genmodel.SetupGenmodel;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilder;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Import;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.scoping.PlatformRelativeUriResolver;
import org.eclipse.etrice.generator.base.DetailCodeTranslator;
import org.eclipse.etrice.generator.base.ILineOutput;
import org.eclipse.etrice.generator.base.ILineOutputLogger;
import org.eclipse.etrice.generator.base.IResourceURIAcceptor;
import org.eclipse.etrice.generator.base.ITranslationProvider;
import org.eclipse.etrice.generator.base.StdLineOutput;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public abstract class AbstractGenerator
implements IResourceURIAcceptor {
    public static final int GENERATOR_OK = 0;
    public static final int GENERATOR_ERROR = 1;
    private static boolean terminateOnError = true;
    private static AbstractGenerator instance = null;
    protected static ILineOutput output = new StdLineOutput();
    private static Injector injector;
    private HashMap<DetailCode, String> detailcode2string = new HashMap();
    private ResourceSet resourceSet;
    private HashSet<URI> modelURIs = new HashSet();
    private HashSet<URI> loadedModelURIs = new HashSet();
    @Inject
    protected Provider<ResourceSet> resourceSetProvider;
    @Inject
    protected ILineOutputLogger logger;
    @Inject
    protected IDiagnostician diagnostician;
    @Inject
    protected JavaIoFileSystemAccess fileAccess;
    @Inject
    protected PlatformRelativeUriResolver uriResolver;
    @Inject
    protected ITranslationProvider translationProvider;
    protected IResourceValidator validator;

    public static void setTerminateOnError(boolean terminateOnError) {
        AbstractGenerator.terminateOnError = terminateOnError;
    }

    public static boolean isTerminateOnError() {
        return terminateOnError;
    }

    public static void setOutput(ILineOutput out) {
        if (out != null) {
            output = out;
        }
    }

    public static AbstractGenerator getInstance() {
        return instance;
    }

    protected AbstractGenerator() {
        instance = this;
    }

    protected static int createAndRunGenerator(Module generatorModule, String[] args) {
        injector = Guice.createInjector((Module[])new Module[]{generatorModule});
        AbstractGenerator generator = (AbstractGenerator)injector.getInstance(AbstractGenerator.class);
        generator.logger.setOutput(output);
        return generator.runGenerator(args);
    }

    public static Injector getInjector() {
        return injector;
    }

    protected ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void setupRoomModel() {
        Injector roomInjector = EMFPlugin.IS_ECLIPSE_RUNNING ? new RoomStandaloneSetup().createInjector() : new RoomStandaloneSetup().createInjectorAndDoEMFRegistration();
        this.validator = (IResourceValidator)roomInjector.getInstance(IResourceValidator.class);
        SetupGenmodel.doSetup();
    }

    protected Root createGeneratorModel(boolean asLibrary, String genModelPath) {
        ArrayList<RoomModel> rml = new ArrayList<RoomModel>();
        for (Resource resource : this.resourceSet.getResources()) {
            EList contents = resource.getContents();
            if (contents.isEmpty() || !(contents.get(0) instanceof RoomModel)) continue;
            rml.add((RoomModel)contents.get(0));
        }
        if (rml.isEmpty()) {
            this.logger.logError("no ROOM models found", null);
            this.logger.logError("-- terminating", null);
            return null;
        }
        this.logger.logInfo("-- creating generator model");
        GeneratorModelBuilder gmb = new GeneratorModelBuilder((ILogger)this.logger, this.diagnostician);
        Root gmRoot = gmb.createGeneratorModel(rml, asLibrary);
        if (this.diagnostician.isFailed()) {
            this.logger.logError("validation failed during build of generator model", null);
            this.logger.logError("-- terminating", null);
            return null;
        }
        this.translateDetailCodes(gmRoot);
        URI genModelURI = genModelPath != null ? URI.createFileURI((String)genModelPath) : URI.createFileURI((String)"tmp.rim");
        Resource genResource = this.resourceSet.createResource(genModelURI);
        genResource.getContents().add((Object)gmRoot);
        if (genModelPath != null) {
            try {
                this.logger.logInfo("saving genmodel to " + genModelPath);
                genResource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                this.logger.logError(e.getMessage(), null);
                this.logger.logError("-- terminating", null);
                return null;
            }
        }
        return gmRoot;
    }

    protected boolean validateModels() {
        this.logger.logInfo("-- validating models");
        int errors = 0;
        int warnings = 0;
        ArrayList resources = new ArrayList(this.resourceSet.getResources());
        for (Resource resource : resources) {
            List list = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            if (list.isEmpty()) continue;
            for (Issue issue : list) {
                if (issue.getSeverity() == Severity.ERROR) {
                    ++errors;
                    this.logger.logError(issue.toString(), null);
                    continue;
                }
                ++warnings;
                this.logger.logInfo(issue.toString());
            }
        }
        this.logger.logInfo("validation finished with " + errors + " errors and " + warnings + " warnings");
        if (errors > 0) {
            this.logger.logError("-- terminating", null);
            return false;
        }
        return true;
    }

    protected boolean loadModel(URI uri) throws RuntimeException, IOException {
        if (this.loadedModelURIs.contains(uri)) {
            return true;
        }
        if (this.resourceSet.getResource(uri, false) != null) {
            return false;
        }
        this.logger.logInfo("Loading " + uri);
        this.resourceSet.getResource(uri, true);
        this.loadedModelURIs.add(uri);
        return true;
    }

    protected boolean loadModels(List<String> uriList) {
        this.logger.logInfo("-- reading models");
        this.resourceSet = (ResourceSet)this.resourceSetProvider.get();
        this.modelURIs.clear();
        this.loadedModelURIs.clear();
        for (String uri : uriList) {
            this.addResourceURI(uri);
        }
        boolean ok = true;
        while (!this.modelURIs.isEmpty()) {
            URI uri = this.modelURIs.iterator().next();
            try {
                if (this.loadModel(uri)) {
                    Resource resource = (Resource)this.resourceSet.getResources().get(this.resourceSet.getResources().size() - 1);
                    for (EObject root : resource.getContents()) {
                        this.addReferencedModels(root, this);
                    }
                }
            }
            catch (Exception e) {
                ok = false;
                if (e instanceof IllegalArgumentException) {
                    this.logger.logError(e.getMessage(), null);
                }
                this.logger.logError("couldn't load '" + uri + "'", null);
            }
            this.modelURIs.remove(uri);
        }
        ArrayList resources = new ArrayList(this.resourceSet.getResources());
        for (Resource res : resources) {
            EcoreUtil2.resolveAll((Resource)res, (CancelIndicator)CancelIndicator.NullImpl);
        }
        return ok;
    }

    protected void addReferencedModels(EObject root, IResourceURIAcceptor acceptor) {
        if (root instanceof RoomModel) {
            for (Import imp : ((RoomModel)root).getImports()) {
                String importURI = this.uriResolver.resolve((EObject)imp);
                acceptor.addResourceURI(importURI);
            }
        }
    }

    protected void translateDetailCodes(Root gmRoot) {
        DetailCodeTranslator dct;
        for (ExpandedActorClass xpac : gmRoot.getXpActorClasses()) {
            dct = new DetailCodeTranslator(xpac.getActorClass(), this.translationProvider);
            this.translateDetailCodesOfTree((EObject)xpac.getActorClass(), dct);
            this.translateDetailCodesOfTree((EObject)xpac.getStateMachine(), dct);
        }
        for (DataClass dc : gmRoot.getUsedDataClasses()) {
            dct = new DetailCodeTranslator(dc, this.translationProvider);
            this.translateDetailCodesOfTree((EObject)dc, dct);
        }
        for (ProtocolClass pc : gmRoot.getUsedProtocolClasses()) {
            if (pc.getConjugate() != null) {
                dct = new DetailCodeTranslator(pc.getConjugate(), this.translationProvider);
                this.translateDetailCodesOfTree((EObject)pc.getConjugate(), dct);
            }
            if (pc.getRegular() != null) {
                dct = new DetailCodeTranslator(pc.getRegular(), this.translationProvider);
                this.translateDetailCodesOfTree((EObject)pc.getRegular(), dct);
            }
            dct = new DetailCodeTranslator(pc, this.translationProvider);
            this.translateDetailCodesOfTree((EObject)pc.getUserCode1(), dct);
            this.translateDetailCodesOfTree((EObject)pc.getUserCode2(), dct);
            this.translateDetailCodesOfTree((EObject)pc.getUserCode3(), dct);
        }
    }

    protected void translateDetailCodesOfTree(EObject container, DetailCodeTranslator dct) {
        if (container == null) {
            return;
        }
        if (container instanceof DetailCode) {
            DetailCode dc = (DetailCode)container;
            this.detailcode2string.put(dc, dct.translateDetailCode(dc));
            return;
        }
        TreeIterator it = container.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof DetailCode)) continue;
            DetailCode dc = (DetailCode)obj;
            this.detailcode2string.put(dc, dct.translateDetailCode(dc));
        }
    }

    public String getTranslatedCode(DetailCode dc) {
        String code = this.detailcode2string.get(dc);
        if (code == null) {
            return "";
        }
        return code;
    }

    protected abstract int runGenerator(String[] var1);

    @Override
    public boolean addResourceURI(String uri) {
        URI can;
        block6: {
            try {
                can = AbstractGenerator.getCanonicalFileURI(uri);
                if (!this.loadedModelURIs.contains(can)) break block6;
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        boolean added = this.modelURIs.add(can);
        if (added) {
            if (this.loadedModelURIs.isEmpty()) {
                this.logger.logInfo("added model " + uri);
            } else {
                this.logger.logInfo("added referenced model " + uri);
            }
        }
        return added;
    }

    private static URI getCanonicalFileURI(String uriString) throws IOException {
        URI uri = uriString.startsWith("file:/") ? URI.createURI((String)uriString) : URI.createFileURI((String)uriString);
        String can = uri.toFileString();
        File f = new File(can);
        can = f.getCanonicalPath();
        return URI.createFileURI((String)can);
    }
}

