/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.ITranslationProvider;

public class DetailCodeTranslator {
    private static final String ATTR_SET = ".set";
    private ITranslationProvider provider;
    private HashMap<String, InterfaceItem> name2item = new HashMap();
    private HashMap<String, Attribute> name2attr = new HashMap();
    private HashMap<String, Operation> name2op = new HashMap();

    public DetailCodeTranslator(ActorClass ac, ITranslationProvider provider) {
        this((EObject)ac, provider);
    }

    public DetailCodeTranslator(ProtocolClass pc, ITranslationProvider provider) {
        this((EObject)pc, provider);
    }

    public DetailCodeTranslator(PortClass pc, ITranslationProvider provider) {
        this((EObject)pc, provider);
    }

    public DetailCodeTranslator(DataClass dc, ITranslationProvider provider) {
        this((EObject)dc, provider);
    }

    private DetailCodeTranslator(EObject container, ITranslationProvider provider) {
        this.provider = provider;
        this.prepare(container);
    }

    public String translateDetailCode(DetailCode code) {
        if (code == null) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        for (String line : code.getCommands()) {
            text.append(String.valueOf(line) + "\n");
        }
        String result = text.substring(0, Math.max(0, text.length() - 1));
        if (this.provider.translateMembers()) {
            result = this.translateText(result);
        }
        if (this.provider.translateTags()) {
            result = this.translateTags(result, code);
        }
        return result;
    }

    private String translateText(String text) {
        StringBuilder result = new StringBuilder();
        Position curr = new Position();
        int last = 0;
        while (curr.pos < text.length()) {
            this.proceedToToken(text, curr);
            last = this.appendParsed(text, curr, last, result);
            String token = this.getToken(text, curr);
            if (token.isEmpty()) {
                if (curr.pos < text.length() && !this.isTokenChar(text.charAt(curr.pos))) {
                    ++curr.pos;
                }
                last = this.appendParsed(text, curr, last, result);
                continue;
            }
            String translated = null;
            Attribute attribute = this.name2attr.get(token);
            if (attribute != null) {
                int start = curr.pos;
                String index = this.getArrayIndex(text, curr);
                if (index == null) {
                    curr.pos = start;
                }
                int endSet = curr.pos + ATTR_SET.length();
                if (text.length() >= endSet && text.substring(curr.pos, endSet).equals(ATTR_SET)) {
                    curr.pos = endSet;
                    ArrayList<String> args = this.getArgs(text, curr);
                    if (args != null && args.size() == 1) {
                        String orig = text.substring(last, curr.pos);
                        String transArg = this.translateText(args.get(0));
                        translated = this.provider.getAttributeSetter(attribute, index, transArg, orig);
                    }
                } else {
                    String orig = text.substring(last, curr.pos);
                    translated = this.provider.getAttributeGetter(attribute, index, orig);
                }
            } else {
                Operation operation = this.name2op.get(token);
                if (operation != null && operation.eContainer() instanceof ActorClass) {
                    ArrayList<String> args = this.getArgs(text, curr);
                    if (args != null && operation.getArguments().size() == args.size()) {
                        int i = 0;
                        while (i < args.size()) {
                            String transArg = this.translateText(args.remove(i));
                            args.add(i, transArg);
                            ++i;
                        }
                        String orig = text.substring(last, curr.pos);
                        translated = this.provider.getOperationText(operation, args, orig);
                    }
                } else {
                    InterfaceItem item = this.name2item.get(token);
                    if (item != null) {
                        Message msg;
                        int start = curr.pos;
                        String index = this.getArrayIndex(text, curr);
                        if (index == null) {
                            curr.pos = start;
                        }
                        if ((msg = this.getMessage(text, curr, item, true)) != null) {
                            ArrayList<String> args = this.getArgs(text, curr);
                            if (args != null && this.argsMatching(msg, args)) {
                                int i = 0;
                                while (i < args.size()) {
                                    String transArg = this.translateText(args.remove(i));
                                    args.add(i, transArg);
                                    ++i;
                                }
                                String orig = text.substring(last, curr.pos);
                                translated = this.provider.getInterfaceItemMessageText(item, msg, args, index, orig);
                            }
                        } else {
                            curr.pos = start;
                            msg = this.getMessage(text, curr, item, false);
                            if (msg != null && (curr.pos >= text.length() || text.charAt(curr.pos) != '(')) {
                                String orig = text.substring(last, curr.pos);
                                translated = this.provider.getInterfaceItemMessageValue(item, msg, orig);
                            }
                        }
                    }
                }
            }
            if (translated != null) {
                last = curr.pos;
                result.append(translated);
                continue;
            }
            last = this.appendParsed(text, curr, last, result);
        }
        return result.toString();
    }

    private String getArrayIndex(String text, Position curr) {
        this.proceedToToken(text, curr);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != '[') {
            return null;
        }
        ++curr.pos;
        String token = this.getIndex(text, curr);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != ']') {
            return null;
        }
        ++curr.pos;
        return this.translateText(token);
    }

    private int appendParsed(String text, Position curr, int last, StringBuilder result) {
        String str = text.substring(last, curr.pos);
        result.append(str);
        return curr.pos;
    }

    private boolean argsMatching(Message msg, ArrayList<String> args) {
        if (msg.getData() == null && args.isEmpty()) {
            return true;
        }
        return msg.getData() != null && args.size() == 1;
    }

    private void proceedToToken(String text, Position curr) {
        this.proceedToToken(text, curr, true);
    }

    private void proceedToToken(String text, Position curr, boolean skipString) {
        boolean stop = false;
        while (curr.pos < text.length() && !stop) {
            if (text.charAt(curr.pos) == '\"') {
                if (skipString) {
                    this.skipString(text, curr);
                    continue;
                }
                stop = true;
                continue;
            }
            if (text.charAt(curr.pos) == '/') {
                if (curr.pos + 1 < text.length()) {
                    if (text.charAt(curr.pos + 1) == '/') {
                        this.skipSingleComment(text, curr);
                        continue;
                    }
                    if (text.charAt(curr.pos + 1) == '*') {
                        this.skipMultiComment(text, curr);
                        continue;
                    }
                    stop = true;
                    continue;
                }
                stop = true;
                continue;
            }
            if (Character.isWhitespace(text.charAt(curr.pos))) {
                this.skipWhiteSpace(text, curr);
                continue;
            }
            stop = true;
        }
    }

    private Message getMessage(String text, Position curr, InterfaceItem item, boolean outgoing) {
        this.proceedToToken(text, curr);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != '.') {
            return null;
        }
        ++curr.pos;
        this.proceedToToken(text, curr);
        String token = this.getToken(text, curr);
        List messages = RoomHelpers.getMessageListDeep((InterfaceItem)item, (boolean)outgoing);
        for (Message message : messages) {
            if (!message.getName().equals(token)) continue;
            return message;
        }
        return null;
    }

    private ArrayList<String> getArgs(String text, Position curr) {
        this.proceedToToken(text, curr);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != '(') {
            return null;
        }
        ++curr.pos;
        ArrayList<String> result = new ArrayList<String>();
        boolean stop = false;
        do {
            this.proceedToToken(text, curr, false);
            if (curr.pos < text.length() && text.charAt(curr.pos) != ')') {
                String arg = this.getParam(text, curr);
                result.add(arg);
                this.proceedToToken(text, curr);
            }
            if (curr.pos < text.length() && text.charAt(curr.pos) == ',') {
                ++curr.pos;
                continue;
            }
            stop = true;
        } while (!stop);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != ')') {
            return null;
        }
        ++curr.pos;
        return result;
    }

    private String getToken(String text, Position curr) {
        int begin = curr.pos;
        while (curr.pos < text.length() && this.isTokenChar(text.charAt(curr.pos))) {
            ++curr.pos;
        }
        String token = text.substring(begin, curr.pos);
        return token;
    }

    private String getParam(String text, Position curr) {
        int begin = curr.pos;
        int parenthesisLevel = 0;
        while (curr.pos < text.length()) {
            if (text.charAt(curr.pos) == '(') {
                ++parenthesisLevel;
            } else if (text.charAt(curr.pos) == ')') {
                if (parenthesisLevel == 0) break;
                --parenthesisLevel;
            } else if (parenthesisLevel == 0 && text.charAt(curr.pos) == ',') break;
            ++curr.pos;
        }
        String token = text.substring(begin, curr.pos).trim();
        return token;
    }

    private String getIndex(String text, Position curr) {
        int begin = curr.pos;
        int parenthesisLevel = 0;
        while (curr.pos < text.length()) {
            if (text.charAt(curr.pos) == '[') {
                ++parenthesisLevel;
            } else if (text.charAt(curr.pos) == ']') {
                if (parenthesisLevel == 0) break;
                --parenthesisLevel;
            }
            ++curr.pos;
        }
        String token = text.substring(begin, curr.pos).trim();
        return token;
    }

    private void skipWhiteSpace(String text, Position curr) {
        while (curr.pos < text.length() && Character.isWhitespace(text.charAt(curr.pos))) {
            ++curr.pos;
        }
    }

    private void skipMultiComment(String text, Position curr) {
        curr.pos += 2;
        while (curr.pos < text.length() - 1 && text.charAt(curr.pos++) != '*') {
            if (text.charAt(curr.pos) == '/') break;
        }
        if (curr.pos < text.length()) {
            ++curr.pos;
        }
    }

    private void skipSingleComment(String text, Position curr) {
        while (curr.pos < text.length() && text.charAt(curr.pos) != '\n') {
            ++curr.pos;
        }
        if (curr.pos < text.length()) {
            ++curr.pos;
        }
    }

    private void skipString(String text, Position curr) {
        while (++curr.pos < text.length() && text.charAt(curr.pos) != '\"') {
            if (text.charAt(curr.pos) != '\\') continue;
            ++curr.pos;
        }
        if (curr.pos < text.length()) {
            ++curr.pos;
        }
    }

    private boolean isTokenChar(char c) {
        return Character.isDigit(c) || Character.isLetter(c) || c == '_';
    }

    private void prepare(EObject container) {
        this.provider.setContainerClass(container);
        if (container instanceof ActorClass) {
            ActorClass ac = (ActorClass)container;
            List items = RoomHelpers.getAllInterfaceItems((ActorClass)ac);
            for (InterfaceItem item : items) {
                this.name2item.put(item.getName(), item);
            }
        }
        List attributes = null;
        if (container instanceof ActorClass) {
            attributes = RoomHelpers.getAllAttributes((ActorClass)((ActorClass)container));
        } else if (container instanceof DataClass) {
            attributes = RoomHelpers.getAllAttributes((DataClass)((DataClass)container));
        } else if (container instanceof PortClass) {
            attributes = ((PortClass)container).getAttributes();
        }
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                this.name2attr.put(attribute.getName(), attribute);
            }
        }
        List operations = null;
        if (container instanceof ActorClass) {
            operations = RoomHelpers.getAllOperations((ActorClass)((ActorClass)container));
        } else if (container instanceof DataClass) {
            operations = RoomHelpers.getAllOperations((DataClass)((DataClass)container));
        } else if (container instanceof PortClass) {
            operations = ((PortClass)container).getOperations();
        }
        if (operations != null) {
            for (Operation operation : operations) {
                this.name2op.put(operation.getName(), operation);
            }
        }
    }

    private String translateTags(String text, DetailCode code) {
        StringBuilder result = new StringBuilder();
        int last = 0;
        int next = text.indexOf("<|", last);
        while (next >= 0) {
            result.append(text.substring(last, next));
            last = next + "<|".length();
            next = text.indexOf("|>", last);
            if (next < 0) break;
            String tag = text.substring(last, next);
            result.append(this.provider.translateTag(tag, code));
            last = next + "|>".length();
            next = text.indexOf("<|", last);
        }
        result.append(text.substring(last));
        return result.toString();
    }

    private static class Position {
        int pos = 0;

        private Position() {
        }
    }
}

