/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ProcedureHelpers {
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    private ILanguageExtension languageExt;
    @Inject
    private ILogger logger;

    public CharSequence userCode(DataClass dc, int id) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)id, (Object)1)) {
            CharSequence _userCode;
            _matched = true;
            String _deepUserCode1 = RoomHelpers.getDeepUserCode1((DataClass)dc);
            _switchResult = _userCode = this.userCode(_deepUserCode1);
        }
        if (!_matched && Objects.equal((Object)id, (Object)2)) {
            CharSequence _userCode_1;
            _matched = true;
            String _deepUserCode2 = RoomHelpers.getDeepUserCode2((DataClass)dc);
            _switchResult = _userCode_1 = this.userCode(_deepUserCode2);
        }
        if (!_matched && Objects.equal((Object)id, (Object)3)) {
            CharSequence _userCode_2;
            _matched = true;
            String _deepUserCode3 = RoomHelpers.getDeepUserCode3((DataClass)dc);
            _switchResult = _userCode_2 = this.userCode(_deepUserCode3);
        }
        return _switchResult;
    }

    public CharSequence userCode(ProtocolClass pc, int id) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)id, (Object)1)) {
            CharSequence _userCode;
            _matched = true;
            String _deepUserCode1 = RoomHelpers.getDeepUserCode1((ProtocolClass)pc);
            _switchResult = _userCode = this.userCode(_deepUserCode1);
        }
        if (!_matched && Objects.equal((Object)id, (Object)2)) {
            CharSequence _userCode_1;
            _matched = true;
            String _deepUserCode2 = RoomHelpers.getDeepUserCode2((ProtocolClass)pc);
            _switchResult = _userCode_1 = this.userCode(_deepUserCode2);
        }
        if (!_matched && Objects.equal((Object)id, (Object)3)) {
            CharSequence _userCode_2;
            _matched = true;
            String _deepUserCode3 = RoomHelpers.getDeepUserCode3((ProtocolClass)pc);
            _switchResult = _userCode_2 = this.userCode(_deepUserCode3);
        }
        return _switchResult;
    }

    public CharSequence userCode(ActorContainerClass ac, int id) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)id, (Object)1)) {
            CharSequence _userCode;
            _matched = true;
            String _deepUserCode1 = RoomHelpers.getDeepUserCode1((ActorContainerClass)ac);
            _switchResult = _userCode = this.userCode(_deepUserCode1);
        }
        if (!_matched && Objects.equal((Object)id, (Object)2)) {
            CharSequence _userCode_1;
            _matched = true;
            String _deepUserCode2 = RoomHelpers.getDeepUserCode2((ActorContainerClass)ac);
            _switchResult = _userCode_1 = this.userCode(_deepUserCode2);
        }
        if (!_matched && Objects.equal((Object)id, (Object)3)) {
            CharSequence _userCode_2;
            _matched = true;
            String _deepUserCode3 = RoomHelpers.getDeepUserCode3((ActorContainerClass)ac);
            _switchResult = _userCode_2 = this.userCode(_deepUserCode3);
        }
        return _switchResult;
    }

    public CharSequence userCode(DetailCode dc) {
        String _detailCode = RoomHelpers.getDetailCode((DetailCode)dc);
        CharSequence _userCode = this.userCode(_detailCode);
        return _userCode;
    }

    private CharSequence userCode(String code) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)code, null);
        if (!_notEquals) {
            _and = false;
        } else {
            boolean _isEmpty = code.isEmpty();
            boolean _not = !_isEmpty;
            boolean bl2 = _and = _notEquals && _not;
        }
        if (_and) {
            _builder.append((Object)"/*--------------------- begin user code ---------------------*/");
            _builder.newLine();
            _builder.append((Object)code, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"/*--------------------- end user code ---------------------*/");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence attributes(List<Attribute> attribs) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*--------------------- attributes ---------------------*/");
        _builder.newLine();
        for (Attribute attribute : attribs) {
            CharSequence _attributeDeclaration = this.attributeDeclaration(attribute);
            _builder.append((Object)_attributeDeclaration, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence attributeDeclaration(Attribute attribute) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        int _size = attribute.getSize();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            RefableType _refType = attribute.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            RefableType _refType_1 = attribute.getRefType();
            boolean _isRef = _refType_1.isRef();
            if (_isRef) {
                String _pointerLiteral = this.languageExt.pointerLiteral();
                _builder.append((Object)_pointerLiteral, "");
            }
            _builder.append((Object)" ");
            String _name = attribute.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        } else {
            RefableType _refType_2 = attribute.getRefType();
            DataType _type_1 = _refType_2.getType();
            String _typeName_1 = this._typeHelpers.typeName(_type_1);
            int _size_1 = attribute.getSize();
            String _name_1 = attribute.getName();
            RefableType _refType_3 = attribute.getRefType();
            boolean _isRef_1 = _refType_3.isRef();
            String _arrayDeclaration = this.languageExt.arrayDeclaration(_typeName_1, _size_1, _name_1, _isRef_1);
            _builder.append((Object)_arrayDeclaration, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String arrayInitializer(Attribute att) {
        boolean _lessThan;
        boolean _notEquals;
        String _xifexpression = null;
        String _defaultValueLiteral = att.getDefaultValueLiteral();
        boolean bl = _notEquals = !Objects.equal((Object)_defaultValueLiteral, null);
        if (_notEquals) {
            String _defaultValueLiteral_1;
            _xifexpression = _defaultValueLiteral_1 = att.getDefaultValueLiteral();
        } else {
            String _defaultValue;
            RefableType _refType = att.getRefType();
            DataType _type = _refType.getType();
            _xifexpression = _defaultValue = this.languageExt.defaultValue(_type);
        }
        String dflt = _xifexpression;
        boolean _startsWith = dflt.startsWith("{");
        if (_startsWith) {
            int _size_1;
            boolean _notEquals_1;
            String[] _split = dflt.split(",");
            int _size = ((List)Conversions.doWrapArray((Object)_split)).size();
            boolean bl2 = _notEquals_1 = _size != (_size_1 = att.getSize());
            if (_notEquals_1) {
                String _name = att.getName();
                String _plus = "WARNING: array size determined by initializer differs from attribute size (" + _name;
                String _plus_1 = String.valueOf(_plus) + "[";
                int _size_2 = att.getSize();
                String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_size_2);
                String _plus_3 = String.valueOf(_plus_2) + "] <-> ";
                String _plus_4 = String.valueOf(_plus_3) + dflt;
                String _plus_5 = String.valueOf(_plus_4) + ")";
                this.logger.logInfo(_plus_5);
            }
            return dflt;
        }
        String result = "{";
        int i = 0;
        int _size_3 = att.getSize();
        boolean _while = _lessThan = i < _size_3;
        while (_while) {
            int _size_4;
            boolean _lessThan_1;
            boolean _lessThan_12;
            String _plus_6;
            result = _plus_6 = String.valueOf(result) + dflt;
            int _plus_7 = i + 1;
            int _size_42 = att.getSize();
            boolean bl3 = _lessThan_12 = (i = _plus_7) < _size_42;
            if (_lessThan_12) {
                String _plus_8;
                result = _plus_8 = String.valueOf(result) + ", ";
            }
            _while = _lessThan_1 = i < (_size_4 = att.getSize());
        }
        return String.valueOf(result) + "}";
    }

    public CharSequence attributeSettersGettersDeclaration(List<Attribute> attribs, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* --------------------- attribute setters and getters */");
        _builder.newLine();
        for (Attribute attribute : attribs) {
            CharSequence _setterHeader = this.setterHeader(attribute, classname);
            _builder.append((Object)_setterHeader, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            CharSequence _terHeader = this.getterHeader(attribute, classname);
            _builder.append((Object)_terHeader, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence attributeSettersGettersImplementation(List<Attribute> attribs, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* --------------------- attribute setters and getters */");
        _builder.newLine();
        for (Attribute attribute : attribs) {
            CharSequence _setterHeader = this.setterHeader(attribute, classname);
            _builder.append((Object)_setterHeader, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t ");
            String _memberAccess = this.languageExt.memberAccess();
            _builder.append((Object)_memberAccess, "\t ");
            String _name = attribute.getName();
            _builder.append((Object)_name, "\t ");
            _builder.append((Object)" = ");
            String _name_1 = attribute.getName();
            _builder.append((Object)_name_1, "\t ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            CharSequence _terHeader = this.getterHeader(attribute, classname);
            _builder.append((Object)_terHeader, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _memberAccess_1 = this.languageExt.memberAccess();
            _builder.append((Object)_memberAccess_1, "\t");
            String _name_2 = attribute.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence setterHeader(Attribute attribute, String classname) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append((Object)_accessLevelPublic, "");
        _builder.append((Object)"void set");
        String _name = attribute.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" (");
        String _selfPointer = this.languageExt.selfPointer(classname, true);
        _builder.append((Object)_selfPointer, "");
        RefableType _refType = attribute.getRefType();
        DataType _type = _refType.getType();
        String _typeName = this._typeHelpers.typeName(_type);
        _builder.append((Object)_typeName, "");
        int _size = attribute.getSize();
        boolean bl = _notEquals = _size != 0;
        if (_notEquals) {
            _builder.append((Object)"[]");
        }
        _builder.append((Object)" ");
        String _name_1 = attribute.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)")");
        return _builder;
    }

    private CharSequence getterHeader(Attribute attribute, String classname) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append((Object)_accessLevelPublic, "");
        RefableType _refType = attribute.getRefType();
        DataType _type = _refType.getType();
        String _typeName = this._typeHelpers.typeName(_type);
        _builder.append((Object)_typeName, "");
        int _size = attribute.getSize();
        boolean bl = _notEquals = _size != 0;
        if (_notEquals) {
            _builder.append((Object)"[]");
        }
        _builder.append((Object)" get");
        String _name = attribute.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" (");
        String _selfPointer = this.languageExt.selfPointer(classname, false);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence argList(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : attributes) {
            boolean _greaterThan;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            RefableType _refType = a.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            int _size = a.getSize();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                _builder.append((Object)"[]");
            }
            _builder.append((Object)" ");
            String _name = a.getName();
            _builder.append((Object)_name, "");
        }
        return _builder;
    }

    public CharSequence invokeGetters(Iterable<Attribute> path, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : path) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)".", "");
            }
            String _name = a.getName();
            CharSequence _invokeGetter = this.invokeGetter(_name, classname);
            _builder.append((Object)_invokeGetter, "");
        }
        return _builder;
    }

    public CharSequence getterImplementation(String typeName, String name, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append((Object)_accessLevelPublic, "");
        _builder.append((Object)typeName, "");
        _builder.append((Object)" get");
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" (");
        String _selfPointer = this.languageExt.selfPointer(classname, false);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)"){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        String _memberAccess = this.languageExt.memberAccess();
        _builder.append((Object)_memberAccess, "\t");
        _builder.append((Object)name, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence invokeGetter(String name, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(");
        String _selfPointer = this.languageExt.selfPointer(classname, true);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence invokeSetter(String name, String classname, String value) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"set");
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(");
        String _selfPointer = this.languageExt.selfPointer(classname, true);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)value, "");
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence operationsDeclaration(List<? extends Operation> operations, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*--------------------- operations ---------------------*/");
        _builder.newLine();
        for (Operation operation : operations) {
            boolean _not;
            boolean _and = false;
            boolean _usesInheritance = this.languageExt.usesInheritance();
            if (!_usesInheritance) {
                _and = false;
            } else {
                boolean _isConstructor = RoomHelpers.isConstructor((Operation)operation);
                _and = _usesInheritance && _isConstructor;
            }
            boolean bl = _not = !_and;
            if (!_not) continue;
            CharSequence _operationSignature = this.operationSignature(operation, classname);
            _builder.append((Object)_operationSignature, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence operationsImplementation(List<? extends Operation> operations, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*--------------------- operations ---------------------*/");
        _builder.newLine();
        for (Operation operation : operations) {
            boolean _not;
            boolean _and = false;
            boolean _usesInheritance = this.languageExt.usesInheritance();
            if (!_usesInheritance) {
                _and = false;
            } else {
                boolean _isConstructor = RoomHelpers.isConstructor((Operation)operation);
                _and = _usesInheritance && _isConstructor;
            }
            boolean bl = _not = !_and;
            if (!_not) continue;
            CharSequence _operationSignature = this.operationSignature(operation, classname);
            _builder.append((Object)_operationSignature, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            AbstractGenerator _instance = AbstractGenerator.getInstance();
            DetailCode _detailCode = operation.getDetailCode();
            String _translatedCode = _instance.getTranslatedCode(_detailCode);
            _builder.append((Object)_translatedCode, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence operationsImplementation(ActorClass ac) {
        EList _operations = ac.getOperations();
        String _name = ac.getName();
        CharSequence _operationsImplementation = this.operationsImplementation((List<? extends Operation>)_operations, _name);
        return _operationsImplementation;
    }

    public String destructorCall(String classname) {
        String _destructorName = this.languageExt.destructorName(classname);
        String _plus = String.valueOf(_destructorName) + "()";
        return _plus;
    }

    private CharSequence operationSignature(Operation operation, String classname) {
        CharSequence _xifexpression = null;
        boolean _isConstructor = RoomHelpers.isConstructor((Operation)operation);
        if (_isConstructor) {
            CharSequence _classOperationSignature;
            String _constructorName = this.languageExt.constructorName(classname);
            String _constructorReturnType = this.languageExt.constructorReturnType();
            _xifexpression = _classOperationSignature = this.classOperationSignature(classname, _constructorName, "", _constructorReturnType);
        } else {
            CharSequence _xifexpression_1 = null;
            boolean _isDestructor = RoomHelpers.isDestructor((Operation)operation);
            if (_isDestructor) {
                CharSequence _classOperationSignature_1;
                String _destructorName = this.languageExt.destructorName(classname);
                String _destructorReturnType = this.languageExt.destructorReturnType();
                _xifexpression_1 = _classOperationSignature_1 = this.classOperationSignature(classname, _destructorName, "", _destructorReturnType);
            } else {
                CharSequence _classOperationSignature_2;
                String _name = operation.getName();
                EList _arguments = operation.getArguments();
                CharSequence _BuildArgumentList = this.BuildArgumentList((EList<VarDecl>)_arguments);
                String _string = _BuildArgumentList.toString();
                RefableType _returntype = operation.getReturntype();
                String _dataTypeToString = this.dataTypeToString(_returntype);
                _xifexpression_1 = _classOperationSignature_2 = this.classOperationSignature(classname, _name, _string, _dataTypeToString);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private String dataTypeToString(RefableType type) {
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)type, null);
        if (_equals) {
            _xifexpression = "void";
        } else {
            String _xifexpression_1 = null;
            boolean _isRef = type.isRef();
            if (_isRef) {
                String _plus;
                DataType _type = type.getType();
                String _typeName = this._typeHelpers.typeName(_type);
                String _pointerLiteral = this.languageExt.pointerLiteral();
                _xifexpression_1 = _plus = String.valueOf(_typeName) + _pointerLiteral;
            } else {
                String _typeName_1;
                DataType _type_1 = type.getType();
                _xifexpression_1 = _typeName_1 = this._typeHelpers.typeName(_type_1);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private CharSequence BuildArgumentList(EList<VarDecl> arguments) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDecl argument : arguments) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            RefableType _refType = argument.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            RefableType _refType_1 = argument.getRefType();
            boolean _isRef = _refType_1.isRef();
            if (_isRef) {
                String _pointerLiteral = this.languageExt.pointerLiteral();
                _builder.append((Object)_pointerLiteral, "");
            }
            _builder.append((Object)" ");
            String _name = argument.getName();
            _builder.append((Object)_name, "");
        }
        return _builder;
    }

    private CharSequence classOperationSignature(String classname, String operationname, String argumentList, String returnType) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append((Object)_accessLevelPublic, "");
        _builder.append((Object)returnType, "");
        _builder.append((Object)" ");
        String _memberInDeclaration = this.languageExt.memberInDeclaration(classname, operationname);
        _builder.append((Object)_memberInDeclaration, "");
        _builder.append((Object)"(");
        boolean _isEmpty = argumentList.isEmpty();
        boolean _not = !_isEmpty;
        String _selfPointer = this.languageExt.selfPointer(classname, _not);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)argumentList, "");
        _builder.append((Object)")");
        return _builder;
    }
}

