/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.LiteralType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.generic.ILanguageExtension;

@Singleton
public class TypeHelpers {
    @Inject
    private ILanguageExtension languageExt;
    @Inject
    private IDataConfiguration dataConfigExt;

    public String typeName(DataType type) {
        if (type instanceof PrimitiveType) {
            return ((PrimitiveType)type).getTargetName();
        }
        if (type instanceof ExternalType) {
            return ((ExternalType)type).getTargetName();
        }
        return type.getName();
    }

    public String getTypeName(DataType t) {
        String _typeName = this.typeName(t);
        return _typeName;
    }

    public String getTypeName(RefableType t) {
        DataType _type = t.getType();
        String _typeName = this.typeName(_type);
        return _typeName;
    }

    public String getTypeName(Message m) {
        VarDecl _data = m.getData();
        RefableType _refType = _data.getRefType();
        String _typeName = this.getTypeName(_refType);
        return _typeName;
    }

    public String getTypeName(Attribute att) {
        RefableType _refType = att.getRefType();
        String _typeName = this.getTypeName(_refType);
        return _typeName;
    }

    public String getPrimitiveTypeName(RefableType t) {
        DataType _type = t.getType();
        String _name = _type.getName();
        return _name;
    }

    public String getPrimitiveTypeName(Message m) {
        VarDecl _data = m.getData();
        RefableType _refType = _data.getRefType();
        String _primitiveTypeName = this.getPrimitiveTypeName(_refType);
        return _primitiveTypeName;
    }

    public String getPrimitiveTypeName(Attribute att) {
        RefableType _refType = att.getRefType();
        String _primitiveTypeName = this.getPrimitiveTypeName(_refType);
        return _primitiveTypeName;
    }

    public String defaultValue(VarDecl a) {
        RefableType _refType = a.getRefType();
        DataType _type = _refType.getType();
        return this.languageExt.defaultValue(_type);
    }

    public String getArgumentList(VarDecl data) {
        String[] _generateArglistAndTypedData = this.languageExt.generateArglistAndTypedData(data);
        String _get = _generateArglistAndTypedData[0];
        return _get;
    }

    public String getTypedDataDefinition(VarDecl data) {
        String[] _generateArglistAndTypedData = this.languageExt.generateArglistAndTypedData(data);
        String _get = _generateArglistAndTypedData[1];
        return _get;
    }

    public String generateTypedArgumentList(VarDecl data) {
        String[] _generateArglistAndTypedData = this.languageExt.generateArglistAndTypedData(data);
        String _get = _generateArglistAndTypedData[2];
        return _get;
    }

    public boolean isPrimitive(DataType type) {
        return type instanceof PrimitiveType;
    }

    public boolean isDataClass(DataType type) {
        return type instanceof DataClass;
    }

    public boolean isCharacterType(PrimitiveType type) {
        LiteralType _type = type.getType();
        boolean _equals = Objects.equal((Object)_type, (Object)LiteralType.CHAR);
        return _equals;
    }

    public boolean isCharacterType(DataType type) {
        boolean _and = false;
        boolean _isPrimitive = this.isPrimitive(type);
        if (!_isPrimitive) {
            _and = false;
        } else {
            boolean _isCharacterType = this.isCharacterType((PrimitiveType)type);
            _and = _isPrimitive && _isCharacterType;
        }
        return _and;
    }

    public String getAttrInstanceConfigValue(List<Attribute> attributePath, InstanceBase instance) {
        String _attrInstanceConfigValue;
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && instance instanceof ActorInstance) {
            ActorInstance _actorInstance = (ActorInstance)instance;
            _matched = true;
            _switchResult = _attrInstanceConfigValue = this.dataConfigExt.getAttrInstanceConfigValue(_actorInstance, attributePath);
        }
        if (!_matched && instance instanceof InterfaceItemInstance) {
            InterfaceItemInstance _interfaceItemInstance = (InterfaceItemInstance)instance;
            _matched = true;
            _switchResult = _attrInstanceConfigValue = this.dataConfigExt.getAttrInstanceConfigValue(_interfaceItemInstance, attributePath);
        }
        return _switchResult;
    }

    public String getAttrClassConfigValue(List<Attribute> attributePath, ActorClass actor, boolean inherite) {
        String result = this.dataConfigExt.getAttrClassConfigValue(actor, attributePath);
        boolean _and = false;
        boolean _equals = Objects.equal((Object)result, null);
        if (!_equals) {
            _and = false;
        } else {
            boolean bl = _and = _equals && inherite;
        }
        if (_and) {
            boolean _notEquals;
            ActorClass base = actor.getBase();
            boolean _and_1 = false;
            boolean bl = _notEquals = !Objects.equal((Object)base, null);
            if (!_notEquals) {
                _and_1 = false;
            } else {
                boolean _equals_1 = Objects.equal((Object)result, null);
                _and_1 = _notEquals && _equals_1;
            }
            boolean _while = _and_1;
            while (_while) {
                boolean _notEquals_1;
                ActorClass _base;
                String _attrClassConfigValue;
                result = _attrClassConfigValue = this.dataConfigExt.getAttrClassConfigValue(base, attributePath);
                base = _base = base.getBase();
                boolean _and_2 = false;
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)base, null);
                if (!_notEquals_1) {
                    _and_2 = false;
                } else {
                    boolean _equals_2 = Objects.equal((Object)result, null);
                    _and_2 = _notEquals_1 && _equals_2;
                }
                _while = _and_2;
            }
        }
        return result;
    }

    public String getAttrClassConfigValue(List<Attribute> attributePath, PortClass port) {
        ProtocolClass pc = RoomHelpers.getProtocolClass((EObject)port);
        boolean _equals = Objects.equal((Object)pc, null);
        if (_equals) {
            return null;
        }
        PortClass _regular = pc.getRegular();
        boolean _equals_1 = port.equals(_regular);
        return this.dataConfigExt.getAttrClassConfigValue(pc, _equals_1, attributePath);
    }
}

