/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.commands;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.SimpleState;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.behavior.support.DefaultPositionProvider;
import org.eclipse.etrice.ui.behavior.support.IPositionProvider;

public class StateGraphContext {
    private ArrayList<StateGraphContext> children = new ArrayList();
    private StateGraph stateGraph;
    private ArrayList<State> states = new ArrayList();
    private ArrayList<ChoicePoint> chPoints = new ArrayList();
    private ArrayList<TrPoint> trPoints = new ArrayList();
    private ArrayList<Transition> transitions = new ArrayList();
    private IPositionProvider positionProvider;
    private HashMap<StateGraphItem, StateGraphContext> obj2ctx;

    public static StateGraphContext createContextTree(ActorClass ac) {
        if (ac.getStateMachine() == null || ac.getStateMachine().eIsProxy()) {
            ac.setStateMachine(RoomFactory.eINSTANCE.createStateGraph());
        }
        ArrayList<ActorClass> classes = new ArrayList<ActorClass>();
        ActorClass a = ac;
        while (a != null) {
            classes.add(0, a);
            a = a.getBase();
        }
        StateGraphContext tree = null;
        for (ActorClass cls : classes) {
            if (cls.getStateMachine() == null) continue;
            if (tree == null) {
                tree = new StateGraphContext(cls.getStateMachine(), new HashMap<StateGraphItem, StateGraphContext>());
                continue;
            }
            super.merge(cls.getStateMachine());
        }
        tree.positionProvider = new DefaultPositionProvider(ac);
        StateGraphContext.makePositionsAvailableToChildrenContexts(tree);
        return tree;
    }

    private StateGraphContext(StateGraph sg, HashMap<StateGraphItem, StateGraphContext> obj2ctx) {
        this.stateGraph = sg;
        this.obj2ctx = obj2ctx;
        this.init(sg);
    }

    private void init(StateGraph sg) {
        for (State s : sg.getStates()) {
            this.states.add(s);
            this.obj2ctx.put((StateGraphItem)s, this);
        }
        for (ChoicePoint cp : sg.getChPoints()) {
            this.chPoints.add(cp);
            this.obj2ctx.put((StateGraphItem)cp, this);
        }
        for (TrPoint tp : sg.getTrPoints()) {
            this.trPoints.add(tp);
            this.obj2ctx.put((StateGraphItem)tp, this);
        }
        for (Transition t : sg.getTransitions()) {
            this.transitions.add(t);
            this.obj2ctx.put((StateGraphItem)t, this);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.children.add(new StateGraphContext(s.getSubgraph(), this.obj2ctx));
        }
    }

    private void merge(StateGraph derived) {
        this.stateGraph = derived;
        for (State s : derived.getStates()) {
            if (!(s instanceof SimpleState)) continue;
            this.states.add(s);
            this.obj2ctx.put((StateGraphItem)s, this);
        }
        for (ChoicePoint cp : derived.getChPoints()) {
            this.chPoints.add(cp);
            this.obj2ctx.put((StateGraphItem)cp, this);
        }
        for (TrPoint tp : derived.getTrPoints()) {
            this.trPoints.add(tp);
            this.obj2ctx.put((StateGraphItem)tp, this);
        }
        for (Transition t : derived.getTransitions()) {
            this.transitions.add(t);
            this.obj2ctx.put((StateGraphItem)t, this);
        }
        for (State s : derived.getStates()) {
            if (!(s instanceof SimpleState) || s.getSubgraph() == null) continue;
            this.children.add(new StateGraphContext(s.getSubgraph(), this.obj2ctx));
        }
        for (State refined : derived.getStates()) {
            if (!(refined instanceof RefinedState)) continue;
            State base = ((RefinedState)refined).getTarget();
            StateGraphContext ctx = this.obj2ctx.get(base);
            assert (ctx != null) : "should have visited base state already";
            ctx.getStates().remove(base);
            ctx.getStates().add(refined);
            this.obj2ctx.put((StateGraphItem)refined, this);
            if (RoomHelpers.hasDirectSubStructure((State)base)) {
                StateGraphContext basesub = null;
                for (StateGraphContext bs : ctx.getChildren()) {
                    if (bs.getParentState() != base) continue;
                    basesub = bs;
                    break;
                }
                if (basesub != null) {
                    if (!RoomHelpers.hasDirectSubStructure((State)refined)) continue;
                    super.merge(refined.getSubgraph());
                    continue;
                }
                assert (false) : "context not found";
                continue;
            }
            if (!RoomHelpers.hasDirectSubStructure((State)refined)) continue;
            StateGraphContext sub = new StateGraphContext(refined.getSubgraph(), this.obj2ctx);
            ctx.getChildren().add(sub);
        }
    }

    private static void makePositionsAvailableToChildrenContexts(StateGraphContext tree) {
        for (StateGraphContext child : tree.getChildren()) {
            child.positionProvider = tree.positionProvider;
            StateGraphContext.makePositionsAvailableToChildrenContexts(child);
        }
    }

    public State getParentState() {
        if (this.stateGraph.eContainer() instanceof State) {
            return (State)this.stateGraph.eContainer();
        }
        return null;
    }

    public ArrayList<StateGraphContext> getChildren() {
        return this.children;
    }

    public ArrayList<State> getStates() {
        return this.states;
    }

    public ArrayList<ChoicePoint> getChPoints() {
        return this.chPoints;
    }

    public StateGraph getStateGraph() {
        return this.stateGraph;
    }

    public ArrayList<TrPoint> getTrPoints() {
        return this.trPoints;
    }

    public ArrayList<Transition> getTransitions() {
        return this.transitions;
    }

    public IPositionProvider getPositionProvider() {
        return this.positionProvider;
    }

    public String toString() {
        return this.dump("");
    }

    private String dump(String indent) {
        StringBuilder result = new StringBuilder();
        result.append(String.valueOf(indent) + ">>> " + this.getText(this.stateGraph) + "\n");
        indent = String.valueOf(indent) + "  ";
        for (State s : this.states) {
            result.append(String.valueOf(indent) + this.getText((StateGraphItem)s) + "\n");
        }
        for (StateGraphContext child : this.children) {
            result.append(child.dump(indent));
        }
        return result.toString();
    }

    private String getText(StateGraph sg) {
        ActorClass ac = this.getActorClass((EObject)sg);
        EObject parent = sg.eContainer();
        String item = parent instanceof ActorClass ? "diagram" : String.valueOf(parent.eClass().getName()) + " " + ((State)parent).getName();
        return "state graph of " + item + " of " + (ac == null ? "?" : ac.getName());
    }

    private String getText(StateGraphItem item) {
        ActorClass ac = this.getActorClass((EObject)item);
        return String.valueOf(item.eClass().getName()) + " " + item.getName() + " of " + (ac == null ? "?" : ac.getName());
    }

    private ActorClass getActorClass(EObject obj) {
        EObject parent = obj.eContainer();
        while (parent != null) {
            if (parent instanceof ActorClass) {
                return (ActorClass)parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    public StateGraphContext getContext(StateGraphItem item) {
        return this.obj2ctx.get(item);
    }

    public StateGraph getInitialPoint() {
        for (Transition t : this.transitions) {
            if (!(t instanceof InitialTransition)) continue;
            return (StateGraph)t.eContainer();
        }
        return null;
    }
}

