/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.ArrayList;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.ui.behavior.commands.StateGraphContext;
import org.eclipse.etrice.ui.behavior.support.StateGraphUpdateContext;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramEditor;

public class DiagramUpdateFeature
extends AbstractUpdateFeature {
    private ArrayList<Shape> usedShapes = new ArrayList();

    public DiagramUpdateFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return true;
    }

    public IReason updateNeeded(IUpdateContext context) {
        ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
        StateGraphContext tree = StateGraphContext.createContextTree(ac);
        this.usedShapes.clear();
        IReason needed = this.updateNeeded(tree);
        if (needed.toBoolean()) {
            return needed;
        }
        for (Shape sgshape : this.getDiagram().getChildren()) {
            if (!this.usedShapes.contains(sgshape)) {
                return Reason.createTrueReason();
            }
            if (!(sgshape instanceof ContainerShape)) continue;
            for (Shape child : ((ContainerShape)sgshape).getChildren()) {
                if (!(child instanceof ContainerShape) || this.usedShapes.contains(child)) continue;
                return Reason.createTrueReason();
            }
        }
        for (Connection conn : this.getDiagram().getConnections()) {
            IReason needUpdate;
            if (conn.getStart() == null || conn.getEnd() == null) {
                return Reason.createTrueReason();
            }
            UpdateContext uf = new UpdateContext((PictogramElement)conn);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)uf);
            if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)uf) || !(needUpdate = updateFeature.updateNeeded((IUpdateContext)uf)).toBoolean()) continue;
            return needUpdate;
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
        StateGraphContext tree = StateGraphContext.createContextTree(ac);
        this.usedShapes.clear();
        boolean changed = this.update(tree);
        ArrayList children = new ArrayList(this.getDiagram().getChildren());
        for (Shape sgshape : children) {
            if (this.usedShapes.contains(sgshape)) continue;
            RemoveContext rc = new RemoveContext((PictogramElement)sgshape);
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)rc);
            if (removeFeature == null) continue;
            removeFeature.remove((IRemoveContext)rc);
            if (!removeFeature.hasDoneChanges()) continue;
            changed = true;
        }
        ArrayList connections = new ArrayList(this.getDiagram().getConnections());
        for (Connection conn : connections) {
            if (conn.getStart() == null || conn.getEnd() == null) {
                RemoveContext rc = new RemoveContext((PictogramElement)conn);
                IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)rc);
                if (removeFeature == null) continue;
                removeFeature.remove((IRemoveContext)rc);
                if (!removeFeature.hasDoneChanges()) continue;
                changed = true;
                continue;
            }
            UpdateContext uf = new UpdateContext((PictogramElement)conn);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)uf);
            if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)uf) || !updateFeature.update((IUpdateContext)uf)) continue;
            changed = true;
        }
        IDiagramEditor diagramEditor = this.getFeatureProvider().getDiagramTypeProvider().getDiagramEditor();
        if (diagramEditor != null) {
            diagramEditor.setPictogramElementForSelection(null);
        }
        return changed;
    }

    private IReason updateNeeded(StateGraphContext ctx) {
        IReason iReason;
        StateGraph sg = ctx.getStateGraph();
        ContainerShape cont = this.findStateGraphContainer(sg);
        if (cont == null) {
            return Reason.createTrueReason((String)"sub graph missing");
        }
        this.usedShapes.add((Shape)cont);
        StateGraphUpdateContext context = new StateGraphUpdateContext((PictogramElement)cont, ctx);
        IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
        if (updateFeature != null && updateFeature.canUpdate((IUpdateContext)context) && (iReason = updateFeature.updateNeeded((IUpdateContext)context)).toBoolean()) {
            return iReason;
        }
        for (Shape shape : cont.getChildren()) {
            IReason needUpdate2;
            UpdateContext uf = new UpdateContext((PictogramElement)shape);
            updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)uf);
            if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)uf) || !(needUpdate2 = updateFeature.updateNeeded((IUpdateContext)uf)).toBoolean()) continue;
            return needUpdate2;
        }
        for (StateGraphContext stateGraphContext : ctx.getChildren()) {
            IReason needUpdate3 = this.updateNeeded(stateGraphContext);
            if (!needUpdate3.toBoolean()) continue;
            return needUpdate3;
        }
        return Reason.createFalseReason();
    }

    private boolean update(StateGraphContext ctx) {
        boolean changed = false;
        StateGraph sg = ctx.getStateGraph();
        ContainerShape cont = this.findStateGraphContainer(sg);
        if (cont == null) {
            cont = SupportUtil.addStateGraph(ctx, this.getDiagram(), this.getFeatureProvider());
            changed = true;
            this.usedShapes.add((Shape)cont);
        } else {
            StateGraphUpdateContext context = new StateGraphUpdateContext((PictogramElement)cont, ctx);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature != null && updateFeature.canUpdate((IUpdateContext)context)) {
                changed = updateFeature.update((IUpdateContext)context);
            }
            this.usedShapes.add((Shape)cont);
            ArrayList children = new ArrayList(cont.getChildren());
            for (Shape child : children) {
                UpdateContext uf = new UpdateContext((PictogramElement)child);
                updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)uf);
                if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)uf)) continue;
                changed = updateFeature.update((IUpdateContext)uf);
            }
        }
        for (StateGraphContext child : ctx.getChildren()) {
            if (!this.update(child)) continue;
            changed = true;
        }
        return changed;
    }

    private ContainerShape findStateGraphContainer(StateGraph sg) {
        for (Shape child : this.getDiagram().getChildren()) {
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)child);
            if (bo != sg) continue;
            return (ContainerShape)child;
        }
        return null;
    }
}

