/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.ui.behavior.commands.StateGraphContext;
import org.eclipse.etrice.ui.behavior.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.support.StateGraphUpdateContext;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class StateGraphSupport {
    public static final int MARGIN = 40;
    private static final int CORNER_SIZE = 20;
    private static final int LINE_WIDTH = 4;
    public static final int DEFAULT_SIZE_X = 800;
    public static final int DEFAULT_SIZE_Y = 500;
    private static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    private static final IColorConstant BACKGROUND = new ColorConstant(255, 255, 255);
    private FeatureProvider afp;
    private BehaviorProvider tbp;

    public StateGraphSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.afp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.afp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return rectangle;
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.GoUpFeature(this.getDiagramTypeProvider().getFeatureProvider());
        }
    }

    private static class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            return new LayoutFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new ResizeFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new GoUpFeature(this.fp)};
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context.getNewObject() instanceof StateGraph && context.getTargetContainer() instanceof Diagram;
            }

            public PictogramElement add(IAddContext context) {
                StateGraph sg = (StateGraph)context.getNewObject();
                ContainerShape targetContainer = context.getTargetContainer();
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ContainerShape containerShape = peCreateService.createContainerShape(targetContainer, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "sg");
                int width = context.getWidth() <= 0 ? 800 : context.getWidth();
                int height = context.getHeight() <= 0 ? 500 : context.getHeight();
                IGaService gaService = Graphiti.getGaService();
                Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
                gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX(), context.getY(), width + 80, height + 80);
                RoundedRectangle rect = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)invisibleRectangle, 20, 20);
                rect.setForeground(this.manageColor(LINE_COLOR));
                rect.setBackground(this.manageColor(BACKGROUND));
                rect.setTransparency(Double.valueOf(0.5));
                rect.setLineWidth(Integer.valueOf(4));
                gaService.setLocationAndSize((GraphicsAlgorithm)rect, 40, 40, width, height);
                rect = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)invisibleRectangle, 20, 20);
                rect.setForeground(this.manageColor(LINE_COLOR));
                rect.setFilled(Boolean.valueOf(false));
                rect.setLineWidth(Integer.valueOf(4));
                gaService.setLocationAndSize((GraphicsAlgorithm)rect, 40, 40, width, height);
                this.link((PictogramElement)containerShape, sg);
                Shape labelShape = peCreateService.createShape(containerShape, false);
                Text label = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)labelShape, RoomNameProvider.getStateGraphLabel((StateGraph)sg));
                label.setForeground(this.manageColor(LINE_COLOR));
                label.setBackground(this.manageColor(LINE_COLOR));
                label.setHorizontalAlignment(Orientation.ALIGNMENT_RIGHT);
                label.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
                Font font = Graphiti.getGaService().manageFont(this.getDiagram(), label.getFont().getName(), (int)((double)label.getFont().getSize() * 1.2), label.getFont().isItalic(), true);
                label.setFont(font);
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, 40, width, 80);
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                return false;
            }
        }

        private static class GoUpFeature
        extends AbstractCustomFeature
        implements ICustomFeature {
            public GoUpFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Switch to SuperGraph";
            }

            public String getDescription() {
                return "Switch Context to SuperGraph";
            }

            public boolean canExecute(ICustomContext context) {
                ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
                return bo instanceof StateGraph && ((StateGraph)bo).eContainer() instanceof State;
            }

            public void execute(ICustomContext context) {
                ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
                if (bo instanceof StateGraph) {
                    StateGraph sg = (StateGraph)bo;
                    this.getDiagramEditor().selectPictogramElements(new PictogramElement[0]);
                    ContextSwitcher.goUp(this.getDiagram(), sg);
                }
            }

            public boolean hasDoneChanges() {
                return false;
            }
        }

        private class LayoutFeature
        extends AbstractLayoutFeature {
            private static final int MIN_HEIGHT = 100;
            private static final int MIN_WIDTH = 250;

            public LayoutFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canLayout(ILayoutContext context) {
                PictogramElement pe = context.getPictogramElement();
                if (!(pe instanceof ContainerShape)) {
                    return false;
                }
                EList businessObjects = pe.getLink().getBusinessObjects();
                return businessObjects.size() == 1 && businessObjects.get(0) instanceof StateGraph;
            }

            public boolean layout(ILayoutContext context) {
                GraphicsAlgorithm ga;
                boolean anythingChanged = false;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
                if (containerGa.getHeight() < 100) {
                    containerGa.setHeight(100);
                    anythingChanged = true;
                }
                if (containerGa.getWidth() < 250) {
                    containerGa.setWidth(250);
                    anythingChanged = true;
                }
                int w = containerGa.getWidth();
                int h = containerGa.getHeight();
                if (containerGa.getGraphicsAlgorithmChildren().size() >= 1) {
                    ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    ga.setWidth(w - 80);
                    ga.setHeight(h - 80);
                    ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(1);
                    ga.setWidth(w - 80);
                    ga.setHeight(h - 80);
                    anythingChanged = true;
                }
                if (containerShape.getChildren().size() >= 1) {
                    ga = ((Shape)containerShape.getChildren().get(0)).getGraphicsAlgorithm();
                    ga.setWidth(w - 80);
                }
                return anythingChanged;
            }
        }

        private class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class ResizeFeature
        extends DefaultResizeShapeFeature {
            public ResizeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canResizeShape(IResizeShapeContext context) {
                if (!super.canResizeShape(context)) {
                    return false;
                }
                ContainerShape containerShape = (ContainerShape)context.getShape();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return false;
                }
                int width = context.getWidth() - 40;
                int height = context.getHeight() - 40;
                int xmax = 0;
                int ymax = 0;
                StateGraph sg = (StateGraph)bo;
                for (Shape childShape : containerShape.getChildren()) {
                    if (this.isOnInterface(sg, this.getBusinessObjectForPictogramElement((PictogramElement)childShape))) continue;
                    bo = this.getBusinessObjectForPictogramElement((PictogramElement)childShape);
                    int margin = -1;
                    if (bo instanceof State) {
                        margin = 30;
                    } else if (bo instanceof TrPoint) {
                        margin = 30;
                    } else if (bo instanceof ChoicePoint) {
                        margin = 30;
                    }
                    if (margin < 0) continue;
                    GraphicsAlgorithm ga = childShape.getGraphicsAlgorithm();
                    int x = ga.getX() + ga.getWidth() - margin;
                    int y = ga.getY() + ga.getHeight() - margin;
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (y <= ymax) continue;
                    ymax = y;
                }
                if (width > 0 && width < xmax) {
                    return false;
                }
                return height <= 0 || height >= ymax;
            }

            public void resizeShape(IResizeShapeContext context) {
                GraphicsAlgorithm containerGa;
                ContainerShape containerShape = (ContainerShape)context.getShape();
                StateGraph sg = (StateGraph)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (containerShape.getGraphicsAlgorithm() != null && (containerGa = containerShape.getGraphicsAlgorithm()).getGraphicsAlgorithmChildren().size() == 2) {
                    GraphicsAlgorithm ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    double sx = (double)(context.getWidth() - 80) / (double)ga.getWidth();
                    double sy = (double)(context.getHeight() - 80) / (double)ga.getHeight();
                    for (Shape childShape : containerShape.getChildren()) {
                        if (!this.isOnInterface(sg, this.getBusinessObjectForPictogramElement((PictogramElement)childShape))) continue;
                        ga = childShape.getGraphicsAlgorithm();
                        ga.setX((int)((double)ga.getX() * sx));
                        ga.setY((int)((double)ga.getY() * sy));
                    }
                }
                super.resizeShape(context);
            }

            private boolean isOnInterface(StateGraph sg, Object childBo) {
                return childBo instanceof TrPoint;
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof StateGraph;
            }

            public IReason updateNeeded(IUpdateContext context) {
                Shape labelShape;
                GraphicsAlgorithm ga;
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"State Graph deleted from model");
                }
                StateGraph sg = (StateGraph)bo;
                ContainerShape shape = (ContainerShape)context.getPictogramElement();
                String reason = "";
                int missing = 0;
                if (context instanceof StateGraphUpdateContext) {
                    StateGraphContext ctx = ((StateGraphUpdateContext)context).getContext();
                    ArrayList<State> expectedStates = ctx.getStates();
                    List<State> presentStates = SupportUtil.getStates(shape, FeatureProvider.this.fp);
                    for (State state : expectedStates) {
                        if (presentStates.contains(state)) continue;
                        ++missing;
                    }
                    if (missing > 0) {
                        reason = String.valueOf(reason) + missing + " missing states\n";
                    }
                    missing = 0;
                    ArrayList<TrPoint> expectedTrPoints = ctx.getTrPoints();
                    List<TrPoint> presentTrPoints = SupportUtil.getTrPoints(sg, shape, FeatureProvider.this.fp);
                    for (TrPoint tp : expectedTrPoints) {
                        if (presentTrPoints.contains(tp)) continue;
                        ++missing;
                    }
                    if (missing > 0) {
                        reason = String.valueOf(reason) + missing + " missing transition points\n";
                    }
                    missing = 0;
                    ArrayList<ChoicePoint> expectedCPs = ctx.getChPoints();
                    List<ChoicePoint> presentCPs = SupportUtil.getChoicePoints(shape, FeatureProvider.this.fp);
                    for (ChoicePoint cp : expectedCPs) {
                        if (presentCPs.contains(cp)) continue;
                        ++missing;
                    }
                    if (missing > 0) {
                        reason = String.valueOf(reason) + missing + " missing choice points\n";
                    }
                    missing = 0;
                    ArrayList<Transition> expectedTrans = ctx.getTransitions();
                    List<Transition> presentTrans = SupportUtil.getTransitions(this.getDiagram(), FeatureProvider.this.fp);
                    for (Transition trans : expectedTrans) {
                        if (presentTrans.contains(trans)) continue;
                        ++missing;
                    }
                    if (missing > 0) {
                        reason = String.valueOf(reason) + missing + " missing transitions\n";
                    }
                }
                if (!shape.getChildren().isEmpty() && (ga = (labelShape = (Shape)shape.getChildren().get(0)).getGraphicsAlgorithm()) instanceof Text && !RoomNameProvider.getStateGraphLabel((StateGraph)sg).equals(((Text)ga).getValue())) {
                    reason = String.valueOf(reason) + "state graph label changed\n";
                }
                if (!reason.isEmpty()) {
                    return Reason.createTrueReason((String)reason.substring(0, reason.length() - 1));
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                Shape labelShape;
                GraphicsAlgorithm ga;
                ContainerShape sgShape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)sgShape);
                StateGraph sg = (StateGraph)bo;
                if (context instanceof StateGraphUpdateContext) {
                    StateGraphContext ctx = ((StateGraphUpdateContext)context).getContext();
                    SupportUtil.updateStateGraph(sg, ctx, sgShape, FeatureProvider.this.fp);
                }
                if (!sgShape.getChildren().isEmpty() && (ga = (labelShape = (Shape)sgShape.getChildren().get(0)).getGraphicsAlgorithm()) instanceof Text) {
                    ((Text)ga).setValue(RoomNameProvider.getStateGraphLabel((StateGraph)sg));
                }
                return true;
            }
        }
    }
}

