/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.CPBranchTransition;
import org.eclipse.etrice.core.room.ChoicepointTerminal;
import org.eclipse.etrice.core.room.ContinuationTransition;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.EntryPoint;
import org.eclipse.etrice.core.room.GuardedTransition;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.RefinedTransition;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.behavior.dialogs.TransitionPropertyDialog;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TransitionSupport {
    private static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    private static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    private static final IColorConstant FILL_COLOR = new ColorConstant(255, 255, 255);
    private static final int LINE_WIDTH = 1;
    private static final int MAX_LABEL_LENGTH = 20;
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public TransitionSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            EObject bo;
            PictogramElement pe = context.getPictogramElements()[0];
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if ((bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof Transition) {
                Transition trans = (Transition)bo;
                ActorClass ac = SupportUtil.getActorClass(this.getDiagramTypeProvider().getDiagram());
                boolean editable = RoomHelpers.getActorClass((StateGraphItem)trans) == ac;
                return new FeatureProvider.PropertyFeature(this.getDiagramTypeProvider().getFeatureProvider(), editable);
            }
            return null;
        }

        public String getToolTip(GraphicsAlgorithm ga) {
            EObject bo;
            PictogramElement pe = ga.getPictogramElement();
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if ((bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof Transition) {
                Transition tr = (Transition)bo;
                String label = RoomNameProvider.getTransitionLabelName((Transition)tr);
                ActorClass ac = SupportUtil.getActorClass(this.getDiagramTypeProvider().getDiagram());
                String code = RoomHelpers.getAllActionCode((Transition)tr, (ActorClass)ac);
                if (code != null && !code.isEmpty()) {
                    if (label.length() > 0) {
                        label = String.valueOf(label) + "\n";
                    }
                    label = String.valueOf(label) + "action:\n" + code;
                }
                return label;
            }
            return super.getToolTip(ga);
        }
    }

    static class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return new ICreateConnectionFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            return new ReconnectionFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            PictogramElement pe = context.getPictogramElements()[0];
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            ArrayList<AbstractCustomFeature> result = new ArrayList<AbstractCustomFeature>();
            if (bo instanceof Transition) {
                boolean editable;
                Transition trans = (Transition)bo;
                ActorClass ac = SupportUtil.getActorClass(this.getDiagramTypeProvider().getDiagram());
                boolean bl = editable = RoomHelpers.getActorClass((StateGraphItem)trans) == ac;
                if (!editable && ac.getStateMachine() != null) {
                    for (RefinedTransition rt : ac.getStateMachine().getRefinedTransitions()) {
                        if (rt.getTarget() != trans) continue;
                        editable = true;
                        break;
                    }
                }
                result.add(new PropertyFeature(this.fp, editable));
                if (!editable) {
                    result.add(new RefineTransitionFeature(this.fp));
                }
            }
            ICustomFeature[] features = new ICustomFeature[result.size()];
            return result.toArray(features);
        }

        protected static void updateLabel(Transition trans, Connection conn, Color fillColor) {
            if (conn.getConnectionDecorators().size() < 2) {
                return;
            }
            ConnectionDecorator cd = (ConnectionDecorator)conn.getConnectionDecorators().get(0);
            if (cd.getGraphicsAlgorithm() instanceof Polygon) {
                Polygon p = (Polygon)cd.getGraphicsAlgorithm();
                p.setBackground(fillColor);
            }
            if ((cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1)).getGraphicsAlgorithm() instanceof Text) {
                Text label = (Text)cd.getGraphicsAlgorithm();
                label.setValue(FeatureProvider.getLabel(trans));
            }
        }

        protected static String getLabel(Transition trans) {
            String label = RoomNameProvider.getTransitionLabelName((Transition)trans);
            if (label.length() > 20) {
                label = String.valueOf(label.substring(0, 20)) + "...";
            }
            return label;
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context instanceof IAddConnectionContext && context.getNewObject() instanceof Transition;
            }

            public PictogramElement add(IAddContext context) {
                IAddConnectionContext addConContext = (IAddConnectionContext)context;
                Transition trans = (Transition)context.getNewObject();
                ContainerShape container = ((ContainerShape)addConContext.getTargetAnchor().getParent()).getContainer();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
                if (!(bo instanceof StateGraph)) {
                    container = container.getContainer();
                }
                boolean inherited = SupportUtil.isInherited((StateGraphItem)trans, container);
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                FreeFormConnection connection = peCreateService.createFreeFormConnection(this.getDiagram());
                connection.setStart(addConContext.getSourceAnchor());
                connection.setEnd(addConContext.getTargetAnchor());
                if (addConContext.getSourceAnchor() == addConContext.getTargetAnchor()) {
                    Point pt = this.createSelfTransitionBendPoint(connection);
                    connection.getBendpoints().add((Object)pt);
                }
                Graphiti.getPeService().setPropertyValue((PropertyContainer)connection, "obj-type", "trans");
                IGaService gaService = Graphiti.getGaService();
                Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
                Color lineColor = this.manageColor(inherited ? INHERITED_COLOR : LINE_COLOR);
                polyline.setForeground(lineColor);
                polyline.setLineWidth(Integer.valueOf(1));
                ConnectionDecorator cd = peCreateService.createConnectionDecorator((Connection)connection, false, 1.0, true);
                Color fillColor = RoomHelpers.hasDetailCode((DetailCode)trans.getAction()) ? lineColor : this.manageColor(FILL_COLOR);
                this.createArrow((GraphicsAlgorithmContainer)cd, lineColor, fillColor);
                ConnectionDecorator textDecorator = peCreateService.createConnectionDecorator((Connection)connection, true, 0.5, true);
                Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)textDecorator, FeatureProvider.getLabel(trans));
                text.setForeground(lineColor);
                gaService.setLocation((GraphicsAlgorithm)text, 10, 0);
                this.link((PictogramElement)connection, trans);
                return connection;
            }

            private Point createSelfTransitionBendPoint(FreeFormConnection connection) {
                ILocation begin = Graphiti.getPeService().getLocationRelativeToDiagram(connection.getStart());
                int deltaX = 0;
                int deltaY = 120;
                return Graphiti.getGaService().createPoint(begin.getX() + deltaX, begin.getY() + deltaY);
            }

            private Polyline createArrow(GraphicsAlgorithmContainer gaContainer, Color lineColor, Color fillColor) {
                IGaService gaService = Graphiti.getGaService();
                int[] nArray = new int[6];
                nArray[0] = -15;
                nArray[1] = 5;
                nArray[4] = -15;
                nArray[5] = -5;
                Polygon polygon = gaService.createPolygon(gaContainer, nArray);
                polygon.setForeground(lineColor);
                polygon.setBackground(fillColor);
                polygon.setLineWidth(Integer.valueOf(1));
                return polygon;
            }
        }

        private class CreateFeature
        extends AbstractCreateConnectionFeature {
            private boolean doneChanges;

            public CreateFeature(IFeatureProvider fp) {
                super(fp, "Transition", "create Transition");
                this.doneChanges = false;
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.behavior.transition";
            }

            public boolean canCreate(ICreateConnectionContext context) {
                return SupportUtil.canConnect(context.getSourceAnchor(), context.getTargetAnchor(), (ContainerShape)context.getSourcePictogramElement().eContainer(), FeatureProvider.this.fp);
            }

            public boolean canStartConnection(ICreateConnectionContext context) {
                TransitionTerminal src = SupportUtil.getTransitionTerminal(context.getSourceAnchor(), FeatureProvider.this.fp);
                if (src == null && !SupportUtil.isInitialPoint(context.getSourceAnchor(), FeatureProvider.this.fp)) {
                    return false;
                }
                StateGraph sg = SupportUtil.getStateGraph((ContainerShape)context.getSourcePictogramElement().eContainer(), FeatureProvider.this.fp);
                if (sg == null) {
                    return false;
                }
                return ValidationUtil.isConnectable((TransitionTerminal)src, (StateGraph)sg).isOk();
            }

            public Connection create(ICreateConnectionContext context) {
                Connection newConnection = null;
                ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                TransitionTerminal src = SupportUtil.getTransitionTerminal(context.getSourceAnchor(), FeatureProvider.this.fp);
                TransitionTerminal dst = SupportUtil.getTransitionTerminal(context.getTargetAnchor(), FeatureProvider.this.fp);
                StateGraph sg = SupportUtil.getStateGraph((ContainerShape)context.getSourcePictogramElement().eContainer(), FeatureProvider.this.fp);
                if (dst != null && sg != null) {
                    InitialTransition trans = null;
                    if (src == null) {
                        InitialTransition t = RoomFactory.eINSTANCE.createInitialTransition();
                        t.setTo(dst);
                        trans = t;
                    } else if (src instanceof SubStateTrPointTerminal || src instanceof TrPointTerminal && ((TrPointTerminal)src).getTrPoint() instanceof EntryPoint) {
                        ContinuationTransition t = RoomFactory.eINSTANCE.createContinuationTransition();
                        t.setFrom(src);
                        t.setTo(dst);
                        trans = t;
                    } else if (src instanceof ChoicepointTerminal) {
                        ContinuationTransition t;
                        boolean dfltBranch = true;
                        for (Transition tr : RoomHelpers.getAllTransitions((StateGraph)sg)) {
                            TransitionTerminal from;
                            if (!(tr instanceof ContinuationTransition) || !((from = ((ContinuationTransition)tr).getFrom()) instanceof ChoicepointTerminal) || ((ChoicepointTerminal)from).getCp() != ((ChoicepointTerminal)src).getCp()) continue;
                            dfltBranch = false;
                        }
                        Object object = t = dfltBranch ? RoomFactory.eINSTANCE.createContinuationTransition() : RoomFactory.eINSTANCE.createCPBranchTransition();
                        if (t instanceof CPBranchTransition) {
                            ((CPBranchTransition)t).setCondition(RoomFactory.eINSTANCE.createDetailCode());
                        }
                        t.setFrom(src);
                        t.setTo(dst);
                        trans = t;
                    } else {
                        GuardedTransition t = null;
                        switch (ac.getCommType()) {
                            case DATA_DRIVEN: {
                                t = RoomFactory.eINSTANCE.createGuardedTransition();
                                break;
                            }
                            case ASYNCHRONOUS: {
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                MessageDialog dlg = new MessageDialog(shell, "Create new transition", null, "Select the kind of transition", 3, new String[]{"triggered", "guarded"}, 0);
                                switch (dlg.open()) {
                                    case 0: {
                                        t = RoomFactory.eINSTANCE.createTriggeredTransition();
                                        break;
                                    }
                                    case 1: {
                                        t = RoomFactory.eINSTANCE.createGuardedTransition();
                                    }
                                }
                                break;
                            }
                            case EVENT_DRIVEN: {
                                t = RoomFactory.eINSTANCE.createTriggeredTransition();
                                break;
                            }
                            case SYNCHRONOUS: {
                                break;
                            }
                        }
                        if (t == null) {
                            return null;
                        }
                        t.setFrom(src);
                        t.setTo(dst);
                        trans = t;
                    }
                    if (trans instanceof InitialTransition) {
                        trans.setName(RoomNameProvider.getUniqueInitialTransitionName((StateGraph)sg));
                    } else {
                        trans.setName(RoomNameProvider.getUniqueTransitionName((StateGraph)sg));
                    }
                    ContainerShape targetContainer = SupportUtil.getStateGraphContainer((ContainerShape)context.getSourcePictogramElement().eContainer());
                    boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)sg);
                    if (inherited) {
                        sg = SupportUtil.insertRefinedState(sg, ac, targetContainer, this.getFeatureProvider());
                    }
                    sg.getTransitions().add((Object)trans);
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    TransitionPropertyDialog dlg = new TransitionPropertyDialog(shell, SupportUtil.getActorClass(this.getDiagram()), (Transition)trans);
                    if (dlg.open() != 0) {
                        if (inherited) {
                            SupportUtil.undoInsertRefinedState(sg, ac, targetContainer, this.getFeatureProvider());
                        } else {
                            sg.getTransitions().remove((Object)trans);
                        }
                        return null;
                    }
                    AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
                    addContext.setNewObject((Object)trans);
                    newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
                    this.doneChanges = true;
                }
                return newConnection;
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        protected static class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                PictogramElement pe = context.getPictogramElement();
                if (pe instanceof ConnectionDecorator) {
                    pe = (PictogramElement)pe.eContainer();
                }
                if (!(pe instanceof Connection)) {
                    return false;
                }
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (bo instanceof Transition) {
                    boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)((Transition)bo));
                    return !inherited;
                }
                return false;
            }
        }

        private static class PropertyFeature
        extends AbstractCustomFeature {
            private boolean doneChanges = false;
            private boolean editable;

            public PropertyFeature(IFeatureProvider fp, boolean editable) {
                super(fp);
                this.editable = editable;
            }

            public String getName() {
                return this.editable ? "Edit Transition..." : "View Transition";
            }

            public String getDescription() {
                return this.editable ? "Edit Transition Properties" : "View Transition Properties";
            }

            public boolean canExecute(ICustomContext context) {
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1) {
                    PictogramElement pe = pes[0];
                    if (pe instanceof ConnectionDecorator) {
                        pe = (PictogramElement)pe.eContainer();
                    }
                    if (!(pe instanceof Connection)) {
                        return false;
                    }
                    Object bo = this.getBusinessObjectForPictogramElement(pe);
                    if (bo instanceof Transition) {
                        return true;
                    }
                }
                return false;
            }

            public void execute(ICustomContext context) {
                PictogramElement pe = context.getPictogramElements()[0];
                if (pe instanceof ConnectionDecorator) {
                    pe = (PictogramElement)pe.eContainer();
                }
                Transition trans = (Transition)this.getBusinessObjectForPictogramElement(pe);
                Connection conn = (Connection)pe;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                TransitionPropertyDialog dlg = new TransitionPropertyDialog(shell, SupportUtil.getActorClass(this.getDiagram()), trans);
                if (dlg.open() != 0) {
                    return;
                }
                this.doneChanges = true;
                boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)trans);
                Color lineColor = inherited ? this.manageColor(INHERITED_COLOR) : this.manageColor(LINE_COLOR);
                Color fillColor = RoomHelpers.hasDetailCode((DetailCode)trans.getAction()) ? lineColor : this.manageColor(FILL_COLOR);
                FeatureProvider.updateLabel(trans, conn, fillColor);
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class ReconnectionFeature
        extends DefaultReconnectionFeature {
            private boolean doneChanges;

            public ReconnectionFeature(IFeatureProvider fp) {
                super(fp);
                this.doneChanges = false;
            }

            public boolean canReconnect(IReconnectionContext context) {
                if (!super.canReconnect(context)) {
                    return false;
                }
                Transition trans = (Transition)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)trans);
                if (inherited) {
                    return false;
                }
                Anchor src = context.getConnection().getStart();
                Anchor tgt = context.getConnection().getEnd();
                if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
                    src = context.getNewAnchor();
                } else {
                    tgt = context.getNewAnchor();
                }
                return SupportUtil.canConnect(src, tgt, trans, (ContainerShape)context.getTargetPictogramElement().eContainer(), FeatureProvider.this.fp);
            }

            public void postReconnect(IReconnectionContext context) {
                InitialTransition t;
                super.postReconnect(context);
                TransitionTerminal src = SupportUtil.getTransitionTerminal(context.getConnection().getStart(), FeatureProvider.this.fp);
                TransitionTerminal dst = SupportUtil.getTransitionTerminal(context.getConnection().getEnd(), FeatureProvider.this.fp);
                StateGraph sg = SupportUtil.getStateGraph((ContainerShape)context.getTargetPictogramElement().eContainer(), FeatureProvider.this.fp);
                ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                Transition orig = (Transition)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                InitialTransition trans = null;
                if (src == null) {
                    t = orig instanceof InitialTransition ? (InitialTransition)orig : RoomFactory.eINSTANCE.createInitialTransition();
                    t.setTo(dst);
                    trans = t;
                } else if (src instanceof SubStateTrPointTerminal || src instanceof TrPointTerminal && ((TrPointTerminal)src).getTrPoint() instanceof EntryPoint) {
                    t = orig instanceof ContinuationTransition ? (ContinuationTransition)orig : RoomFactory.eINSTANCE.createContinuationTransition();
                    t.setFrom(src);
                    t.setTo(dst);
                    trans = t;
                } else if (src instanceof ChoicepointTerminal) {
                    t = null;
                    if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
                        boolean dfltBranch = true;
                        for (Transition tr : RoomHelpers.getAllTransitions((StateGraph)sg)) {
                            TransitionTerminal from;
                            if (!(tr instanceof ContinuationTransition) || !((from = ((ContinuationTransition)tr).getFrom()) instanceof ChoicepointTerminal) || ((ChoicepointTerminal)from).getCp() != ((ChoicepointTerminal)src).getCp()) continue;
                            dfltBranch = false;
                        }
                        t = dfltBranch ? RoomFactory.eINSTANCE.createContinuationTransition() : RoomFactory.eINSTANCE.createCPBranchTransition();
                    } else {
                        t = (NonInitialTransition)orig;
                    }
                    t.setFrom(src);
                    t.setTo(dst);
                    trans = t;
                } else {
                    t = ac.getCommType() == ActorCommunicationType.DATA_DRIVEN ? (orig instanceof GuardedTransition ? (GuardedTransition)orig : RoomFactory.eINSTANCE.createGuardedTransition()) : (orig instanceof TriggeredTransition ? (TriggeredTransition)orig : RoomFactory.eINSTANCE.createTriggeredTransition());
                    t.setFrom(src);
                    t.setTo(dst);
                    trans = t;
                }
                if (orig != trans) {
                    if (trans instanceof InitialTransition) {
                        trans.setName("init");
                    } else {
                        trans.setName(orig.getName());
                    }
                    trans.setAction(orig.getAction());
                    trans.setName(orig.getName());
                    sg.getTransitions().remove((Object)orig);
                    sg.getTransitions().add((Object)trans);
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    TransitionPropertyDialog dlg = new TransitionPropertyDialog(shell, ac, (Transition)trans);
                    if (dlg.open() != 0) {
                        sg.getTransitions().add((Object)orig);
                        sg.getTransitions().remove((Object)trans);
                        if (context.getNewAnchor() == context.getConnection().getStart()) {
                            context.getConnection().setStart(context.getOldAnchor());
                        } else {
                            context.getConnection().setEnd(context.getOldAnchor());
                        }
                        return;
                    }
                    this.link((PictogramElement)context.getConnection(), trans);
                }
                this.doneChanges = true;
                Color fillColor = RoomHelpers.hasDetailCode((DetailCode)trans.getAction()) ? this.manageColor(LINE_COLOR) : this.manageColor(FILL_COLOR);
                FeatureProvider.updateLabel((Transition)trans, context.getConnection(), fillColor);
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private static class RefineTransitionFeature
        extends AbstractCustomFeature {
            public RefineTransitionFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Refine Transition";
            }

            public String getDescription() {
                return "Refine transition to add action code";
            }

            public boolean canExecute(ICustomContext context) {
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1) {
                    PictogramElement pe = pes[0];
                    if (pe instanceof ConnectionDecorator) {
                        pe = (PictogramElement)pe.eContainer();
                    }
                    if (!(pe instanceof Connection)) {
                        return false;
                    }
                    Object bo = this.getBusinessObjectForPictogramElement(pe);
                    if (bo instanceof Transition) {
                        return true;
                    }
                }
                return false;
            }

            public void execute(ICustomContext context) {
                ICustomFeature[] features;
                PictogramElement pe = context.getPictogramElements()[0];
                if (pe instanceof ConnectionDecorator) {
                    pe = (PictogramElement)pe.eContainer();
                }
                Transition trans = (Transition)this.getBusinessObjectForPictogramElement(pe);
                ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                if (ac.getStateMachine() == null) {
                    ac.setStateMachine(RoomFactory.eINSTANCE.createStateGraph());
                }
                RefinedTransition rt = RoomFactory.eINSTANCE.createRefinedTransition();
                rt.setTarget(trans);
                ac.getStateMachine().getRefinedTransitions().add((Object)rt);
                ICustomFeature[] iCustomFeatureArray = features = this.getFeatureProvider().getCustomFeatures(context);
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    ICustomFeature cf = iCustomFeatureArray[n2];
                    if (cf instanceof PropertyFeature) {
                        cf.execute(context);
                        break;
                    }
                    ++n2;
                }
            }
        }

        protected static class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof Transition;
            }

            public IReason updateNeeded(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"Transition deleted from model");
                }
                if (bo instanceof Transition) {
                    Transition t = (Transition)bo;
                    Connection conn = (Connection)context.getPictogramElement();
                    if (conn.getConnectionDecorators().size() >= 2) {
                        Text label;
                        ConnectionDecorator cd = (ConnectionDecorator)conn.getConnectionDecorators().get(0);
                        if (cd.getGraphicsAlgorithm() instanceof Polygon) {
                            Color fillColor;
                            ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                            boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)t);
                            Color lineColor = inherited ? this.manageColor(INHERITED_COLOR) : this.manageColor(LINE_COLOR);
                            String code = RoomHelpers.getAllActionCode((Transition)t, (ActorClass)ac);
                            boolean hasActionCode = code != null && !code.isEmpty();
                            Color color = fillColor = hasActionCode ? lineColor : this.manageColor(FILL_COLOR);
                            if (!this.equal(cd.getGraphicsAlgorithm().getBackground(), fillColor)) {
                                return Reason.createTrueReason((String)"Arrow head needs update");
                            }
                        }
                        if ((cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1)).getGraphicsAlgorithm() instanceof Text && !(label = (Text)cd.getGraphicsAlgorithm()).getValue().equals(FeatureProvider.getLabel(t))) {
                            return Reason.createTrueReason((String)"Label needs update");
                        }
                    }
                }
                return Reason.createFalseReason();
            }

            private boolean equal(Color c1, Color c2) {
                return c1.getRed() == c2.getRed() && c1.getGreen() == c2.getGreen() && c1.getBlue() == c2.getBlue();
            }

            public boolean update(IUpdateContext context) {
                Connection containerShape = (Connection)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext((PictogramElement)containerShape);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                boolean updated = false;
                if (bo instanceof Transition) {
                    ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                    Transition trans = (Transition)bo;
                    Connection conn = (Connection)context.getPictogramElement();
                    boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)trans);
                    Color lineColor = inherited ? this.manageColor(INHERITED_COLOR) : this.manageColor(LINE_COLOR);
                    String code = RoomHelpers.getAllActionCode((Transition)trans, (ActorClass)ac);
                    boolean hasActionCode = code != null && !code.isEmpty();
                    Color fillColor = hasActionCode ? lineColor : this.manageColor(FILL_COLOR);
                    FeatureProvider.updateLabel(trans, conn, fillColor);
                    updated = true;
                    if (this.updateNeeded(context).toBoolean()) {
                        updated = false;
                    }
                }
                return updated;
            }
        }
    }
}

