/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.commands.handlers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.naming.RoomFragmentProvider;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.ui.behavior.DiagramAccess;
import org.eclipse.etrice.ui.commands.handlers.AbstractEditHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class EditBehaviorHandler
extends AbstractEditHandler {
    @Override
    protected boolean prepare(XtextEditor xtextEditor, String fragment) {
        if (this.hasUnnamedTransitions(xtextEditor.getDocument(), fragment)) {
            if (!MessageDialog.openQuestion((Shell)xtextEditor.getSite().getShell(), (String)"Create transition names", (String)"Transition names will be created where missing.\nProceed?")) {
                return false;
            }
            this.createTransitionNames(xtextEditor.getDocument(), fragment);
            xtextEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        return true;
    }

    private void createTransitionNames(IXtextDocument document, final String fragment) {
        document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource resource) throws Exception {
                EObject object;
                if (resource != null && (object = resource.getEObject(fragment)) instanceof ActorClass) {
                    this.createTransitionNames(((ActorClass)object).getStateMachine());
                }
            }

            private void createTransitionNames(StateGraph sg) {
                if (sg == null) {
                    return;
                }
                for (Transition tr : sg.getTransitions()) {
                    if (tr.getName() != null && !tr.getName().isEmpty()) continue;
                    tr.setName(RoomNameProvider.getUniqueTransitionName((StateGraph)sg));
                }
                for (State s : sg.getStates()) {
                    this.createTransitionNames(s.getSubgraph());
                }
            }
        });
    }

    private boolean hasUnnamedTransitions(IXtextDocument document, final String fragment) {
        return (Boolean)document.readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource resource) throws Exception {
                EObject object;
                if (resource != null && (object = resource.getEObject(fragment)) instanceof ActorClass) {
                    return this.hasUnnamedTransitions(((ActorClass)object).getStateMachine());
                }
                return false;
            }

            private boolean hasUnnamedTransitions(StateGraph sg) {
                if (sg == null) {
                    return false;
                }
                for (Transition tr : sg.getTransitions()) {
                    if (tr.getName() != null && !tr.getName().isEmpty()) continue;
                    return true;
                }
                for (State s : sg.getStates()) {
                    if (!this.hasUnnamedTransitions(s.getSubgraph())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    protected void openEditor(EObject object) {
        if (object instanceof ActorClass) {
            DiagramAccess diagramAccess = new DiagramAccess();
            diagramAccess.openDiagramEditor((StructureClass)((ActorClass)object));
        }
    }

    @Override
    protected boolean isEnabled(String fragment) {
        return RoomFragmentProvider.isActorClass((String)fragment);
    }
}

