/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.commands.handlers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.ui.behavior.editor.BehaviorEditor;
import org.eclipse.etrice.ui.structure.editor.StructureEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.ITextRegion;

public class EditModelHandler
extends AbstractHandler {
    @Inject
    ILocationInFileProvider locationProvider;

    public EditModelHandler() {
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IEditorPart editor = window.getActivePage().getActiveEditor();
        StructureClass sc = null;
        if (editor instanceof StructureEditor) {
            sc = ((StructureEditor)editor).getStructureClass();
        } else if (editor instanceof BehaviorEditor) {
            sc = ((BehaviorEditor)editor).getActorClass();
        }
        if (sc != null) {
            try {
                if (EditUIUtil.openEditor((EObject)sc) && (editor = window.getActivePage().getActiveEditor()) instanceof XtextEditor) {
                    XtextEditor xed = (XtextEditor)editor;
                    ITextRegion location = this.locationProvider.getFullTextRegion((EObject)sc);
                    xed.selectAndReveal(location.getOffset(), location.getLength());
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

