/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.editor;

import java.io.FileOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.common.Activator;
import org.eclipse.etrice.ui.common.DiagramAccessBase;
import org.eclipse.etrice.ui.common.editor.RoomDiagramEditor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.graphiti.ui.internal.fixed.FixedScaledGraphics;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DiagramExporter {
    public static void export(StructureClass sc, DiagramAccessBase da, String filename) {
        boolean wasOpen = false;
        RoomDiagramEditor editor = da.findDiagramEditor(sc);
        if (editor != null) {
            wasOpen = true;
        } else {
            editor = da.openDiagramEditor(sc);
        }
        if (editor != null) {
            DiagramExporter.export(editor, filename);
            if (!wasOpen) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
            }
        }
    }

    public static void export(RoomDiagramEditor editor, String filename) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String format = store.getString("ExportDiagramFormat");
        int fmt = 4;
        if (format.equals("bmp")) {
            fmt = 0;
        } else if (format.equals("png")) {
            fmt = 5;
        } else if (format.equals("gif")) {
            fmt = 2;
        }
        final String fname = String.valueOf(filename) + "." + format;
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        Image image = DiagramExporter.createImage(viewer, 1.0, 3000.0);
        if (image != null) {
            try {
                final byte[] imgData = GraphitiUiInternal.getUiService().createImage(image, fmt);
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        FileOutputStream outputStream = null;
                        try {
                            try {
                                outputStream = new FileOutputStream(fname);
                                outputStream.write(imgData);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                try {
                                    outputStream.close();
                                }
                                catch (Exception x) {
                                    x.printStackTrace();
                                }
                            }
                        }
                        finally {
                            try {
                                outputStream.close();
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                        }
                    }
                };
                new ProgressMonitorDialog(editor.getEditorSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Image createImage(GraphicalViewer viewer, double scaleFactor, double upperBoundPixels) {
        RootEditPart rootEditPart = viewer.getRootEditPart();
        if (!(rootEditPart instanceof GraphicalEditPart)) {
            return null;
        }
        GraphicalEditPart graphicalRootEditPart = (GraphicalEditPart)rootEditPart;
        IFigure rootFigure = ((LayerManager)graphicalRootEditPart).getLayer((Object)"Printable Layers");
        if (rootFigure == null) {
            return null;
        }
        if (scaleFactor * (double)rootFigure.getBounds().width > upperBoundPixels || scaleFactor * (double)rootFigure.getBounds().height > upperBoundPixels) {
            scaleFactor = Math.min(upperBoundPixels / (double)rootFigure.getBounds().width, upperBoundPixels / (double)rootFigure.getBounds().height);
        }
        Image scaledImage = new Image((Device)Display.getDefault(), (int)((double)rootFigure.getBounds().width * scaleFactor), (int)(scaleFactor * (double)rootFigure.getBounds().height));
        GC gc = new GC((Drawable)scaledImage);
        FixedScaledGraphics graphics = new FixedScaledGraphics((Graphics)new SWTGraphics(gc));
        graphics.scale(scaleFactor);
        EditPart contents = viewer.getContents();
        if (contents instanceof GraphicalEditPart) {
            IFigure contentsFigure = ((GraphicalEditPart)contents).getFigure();
            Rectangle contentBounds = contentsFigure.getBounds();
            graphics.translate(-contentBounds.x, -contentBounds.y);
        }
        rootFigure.paint((Graphics)graphics);
        return scaledImage;
    }
}

