/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.editor;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.ui.common.Activator;
import org.eclipse.etrice.ui.common.editor.ModificationTrackingEnabler;
import org.eclipse.etrice.ui.common.editor.SaveOnFocusLostListener;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class RoomDiagramEditor
extends DiagramEditor {
    @Inject
    protected IResourceValidator resourceValidator;
    private SaveOnFocusLostListener partListener;
    private ModificationTrackingEnabler mte = new ModificationTrackingEnabler();

    public RoomDiagramEditor() {
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        Map result = EcoreUtil.UnresolvedProxyCrossReferencer.find((ResourceSet)this.getEditingDomain().getResourceSet());
        if (!result.isEmpty()) {
            System.err.println("ERROR in diagram viewer: could not resolve all proxies!");
        }
        this.mte.setTarget(this.getEditingDomain());
    }

    public void dispose() {
        this.mte.unsetTarget(this.getEditingDomain());
        this.getSite().getPage().removePartListener((IPartListener)this.partListener);
        super.dispose();
    }

    public void doSave(final IProgressMonitor monitor) {
        ResourceSet rs = this.getEditingDomain().getResourceSet();
        for (Resource res : rs.getResources()) {
            if (!(res instanceof XtextResource)) continue;
            if (!res.isLoaded()) {
                try {
                    res.load(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)("Internal error: couldn't load referenced resource " + res.getURI()));
                    return;
                }
            }
            if (!res.isModified()) continue;
            XtextResource xres = (XtextResource)res;
            ISerializer serializer = xres.getSerializer();
            if (xres.getContents().isEmpty()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)"Internal error: part of textual model is empty, can't save");
                return;
            }
            serializer.serialize((EObject)xres.getContents().get(0));
            List result = this.resourceValidator.validate(res, CheckMode.NORMAL_AND_FAST, new CancelIndicator(){

                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            });
            if (result.isEmpty()) continue;
            boolean error = false;
            MultiStatus ms = new MultiStatus("org.eclipse.etrice.ui.common", 4, "validation errors during diagram save", null);
            for (Issue issue : result) {
                if (!issue.isSyntaxError() && issue.getSeverity() != Severity.ERROR) continue;
                ms.add((IStatus)new Status(4, "org.eclipse.etrice.ui.common", issue.getMessage()));
                error = true;
            }
            if (!error) continue;
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)"Internal error: model is invalid, can't save");
            Activator.getDefault().getLog().log((IStatus)ms);
            return;
        }
        super.doSave(monitor);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.partListener = new SaveOnFocusLostListener(this);
        this.getSite().getPage().addPartListener((IPartListener)this.partListener);
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public void setFocus() {
        boolean dirtyAlready = this.isDirty();
        super.setFocus();
        if (!dirtyAlready && this.isDirty()) {
            this.doSave(null);
        }
    }
}

