/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.editor;

import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.etrice.ui.common.Activator;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class SaveOnFocusLostListener
implements IPartListener,
CommandStackListener {
    private DiagramEditor editor;
    private IPreferenceStore store;
    private boolean saveAfterCurrentCommand = false;

    public SaveOnFocusLostListener(DiagramEditor editor) {
        this.editor = editor;
        this.store = Activator.getDefault().getPreferenceStore();
        editor.getEditingDomain().getCommandStack().addCommandStackListener((CommandStackListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
        boolean save = this.store.getBoolean("SaveDiagOnFocusLost");
        if (save && this.editor.isDirty()) {
            TransactionalEditingDomainImpl ted;
            if (this.editor.getEditingDomain() instanceof TransactionalEditingDomainImpl && (ted = (TransactionalEditingDomainImpl)this.editor.getEditingDomain()).getActiveTransaction() != null) {
                this.saveAfterCurrentCommand = true;
                return;
            }
            this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void commandStackChanged(EventObject event) {
        if (this.saveAfterCurrentCommand) {
            this.saveAfterCurrentCommand = false;
            this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

