/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.layout;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.ui.layout.ETriceLayoutCommand;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class StructureLayoutCommand
extends ETriceLayoutCommand {
    public StructureLayoutCommand(TransactionalEditingDomain domain, IFeatureProvider thefeatureProvider) {
        super(domain, thefeatureProvider);
    }

    @Override
    protected void applyNodeLayout(KNode knode, PictogramElement pelem) {
        this.setCalculatedPositionAndSize((KGraphElement)knode, knode.getParent(), (ContainerShape)pelem);
        EObject modelObject = (EObject)pelem.getLink().getBusinessObjects().get(0);
        if (modelObject instanceof InterfaceItem) {
            StructureLayoutCommand.adjustLabelForPort((ContainerShape)pelem);
        }
        this.getFeatureProvider().layoutIfPossible((ILayoutContext)new LayoutContext(pelem));
    }

    @Override
    protected void applyPortLayout(KPort kport, PictogramElement pelem) {
        ContainerShape shape = (ContainerShape)((Anchor)pelem).getParent();
        this.setCalculatedPositionAndSize((KGraphElement)kport, kport.getNode(), shape);
        StructureLayoutCommand.adjustLabelForPort(shape);
        this.getFeatureProvider().layoutIfPossible((ILayoutContext)new LayoutContext((PictogramElement)shape));
    }

    private static void adjustLabelForPort(ContainerShape shape) {
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        EObject boContainer = (EObject)shape.getContainer().getLink().getBusinessObjects().get(0);
        EObject bo = (EObject)shape.getLink().getBusinessObjects().get(0);
        if (bo instanceof InterfaceItem) {
            int margin = 40;
            int size = 40;
            if (boContainer instanceof ActorContainerRef) {
                margin = 30;
                size = 18;
            }
            Text label = (Text)((Shape)shape.getChildren().get(0)).getGraphicsAlgorithm();
            StructureLayoutCommand.adjustLabel(label, ga.getX(), ga.getY(), ga.getWidth(), margin, size);
        }
    }

    private static void adjustLabel(Text label, int x, int y, int width, int margin, int size) {
        Orientation align = Orientation.ALIGNMENT_CENTER;
        label.setHorizontalAlignment(align);
        int pos = margin + size / 2;
        if (x <= margin) {
            align = Orientation.ALIGNMENT_LEFT;
        } else if (width - margin <= x) {
            align = Orientation.ALIGNMENT_RIGHT;
        }
        if (y <= margin) {
            pos = (margin - size) / 2;
        }
        if (align != label.getHorizontalAlignment()) {
            label.setHorizontalAlignment(align);
        }
        if (pos != label.getY()) {
            IGaService gaService = Graphiti.getGaService();
            gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, pos, 2 * margin, margin / 2);
        }
    }
}

