/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.layout.preferences;

import de.cau.cs.kieler.kiml.ui.Messages;
import org.eclipse.etrice.ui.layout.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ETriceLayoutPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button animationCheckBox;
    private Button zoomCheckBox;
    private Button progressCheckBox;
    private Button obliqueCheckBox;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 5;

    public ETriceLayoutPreferencePage() {
        this.setDescription("Preferences for eTrice automatic diagram layout");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Group generalGroup = this.createGeneralGroup(composite);
        generalGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Label redirectionText = new Label(composite, 64);
        redirectionText.setAlignment(16384);
        redirectionText.setText("Use sub-pages to set Diagram specific preferences");
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        return composite;
    }

    private Group createGeneralGroup(Composite parent) {
        Group generalGroup = new Group(parent, 0);
        generalGroup.setText(Messages.getString((String)"kiml.ui.35"));
        this.animationCheckBox = new Button((Composite)generalGroup, 16416);
        this.animationCheckBox.setText(Messages.getString((String)"kiml.ui.64"));
        this.animationCheckBox.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.kiml.animation"));
        this.zoomCheckBox = new Button((Composite)generalGroup, 16416);
        this.zoomCheckBox.setText(Messages.getString((String)"kiml.ui.65"));
        this.zoomCheckBox.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.kiml.zoomToFit"));
        this.progressCheckBox = new Button((Composite)generalGroup, 16416);
        this.progressCheckBox.setText(Messages.getString((String)"kiml.ui.66"));
        this.progressCheckBox.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.kiml.progressDialog"));
        this.obliqueCheckBox = new Button((Composite)generalGroup, 16416);
        this.obliqueCheckBox.setText(Messages.getString((String)"kiml.ui.36"));
        this.obliqueCheckBox.setSelection(this.getPreferenceStore().getBoolean("kiml.oblique.route"));
        FillLayout layout = new FillLayout(512);
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        generalGroup.setLayout((Layout)layout);
        return generalGroup;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getSharedPreferenceStore());
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.animationCheckBox.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.kiml.animation"));
        this.zoomCheckBox.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.kiml.zoomToFit"));
        this.progressCheckBox.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.kiml.progressDialog"));
        this.obliqueCheckBox.setSelection(preferenceStore.getDefaultBoolean("kiml.oblique.route"));
    }

    public boolean performOk() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setValue("de.cau.cs.kieler.kiml.animation", this.animationCheckBox.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.kiml.zoomToFit", this.zoomCheckBox.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.kiml.progressDialog", this.progressCheckBox.getSelection());
        preferenceStore.setValue("kiml.oblique.route", this.obliqueCheckBox.getSelection());
        return true;
    }
}

