/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import de.cau.cs.kieler.kiml.service.grana.analyses.NodeSizeAnalysis;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.area";
    public static final int INDEX_WIDTH = 0;
    public static final int INDEX_HEIGHT = 1;

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Area analysis", 1.0f);
        Point2D.Float area = this.computeArea(parentNode);
        progressMonitor.done();
        return new Object[]{Float.valueOf(area.x), Float.valueOf(area.y)};
    }

    private Point2D.Float computeArea(KNode parentNode) {
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (KNode child : parentNode.getChildren()) {
            Rectangle2D.Float nodeRect = NodeSizeAnalysis.computeNodeRect(child, true, true, true);
            minX = Math.min(minX, nodeRect.x);
            minY = Math.min(minY, nodeRect.y);
            maxX = Math.max(maxX, nodeRect.x + nodeRect.width);
            maxY = Math.max(maxY, nodeRect.y + nodeRect.height);
        }
        return new Point2D.Float(maxX - minX, maxY - minY);
    }
}

