/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.views;

import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.LayoutTypeData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.util.KimlUiUtil;
import de.cau.cs.kieler.kiml.ui.views.LayoutPropertyDescriptor;
import de.cau.cs.kieler.kiml.ui.views.LayoutViewPart;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPropertySource
implements IPropertySource {
    private IMutableLayoutConfig layoutConfig;
    private LayoutContext layoutContext;
    private TransactionalEditingDomain editingDomain;
    private IPropertyDescriptor[] propertyDescriptors;
    private final Set<String> dependencyOptions = new HashSet<String>();

    public LayoutPropertySource(IMutableLayoutConfig config, LayoutContext context, TransactionalEditingDomain theeditingDomain) {
        this.layoutConfig = config;
        this.layoutContext = context;
        this.editingDomain = theeditingDomain;
    }

    public LayoutContext getContext() {
        return this.layoutContext;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.layoutContext.setProperty(DefaultLayoutConfig.OPT_MAKE_OPTIONS, (Object)true);
            this.layoutConfig.enrich(this.layoutContext);
            List optionData = (List)this.layoutContext.getProperty(DefaultLayoutConfig.OPTIONS);
            this.filterDependencies(optionData);
            this.propertyDescriptors = new IPropertyDescriptor[optionData.size()];
            ListIterator optionIter = optionData.listIterator();
            while (optionIter.hasNext()) {
                LayoutOptionData data = (LayoutOptionData)optionIter.next();
                this.propertyDescriptors[optionIter.previousIndex()] = new LayoutPropertyDescriptor(data);
            }
        }
        return this.propertyDescriptors;
    }

    private void filterDependencies(List<LayoutOptionData<?>> optionData) {
        this.dependencyOptions.add(LayoutOptions.ALGORITHM.getId());
        ListIterator<LayoutOptionData<?>> optionIter = optionData.listIterator();
        while (optionIter.hasNext()) {
            LayoutOptionData<?> option = optionIter.next();
            boolean visible = option.getDependencies().isEmpty();
            for (Pair dependency : option.getDependencies()) {
                LayoutOptionData targetOption = (LayoutOptionData)dependency.getFirst();
                this.dependencyOptions.add(targetOption.getId());
                Object expectedValue = dependency.getSecond();
                Object value = this.layoutConfig.getValue(targetOption, this.layoutContext);
                if ((expectedValue != null || value == null) && (expectedValue == null || !expectedValue.equals(value))) continue;
                visible = true;
                break;
            }
            if (visible) continue;
            optionIter.remove();
        }
    }

    public Object getPropertyValue(Object id) {
        LayoutDataService layoutServices = LayoutDataService.getInstance();
        LayoutOptionData optionData = layoutServices.getOptionData((String)id);
        Object value = LayoutOptions.ALGORITHM.getId().equals(id) ? ((LayoutAlgorithmData)this.layoutContext.getProperty(DefaultLayoutConfig.CONTENT_ALGO)).getId() : this.layoutConfig.getValue(optionData, this.layoutContext);
        return LayoutPropertySource.translateValue(value, optionData);
    }

    private static Object translateValue(Object value, LayoutOptionData<?> optionData) {
        if (value == null) {
            return "";
        }
        switch (optionData.getType()) {
            case INT: 
            case FLOAT: {
                return value.toString();
            }
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1 : 0;
                }
                if (value instanceof String) {
                    return Boolean.valueOf((String)value) != false ? 1 : 0;
                }
                return value;
            }
            case ENUM: 
            case REMOTE_ENUM: {
                if (value instanceof Enum) {
                    return ((Enum)value).ordinal();
                }
                if (value instanceof String) {
                    String[] choices = optionData.getChoices();
                    int i = 0;
                    while (i < choices.length) {
                        if (choices[i].equals(value)) {
                            return i;
                        }
                        ++i;
                    }
                    return 0;
                }
                return value;
            }
            case OBJECT: {
                return value.toString();
            }
        }
        return value;
    }

    public void setPropertyValue(final Object id, final Object thevalue) {
        LayoutViewPart layoutView;
        if (this.editingDomain == null) {
            throw new UnsupportedOperationException(Messages.getString("kiml.ui.67"));
        }
        Runnable modelChange = new Runnable(){

            public void run() {
                Object value = thevalue;
                LayoutOptionData optionData = LayoutDataService.getInstance().getOptionData((String)id);
                switch (optionData.getType()) {
                    case STRING: {
                        break;
                    }
                    case BOOLEAN: {
                        value = (Integer)value == 1;
                        break;
                    }
                    case ENUM: {
                        value = optionData.getEnumValue(((Integer)value).intValue());
                        break;
                    }
                    case REMOTE_ENUM: {
                        value = optionData.getChoices()[(Integer)value];
                        break;
                    }
                    default: {
                        value = optionData.parseValue((String)value);
                    }
                }
                LayoutPropertySource.this.layoutConfig.setValue(optionData, LayoutPropertySource.this.layoutContext, value);
            }
        };
        KimlUiUtil.runModelChange(modelChange, this.editingDomain, Messages.getString("kiml.ui.11"));
        if (this.dependencyOptions.contains(id) && (layoutView = LayoutViewPart.findView()) != null) {
            layoutView.refresh();
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean isPropertySet(Object id) {
        LayoutOptionData optionData = LayoutDataService.getInstance().getOptionData((String)id);
        return this.layoutConfig.isSet(optionData, this.layoutContext);
    }

    public void resetPropertyValue(Object id) {
        LayoutViewPart layoutView;
        if (this.editingDomain == null) {
            throw new UnsupportedOperationException(Messages.getString("kiml.ui.67"));
        }
        final LayoutOptionData optionData = LayoutDataService.getInstance().getOptionData((String)id);
        Runnable modelChange = new Runnable(){

            public void run() {
                LayoutPropertySource.this.layoutConfig.setValue(optionData, LayoutPropertySource.this.layoutContext, null);
            }
        };
        KimlUiUtil.runModelChange(modelChange, this.editingDomain, Messages.getString("kiml.ui.12"));
        if (this.dependencyOptions.contains(id) && (layoutView = LayoutViewPart.findView()) != null) {
            layoutView.refresh();
        }
    }

    public static String getLayoutHint(String displayedName) {
        String bestHint = null;
        int bestLength = 0;
        for (LayoutAlgorithmData layouterData : LayoutDataService.getInstance().getAlgorithmData()) {
            String name = layouterData.getName();
            if (!displayedName.startsWith(name) || name.length() <= bestLength) continue;
            bestHint = layouterData.getId();
            bestLength = name.length();
        }
        if (bestHint == null) {
            for (LayoutTypeData layoutType : LayoutDataService.getInstance().getTypeData()) {
                String typeId = layoutType.getId();
                String typeName = layoutType.getName();
                if (!displayedName.startsWith(typeName) || typeName.length() <= bestLength) continue;
                bestHint = typeId;
                bestLength = typeName.length();
            }
        }
        return bestHint;
    }
}

