/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.config;

import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SemanticLayoutConfig
implements IMutableLayoutConfig {
    public static final int PRIORITY = 5;

    @Override
    public int getPriority() {
        return 5;
    }

    protected abstract IProperty<?>[] getAffectedOptions(EObject var1);

    protected abstract Object getSemanticValue(EObject var1, LayoutOptionData<?> var2);

    protected abstract void setSemanticValue(EObject var1, LayoutOptionData<?> var2, Object var3);

    @Override
    public void enrich(LayoutContext context) {
        EObject containerElem;
        LayoutDataService layoutDataService = LayoutDataService.getInstance();
        LayoutOptionData<?> algorithmData = layoutDataService.getOptionData(LayoutOptions.ALGORITHM.getId());
        LayoutOptionData<?> diagTypeData = layoutDataService.getOptionData(LayoutOptions.DIAGRAM_TYPE.getId());
        EObject element = (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL);
        if (element != null) {
            String diagType;
            String hint;
            if (context.getProperty(DefaultLayoutConfig.CONTENT_HINT) == null && algorithmData != null && (hint = (String)this.getSemanticValue(element, algorithmData)) != null) {
                context.setProperty(DefaultLayoutConfig.CONTENT_HINT, hint);
            }
            if (context.getProperty(DefaultLayoutConfig.CONTENT_DIAGT) == null && diagTypeData != null && (diagType = (String)this.getSemanticValue(element, diagTypeData)) != null) {
                context.setProperty(DefaultLayoutConfig.CONTENT_DIAGT, diagType);
            }
        }
        if ((containerElem = (EObject)context.getProperty(LayoutContext.CONTAINER_DOMAIN_MODEL)) != null) {
            String diagType;
            String hint;
            if (context.getProperty(DefaultLayoutConfig.CONTAINER_HINT) == null && algorithmData != null && (hint = (String)this.getSemanticValue(containerElem, algorithmData)) != null) {
                context.setProperty(DefaultLayoutConfig.CONTAINER_HINT, hint);
            }
            if (context.getProperty(DefaultLayoutConfig.CONTAINER_DIAGT) == null && diagTypeData != null && (diagType = (String)this.getSemanticValue(containerElem, diagTypeData)) != null) {
                context.setProperty(DefaultLayoutConfig.CONTAINER_DIAGT, diagType);
            }
        }
    }

    @Override
    public final Object getValue(LayoutOptionData<?> optionData, LayoutContext context) {
        EObject element = (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL);
        if (element != null) {
            return this.getSemanticValue(element, optionData);
        }
        return null;
    }

    @Override
    public final void transferValues(KGraphData graphData, LayoutContext context) {
        EObject element = (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL);
        if (element != null) {
            LayoutDataService layoutDataService = LayoutDataService.getInstance();
            IProperty<?>[] affectedOptions = this.getAffectedOptions(element);
            if (affectedOptions != null) {
                IProperty<?>[] iPropertyArray = affectedOptions;
                int n = affectedOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    IProperty<?> property = iPropertyArray[n2];
                    LayoutOptionData<?> optionData = property instanceof LayoutOptionData ? (LayoutOptionData<?>)property : layoutDataService.getOptionData(property.getId());
                    if (optionData != null) {
                        Object value = this.getSemanticValue(element, optionData);
                        graphData.setProperty(property, value);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void clearValues(LayoutContext context) {
        EObject element = (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL);
        if (element != null) {
            LayoutDataService layoutDataService = LayoutDataService.getInstance();
            IProperty<?>[] affectedOptions = this.getAffectedOptions(element);
            if (affectedOptions != null) {
                IProperty<?>[] iPropertyArray = affectedOptions;
                int n = affectedOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    IProperty<?> property = iPropertyArray[n2];
                    LayoutOptionData<?> optionData = property instanceof LayoutOptionData ? (LayoutOptionData<?>)property : layoutDataService.getOptionData(property.getId());
                    if (optionData != null) {
                        this.setSemanticValue(element, optionData, null);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public final void setValue(LayoutOptionData<?> optionData, LayoutContext context, Object value) {
        EObject element = (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL);
        if (element != null) {
            this.setSemanticValue(element, optionData, value);
        }
    }

    @Override
    public final boolean isSet(LayoutOptionData<?> optionData, LayoutContext context) {
        EObject element = (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL);
        if (element != null) {
            return this.getSemanticValue(element, optionData) != null;
        }
        return false;
    }
}

