/*******************************************************************************
 * Copyright (c) 2010 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Thomas Schuetz and Henrik Rentz-Reichert (initial contribution)
 * 
 *******************************************************************************/

package org.eclipse.etrice.core.genmodel.etricegen;

import org.eclipse.etrice.core.room.CPBranchTransition;
import org.eclipse.etrice.core.room.ContinuationTransition;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.Transition;

/**
 * This interface describes the transition chain visitor.
 * The visitor is used by the code generator to generate the code associated with a transition chain.
 * It is passed in a call to
 * {@link org.eclipse.etrice.core.genmodel.etricegen.TransitionChain#genExecuteChain(ITransitionChainVisitor)
 * TransitionChain.genExecuteChain(ITransitionChainVisitor)}.
 * 
 * <p>
 * The visitor has to be implemented by the concrete target language generator.
 * </p>
 * 
 * @author Henrik Rentz-Reichert
 *
 */
public interface ITransitionChainVisitor {
	
	/**
	 * @param tc the transition chain
	 * @return a typed declaration of the data associated with this message 
	 */
	String genTypedData(TransitionChain tc);
	
	/**
	 * @param tr a transition
	 * @return a call of the action operation (as generated by the generator)
	 */
	String genActionOperationCall(Transition tr);
	
	/**
	 * @param state a state
	 * @return a call of the entry operation (as generated by the generator)
	 */
	String genEntryOperationCall(State state);
	
	/**
	 * @param state a state
	 * @return a call of the exit operation (as generated by the generator)
	 */
	String genExitOperationCall(State state);
	
	/**
	 * @param tr a choice point branch transition (not the default branch)
	 * @param isFirst <code>true</code> if this is the first of a series of if statements
	 * @return code for the [else] if statement with condition (guard) and block opening
	 */
	String genElseIfBranch(CPBranchTransition tr, boolean isFirst);
	
	/**
	 * @param tr the choice point default branch transition
	 * @return code for the final else with block opening
	 */
	String genElseBranch(ContinuationTransition tr);
	
	/**
	 * @return the final closing of the block
	 */
	String genEndIf();
	
	/**
	 * @param state a state
	 * @param executeEntryCode <code>true</code> if entry code of state should be executed
	 * @return a return statement with the ID of the state
	 */
	String genReturnState(State state, boolean executeEntryCode);

}
