/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorInstanceMapping;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.Import;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefPath;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RefinedTransition;
import org.eclipse.etrice.core.room.RoomAnnotationTargetEnum;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.SimpleState;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.AbstractRoomJavaValidator;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.validation.Check;

public class RoomJavaValidator
extends AbstractRoomJavaValidator {
    public static final String OPTIONAL_REFS_HAVE_TO_HAVE_MULTIPLICITY_ANY = "optional refs have to have multiplicity any [*]";
    public static final String MULTIPLICITY_ANY_REQUIRES_OPTIONAL = "multiplicity any [*] requires optional";
    public static final String A_REPLICATED_PORT_MUST_HAVE_AT_MOST_ONE_REPLICATED_PEER = "a replicated port must have at most one replicated peer";
    public static final String THREAD_MISSING = "RoomJavaValidator.ThreadMissing";
    public static final String DUPLICATE_ACTOR_INSTANCE_MAPPING = "RoomJavaValidator.DuplicateActorInstanceMapping";
    public static final String WRONG_NAMESPACE = "RoomJavaValidator.WrongNamespace";
    public static final String CIRCULAR_CONTAINMENT = "RoomJavaValidator.CircularContainment";
    public static final String ACTOR_REF_CHANGE_REF_TYPE_TO_FIXED_OR_MULT_TO_ANY = "RoomJavaValidator.ActorRefChangeRefTypeToFixed";
    public static final String ACTOR_REF_CHANGE_REF_TYPE_TO_OPTIONAL = "RoomJavaValidator.ActorRefChangeRefTypeToOptional";
    public static final String CHANGE_DESTRUCTOR_NAME = "RoomJavaValidator.ChangeDestructorName";
    public static final String CHANGE_CONSTRUCTOR_NAME = "RoomJavaValidator.ChangeConstructorName";
    @Inject
    ImportUriResolver importUriResolver;

    @Check
    public void checkImportedNamespace(Import imp) {
        if (imp.getImportedNamespace() == null) {
            return;
        }
        if (imp.getImportURI() == null) {
            return;
        }
        String uriString = this.importUriResolver.resolve((EObject)imp);
        URI uri = URI.createURI((String)uriString);
        ResourceSetImpl rs = new ResourceSetImpl();
        try {
            Resource res = rs.getResource(uri, true);
            if (res == null) {
                return;
            }
            if (res.getContents().isEmpty()) {
                this.error("referenced model is empty", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORT_URI);
                return;
            }
            if (!(res.getContents().get(0) instanceof RoomModel)) {
                if (uri.lastSegment().endsWith(".room")) {
                    this.error("referenced model is no ROOM model (but has .room extension)", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORT_URI);
                } else {
                    this.warning("referenced model is no ROOM model", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORT_URI);
                }
                return;
            }
            RoomModel model = (RoomModel)res.getContents().get(0);
            if (!imp.getImportedNamespace().equals(String.valueOf(model.getName()) + ".*")) {
                this.error("the imported namespace should be '" + model.getName() + ".*'", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORTED_NAMESPACE, WRONG_NAMESPACE, new String[]{String.valueOf(model.getName()) + ".*"});
            }
        }
        catch (RuntimeException re) {
            this.warning("could not load referenced model", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORT_URI);
            return;
        }
    }

    @Check
    public void checkActorRef(ActorRef ar) {
        ActorClass ac;
        if (ar.eContainer() instanceof ActorClass) {
            ac = (ActorClass)ar.eContainer();
            if (ValidationUtil.isReferencing(ar.getType(), ac)) {
                this.error("Actor reference is circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_Type());
            }
        }
        if (ar.getMultiplicity() < 0) {
            if (ar.getRefType() != ReferenceType.OPTIONAL) {
                this.error(MULTIPLICITY_ANY_REQUIRES_OPTIONAL, (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_RefType(), ACTOR_REF_CHANGE_REF_TYPE_TO_OPTIONAL, new String[0]);
            }
        } else if (ar.getMultiplicity() > 1 && ar.getRefType() == ReferenceType.OPTIONAL) {
            this.error(OPTIONAL_REFS_HAVE_TO_HAVE_MULTIPLICITY_ANY, (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_RefType(), ACTOR_REF_CHANGE_REF_TYPE_TO_FIXED_OR_MULT_TO_ANY, new String[]{ar.getName()});
        }
        if (ar != null) {
            ac = ar.getType();
            if (ar.getMultiplicity() > 1) {
                for (Port p : ac.getInterfacePorts()) {
                    if (p.getMultiplicity() >= 0) continue;
                    int idx = ((ActorContainerClass)ar.eContainer()).getActorRefs().indexOf((Object)ar);
                    this.error("replicated actor must not have replicated port with arbitrary multiplicity", (EStructuralFeature)RoomPackage.Literals.ACTOR_CONTAINER_CLASS__ACTOR_REFS, idx);
                }
            }
        }
    }

    @Check
    public void checkLayerConnectiontarget(LayerConnection lc) {
        if (lc.getTo().getRef() instanceof ActorRef && ((ActorRef)lc.getTo().getRef()).getMultiplicity() > 1) {
            int idx = ((StructureClass)lc.eContainer()).getConnections().indexOf((Object)lc);
            this.error("layer connection must not connect to replicated actor", (EStructuralFeature)RoomPackage.Literals.STRUCTURE_CLASS__CONNECTIONS, idx);
        }
    }

    @Check
    public void checkBaseClassesNotCircular(DataClass dc) {
        if (dc == null) {
            return;
        }
        if (ValidationUtil.isCircularClassHierarchy(dc)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getDataClass_Base());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Check
    public void checkAttributeNotCircular(Attribute att) {
        if (att.eContainer() instanceof ActorClass) {
            return;
        }
        if (att.eContainer() instanceof PortClass) {
            return;
        }
        if (!(att.eContainer() instanceof DataClass)) {
            if (!RoomJavaValidator.$assertionsDisabled) {
                throw new AssertionError((Object)"unexpected parent class");
            }
            return;
        }
        dc = (DataClass)att.eContainer();
        if (!ValidationUtil.isCircularClassHierarchy(dc)) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            if (att.getType().getType() == dc && !att.getType().isRef()) {
                this.error("Attribute type must not refer to own class or a super class", (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__TYPE, "RoomJavaValidator.CircularContainment", new String[]{"" + att.getType().getType().getName().length()});
                break;
            }
            dc = dc.getBase();
lbl16:
            // 2 sources

            ** while (dc != null)
        }
lbl17:
        // 2 sources

    }

    @Check
    public void checkAttributeNoStringArray(Attribute att) {
        PrimitiveType type;
        if (!att.getType().isRef() && att.getType().getType() instanceof PrimitiveType && (type = (PrimitiveType)att.getType().getType()).getName().equalsIgnoreCase("string") && att.getSize() > 0) {
            this.error("string type must have multiplicity 0", (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__SIZE);
        }
    }

    @Check
    public void checkBaseClassesNotCircular(ProtocolClass pc) {
        if (pc == null) {
            return;
        }
        if (ValidationUtil.isCircularClassHierarchy(pc)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getProtocolClass_Base());
        }
    }

    @Check
    public void checkBaseClassesNotCircular(ActorClass ac) {
        if (ac == null) {
            return;
        }
        if (ValidationUtil.isCircularClassHierarchy(ac)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_Base());
        }
    }

    @Check
    public void checkUniqueNames(ActorClass ac) {
        if (ValidationUtil.isCircularClassHierarchy(ac)) {
            return;
        }
        HashMap<String, Object> name2obj = new HashMap<String, Object>();
        if (ac.getBase() != null) {
            ActorClass base = ac.getBase();
            List<InterfaceItem> items = RoomHelpers.getAllInterfaceItems(base);
            for (InterfaceItem item : items) {
                name2obj.put(item.getName(), item);
            }
            List<ActorContainerRef> refs = RoomHelpers.getAllActorContainerRefs(base);
            Iterator iterator = refs.iterator();
            while (iterator.hasNext()) {
                ActorContainerRef ref = (ActorContainerRef)iterator.next();
                name2obj.put(ref.getName(), ref);
            }
        }
        List<InterfaceItem> items = RoomHelpers.getInterfaceItems(ac);
        for (InterfaceItem item : items) {
            if (name2obj.containsKey(item.getName())) {
                EObject duplicate = (EObject)name2obj.get(item.getName());
                String location = RoomNameProvider.getLocation(duplicate);
                EObject parent = item.eContainer();
                int idx = ((List)parent.eGet(item.eContainingFeature())).indexOf(item);
                this.error("names must be unique (duplicate of " + location + ")", parent, item.eContainingFeature(), idx);
                continue;
            }
            name2obj.put(item.getName(), item);
        }
        List<ActorContainerRef> refs = RoomHelpers.getRefs(ac, false);
        for (ActorContainerRef ref : refs) {
            if (name2obj.containsKey(ref.getName())) {
                EObject duplicate = (EObject)name2obj.get(ref.getName());
                String location = RoomNameProvider.getLocation(duplicate);
                EObject parent = ref.eContainer();
                int idx = ((List)parent.eGet(ref.eContainingFeature())).indexOf(ref);
                this.error("names must be unique (duplicate of " + location + ")", parent, ref.eContainingFeature(), idx);
                continue;
            }
            name2obj.put(ref.getName(), ref);
        }
    }

    @Check
    public void checkExecModelConsistent(ActorClass ac) {
        if (ValidationUtil.isCircularClassHierarchy(ac)) {
            return;
        }
        ActorCommunicationType commType = ac.getCommType();
        switch (commType) {
            case ASYNCHRONOUS: {
                break;
            }
            case DATA_DRIVEN: {
                break;
            }
            case EVENT_DRIVEN: {
                break;
            }
            case SYNCHRONOUS: {
                this.error("synchronous communication type not supported yet", (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_CommType());
            }
        }
        while (ac.getBase() != null) {
            if (commType == (ac = ac.getBase()).getCommType()) continue;
            this.error("data_driven attribute not consistent in inheritance hierarchy", (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_CommType());
        }
    }

    @Check
    public void checkTopLevelRefinedStates(ActorClass ac) {
        List<ValidationUtil.Result> errors = ValidationUtil.checkTopLevelRefinedStates(ac);
        for (ValidationUtil.Result err : errors) {
            this.error(err);
        }
    }

    @Check
    public void checkRefinedStateUnique(RefinedState rs) {
        StateGraph sg = (StateGraph)rs.eContainer();
        TreeIterator it = sg.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj == rs || !(obj instanceof RefinedState) || rs.getTarget() != ((RefinedState)obj).getTarget()) continue;
            if (rs.eContainer().eContainer() instanceof ActorClass) {
                this.error("refined state conflicts with nested refined state with same target", (EStructuralFeature)RoomPackage.Literals.REFINED_STATE__TARGET);
                continue;
            }
            this.error("refined state not unique", (EStructuralFeature)RoomPackage.Literals.REFINED_STATE__TARGET);
        }
    }

    @Check
    public void checkStateNameUnique(SimpleState s) {
        ValidationUtil.Result result = ValidationUtil.isUniqueName(s, s.getName());
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.Literals.SIMPLE_STATE__NAME);
        }
    }

    @Check
    public void checkSubSystem(SubSystemClass ssc) {
        if (ssc.getActorRefs().isEmpty()) {
            this.warning("SubSystemClass must contain at least one ActorRef", (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_ActorRefs());
        }
        if (ssc.getThreads().isEmpty()) {
            this.warning("at least one thread has to be defined", (EStructuralFeature)RoomPackage.Literals.SUB_SYSTEM_CLASS__THREADS, THREAD_MISSING, new String[]{"LogicalThread dflt_thread"});
        }
        this.checkMappings(ssc.getActorInstanceMappings());
    }

    @Check
    public void checkLogicalSystem(LogicalSystem ls) {
        if (ls.getSubSystems().isEmpty()) {
            this.error("LogicalSystem must contain at least one SubSystemRef", (EStructuralFeature)RoomPackage.eINSTANCE.getLogicalSystem_SubSystems());
        }
    }

    @Check
    public void checkActorInstanceMapping(ActorInstanceMapping aim) {
        RefPath path;
        ActorContainerClass root = RoomHelpers.getParentContainer(aim);
        if (root != null && !root.eIsProxy() && (path = aim.getPath()) != null) {
            String invalidSegment = RoomHelpers.checkPath(root, path);
            if (invalidSegment != null) {
                this.error("no match for segment '" + invalidSegment + "'", (EStructuralFeature)RoomPackage.Literals.ACTOR_INSTANCE_MAPPING__PATH);
            } else {
                ActorRef aRef = RoomHelpers.getLastActorRef(root, path);
                if (aRef == null) {
                    this.error("invalid actor reference", (EStructuralFeature)RoomPackage.Literals.ACTOR_INSTANCE_MAPPING__PATH);
                }
            }
        }
        this.checkMappings(aim.getActorInstanceMappings());
    }

    private void checkMappings(EList<ActorInstanceMapping> actorInstanceMappings) {
        HashSet<String> paths = new HashSet<String>();
        for (ActorInstanceMapping aim : actorInstanceMappings) {
            if (paths.add(aim.getPath().toString())) continue;
            EObject parent = aim.eContainer();
            int idx = actorInstanceMappings.indexOf((Object)aim);
            this.error("duplicate mapping", parent, aim.eContainingFeature(), idx, DUPLICATE_ACTOR_INSTANCE_MAPPING, new String[0]);
        }
    }

    @Check
    public void checkPortCompatibility(Binding bind) {
        ValidationUtil.Result result = ValidationUtil.isValid(bind);
        if (!result.isOk()) {
            EObject sc = bind.eContainer();
            int idx = ((List)sc.eGet(bind.eContainingFeature())).indexOf(bind);
            this.error(result.getMsg(), sc, bind.eContainingFeature(), idx);
        }
    }

    @Check
    public void checkServiceCompatibility(LayerConnection conn) {
        ValidationUtil.Result result = ValidationUtil.isValid(conn);
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
        }
    }

    @Check
    public void checkTrPoint(TrPoint tp) {
        ValidationUtil.Result result = ValidationUtil.isValid(tp);
        if (!result.isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkChoicePoint(ChoicePoint cp) {
        if (!ValidationUtil.isUniqueName(cp, cp.getName()).isOk()) {
            this.error("name is not unique", (EStructuralFeature)RoomPackage.Literals.CHOICE_POINT__NAME);
        }
    }

    @Check
    public void checkInterfaceItemUniqueName(InterfaceItem item) {
        ValidationUtil.Result result = ValidationUtil.isUniqueName(item);
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.eINSTANCE.getInterfaceItem_Name());
        }
    }

    @Check
    public void checkTransition(Transition trans) {
        ValidationUtil.Result result = ValidationUtil.checkTransition(trans);
        if (!result.isOk()) {
            this.error(result);
        }
        if (!(result = trans instanceof InitialTransition ? ValidationUtil.isConnectable(null, trans.getTo(), trans, (StateGraph)trans.eContainer()) : ValidationUtil.isConnectable(((NonInitialTransition)trans).getFrom(), trans.getTo(), trans, (StateGraph)trans.eContainer())).isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkState(State state) {
        ValidationUtil.Result result = ValidationUtil.checkState(state);
        if (!result.isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkPortCommunicationCompatibility(ActorClass ac) {
        if (ac.getCommType() == ActorCommunicationType.SYNCHRONOUS) {
            return;
        }
        ArrayList<Port> extPorts = new ArrayList<Port>();
        for (ExternalPort exPort : ac.getExternalPorts()) {
            extPorts.add(exPort.getInterfacePort());
        }
        this.checkPortCommunicationCompatibility(ac, extPorts, RoomPackage.eINSTANCE.getActorClass_ExternalPorts());
        this.checkPortCommunicationCompatibility(ac, (List<? extends InterfaceItem>)ac.getInternalPorts(), RoomPackage.eINSTANCE.getActorClass_InternalPorts());
        this.checkPortCommunicationCompatibility(ac, (List<? extends InterfaceItem>)ac.getServiceAccessPoints(), RoomPackage.eINSTANCE.getActorClass_ServiceAccessPoints());
        ArrayList<SPP> serviceImpls = new ArrayList<SPP>();
        for (ServiceImplementation si : ac.getServiceImplementations()) {
            serviceImpls.add(si.getSpp());
        }
        this.checkPortCommunicationCompatibility(ac, serviceImpls, RoomPackage.eINSTANCE.getActorClass_ServiceImplementations());
    }

    private void checkPortCommunicationCompatibility(ActorClass ac, List<? extends InterfaceItem> items, EReference ref) {
        boolean datadriven = ac.getCommType() == ActorCommunicationType.DATA_DRIVEN;
        boolean eventdriven = ac.getCommType() == ActorCommunicationType.EVENT_DRIVEN;
        boolean async = ac.getCommType() == ActorCommunicationType.ASYNCHRONOUS;
        block4: for (InterfaceItem interfaceItem : items) {
            ProtocolClass pc = RoomHelpers.getProtocol(interfaceItem);
            if (pc == null) continue;
            switch (pc.getCommType()) {
                case DATA_DRIVEN: {
                    if (datadriven || async) continue block4;
                    this.error("ports with datadriven protocols not allowed", (EStructuralFeature)ref, items.indexOf(interfaceItem));
                    break;
                }
                case EVENT_DRIVEN: {
                    if (eventdriven || async) continue block4;
                    this.error("ports with eventdriven protocols not allowed", (EStructuralFeature)ref, items.indexOf(interfaceItem));
                }
            }
        }
    }

    @Check
    public void checkPort(Port port) {
        if (port.getMultiplicity() == 0) {
            this.error("multiplicity must not be 0", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
        if (port.getMultiplicity() < -1) {
            this.error("multiplicity must be -1 or positive", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
        if (port.getProtocol() instanceof ProtocolClass && ((ProtocolClass)port.getProtocol()).getCommType() == CommunicationType.DATA_DRIVEN && port.getMultiplicity() != 1) {
            this.error("multiplicity must be 1 for data driven ports", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
    }

    @Check
    public void checkProtocol(ProtocolClass pc) {
        if (ValidationUtil.isCircularClassHierarchy(pc)) {
            return;
        }
        switch (pc.getCommType()) {
            case DATA_DRIVEN: {
                if (pc.getBase() != null && pc.getBase().getCommType() != CommunicationType.DATA_DRIVEN) {
                    this.error("super protocol has to have same communication type", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
                }
                if (RoomHelpers.getAllMessages(pc, true).isEmpty()) {
                    this.error("at least one incoming message must be defined", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__INCOMING_MESSAGES);
                }
                if (RoomHelpers.getAllMessages(pc, false).isEmpty()) break;
                this.error("data driven protocols must have no outgoing messages", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__OUTGOING_MESSAGES);
                break;
            }
            case EVENT_DRIVEN: {
                if (pc.getBase() != null && pc.getBase().getCommType() != CommunicationType.EVENT_DRIVEN) {
                    this.error("super protocol has to have same communication type", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
                }
                if (!RoomHelpers.getAllMessages(pc, true).isEmpty() || !RoomHelpers.getAllMessages(pc, false).isEmpty()) break;
                this.error("at least one message (incoming or outgoing) must be defined", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__INCOMING_MESSAGES);
                break;
            }
            case SYNCHRONOUS: {
                this.error("synchronous communication type not supported yet", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
            }
        }
        if (pc.getBase() != null) {
            int idx;
            if (pc.getIncomingMessages().size() > 0 && pc.getOutgoingMessages().size() > 0) {
                this.warning("a derived protocol should add either incoming or outgoing messages, not both", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__OUTGOING_MESSAGES);
            }
            List<Message> incoming = RoomHelpers.getAllMessages(pc, true);
            HashSet<String> inNames = new HashSet<String>();
            for (Message in : incoming) {
                if (inNames.add(in.getName()) || (idx = pc.getIncomingMessages().indexOf((Object)in)) < 0) continue;
                this.error("duplicate message name", pc, (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__INCOMING_MESSAGES, idx);
            }
            List<Message> outgoing = RoomHelpers.getAllMessages(pc, true);
            HashSet<String> outNames = new HashSet<String>();
            for (Message out : outgoing) {
                if (outNames.add(out.getName()) || (idx = pc.getOutgoingMessages().indexOf((Object)out)) < 0) continue;
                this.error("duplicate message name", pc, (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__OUTGOING_MESSAGES, idx);
            }
        }
    }

    @Check
    public void checkMessage(Message msg) {
        ProtocolClass pc = (ProtocolClass)msg.eContainer();
        if (pc.getCommType() == CommunicationType.DATA_DRIVEN && msg.getData() == null) {
            this.error("Messages of data driven protocols must carry data", (EStructuralFeature)RoomPackage.Literals.MESSAGE__DATA);
        }
    }

    @Check
    public void checkMessageFromIf(MessageFromIf mfi) {
        if (mfi.getFrom() != null && RoomHelpers.getProtocol(mfi.getFrom()).getCommType() != CommunicationType.EVENT_DRIVEN) {
            this.error("port must have event driven protocol", mfi, (EStructuralFeature)RoomPackage.eINSTANCE.getMessageFromIf_From());
        }
    }

    @Check
    public void checkOperation(StandardOperation op) {
        if (RoomHelpers.isConstructor(op)) {
            if (!op.getArguments().isEmpty()) {
                this.error("Constructor must have no arguments", (EStructuralFeature)RoomPackage.Literals.OPERATION__ARGUMENTS);
            }
            if (op.getReturnType() != null) {
                this.error("Constructor must have no return type", (EStructuralFeature)RoomPackage.Literals.OPERATION__RETURN_TYPE);
            }
        } else if (RoomHelpers.isDestructor(op)) {
            if (!op.getArguments().isEmpty()) {
                this.error("Destructor must have no arguments", (EStructuralFeature)RoomPackage.Literals.OPERATION__ARGUMENTS);
            }
            if (op.getReturnType() != null) {
                this.error("Destructor must have no return type", (EStructuralFeature)RoomPackage.Literals.OPERATION__RETURN_TYPE);
            }
        } else if (op.isDestructor()) {
            RoomClass cls = (RoomClass)op.eContainer();
            this.error("Destructor must have class name", (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME, CHANGE_DESTRUCTOR_NAME, new String[]{cls.getName()});
        } else if (op.getArguments().isEmpty()) {
            RoomClass cls = (RoomClass)op.eContainer();
            EList<StandardOperation> ops = null;
            if (cls instanceof ActorClass) {
                ops = ((ActorClass)cls).getOperations();
            } else if (cls instanceof DataClass) {
                ops = ((DataClass)cls).getOperations();
            } else assert (false) : "unexpected parent class";
            for (StandardOperation o : ops) {
                if (!o.isDestructor() || !o.getName().equals(op.getName())) continue;
                this.warning("Constructor meant?", (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME, CHANGE_CONSTRUCTOR_NAME, new String[]{cls.getName()});
            }
        }
    }

    @Check
    public void checkRefinedTransition(RefinedTransition rt) {
        if (!(rt.eContainer().eContainer() instanceof ActorClass)) {
            StateGraph sg = (StateGraph)rt.eContainer();
            int idx = sg.getRefinedTransitions().indexOf((Object)rt);
            this.error("RefinedTransition only allowed in top level state graph of an actor", sg, (EStructuralFeature)RoomPackage.Literals.STATE_GRAPH__REFINED_TRANSITIONS, idx);
        }
    }

    @Check
    public void checkDataClass(DataClass dc) {
        if (dc.getAttributes().isEmpty() && dc.getBase() == null) {
            this.error("Non-derived data classes have to define at least one attribute", (EStructuralFeature)RoomPackage.Literals.DATA_CLASS__ATTRIBUTES);
        }
    }

    @Check
    public void checkAttribute(Attribute att) {
        ArrayList<Attribute> all = new ArrayList<Attribute>();
        if (att.eContainer() instanceof ActorClass) {
            ActorClass ac = (ActorClass)att.eContainer();
            if (ValidationUtil.isCircularClassHierarchy(ac)) {
                return;
            }
            do {
                all.addAll((Collection<Attribute>)ac.getAttributes());
            } while ((ac = ac.getBase()) != null);
        } else if (att.eContainer() instanceof DataClass) {
            DataClass dc = (DataClass)att.eContainer();
            if (ValidationUtil.isCircularClassHierarchy(dc)) {
                return;
            }
            do {
                all.addAll((Collection<Attribute>)dc.getAttributes());
            } while ((dc = dc.getBase()) != null);
        }
        String name = att.getName();
        for (Attribute a : all) {
            if (a == att || !a.getName().equals(name)) continue;
            if (a.eContainer() != att.eContainer()) {
                this.error("name already used in base class '" + ((RoomClass)a.eContainer()).getName() + "'", (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__NAME);
                continue;
            }
            this.error("name already used", (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__NAME);
        }
    }

    @Check
    public void checkReplicatedPortBindingPatterns(StructureClass sc) {
        HashSet<Port> haveReplPeer = new HashSet<Port>();
        for (Binding bind : sc.getBindings()) {
            Port p1 = bind.getEndpoint1().getPort();
            Port p2 = bind.getEndpoint2().getPort();
            if (p1.getMultiplicity() == 1 || p2.getMultiplicity() == 1) continue;
            if (!haveReplPeer.add(p1)) {
                this.error(A_REPLICATED_PORT_MUST_HAVE_AT_MOST_ONE_REPLICATED_PEER, bind, (EStructuralFeature)RoomPackage.Literals.BINDING__ENDPOINT1);
            }
            if (haveReplPeer.add(p2)) continue;
            this.error(A_REPLICATED_PORT_MUST_HAVE_AT_MOST_ONE_REPLICATED_PEER, bind, (EStructuralFeature)RoomPackage.Literals.BINDING__ENDPOINT2);
        }
    }

    @Check
    public void checkDetailCode(DetailCode dc) {
        if (dc.getLines().isEmpty()) {
            this.error("detail code must not be empty", dc, (EStructuralFeature)RoomPackage.Literals.DETAIL_CODE__LINES);
        }
    }

    @Check
    public void checkPortClassContents(PortClass pc) {
        if (pc.getAttributes().isEmpty() && pc.getMsgHandlers().isEmpty() && pc.getOperations().isEmpty()) {
            this.error("port class must not be empty", pc, (EStructuralFeature)RoomPackage.Literals.PORT_CLASS__ATTRIBUTES);
        }
    }

    @Check
    public void checkCompoundProtocolClass(CompoundProtocolClass cpc) {
        if (cpc.getSubProtocols().isEmpty()) {
            this.error("no sub protocols defined", cpc, (EStructuralFeature)RoomPackage.Literals.COMPOUND_PROTOCOL_CLASS__SUB_PROTOCOLS);
        }
    }

    @Check
    public void checkAnnotationTarget(Annotation a) {
        if (a.getType() == null || a.getType().eIsProxy()) {
            return;
        }
        EObject parent = a.eContainer();
        EList targetList = a.getType().getTargets();
        RoomAnnotationTargetEnum invalidTargetType = null;
        if (parent instanceof ActorClass) {
            ActorClass actorParent = (ActorClass)parent;
            if (actorParent.getAnnotations().contains((Object)a) && !targetList.contains((Object)RoomAnnotationTargetEnum.ACTOR_CLASS.getLiteral())) {
                invalidTargetType = RoomAnnotationTargetEnum.ACTOR_CLASS;
            } else if (actorParent.getBehaviorAnnotations().contains((Object)a) && !targetList.contains((Object)RoomAnnotationTargetEnum.ACTOR_BEHAVIOR.getLiteral())) {
                invalidTargetType = RoomAnnotationTargetEnum.ACTOR_BEHAVIOR;
            }
        } else if (parent instanceof DataClass && !targetList.contains((Object)RoomAnnotationTargetEnum.DATA_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.DATA_CLASS;
        } else if (parent instanceof ProtocolClass && !targetList.contains((Object)RoomAnnotationTargetEnum.PROTOCOL_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.PROTOCOL_CLASS;
        } else if (parent instanceof CompoundProtocolClass && !targetList.contains((Object)RoomAnnotationTargetEnum.COMPOUND_PROTOCOL_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.COMPOUND_PROTOCOL_CLASS;
        } else if (parent instanceof LogicalSystem && !targetList.contains((Object)RoomAnnotationTargetEnum.LOGICAL_SYSTEM_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.LOGICAL_SYSTEM_CLASS;
        } else if (parent instanceof SubSystemClass && !targetList.contains((Object)RoomAnnotationTargetEnum.SUBSYSTEM_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.SUBSYSTEM_CLASS;
        }
        if (invalidTargetType != null) {
            this.error("AnnotationType " + a.getType().getName() + " is not allowed for target " + invalidTargetType.getLiteral(), (EObject)a, (EStructuralFeature)BasePackage.Literals.ANNOTATION__TYPE);
        }
    }

    @Check
    public void checkRoomClassAnnotationTypeUniqueness(RoomClass rc) {
        if (rc.eContainer() instanceof RoomModel) {
            RoomModel model = (RoomModel)rc.eContainer();
            for (AnnotationType at : model.getAnnotationTypes()) {
                if (!rc.getName().equals(at.getName())) continue;
                this.error("The name \"" + at.getName() + "\" already exists as an AnnotationType name", rc, (EStructuralFeature)RoomPackage.Literals.ROOM_CLASS__NAME);
            }
        }
    }

    @Check
    public void checkRoomClassAnnotationTypeUniqueness(AnnotationType at) {
        if (at.eContainer() instanceof RoomModel) {
            RoomModel model = (RoomModel)at.eContainer();
            for (Object obj : EcoreUtil.getObjectsByType((Collection)model.eContents(), (EClassifier)RoomPackage.Literals.ROOM_CLASS)) {
                RoomClass rc = (RoomClass)obj;
                if (!at.getName().equals(rc.getName())) continue;
                this.error("The name \"" + at.getName() + "\" already exists as a RoomClass name", (EObject)at, (EStructuralFeature)BasePackage.Literals.ANNOTATION_TYPE__NAME);
            }
        }
    }

    private void error(ValidationUtil.Result result) {
        this.error(result.getMsg(), result.getSource(), result.getFeature(), result.getIndex());
    }
}

