/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.GeneratorSettings;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.cpp.gen.StateMachineGen;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ActorClassGen
extends GenericActorClassGenerator {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private CppExtensions _cppExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private Initialization _initialization;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private StateMachineGen _stateMachineGen;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _xpActorClasses = root.getXpActorClasses();
        for (ExpandedActorClass xpac : _xpActorClasses) {
            ActorClass _actorClass = xpac.getActorClass();
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_actorClass);
            ActorClass _actorClass_1 = xpac.getActorClass();
            String _path = this._roomExtensions.getPath((RoomClass)_actorClass_1);
            String path = String.valueOf(_generationTargetPath) + _path;
            ActorClass _actorClass_2 = xpac.getActorClass();
            String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName((RoomClass)_actorClass_2);
            String _plus = "generating ActorClass header '" + _cppHeaderFileName;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            ActorClass _actorClass_3 = xpac.getActorClass();
            String _cppHeaderFileName_1 = this._cppExtensions.getCppHeaderFileName((RoomClass)_actorClass_3);
            ActorClass _actorClass_4 = xpac.getActorClass();
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, xpac, _actorClass_4);
            this.fileAccess.generateFile(_cppHeaderFileName_1, _generateHeaderFile);
            ActorClass _actorClass_5 = xpac.getActorClass();
            String _cppSourceFileName = this._cppExtensions.getCppSourceFileName((RoomClass)_actorClass_5);
            String _plus_4 = "generating ActorClass source '" + _cppSourceFileName;
            String _plus_5 = String.valueOf(_plus_4) + "' in '";
            String _plus_6 = String.valueOf(_plus_5) + path;
            String _plus_7 = String.valueOf(_plus_6) + "'";
            this.logger.logInfo(_plus_7);
            this.fileAccess.setOutputPath(path);
            ActorClass _actorClass_6 = xpac.getActorClass();
            String _cppSourceFileName_1 = this._cppExtensions.getCppSourceFileName((RoomClass)_actorClass_6);
            ActorClass _actorClass_7 = xpac.getActorClass();
            CharSequence _generateSourceFile = this.generateSourceFile(root, xpac, _actorClass_7);
            this.fileAccess.generateFile(_cppSourceFileName_1, _generateSourceFile);
        }
    }

    private CharSequence generateHeaderFile(Root root, ExpandedActorClass xpac, ActorClass ac) {
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Header File of ActorClass ");
        String _name = ac.getName();
        _builder.append((Object)_name, "\t ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_1 = ac.getName();
        CharSequence _generateIncludeGuardBegin = this._cppExtensions.generateIncludeGuardBegin(_name_1);
        _builder.append((Object)_generateIncludeGuardBegin, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"platforms/generic/etDatatypes.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/messaging/IRTObject.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/modelbase/PortBase.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/modelbase/InterfaceItemBase.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/modelbase/ActorClassBase.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/modelbase/SubSystemClassBase.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/messaging/Address.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/messaging/IMessageReceiver.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        GeneratorSettings _settings = Main.getSettings();
        boolean _isUseEtUnit2 = _settings.isUseEtUnit();
        if (_isUseEtUnit2) {
            _builder.append((Object)"\t");
            _builder.append((Object)"extern \"C\" {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"#include \"etUnit.h\"");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"#include <string>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include <vector>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _referencedModels = root.getReferencedModels((RoomClass)ac);
        for (RoomModel _isUseEtUnit2 : _referencedModels) {
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)ac);
        for (ProtocolClass pc : _referencedProtocolClasses) {
            _builder.append((Object)"\t");
            _builder.append((Object)"#include \"");
            String _path = this._roomExtensions.getPath((RoomClass)pc);
            _builder.append((Object)_path, "\t");
            String _name_2 = pc.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)ac);
        for (DataClass dc : _referencedDataClasses) {
            _builder.append((Object)"\t");
            _builder.append((Object)"#include \"");
            String _path_1 = this._roomExtensions.getPath((RoomClass)dc);
            _builder.append((Object)_path_1, "\t");
            String _name_3 = dc.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)ac, 1, true);
        _builder.append((Object)_userCode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"class ");
        String _name_4 = ac.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" : public ");
        ActorClass _base = ac.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            ActorClass _base_1 = ac.getBase();
            String _name_5 = _base_1.getName();
            _builder.append((Object)_name_5, "\t");
        } else {
            _builder.append((Object)"etRuntime::ActorClassBase");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"protected:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"//--------------------- ports");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        List _endPorts = RoomHelpers.getEndPorts((ActorClass)ac);
        Functions.Function1<Port, String> _function = new Functions.Function1<Port, String>(){

            public String apply(Port port) {
                StringConcatenation _builder = new StringConcatenation();
                String _portClassName = ActorClassGen.this._roomExtensions.getPortClassName((EObject)port);
                _builder.append((Object)_portClassName, "");
                _builder.append((Object)" ");
                String _name = port.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)";");
                return _builder.toString();
            }
        };
        List _map = ListExtensions.map((List)_endPorts, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"//--------------------- saps");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        EList _serviceAccessPoints = ac.getServiceAccessPoints();
        Functions.Function1<SAP, String> _function_1 = new Functions.Function1<SAP, String>(){

            public String apply(SAP sap) {
                StringConcatenation _builder = new StringConcatenation();
                String _portClassName = ActorClassGen.this._roomExtensions.getPortClassName((EObject)sap);
                _builder.append((Object)_portClassName, "");
                _builder.append((Object)" ");
                String _name = sap.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)";");
                return _builder.toString();
            }
        };
        List _map_1 = ListExtensions.map((List)_serviceAccessPoints, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"\n");
        _builder.append((Object)_join_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"//--------------------- services");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        EList _serviceImplementations = ac.getServiceImplementations();
        Functions.Function1<ServiceImplementation, String> _function_2 = new Functions.Function1<ServiceImplementation, String>(){

            public String apply(ServiceImplementation svc) {
                StringConcatenation _builder = new StringConcatenation();
                String _portClassName = ActorClassGen.this._roomExtensions.getPortClassName((EObject)svc);
                _builder.append((Object)_portClassName, "");
                _builder.append((Object)" ");
                SPP _spp = svc.getSpp();
                String _name = _spp.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)";");
                return _builder.toString();
            }
        };
        List _map_2 = ListExtensions.map((List)_serviceImplementations, (Functions.Function1)_function_2);
        String _join_2 = IterableExtensions.join((Iterable)_map_2, (CharSequence)"\n");
        _builder.append((Object)_join_2, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"//--------------------- interface item IDs");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        String _genInterfaceItemConstants = this.genInterfaceItemConstants(xpac);
        _builder.append((Object)_genInterfaceItemConstants, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        EList _attributes = ac.getAttributes();
        CharSequence _attributes_1 = this._procedureHelpers.attributes((List)_attributes);
        _builder.append((Object)_attributes_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation(ac);
        _builder.append((Object)_operationsImplementation, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"//--------------------- construction");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        String _name_6 = ac.getName();
        _builder.append((Object)_name_6, "\t\t\t");
        _builder.append((Object)"(etRuntime::IRTObject* parent, std::string name, const std::vector<std::vector<etRuntime::Address> >& port_addr, ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  ");
        _builder.append((Object)"const std::vector<std::vector<etRuntime::Address> >& peer_addr);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"//--------------------- port getters");
        _builder.newLine();
        List _endPorts_1 = RoomHelpers.getEndPorts((ActorClass)ac);
        for (Port ep : _endPorts_1) {
            _builder.append((Object)"\t\t");
            String _portClassName = this._roomExtensions.getPortClassName((EObject)ep);
            String _name_7 = ep.getName();
            String _name_8 = ac.getName();
            CharSequence _terImplementation = this._procedureHelpers.getterImplementation(_portClassName, _name_7, _name_8);
            _builder.append((Object)_terImplementation, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        EList _serviceAccessPoints_1 = ac.getServiceAccessPoints();
        for (SAP sap : _serviceAccessPoints_1) {
            _builder.append((Object)"\t\t");
            String _portClassName_1 = this._roomExtensions.getPortClassName((EObject)sap);
            String _name_9 = sap.getName();
            String _name_10 = ac.getName();
            CharSequence _terImplementation_1 = this._procedureHelpers.getterImplementation(_portClassName_1, _name_9, _name_10);
            _builder.append((Object)_terImplementation_1, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        EList _serviceImplementations_1 = ac.getServiceImplementations();
        for (ServiceImplementation svc : _serviceImplementations_1) {
            _builder.append((Object)"\t\t");
            String _portClassName_2 = this._roomExtensions.getPortClassName((EObject)svc);
            SPP _spp = svc.getSpp();
            String _name_11 = _spp.getName();
            String _name_12 = ac.getName();
            CharSequence _terImplementation_2 = this._procedureHelpers.getterImplementation(_portClassName_2, _name_11, _name_12);
            _builder.append((Object)_terImplementation_2, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//--------------------- lifecycle functions");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"virtual void init();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"virtual void start();");
        _builder.newLine();
        boolean _overridesStop = this._roomExtensions.overridesStop(ac);
        boolean bl2 = _not = !_overridesStop;
        if (_not) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"virtual void stop();");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"virtual void destroy();\t\t\t");
        _builder.newLine();
        boolean _hasNonEmptyStateMachine = RoomHelpers.hasNonEmptyStateMachine((ActorClass)ac);
        if (_hasNonEmptyStateMachine) {
            _builder.append((Object)"\t\t");
            CharSequence _genStateMachineMethodDeclarations = this._stateMachineGen.genStateMachineMethodDeclarations(xpac);
            _builder.append((Object)_genStateMachineMethodDeclarations, "\t\t");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _not_1;
            boolean _hasStateMachine = xpac.hasStateMachine();
            boolean bl3 = _not_1 = !_hasStateMachine;
            if (_not_1) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public: ");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"//--------------------- no state machine");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"virtual void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* data);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"virtual void executeInitTransition();");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode((ActorContainerClass)ac, 2, false);
        _builder.append((Object)_userCode_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_13 = ac.getName();
        CharSequence _generateIncludeGuardEnd = this._cppExtensions.generateIncludeGuardEnd(_name_13);
        _builder.append((Object)_generateIncludeGuardEnd, "\t");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private String generateConstructorInitalizerList(ActorClass ac) {
        ArrayList<Object> _arrayList;
        ArrayList<Object> initializerList = _arrayList = new ArrayList<Object>();
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"ActorClassBase( parent, name, port_addr[0][0], peer_addr[0][0])");
            initializerList.add(_builder);
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            ActorClass _base_1 = ac.getBase();
            String _name = _base_1.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)"(*this, parent, name, port_addr, peer_addr)");
            initializerList.add(_builder_1);
        }
        List _endPorts = RoomHelpers.getEndPorts((ActorClass)ac);
        for (Port ep : _endPorts) {
            boolean _equals_3;
            boolean _equals_2;
            boolean _equals_1;
            Iterator _builder_2 = new StringConcatenation();
            String _name_1 = ep.getName();
            _builder_2.append(_name_1, "");
            _builder_2.append("(*this, this, \"");
            String _name_2 = ep.getName();
            _builder_2.append(_name_2, "");
            _builder_2.append("\", IFITEM_");
            String _name_3 = ep.getName();
            _builder_2.append(_name_3, "");
            _builder_2.append(", ");
            int _multiplicity = ep.getMultiplicity();
            boolean bl = _equals_1 = _multiplicity == 1;
            if (_equals_1) {
                _builder_2.append("0, ");
            }
            _builder_2.append("port_addr[IFITEM_");
            String _name_4 = ep.getName();
            _builder_2.append(_name_4, "");
            _builder_2.append("]");
            int _multiplicity_1 = ep.getMultiplicity();
            boolean bl2 = _equals_2 = _multiplicity_1 == 1;
            if (_equals_2) {
                _builder_2.append("[0]");
            }
            _builder_2.append(", peer_addr[IFITEM_");
            String _name_5 = ep.getName();
            _builder_2.append(_name_5, "");
            _builder_2.append("]");
            int _multiplicity_2 = ep.getMultiplicity();
            boolean bl3 = _equals_3 = _multiplicity_2 == 1;
            if (_equals_3) {
                _builder_2.append("[0]");
            }
            _builder_2.append(")");
            initializerList.add(_builder_2);
        }
        EList _serviceAccessPoints = ac.getServiceAccessPoints();
        for (SAP sap : _serviceAccessPoints) {
            Iterator _builder_3 = new StringConcatenation();
            String _name_6 = sap.getName();
            _builder_3.append(_name_6, "");
            _builder_3.append("(*this, this, \"");
            String _name_7 = sap.getName();
            _builder_3.append(_name_7, "");
            _builder_3.append("\", IFITEM_");
            String _name_8 = sap.getName();
            _builder_3.append(_name_8, "");
            _builder_3.append(", 0, port_addr[IFITEM_");
            String _name_9 = sap.getName();
            _builder_3.append(_name_9, "");
            _builder_3.append("][0], peer_addr[IFITEM_");
            String _name_10 = sap.getName();
            _builder_3.append(_name_10, "");
            _builder_3.append("][0])");
            initializerList.add(_builder_3);
        }
        EList _serviceImplementations = ac.getServiceImplementations();
        for (ServiceImplementation svc : _serviceImplementations) {
            Iterator _builder_4 = new StringConcatenation();
            SPP _spp = svc.getSpp();
            String _name_11 = _spp.getName();
            _builder_4.append(_name_11, "");
            _builder_4.append("(*this, this, \"");
            SPP _spp_1 = svc.getSpp();
            String _name_12 = _spp_1.getName();
            _builder_4.append(_name_12, "");
            _builder_4.append("\", IFITEM_");
            SPP _spp_2 = svc.getSpp();
            String _name_13 = _spp_2.getName();
            _builder_4.append(_name_13, "");
            _builder_4.append(", port_addr[IFITEM_");
            SPP _spp_3 = svc.getSpp();
            String _name_14 = _spp_3.getName();
            _builder_4.append(_name_14, "");
            _builder_4.append("], peer_addr[IFITEM_");
            SPP _spp_4 = svc.getSpp();
            String _name_15 = _spp_4.getName();
            _builder_4.append(_name_15, "");
            _builder_4.append("])");
            initializerList.add(_builder_4);
        }
        EList _attributes = ac.getAttributes();
        for (Attribute attrib : _attributes) {
            CharSequence _attributeInitialization = this._initialization.attributeInitialization(attrib, false);
            initializerList.add(_attributeInitialization);
        }
        StringConcatenation _builder_5 = new StringConcatenation();
        String _join = IterableExtensions.join(initializerList, (CharSequence)",\n");
        _builder_5.append((Object)_join, "");
        _builder_5.newLineIfNotEmpty();
        return _builder_5.toString();
    }

    private CharSequence generateSourceFile(Root root, ExpandedActorClass xpac, ActorClass ac) {
        boolean _notEquals_1;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        EList _operations = ac.getOperations();
        Functions.Function1<StandardOperation, Boolean> _function = new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation op) {
                boolean _isConstructor = RoomHelpers.isConstructor((Operation)op);
                return _isConstructor;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_operations, (Functions.Function1)_function);
        StandardOperation ctor = (StandardOperation)IterableExtensions.head((Iterable)_filter);
        EList _operations_1 = ac.getOperations();
        Functions.Function1<StandardOperation, Boolean> _function_1 = new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation op) {
                boolean _isDestructor = op.isDestructor();
                return _isDestructor;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_operations_1, (Functions.Function1)_function_1);
        StandardOperation dtor = (StandardOperation)IterableExtensions.head((Iterable)_filter_1);
        ActorClass _actorClass = xpac.getActorClass();
        ActorCommunicationType _commType = _actorClass.getCommType();
        boolean async = Objects.equal((Object)_commType, (Object)ActorCommunicationType.ASYNCHRONOUS);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of ActorClass ");
        String _name = ac.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName((RoomClass)ac);
        _builder.append((Object)_cppHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append((Object)"#include <iostream>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        String _name_1 = ac.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"::");
        String _name_2 = ac.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"(etRuntime::IRTObject* parent, std::string name, const std::vector<std::vector<etRuntime::Address> >& port_addr, ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" \t\t\t\t\t\t  \t\t\t\t\t\t\t\t\t\t\t ");
        _builder.append((Object)"const std::vector<std::vector<etRuntime::Address> >& peer_addr)");
        _builder.newLine();
        _builder.append((Object)":  ");
        String _generateConstructorInitalizerList = this.generateConstructorInitalizerList(ac);
        _builder.append((Object)_generateConstructorInitalizerList, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        boolean _hasNonEmptyStateMachine = RoomHelpers.hasNonEmptyStateMachine((ActorClass)ac);
        if (_hasNonEmptyStateMachine) {
            _builder.append((Object)"\t");
            _builder.append((Object)"history = new int[s_numberOfStates];");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"for (int i = 0; i < s_numberOfStates; i++) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"history[i] = NO_STATE;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"setClassName(\"");
        String _name_3 = ac.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        EList _attributes = ac.getAttributes();
        CharSequence _attributeInitialization = this._initialization.attributeInitialization((List<Attribute>)_attributes, false);
        _builder.append((Object)_attributeInitialization, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (async) {
            _builder.append((Object)"\t");
            _builder.append((Object)"getMsgsvc()->addAsyncActor(*this);");
            _builder.newLine();
        }
        boolean bl = _notEquals = !Objects.equal((Object)ctor, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// user defined constructor body");
            _builder.newLine();
            _builder.append((Object)"\t");
            AbstractGenerator _instance = AbstractGenerator.getInstance();
            DetailCode _detailCode = ctor.getDetailCode();
            String _translatedCode = _instance.getTranslatedCode(_detailCode);
            _builder.append((Object)_translatedCode, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_4 = ac.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)"::init(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"initUser();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_5 = ac.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)"::start(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"startUser();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean _overridesStop = this._roomExtensions.overridesStop(ac);
        boolean bl2 = _not = !_overridesStop;
        if (_not) {
            _builder.append((Object)"void ");
            String _name_6 = ac.getName();
            _builder.append((Object)_name_6, "");
            _builder.append((Object)"::stop(){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"stopUser();");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_7 = ac.getName();
        _builder.append((Object)_name_7, "");
        _builder.append((Object)"::destroy(){");
        _builder.newLineIfNotEmpty();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)dtor, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"// user defined destructor body");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            AbstractGenerator _instance_1 = AbstractGenerator.getInstance();
            DetailCode _detailCode_1 = dtor.getDetailCode();
            String _translatedCode_1 = _instance_1.getTranslatedCode(_detailCode_1);
            _builder.append((Object)_translatedCode_1, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean _hasNonEmptyStateMachine_1 = RoomHelpers.hasNonEmptyStateMachine((ActorClass)ac);
        if (_hasNonEmptyStateMachine_1) {
            CharSequence _genStateMachine = this._stateMachineGen.genStateMachine(xpac, false);
            _builder.append((Object)_genStateMachine, "");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _not_1;
            boolean _hasStateMachine = xpac.hasStateMachine();
            boolean bl4 = _not_1 = !_hasStateMachine;
            if (_not_1) {
                _builder.append((Object)"//--------------------- no state machine");
                _builder.newLine();
                _builder.append((Object)"void ");
                String _name_8 = ac.getName();
                _builder.append((Object)_name_8, "");
                _builder.append((Object)"::receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* data) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"handleSystemEvent(ifitem, evt, data);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"void ");
                String _name_9 = ac.getName();
                _builder.append((Object)_name_9, "");
                _builder.append((Object)"::executeInitTransition(){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

