/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class CppExtensions
implements ILanguageExtension {
    @Inject
    private IDiagnostician diagnostician;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;

    public String getTypedDataDefinition(Message m) {
        VarDecl _data = m.getData();
        String[] _generateArglistAndTypedData = this.generateArglistAndTypedData(_data);
        String _get = _generateArglistAndTypedData[1];
        return _get;
    }

    public String getCppHeaderFileName(RoomClass rc) {
        String _name = rc.getName();
        String _plus = String.valueOf(_name) + ".h";
        return _plus;
    }

    public String getCppSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        String _plus = String.valueOf(_name) + ".cpp";
        return _plus;
    }

    public String getInstSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        String _plus = String.valueOf(_name) + "_Inst.h";
        return _plus;
    }

    public String getDispSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        String _plus = String.valueOf(_name) + "_Disp.h";
        return _plus;
    }

    public String accessLevelPrivate() {
        return "";
    }

    public String accessLevelProtected() {
        return "";
    }

    public String accessLevelPublic() {
        return "";
    }

    public String memberAccess() {
        return "this->";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        String _plus;
        String _xifexpression = null;
        _xifexpression = isDeclaration ? "" : (_plus = String.valueOf(classname) + "::");
        return _xifexpression;
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        String _plus = String.valueOf(namespace) + ".";
        return String.valueOf(_plus) + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public boolean usesPointers() {
        return true;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef enum {");
        _builder.newLine();
        for (Pair<String, String> entry : entries) {
            String _first = (String)entry.getFirst();
            _builder.append((Object)_first, "");
            _builder.append((Object)" = ");
            String _second = (String)entry.getSecond();
            _builder.append((Object)_second, "");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"} ");
        _builder.append((Object)name, "");
        _builder.append((Object)";");
        String _string = _builder.toString();
        return _string;
    }

    public String booleanConstant(boolean b) {
        String _string = Boolean.valueOf(b).toString();
        return _string;
    }

    public String pointerLiteral() {
        return "*";
    }

    public String nullPointer() {
        return "0";
    }

    public String voidPointer() {
        return "void*";
    }

    public String arrayDeclaration(String type, int size, String name, boolean isRef) {
        String _plus = String.valueOf(type) + " ";
        String _plus_1 = String.valueOf(_plus) + name;
        String _plus_2 = String.valueOf(_plus_1) + "[";
        String _plus_3 = String.valueOf(_plus_2) + Integer.valueOf(size);
        String _plus_4 = String.valueOf(_plus_3) + "]";
        return _plus_4;
    }

    public String constructorName(String cls) {
        return cls;
    }

    public String destructorName(String cls) {
        String _plus = String.valueOf(cls) + "_dtor";
        return _plus;
    }

    public String constructorReturnType() {
        return "";
    }

    public String destructorReturnType() {
        return "void";
    }

    public CharSequence getIncludeGuardString(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"_");
        String _replaceAll = filename.replaceAll("\\/.", "_");
        String _upperCase = _replaceAll.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_H_");
        return _builder;
    }

    public CharSequence generateIncludeGuardBegin(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#ifndef ");
        CharSequence _includeGuardString = this.getIncludeGuardString(filename);
        _builder.append((Object)_includeGuardString, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#define ");
        CharSequence _includeGuardString_1 = this.getIncludeGuardString(filename);
        _builder.append((Object)_includeGuardString_1, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateIncludeGuardEnd(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#endif /* ");
        CharSequence _includeGuardString = this.getIncludeGuardString(filename);
        _builder.append((Object)_includeGuardString, "");
        _builder.append((Object)" */");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String superCall(String baseClassName, String method, String arguments) {
        String _plus = String.valueOf(baseClassName) + "::";
        String _plus_1 = String.valueOf(_plus) + method;
        String _plus_2 = String.valueOf(_plus_1) + "(";
        String _plus_3 = String.valueOf(_plus_2) + arguments;
        String _plus_4 = String.valueOf(_plus_3) + ");";
        return _plus_4;
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("TODO Config for Cpp");
        throw _unsupportedOperationException;
    }

    public String defaultValue(DataType dt) {
        String _xifexpression = null;
        if (dt instanceof PrimitiveType) {
            return ((PrimitiveType)dt).getDefaultValueLiteral();
        }
        String _xifexpression_1 = null;
        if (dt instanceof ExternalType) {
            String _name = dt.getName();
            String _plus = "initialize external type with default constructor" + _name;
            EObject _eContainer = dt.eContainer();
            EStructuralFeature _eContainingFeature = dt.eContainingFeature();
            this.diagnostician.warning(_plus, _eContainer, _eContainingFeature);
            String _typeName = this._typeHelpers.typeName(dt);
            return String.valueOf(_typeName) + "()";
        }
        String _xblockexpression = null;
        DataClass dc = (DataClass)dt;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        EList _attributes = dc.getAttributes();
        boolean _hasElements = false;
        for (Attribute att : _attributes) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            RefableType _type = att.getType();
            DataType _type_1 = _type.getType();
            int _size = att.getSize();
            String _initializationWithDefaultValues = this.initializationWithDefaultValues(_type_1, _size);
            _builder.append((Object)_initializationWithDefaultValues, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _xifexpression = _xifexpression_1 = (_xblockexpression = _builder.toString());
        return _xifexpression;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        boolean _greaterThan;
        String _xblockexpression = null;
        String dv = this.defaultValue(dt);
        String _xifexpression = null;
        boolean bl = _greaterThan = size > 1;
        if (_greaterThan) {
            String _plus;
            boolean _lessThan;
            String _xblockexpression_1 = null;
            String res = "{";
            int i = 0;
            boolean _while = _lessThan = i < size;
            while (_while) {
                boolean _lessThan_1;
                boolean _lessThan_12;
                String _plus2;
                res = _plus2 = String.valueOf(res) + dv;
                int _plus_1 = i + 1;
                boolean bl2 = _lessThan_12 = (i = _plus_1) < size;
                if (_lessThan_12) {
                    String _plus_2;
                    res = _plus_2 = String.valueOf(res) + ",";
                }
                _while = _lessThan_1 = i < size;
            }
            _xifexpression = _xblockexpression_1 = (_plus = String.valueOf(res) + "}");
        } else {
            _xifexpression = dv;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String[] generateArglistAndTypedData(VarDecl data) {
        String _plus;
        String deref = "*";
        boolean _equals = Objects.equal((Object)data, null);
        if (_equals) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        String _xifexpression = null;
        RefableType _refType = data.getRefType();
        DataType _type = _refType.getType();
        if (_type instanceof PrimitiveType) {
            String _targetName;
            RefableType _refType_1 = data.getRefType();
            DataType _type_1 = _refType_1.getType();
            _xifexpression = _targetName = ((PrimitiveType)_type_1).getTargetName();
        } else {
            String _name;
            RefableType _refType_2 = data.getRefType();
            DataType _type_2 = _refType_2.getType();
            _xifexpression = _name = _type_2.getName();
        }
        String typeName = _xifexpression;
        String _xifexpression_1 = null;
        RefableType _refType_3 = data.getRefType();
        DataType _type_3 = _refType_3.getType();
        if (_type_3 instanceof PrimitiveType) {
            boolean _notEquals;
            String _xblockexpression = null;
            RefableType _refType_4 = data.getRefType();
            DataType _type_4 = _refType_4.getType();
            String ct = ((PrimitiveType)_type_4).getCastName();
            String _xifexpression_2 = null;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)ct, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _isEmpty = ct.isEmpty();
                boolean _not = !_isEmpty;
                _and = _notEquals && _not;
            }
            _xifexpression_2 = _and ? ct : typeName;
            _xifexpression_1 = _xblockexpression = _xifexpression_2;
        } else {
            _xifexpression_1 = typeName;
        }
        String castTypeName = _xifexpression_1;
        castTypeName = _plus = String.valueOf(castTypeName) + "*";
        RefableType _refType_4 = data.getRefType();
        boolean _isRef = _refType_4.isRef();
        if (_isRef) {
            String _plus_2;
            String _plus_1;
            typeName = _plus_1 = String.valueOf(typeName) + "*";
            castTypeName = _plus_2 = String.valueOf(castTypeName) + "*";
        } else {
            boolean _not;
            RefableType _refType_5 = data.getRefType();
            DataType _type_4 = _refType_5.getType();
            boolean bl = _not = !(_type_4 instanceof PrimitiveType);
            if (_not) {
                String _plus_4;
                String _plus_3;
                typeName = _plus_3 = String.valueOf(typeName) + "*";
                castTypeName = _plus_4 = String.valueOf(castTypeName) + "*";
            } else {
                castTypeName = typeName;
                deref = "";
            }
        }
        String _plus_5 = String.valueOf(typeName) + " ";
        String _name_1 = data.getName();
        String _plus_6 = String.valueOf(_plus_5) + _name_1;
        String _plus_7 = String.valueOf(_plus_6) + " = ";
        String _plus_8 = String.valueOf(_plus_7) + deref;
        String _plus_9 = String.valueOf(_plus_8) + "((";
        String _plus_10 = String.valueOf(_plus_9) + castTypeName;
        String typedData = String.valueOf(_plus_10) + ") generic_data);\n";
        String _name_2 = data.getName();
        String dataArg = ", " + _name_2;
        String _plus_11 = ", " + typeName;
        String _plus_12 = String.valueOf(_plus_11) + " ";
        String _name_3 = data.getName();
        String typedArgList = String.valueOf(_plus_12) + _name_3;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }
}

