/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.Documentation;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.CodegenHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class DocGen {
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _models = root.getModels();
        for (RoomModel model : _models) {
            String path = this.roomExt.getDocGenerationTargetPath((EObject)model);
            String _name = model.getName();
            String file = String.valueOf(_name) + ".tex";
            String _plus = "generating LaTeX documentation: '" + file;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            CharSequence _generateModelDoc = this.generateModelDoc(root, model);
            this.fileAccess.generateFile(file, _generateModelDoc);
        }
    }

    private CharSequence generateModelDoc(Root root, RoomModel model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\documentclass[titlepage]{article}");
        _builder.newLine();
        _builder.append((Object)"\\usepackage{graphicx}");
        _builder.newLine();
        _builder.append((Object)"\\usepackage[a4paper,text={160mm,255mm},centering,headsep=5mm,footskip=10mm]{geometry}");
        _builder.newLine();
        _builder.append((Object)"\\usepackage{nonfloat}");
        _builder.newLine();
        _builder.append((Object)"\\parindent 0pt");
        _builder.newLine();
        _builder.append((Object)"\\makeatletter");
        _builder.newLine();
        _builder.append((Object)"\\newcommand\\level[1]{%");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\ifcase#1\\relax\\expandafter\\chapter\\or");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\expandafter\\section\\or");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\expandafter\\subsection\\or");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\expandafter\\subsubsection\\else");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\def\\next{\\@level{#1}}\\expandafter\\next");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\fi}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\newcommand{\\@level}[1]{%");
        _builder.newLine();
        _builder.append((Object)"\\@startsection{level#1}");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{#1}");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{\\z@}%");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{-3.25ex\\@plus -1ex \\@minus -.2ex}%");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{1.5ex \\@plus .2ex}%");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{\\normalfont\\normalsize\\bfseries}}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\newdimen\\@leveldim");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\newdimen\\@dotsdim");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"{\\normalfont\\normalsize");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"\\sbox\\z@{0}\\global\\@leveldim=\\wd\\z@");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"\\sbox\\z@{.}\\global\\@dotsdim=\\wd\\z@");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"}  ");
        _builder.newLine();
        _builder.append((Object)"\\newcounter{level4}[subsubsection]");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\@namedef{thelevel4}{\\thesubsubsection.\\arabic{level4}}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\@namedef{level4mark}#1{}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\def\\l@section{\\@dottedtocline{1}{0pt}{\\dimexpr\\@leveldim*4+\\@dotsdim*1+6pt\\relax}}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\def\\l@subsection{\\@dottedtocline{2}{0pt}{\\dimexpr\\@leveldim*5+\\@dotsdim*2+6pt\\relax}}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\def\\l@subsubsection{\\@dottedtocline{3}{0pt}{\\dimexpr\\@leveldim*6+\\@dotsdim*3+6pt\\relax}}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\@namedef{l@level4}{\\@dottedtocline{4}{0pt}{\\dimexpr\\@leveldim*7+\\@dotsdim*4+6pt\\relax}}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\count@=4");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\def\\@ncp#1{\\number\\numexpr\\count@+#1\\relax}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\loop\\ifnum\\count@<100");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\begingroup\\edef\\x{\\endgroup");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\noexpand\\newcounter{level\\@ncp{1}}[level\\number\\count@]");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\noexpand\\@namedef{thelevel\\@ncp{1}}{%");
        _builder.newLine();
        _builder.append((Object)"       ");
        _builder.append((Object)"\\noexpand\\@nameuse{thelevel\\@ncp{0}}.\\noexpand\\arabic{level\\@ncp{0}}}");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\noexpand\\@namedef{level\\@ncp{1}mark}####1{}%");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\noexpand\\@namedef{l@level\\@ncp{1}}%");
        _builder.newLine();
        _builder.append((Object)"       ");
        _builder.append((Object)"{\\noexpand\\@dottedtocline{\\@ncp{1}}{0pt}{\\the\\dimexpr\\@leveldim*\\@ncp{5}+\\@dotsdim*\\@ncp{0}\\relax}}}%");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\x");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\advance\\count@\\@ne");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\repeat");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\makeatother");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\setcounter{secnumdepth}{100}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\setcounter{tocdepth}{100}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\title{");
        String _name = model.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" Model Documentation}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\date{\\today}");
        _builder.newLine();
        _builder.append((Object)"\\author{generated by eTrice}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\begin{document}");
        _builder.newLine();
        _builder.append((Object)"\\pagestyle{plain}");
        _builder.newLine();
        _builder.append((Object)"\\maketitle");
        _builder.newLine();
        _builder.append((Object)"\\tableofcontents");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\newpage");
        _builder.newLine();
        _builder.append((Object)"\\listoffigures");
        _builder.newLine();
        _builder.append((Object)"\\newpage");
        _builder.newLine();
        _builder.append((Object)"\\section{Model Description}");
        _builder.newLine();
        Documentation _docu = model.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\section{Logical System Description}");
        _builder.newLine();
        CharSequence _generateAllLogicalSystemDocs = this.generateAllLogicalSystemDocs(root, model);
        _builder.append((Object)_generateAllLogicalSystemDocs, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\section{Subsystem Description}");
        _builder.newLine();
        CharSequence _generateAllSubSysClassDocs = this.generateAllSubSysClassDocs(root, model);
        _builder.append((Object)_generateAllSubSysClassDocs, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\section{Protocol Class Description}");
        _builder.newLine();
        CharSequence _generateAllProtocolClassDocs = this.generateAllProtocolClassDocs(root, model);
        _builder.append((Object)_generateAllProtocolClassDocs, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\section{Data Class Description}");
        _builder.newLine();
        CharSequence _generateAllDataClassDocs = this.generateAllDataClassDocs(root, model);
        _builder.append((Object)_generateAllDataClassDocs, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\section{Actor Class Description}");
        _builder.newLine();
        CharSequence _generateAllActorClassDocs = this.generateAllActorClassDocs(root, model);
        _builder.append((Object)_generateAllActorClassDocs, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\end{document}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateAllLogicalSystemDocs(Root root, RoomModel model) {
        StringConcatenation _builder = new StringConcatenation();
        EList _systems = model.getSystems();
        for (LogicalSystem sys : _systems) {
            CharSequence _generateLogicalSystemDoc = this.generateLogicalSystemDoc(root, model, sys);
            _builder.append((Object)_generateLogicalSystemDoc, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateLogicalSystemDoc(Root root, RoomModel model, LogicalSystem system) {
        String _replaceAll;
        StringConcatenation _xblockexpression = null;
        String _docGenerationTargetPath = this.roomExt.getDocGenerationTargetPath((EObject)model);
        String _plus = String.valueOf(_docGenerationTargetPath) + "images\\";
        String _name = system.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String filenamei = String.valueOf(_plus_1) + "_instanceTree.jpg";
        filenamei = _replaceAll = filenamei.replaceAll("\\\\", "/");
        String latexFilenamei = filenamei.replaceAll("/", "//");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2}{");
        String _name_1 = system.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = system.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\level{3}{Instance Tree}");
        _builder.newLine();
        String _fileExists = this.fileExists(filenamei);
        boolean _equals = _fileExists.equals("true");
        if (_equals) {
            String _name_2 = system.getName();
            String _plus_2 = String.valueOf(_name_2) + " Instance Tree";
            CharSequence _includeGraphics = this.includeGraphics(latexFilenamei, "0.5", _plus_2);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateAllSubSysClassDocs(Root root, RoomModel model) {
        StringConcatenation _builder = new StringConcatenation();
        EList _subSystemClasses = model.getSubSystemClasses();
        for (SubSystemClass ssc : _subSystemClasses) {
            CharSequence _generateSubSysClassDoc = this.generateSubSysClassDoc(root, model, ssc);
            _builder.append((Object)_generateSubSysClassDoc, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateSubSysClassDoc(Root root, RoomModel model, SubSystemClass ssc) {
        String _replaceAll;
        StringConcatenation _xblockexpression = null;
        String _docGenerationTargetPath = this.roomExt.getDocGenerationTargetPath((EObject)model);
        String _plus = String.valueOf(_docGenerationTargetPath) + "images\\";
        String _name = ssc.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String filename = String.valueOf(_plus_1) + "_structure.jpg";
        filename = _replaceAll = filename.replaceAll("\\\\", "/");
        String latexFilename = filename.replaceAll("/", "//");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2}{");
        String _name_1 = ssc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = ssc.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\level{3}{Structure}");
        _builder.newLine();
        String _fileExists = this.fileExists(filename);
        boolean _equals = _fileExists.equals("true");
        if (_equals) {
            String _name_2 = ssc.getName();
            String _plus_2 = String.valueOf(_name_2) + " Structure";
            CharSequence _includeGraphics = this.includeGraphics(latexFilename, "0.4", _plus_2);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateAllDataClassDocs(Root root, RoomModel model) {
        StringConcatenation _builder = new StringConcatenation();
        EList _dataClasses = model.getDataClasses();
        for (DataClass dc : _dataClasses) {
            CharSequence _generateDataClassDoc = this.generateDataClassDoc(root, dc);
            _builder.append((Object)_generateDataClassDoc, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateDataClassDoc(Root root, DataClass dc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2} {");
        String _name = dc.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = dc.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\level{3}{Attributes}");
        _builder.newLine();
        EList _attributes = dc.getAttributes();
        CharSequence _generateAttributesDoc = this.generateAttributesDoc((List<Attribute>)_attributes);
        _builder.append((Object)_generateAttributesDoc, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\\level{3}{Operations}");
        _builder.newLine();
        EList _operations = dc.getOperations();
        CharSequence _generateOperationsDoc = this.generateOperationsDoc((List<StandardOperation>)_operations);
        _builder.append((Object)_generateOperationsDoc, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateAllProtocolClassDocs(Root root, RoomModel model) {
        StringConcatenation _builder = new StringConcatenation();
        EList _protocolClasses = model.getProtocolClasses();
        for (GeneralProtocolClass pc : _protocolClasses) {
            CharSequence _generateProtocolClassDoc = this.generateProtocolClassDoc(root, pc);
            _builder.append((Object)_generateProtocolClassDoc, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence _generateProtocolClassDoc(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\t");
        _builder.append((Object)"\\level{2} {");
        String _name = pc.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Documentation _docu = pc.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"\\level{3}{Incoming Messages}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"\\begin{tabular}[ht]{|l|l|l|}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Message & Data & Description\\\\");
        _builder.newLine();
        List _allIncomingMessages = RoomHelpers.getAllIncomingMessages((ProtocolClass)pc);
        for (Message ims : _allIncomingMessages) {
            boolean _notEquals;
            _builder.append((Object)"\t");
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _name_1 = ims.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)" & ");
            VarDecl _data = ims.getData();
            boolean bl = _notEquals = !Objects.equal((Object)_data, null);
            if (_notEquals) {
                _builder.append((Object)" ");
                VarDecl _data_1 = ims.getData();
                String _name_2 = _data_1.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append((Object)" ");
            }
            _builder.append((Object)" & ");
            Documentation _docu_1 = ims.getDocu();
            CharSequence _generateDocText_1 = this.generateDocText(_docu_1);
            _builder.append((Object)_generateDocText_1, "\t");
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"\\end{tabular}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"\\level{3}{Outgoing Messages}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"\\begin{tabular}[ht]{|l|l|l|}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Message & Data & Description\\\\");
        _builder.newLine();
        List _allOutgoingMessages = RoomHelpers.getAllOutgoingMessages((ProtocolClass)pc);
        for (Message oms : _allOutgoingMessages) {
            boolean _notEquals_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _name_3 = oms.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)" & ");
            VarDecl _data_2 = oms.getData();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_data_2, null);
            if (_notEquals_1) {
                _builder.append((Object)" ");
                VarDecl _data_3 = oms.getData();
                String _name_4 = _data_3.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append((Object)" ");
            }
            _builder.append((Object)" & ");
            Documentation _docu_2 = oms.getDocu();
            CharSequence _generateDocText_2 = this.generateDocText(_docu_2);
            _builder.append((Object)_generateDocText_2, "\t");
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"\\end{tabular}\t\t\t");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _generateProtocolClassDoc(Root root, CompoundProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2} {");
        String _name = pc.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = pc.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\level{3}{Sub Protocols}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\begin{tabular}[ht]{|l|l|}");
        _builder.newLine();
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"Name & Protocol\\\\");
        _builder.newLine();
        EList _subProtocols = pc.getSubProtocols();
        for (SubProtocol sub : _subProtocols) {
            _builder.append((Object)"\\hline");
            _builder.newLine();
            String _name_1 = sub.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)" & ");
            GeneralProtocolClass _protocol = sub.getProtocol();
            String _name_2 = _protocol.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\\end{tabular}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateAllActorClassDocs(Root root, RoomModel model) {
        StringConcatenation _builder = new StringConcatenation();
        EList _actorClasses = model.getActorClasses();
        for (ActorClass ac : _actorClasses) {
            CharSequence _generateActorClassDoc = this.generateActorClassDoc(root, model, ac);
            _builder.append((Object)_generateActorClassDoc, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateActorClassDoc(Root root, RoomModel model, ActorClass ac) {
        String _replaceAll;
        StringConcatenation _xblockexpression = null;
        String _docGenerationTargetPath = this.roomExt.getDocGenerationTargetPath((EObject)model);
        String _plus = String.valueOf(_docGenerationTargetPath) + "images\\";
        String _name = ac.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String filename = String.valueOf(_plus_1) + "_structure.jpg";
        filename = _replaceAll = filename.replaceAll("\\\\", "/");
        String latexFilename = filename.replaceAll("/", "//");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2}{");
        String _name_1 = ac.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = ac.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\level{3}{Structure}");
        _builder.newLine();
        _builder.newLine();
        String _fileExists = this.fileExists(filename);
        boolean _equals = _fileExists.equals("true");
        if (_equals) {
            String _name_2 = ac.getName();
            String _plus_2 = String.valueOf(_name_2) + " Structure";
            CharSequence _includeGraphics = this.includeGraphics(latexFilename, "0.4", _plus_2);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\\level{3}{Attributes}");
        _builder.newLine();
        EList _attributes = ac.getAttributes();
        CharSequence _generateAttributesDoc = this.generateAttributesDoc((List<Attribute>)_attributes);
        _builder.append((Object)_generateAttributesDoc, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\\level{3}{Operations}");
        _builder.newLine();
        EList _operations = ac.getOperations();
        CharSequence _generateOperationsDoc = this.generateOperationsDoc((List<StandardOperation>)_operations);
        _builder.append((Object)_generateOperationsDoc, "");
        _builder.newLineIfNotEmpty();
        boolean _hasNonEmptyStateMachine = RoomHelpers.hasNonEmptyStateMachine((ActorClass)ac);
        if (_hasNonEmptyStateMachine) {
            _builder.append((Object)"\\level{3}{Statemachine}");
            _builder.newLine();
            CharSequence _generateFsmDoc = this.generateFsmDoc(model, ac);
            _builder.append((Object)_generateFsmDoc, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateFsmDoc(RoomModel model, ActorClass ac) {
        String _replaceAll;
        StringConcatenation _xblockexpression = null;
        String _docGenerationTargetPath = this.roomExt.getDocGenerationTargetPath((EObject)model);
        String _plus = String.valueOf(_docGenerationTargetPath) + "images\\";
        String _name = ac.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String filename = String.valueOf(_plus_1) + "_behavior.jpg";
        filename = _replaceAll = filename.replaceAll("\\\\", "/");
        String latexFilename = filename.replaceAll("/", "//");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{4}{Top Level}");
        _builder.newLine();
        String _fileExists = this.fileExists(filename);
        boolean _equals = _fileExists.equals("true");
        if (_equals) {
            String _name_1 = ac.getName();
            String _plus_2 = String.valueOf(_name_1) + " Top State";
            CharSequence _includeGraphics = this.includeGraphics(latexFilename, "0.4", _plus_2);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\\begin{par}");
        _builder.newLine();
        StateGraph _stateMachine = ac.getStateMachine();
        EList _states = _stateMachine.getStates();
        for (State s : _states) {
            boolean _notEquals;
            Documentation _docu = s.getDocu();
            boolean bl = _notEquals = !Objects.equal((Object)_docu, null);
            if (!_notEquals) continue;
            _builder.append((Object)"\\textbf{State description} \\textit{");
            String _genStatePathName = CodegenHelpers.getGenStatePathName((State)s);
            String _replaceAll_1 = _genStatePathName.replaceAll("_", "\\\\_");
            _builder.append((Object)_replaceAll_1, "");
            _builder.append((Object)"}:");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline");
            _builder.newLine();
            Documentation _docu_1 = s.getDocu();
            CharSequence _generateDocText = this.generateDocText(_docu_1);
            _builder.append((Object)_generateDocText, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline\\newline");
            _builder.newLine();
        }
        _builder.newLine();
        StateGraph _stateMachine_1 = ac.getStateMachine();
        EList _chPoints = _stateMachine_1.getChPoints();
        for (ChoicePoint c : _chPoints) {
            boolean _notEquals_1;
            Documentation _docu_2 = c.getDocu();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_docu_2, null);
            if (!_notEquals_1) continue;
            _builder.append((Object)"\\textbf{Choicepoint description} \\textit{");
            String _name_2 = c.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)"}:");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline");
            _builder.newLine();
            Documentation _docu_3 = c.getDocu();
            CharSequence _generateDocText_1 = this.generateDocText(_docu_3);
            _builder.append((Object)_generateDocText_1, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline\\newline");
            _builder.newLine();
        }
        _builder.append((Object)"\\end{par}");
        _builder.newLine();
        _builder.newLine();
        StateGraph _stateMachine_2 = ac.getStateMachine();
        EList _states_1 = _stateMachine_2.getStates();
        for (State s_1 : _states_1) {
            boolean _not;
            boolean _isLeaf = RoomHelpers.isLeaf((State)s_1);
            boolean bl = _not = !_isLeaf;
            if (!_not) continue;
            String _generateStateDoc = this.generateStateDoc(model, ac, s_1);
            _builder.append((Object)_generateStateDoc, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String generateStateDoc(RoomModel model, ActorClass ac, State state) {
        String _replaceAll;
        String _xblockexpression = null;
        String _docGenerationTargetPath = this.roomExt.getDocGenerationTargetPath((EObject)model);
        String _plus = String.valueOf(_docGenerationTargetPath) + "images\\";
        String _name = ac.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String _plus_2 = String.valueOf(_plus_1) + "_";
        String _genStatePathName = CodegenHelpers.getGenStatePathName((State)state);
        String _plus_3 = String.valueOf(_plus_2) + _genStatePathName;
        String filename = String.valueOf(_plus_3) + "_behavior.jpg";
        filename = _replaceAll = filename.replaceAll("\\\\", "/");
        String latexFilename = filename.replaceAll("/", "//");
        String _plus_4 = "Gen Filename: " + filename;
        this.logger.logInfo(_plus_4);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{4}{Subgraph ");
        String _genStatePathName_1 = CodegenHelpers.getGenStatePathName((State)state);
        String _replaceAll_1 = _genStatePathName_1.replaceAll("_", "\\\\_");
        _builder.append((Object)_replaceAll_1, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        String _fileExists = this.fileExists(filename);
        boolean _equals = _fileExists.equals("true");
        if (_equals) {
            String _name_1 = ac.getName();
            String _plus_5 = String.valueOf(_name_1) + "_";
            String _genStatePathName_2 = CodegenHelpers.getGenStatePathName((State)state);
            String _plus_6 = String.valueOf(_plus_5) + _genStatePathName_2;
            CharSequence _includeGraphics = this.includeGraphics(latexFilename, "0.4", _plus_6);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\\begin{par}");
        _builder.newLine();
        StateGraph _subgraph = state.getSubgraph();
        EList _states = _subgraph.getStates();
        for (State s : _states) {
            boolean _notEquals;
            Documentation _docu = s.getDocu();
            boolean bl = _notEquals = !Objects.equal((Object)_docu, null);
            if (!_notEquals) continue;
            _builder.append((Object)"\\textbf{State description} \\textit{");
            String _genStatePathName_3 = CodegenHelpers.getGenStatePathName((State)s);
            String _replaceAll_2 = _genStatePathName_3.replaceAll("_", "\\\\_");
            _builder.append((Object)_replaceAll_2, "");
            _builder.append((Object)"}:");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline");
            _builder.newLine();
            Documentation _docu_1 = s.getDocu();
            CharSequence _generateDocText = this.generateDocText(_docu_1);
            _builder.append((Object)_generateDocText, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline\\newline");
            _builder.newLine();
        }
        _builder.newLine();
        StateGraph _subgraph_1 = state.getSubgraph();
        EList _chPoints = _subgraph_1.getChPoints();
        for (ChoicePoint c : _chPoints) {
            boolean _notEquals_1;
            Documentation _docu_2 = c.getDocu();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_docu_2, null);
            if (!_notEquals_1) continue;
            _builder.append((Object)"\\textbf{Choicepoint description} \\textit{");
            String _name_2 = c.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)"}:");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline");
            _builder.newLine();
            Documentation _docu_3 = c.getDocu();
            CharSequence _generateDocText_1 = this.generateDocText(_docu_3);
            _builder.append((Object)_generateDocText_1, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline\\newline");
            _builder.newLine();
        }
        _builder.append((Object)"\\end{par}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        StateGraph _subgraph_2 = state.getSubgraph();
        EList _states_1 = _subgraph_2.getStates();
        for (State s_1 : _states_1) {
            boolean _not;
            boolean _isLeaf = RoomHelpers.isLeaf((State)s_1);
            boolean bl = _not = !_isLeaf;
            if (!_not) continue;
            String _generateStateDoc = this.generateStateDoc(model, ac, s_1);
            _builder.append((Object)_generateStateDoc, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private CharSequence generateAttributesDoc(List<Attribute> attributes) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = attributes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"\\begin{tabular}[ht]{|l|l|l|}");
            _builder.newLine();
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"Name & Type & Description\\\\");
            _builder.newLine();
            for (Attribute at : attributes) {
                _builder.append((Object)"\\hline");
                _builder.newLine();
                String _name = at.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)" & ");
                RefableType _type = at.getType();
                DataType _type_1 = _type.getType();
                String _name_1 = _type_1.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)" & ");
                Documentation _docu = at.getDocu();
                CharSequence _generateDocText = this.generateDocText(_docu);
                _builder.append((Object)_generateDocText, "");
                _builder.append((Object)"\\\\");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\\end{tabular}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateOperationsDoc(List<StandardOperation> operations) {
        StringConcatenation _builder = new StringConcatenation();
        for (StandardOperation op : operations) {
            boolean _notEquals_1;
            boolean _notEquals;
            _builder.append((Object)"\\begin{tabular}[ht]{|l|l|}");
            _builder.newLine();
            _builder.append((Object)"\\hline\t\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"Name: & ");
            String _name = op.getName();
            _builder.append((Object)_name, "\t");
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"ReturnType: &  ");
            RefableType _returnType = op.getReturnType();
            boolean bl = _notEquals = !Objects.equal((Object)_returnType, null);
            if (_notEquals) {
                RefableType _returnType_1 = op.getReturnType();
                DataType _type = _returnType_1.getType();
                String _name_1 = _type.getName();
                _builder.append((Object)_name_1, "\t");
            } else {
                _builder.append((Object)"void");
            }
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"Arguments: & ");
            EList _arguments = op.getArguments();
            boolean _hasElements = false;
            for (VarDecl pa : _arguments) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _name_2 = pa.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append((Object)":");
                RefableType _refType = pa.getRefType();
                DataType _type_1 = _refType.getType();
                String _name_3 = _type_1.getName();
                _builder.append((Object)_name_3, "\t");
            }
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
            Documentation _docu = op.getDocu();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_docu, null);
            if (_notEquals_1) {
                boolean _greaterThan;
                _builder.append((Object)"\t");
                _builder.append((Object)"\\hline");
                _builder.newLine();
                Documentation _docu_1 = op.getDocu();
                String _string = _docu_1.toString();
                int _length = _string.length();
                boolean bl3 = _greaterThan = _length > 85;
                if (_greaterThan) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\\multicolumn{2} {|p{13cm}|} {");
                    Documentation _docu_2 = op.getDocu();
                    CharSequence _generateDocText = this.generateDocText(_docu_2);
                    _builder.append((Object)_generateDocText, "\t");
                    _builder.append((Object)"}\\\\");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\\multicolumn{2} {|l|} {");
                    Documentation _docu_3 = op.getDocu();
                    CharSequence _generateDocText_1 = this.generateDocText(_docu_3);
                    _builder.append((Object)_generateDocText_1, "\t");
                    _builder.append((Object)"}\\\\");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\\end{tabular}");
            _builder.newLine();
            _builder.append((Object)"\\newline\\newline\\newline");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateDocText(Documentation doc) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)doc, null);
        if (_notEquals) {
            EList _lines = doc.getLines();
            String _join = IterableExtensions.join((Iterable)_lines);
            _builder.append((Object)_join, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String fileExists(String f) {
        File _file = new File(f);
        File file = _file;
        boolean exist = file.exists();
        boolean _equals = exist;
        if (_equals) {
            String _plus = "File found ! " + f;
            this.logger.logInfo(_plus);
            return "true";
        }
        String _plus_1 = "File not found ! " + f;
        this.logger.logInfo(_plus_1);
        return "false";
    }

    private CharSequence includeGraphics(String filename, String scale, String caption) {
        StringConcatenation _xblockexpression = null;
        String latexCaption = caption.replaceAll("_", "\\\\_");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\begin{center}");
        _builder.newLine();
        _builder.append((Object)"\\includegraphics[scale=");
        _builder.append((Object)scale, "");
        _builder.append((Object)"]{");
        _builder.append((Object)filename, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\figcaption{");
        _builder.append((Object)latexCaption, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\end{center}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateProtocolClassDoc(Root root, GeneralProtocolClass pc) {
        if (pc instanceof CompoundProtocolClass) {
            return this._generateProtocolClassDoc(root, (CompoundProtocolClass)pc);
        }
        if (pc instanceof ProtocolClass) {
            return this._generateProtocolClassDoc(root, (ProtocolClass)pc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(root, pc).toString());
    }
}

