/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class JavaExtensions
implements ILanguageExtension {
    @Inject
    private TypeHelpers typeHelpers;

    public String getTypedDataDefinition(Message m) {
        VarDecl _data = m.getData();
        String[] _generateArglistAndTypedData = this.generateArglistAndTypedData(_data);
        String _get = _generateArglistAndTypedData[1];
        return _get;
    }

    public String getJavaFileName(RoomClass rc) {
        String _name = rc.getName();
        String _plus = String.valueOf(_name) + ".java";
        return _plus;
    }

    public String getJavaFactoryName(ActorClass rc) {
        String _name = rc.getName();
        String _plus = String.valueOf(_name) + "Factory";
        return _plus;
    }

    public String getJavaFactoryFileName(ActorClass rc) {
        String _javaFactoryName = this.getJavaFactoryName(rc);
        String _plus = String.valueOf(_javaFactoryName) + ".java";
        return _plus;
    }

    public String getJavaScalarInterfaceName(ActorClass rc) {
        String _name = rc.getName();
        String _plus = String.valueOf(_name) + "Interface";
        return _plus;
    }

    public String getJavaScalarInterfaceFileName(ActorClass rc) {
        String _javaScalarInterfaceName = this.getJavaScalarInterfaceName(rc);
        String _plus = String.valueOf(_javaScalarInterfaceName) + ".java";
        return _plus;
    }

    public String getJavaReplicatedInterfaceName(ActorClass rc) {
        String _name = rc.getName();
        String _plus = String.valueOf(_name) + "ReplicatedInterface";
        return _plus;
    }

    public String getJavaReplicatedInterfaceFileName(ActorClass rc) {
        String _javaReplicatedInterfaceName = this.getJavaReplicatedInterfaceName(rc);
        String _plus = String.valueOf(_javaReplicatedInterfaceName) + ".java";
        return _plus;
    }

    public String getJavaInterfaceName(ActorClass ac, boolean replicated) {
        String _javaScalarInterfaceName;
        String _javaReplicatedInterfaceName;
        String _xifexpression = null;
        _xifexpression = replicated ? (_javaReplicatedInterfaceName = this.getJavaReplicatedInterfaceName(ac)) : (_javaScalarInterfaceName = this.getJavaScalarInterfaceName(ac));
        return _xifexpression;
    }

    public String getJavaInterfaceFileName(ActorClass ac, boolean replicated) {
        String _javaScalarInterfaceFileName;
        String _javaReplicatedInterfaceFileName;
        String _xifexpression = null;
        _xifexpression = replicated ? (_javaReplicatedInterfaceFileName = this.getJavaReplicatedInterfaceFileName(ac)) : (_javaScalarInterfaceFileName = this.getJavaScalarInterfaceFileName(ac));
        return _xifexpression;
    }

    public String getJavaClassName(NodeRef nr, SubSystemInstance ssi) {
        String _name = nr.getName();
        String _plus = "Node_" + _name;
        String _plus_1 = String.valueOf(_plus) + "_";
        String _name_1 = ssi.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name_1;
        return _plus_2;
    }

    public String getJavaFileName(NodeRef nr, SubSystemInstance ssi) {
        String _javaClassName = this.getJavaClassName(nr, ssi);
        String _plus = String.valueOf(_javaClassName) + ".java";
        return _plus;
    }

    public String toWrapper(String type) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)type, (Object)"int")) {
            _matched = true;
            _switchResult = "Integer";
        }
        if (!_matched && Objects.equal((Object)type, (Object)"char")) {
            _matched = true;
            _switchResult = "Character";
        }
        if (!_matched) {
            String _firstUpper;
            _switchResult = _firstUpper = StringExtensions.toFirstUpper((String)type);
        }
        return _switchResult;
    }

    public boolean needsInitialization(Attribute a) {
        boolean _greaterThan;
        boolean _or = false;
        boolean _or_1 = false;
        int _size = a.getSize();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _or_1 = true;
        } else {
            RefableType _type = a.getType();
            DataType _type_1 = _type.getType();
            boolean _isPrimitive = this.typeHelpers.isPrimitive(_type_1);
            boolean _not = !_isPrimitive;
            boolean bl2 = _or_1 = _greaterThan || _not;
        }
        if (_or_1) {
            _or = true;
        } else {
            RefableType _type_2 = a.getType();
            DataType _type_3 = _type_2.getType();
            String _typeName = this.typeHelpers.typeName(_type_3);
            boolean _equals = _typeName.equals("String");
            _or = _or_1 || _equals;
        }
        return _or;
    }

    public String accessLevelPrivate() {
        return "private ";
    }

    public String accessLevelProtected() {
        return "protected ";
    }

    public String accessLevelPublic() {
        return "public ";
    }

    public String memberAccess() {
        return "this.";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        return "";
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        String _plus = String.valueOf(namespace) + ".";
        return String.valueOf(_plus) + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public boolean usesPointers() {
        return false;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        StringConcatenation _builder = new StringConcatenation();
        for (Pair<String, String> entry : entries) {
            _builder.append((Object)"public static final int ");
            String _first = (String)entry.getFirst();
            _builder.append((Object)_first, "");
            _builder.append((Object)" = ");
            String _second = (String)entry.getSecond();
            _builder.append((Object)_second, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        String _string = _builder.toString();
        return _string;
    }

    public String booleanConstant(boolean b) {
        String _string = Boolean.valueOf(b).toString();
        return _string;
    }

    public String pointerLiteral() {
        return "";
    }

    public String nullPointer() {
        return "null";
    }

    public String voidPointer() {
        return "Object";
    }

    public String arrayDeclaration(String type, int size, String name, boolean isRef) {
        String _plus = String.valueOf(type) + " ";
        String _plus_1 = String.valueOf(_plus) + name;
        String _plus_2 = String.valueOf(_plus_1) + "[]";
        return _plus_2;
    }

    public String constructorName(String cls) {
        return cls;
    }

    public String destructorName(String cls) {
        String _plus = String.valueOf(cls) + "_dtor";
        return _plus;
    }

    public String constructorReturnType() {
        return "";
    }

    public String destructorReturnType() {
        return "void";
    }

    public String superCall(String baseClassName, String method, String args) {
        String _plus = "super." + method;
        String _plus_1 = String.valueOf(_plus) + "(";
        String _plus_2 = String.valueOf(_plus_1) + args;
        String _plus_3 = String.valueOf(_plus_2) + ");";
        return _plus_3;
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        String _targetName;
        String _switchResult = null;
        String _switchValue = _targetName = type.getTargetName();
        boolean _matched = false;
        if (!_matched) {
            boolean _not;
            boolean _and = false;
            boolean _isCharacterType = this.typeHelpers.isCharacterType(type);
            boolean bl = _not = !_isCharacterType;
            if (!_not) {
                _and = false;
            } else {
                boolean _contains = value.contains(",");
                boolean bl2 = _and = _not && _contains;
            }
            if (_and) {
                String _string;
                _matched = true;
                String _xblockexpression = null;
                String _replace = value.replace("{", "");
                String _replace_1 = _replace.replace("}", "");
                String _trim = _replace_1.trim();
                String[] singleValues = _trim.split(",");
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"{ ");
                boolean _hasElements = false;
                String[] stringArray = singleValues;
                int n = singleValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String v = stringArray[n2];
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    String _trim_1 = v.trim();
                    String _castValue = this.castValue(type, _trim_1);
                    _builder.append((Object)_castValue, "");
                    ++n2;
                }
                _builder.append((Object)" }");
                _switchResult = _xblockexpression = (_string = _builder.toString());
            }
        }
        if (!_matched) {
            String _castValue;
            _switchResult = _castValue = this.castValue(type, value);
        }
        return _switchResult;
    }

    private String castValue(PrimitiveType type, String value) {
        String _targetName;
        String _switchResult = null;
        String _switchValue = _targetName = type.getTargetName();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"boolean")) {
            String _lowerCase;
            _matched = true;
            _switchResult = _lowerCase = value.toLowerCase();
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"byte")) {
            String _plus;
            _matched = true;
            _switchResult = _plus = "(byte)" + value;
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"short")) {
            String _plus_1;
            _matched = true;
            _switchResult = _plus_1 = "(short)" + value;
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"int")) {
            _matched = true;
            _switchResult = value;
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"long")) {
            String _plus_2;
            _matched = true;
            _switchResult = _plus_2 = String.valueOf(value) + "L";
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"float")) {
            String _plus_3;
            _matched = true;
            _switchResult = _plus_3 = String.valueOf(value) + "f";
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"double")) {
            String _plus_4;
            _matched = true;
            _switchResult = _plus_4 = String.valueOf(value) + "d";
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"char")) {
            _matched = true;
            String _xifexpression = null;
            boolean _isEmpty = value.isEmpty();
            if (_isEmpty) {
                _xifexpression = "(char) 0";
            } else {
                boolean _equals;
                String _xifexpression_1 = null;
                int _length = value.length();
                boolean bl = _equals = _length == 1;
                if (_equals) {
                    String _plus_6;
                    char _charAt = value.charAt(0);
                    String _plus_5 = "'" + Character.valueOf(_charAt);
                    _xifexpression_1 = _plus_6 = String.valueOf(_plus_5) + "'";
                } else {
                    String _plus_8;
                    String _replace = value.replace("\\", "\\\\");
                    String _replace_1 = _replace.replace("\"", "\\\"");
                    String _plus_7 = "\"" + _replace_1;
                    _xifexpression_1 = _plus_8 = String.valueOf(_plus_7) + "\".toCharArray()";
                }
                _xifexpression = _xifexpression_1;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"String")) {
            String _plus_10;
            _matched = true;
            String _replace_2 = value.replace("\\", "\\\\");
            String _replace_3 = _replace_2.replace("\"", "\\\"");
            String _plus_9 = "\"" + _replace_3;
            _switchResult = _plus_10 = String.valueOf(_plus_9) + "\"";
        }
        if (!_matched) {
            String _targetName_1 = type.getTargetName();
            UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException(_targetName_1);
            throw _unsupportedOperationException;
        }
        return _switchResult;
    }

    public String defaultValue(DataType dt) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && dt instanceof PrimitiveType) {
            String _valueLiteral;
            PrimitiveType _primitiveType = (PrimitiveType)dt;
            _matched = true;
            String _defaultValueLiteral = _primitiveType.getDefaultValueLiteral();
            _switchResult = _valueLiteral = this.toValueLiteral(_primitiveType, _defaultValueLiteral);
        }
        if (!_matched && dt instanceof ExternalType) {
            String _plus_1;
            ExternalType _externalType = (ExternalType)dt;
            _matched = true;
            String _targetName = _externalType.getTargetName();
            String _plus = "new " + _targetName;
            _switchResult = _plus_1 = String.valueOf(_plus) + "()";
        }
        if (!_matched) {
            String _plus_1;
            String _name = dt.getName();
            String _plus = "new " + _name;
            _switchResult = _plus_1 = String.valueOf(_plus) + "()";
        }
        return _switchResult;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        boolean _greaterThan;
        String _xblockexpression = null;
        String dv = this.defaultValue(dt);
        String _xifexpression = null;
        boolean bl = _greaterThan = size > 1;
        if (_greaterThan) {
            String _plus;
            boolean _lessThan;
            String _xblockexpression_1 = null;
            String res = "{";
            int i = 0;
            boolean _while = _lessThan = i < size;
            while (_while) {
                boolean _lessThan_1;
                boolean _lessThan_12;
                String _plus2;
                res = _plus2 = String.valueOf(res) + dv;
                int _plus_1 = i + 1;
                boolean bl2 = _lessThan_12 = (i = _plus_1) < size;
                if (_lessThan_12) {
                    String _plus_2;
                    res = _plus_2 = String.valueOf(res) + ",";
                }
                _while = _lessThan_1 = i < size;
            }
            _xifexpression = _xblockexpression_1 = (_plus = String.valueOf(res) + "}");
        } else {
            _xifexpression = dv;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String[] generateArglistAndTypedData(VarDecl data) {
        String typeName;
        boolean _equals = Objects.equal((Object)data, null);
        if (_equals) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        RefableType _refType = data.getRefType();
        DataType _type = _refType.getType();
        String castTypeName = typeName = _type.getName();
        RefableType _refType_1 = data.getRefType();
        DataType _type_1 = _refType_1.getType();
        if (_type_1 instanceof PrimitiveType) {
            boolean _notEquals;
            String _targetName;
            RefableType _refType_2 = data.getRefType();
            DataType _type_2 = _refType_2.getType();
            typeName = _targetName = ((PrimitiveType)_type_2).getTargetName();
            RefableType _refType_3 = data.getRefType();
            DataType _type_3 = _refType_3.getType();
            String ct = ((PrimitiveType)_type_3).getCastName();
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)ct, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _isEmpty = ct.isEmpty();
                boolean _not = !_isEmpty;
                boolean bl2 = _and = _notEquals && _not;
            }
            if (_and) {
                castTypeName = ct;
            }
        }
        String _plus = String.valueOf(typeName) + " ";
        String _name = data.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String _plus_2 = String.valueOf(_plus_1) + " = (";
        String _plus_3 = String.valueOf(_plus_2) + castTypeName;
        String typedData = String.valueOf(_plus_3) + ") generic_data;\n";
        String _name_1 = data.getName();
        String dataArg = ", " + _name_1;
        String _plus_4 = ", " + typeName;
        String _plus_5 = String.valueOf(_plus_4) + " ";
        String _name_2 = data.getName();
        String typedArgList = String.valueOf(_plus_5) + _name_2;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }
}

